/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import oracle.ideimpl.index.res.IndexingArb;
import oracle.ideimpl.index.task.ProgressMonitor;

@ThreadSafe
public class IndexProgressMonitor
implements ProgressMonitor {
    @GuardedBy(value="this")
    private int current;
    @GuardedBy(value="this")
    private int total;

    public synchronized int getProgress() {
        return this.total > 0 ? this.current * 100 / this.total : 0;
    }

    public synchronized String getProgressText() {
        if (this.total > 0) {
            int remaining = this.total - this.current;
            return IndexingArb.format(7, remaining);
        }
        return IndexingArb.getString(3);
    }

    public synchronized void setCurrentValue(int current) {
        this.current = current;
    }

    public synchronized int getCurrentValue() {
        return this.current;
    }

    public synchronized void setTotal(int total) {
        this.total = total;
    }
}

