/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.index.Indexer;

public class IndexerStatistics {
    private static final Logger LOGGER = Logger.getLogger(IndexerStatistics.class.getName());
    private static final boolean ENABLED = LOGGER.isLoggable(Level.FINE);
    private static final HashMap<String, Integer> ENTRIES = new HashMap();
    private static final HashMap<String, Long> TIMING = new HashMap();
    private static final HashMap<String, Integer> CALLS = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addIndexEntry(String key) {
        if (ENABLED) {
            HashMap<String, Integer> hashMap = ENTRIES;
            synchronized (hashMap) {
                Integer count = ENTRIES.get(key);
                ENTRIES.put(key, count == null ? 1 : count + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addIndexerTiming(Indexer indexer, long time) {
        if (ENABLED) {
            HashMap<String, Long> hashMap = TIMING;
            synchronized (hashMap) {
                String key = indexer.getClass().getName();
                Long total = TIMING.get(key);
                TIMING.put(key, total == null ? time : total + time);
                Integer calls = CALLS.get(key);
                CALLS.put(key, calls == null ? 1 : calls + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void logStatistics() {
        if (ENABLED) {
            boolean hasData = false;
            StringBuilder msg = new StringBuilder();
            Formatter formatter = new Formatter(msg);
            msg.append("\n\n  Total time per Indexer:\n");
            HashMap<String, Long> hashMap = TIMING;
            synchronized (hashMap) {
                if (!TIMING.isEmpty()) {
                    hasData = true;
                    ArrayList<String> keys = new ArrayList<String>(TIMING.keySet());
                    1 c = new 1();
                    Collections.sort(keys, c);
                    for (String key : keys) {
                        formatter.format("  %6dms %s (%d files)\n", TIMING.get(key) / 1000000L, key, CALLS.get(key));
                    }
                }
            }
            HashMap<String, Integer> hashMap2 = ENTRIES;
            synchronized (hashMap2) {
                if (!ENTRIES.isEmpty()) {
                    if (hasData) {
                        msg.append("\n");
                    }
                    hasData = true;
                    ArrayList<String> keys = new ArrayList<String>(ENTRIES.keySet());
                    2 c = new 2();
                    Collections.sort(keys, c);
                    msg.append("  Number of entries per key:\n");
                    for (String key : keys) {
                        formatter.format("  %10d %s\n", ENTRIES.get(key), key);
                    }
                }
            }
            if (hasData) {
                LOGGER.fine(msg.toString());
            }
        }
    }

    static HashMap ra$TIMING() {
        return TIMING;
    }

    static HashMap ra$ENTRIES() {
        return ENTRIES;
    }

    static final class 1
    implements Comparator {
        public int compare(String s1, String s2) {
            long time1 = (Long)IndexerStatistics.ra$TIMING().get(s1);
            long time2 = (Long)IndexerStatistics.ra$TIMING().get(s2);
            return time2 > time1 ? 1 : (time2 == time1 ? 0 : -1);
        }

        public boolean equals(Object obj) {
            return this.equals(obj);
        }
    }

    static final class 2
    implements Comparator {
        public int compare(String s1, String s2) {
            int count1 = (Integer)IndexerStatistics.ra$ENTRIES().get(s1);
            int count2 = (Integer)IndexerStatistics.ra$ENTRIES().get(s2);
            return count2 - count1;
        }

        public boolean equals(Object obj) {
            return this.equals(obj);
        }
    }
}

