/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import oracle.ide.index.DataCollector;
import oracle.ide.index.IndexManager;
import oracle.ide.index.Indexer;
import oracle.ide.index.IndexingContext;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.UnrecognizedTextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideimpl.index.IndexLogger;
import oracle.ideimpl.index.IndexManagerImpl;
import oracle.ideimpl.index.IndexerStatistics;
import oracle.ideimpl.index.extension.IndexerInfo;
import oracle.ideimpl.index.extension.IndexingExtensionHook;
import oracle.ideimpl.index.extension.IndexingInfo;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexingContextImpl
implements IndexingContext {
    private Project project;
    private Node node;
    private URL url;
    private TextBuffer buffer;
    private long timestamp;
    private Object filterKey;
    private Object filterValue;
    private HashMap<String, Object> items;
    private ArrayList<Indexer> genericIndexers;
    private MultiMap<Class, Indexer> indexers;
    private static final HashSet<String> invalidIndexers = new HashSet(3);

    private void $init$() {
        this.timestamp = -1;
        this.items = new HashMap();
        this.genericIndexers = new ArrayList();
        this.indexers = new MultiMap();
    }

    public IndexingContextImpl(Project project) {
        this.$init$();
        this.project = project;
        this.createIndexerInstances();
    }

    public IndexingContextImpl(TextBuffer buffer) {
        this.$init$();
        this.buffer = buffer;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public TextBuffer getTextBuffer() {
        return this.buffer;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Object getFilterKey() {
        return this.filterKey;
    }

    @Override
    public Object getFilterValue() {
        return this.filterValue;
    }

    @Override
    public Object get(String key) {
        return this.items.get(key);
    }

    @Override
    public void put(String key, Object item) {
        this.items.put(key, item);
    }

    protected void setNode(Node node) {
        this.node = node;
        this.setURL(node.getURL());
    }

    protected void setURL(URL url) {
        this.url = url;
    }

    protected void setTextBuffer(TextBuffer buffer) {
        this.buffer = buffer;
    }

    protected void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setFilterKey(Object filterKey) {
        this.filterKey = filterKey;
    }

    protected void setFilterValue(Object filterValue) {
        this.filterValue = filterValue;
    }

    public void startIndexing() {
        for (Indexer indexer : this.genericIndexers) {
            indexer.startIndexing(this);
        }
        for (Class key : this.indexers.keySet()) {
            for (Indexer indexer : this.indexers.get((Object)key)) {
                indexer.startIndexing(this);
            }
        }
    }

    public void endIndexing() {
        for (Indexer indexer : this.genericIndexers) {
            indexer.endIndexing(this);
        }
        for (Class key : this.indexers.keySet()) {
            for (Indexer indexer : this.indexers.get((Object)key)) {
                indexer.endIndexing(this);
            }
        }
    }

    public void index(URL url, long timestamp, DataCollector data) {
        block18: {
            try {
                Collection<Indexer> indexers;
                Node node = NodeFactory.findOrCreate((URL)url);
                if (node instanceof TextNode && !(node instanceof UnrecognizedTextNode)) {
                    this.setNode(node);
                    this.setTimestamp(timestamp);
                    Collection<Indexer> nodeIndexers = this.getIndexers(node);
                    boolean releaseBuffer = true;
                    TextBuffer buffer = null;
                    TextNode textNode = (TextNode)node;
                    if (node.isOpenUnsafe()) {
                        buffer = textNode.tryAcquireTextBuffer();
                    }
                    if (buffer == null) {
                        releaseBuffer = false;
                        buffer = this.getTextBuffer(textNode);
                    }
                    this.setTextBuffer(buffer);
                    try {
                        if (buffer.tryReadLock()) {
                            try {
                                if (IndexLogger.getLogger().isLoggable(Level.FINEST)) {
                                    String path = URLFileSystem.getPlatformPathName((URL)url);
                                    IndexLogger.getLogger().finest("Indexing " + path);
                                }
                                for (Indexer indexer : this.genericIndexers) {
                                    this.invokeIndexer(indexer, data);
                                }
                                for (Indexer indexer : nodeIndexers) {
                                    this.invokeIndexer(indexer, data);
                                }
                                break block18;
                            }
                            finally {
                                buffer.readUnlock();
                            }
                        }
                        IndexLogger.getLogger().finest("Unable to acquire text buffer lock for " + URLFileSystem.getPlatformPathName((URL)url));
                        break block18;
                    }
                    finally {
                        if (releaseBuffer) {
                            ((TextNode)node).releaseTextBuffer();
                        }
                    }
                }
                if (!(node instanceof TextNode) && !(indexers = this.getIndexers(node)).isEmpty()) {
                    this.setNode(node);
                    this.setTextBuffer(null);
                    this.setTimestamp(timestamp);
                    node.tryRunUnderReadLock((Runnable)new 1(this, indexers, data));
                }
            }
            catch (FileNotFoundException fnfe) {
                IndexLogger.getLogger().finest("File does not exist: " + URLFileSystem.getPlatformPathName((URL)url));
            }
            catch (Exception e) {
                IndexLogger.getLogger().log(Level.SEVERE, "Unable to index " + URLFileSystem.getPlatformPathName((URL)url), e);
            }
        }
    }

    private void invokeIndexer(Indexer indexer, DataCollector data) {
        long start = System.nanoTime();
        try {
            try {
                indexer.index(this, data);
            }
            catch (RuntimeException e) {
                IndexLogger.getLogger().log(Level.SEVERE, "Exception in " + indexer.getClass().getName() + " while indexing " + URLFileSystem.getPlatformPathName((URL)this.url), e);
            }
        }
        finally {
            long time = System.nanoTime() - start;
            PerformanceLogger.get().log("Indexer.index", indexer.getClass().getName(), time);
            IndexerStatistics.addIndexerTiming(indexer, time);
        }
    }

    private void createIndexerInstances() {
        IndexManagerImpl manager = (IndexManagerImpl)IndexManager.getIndexManager();
        IndexingInfo ii = IndexingExtensionHook.getIndexingInfo();
        for (IndexerInfo info : ii.getIndexers()) {
            String classname = info.getIndexerClass();
            String type = info.getNodeClass();
            try {
                Class<?> clazz = Class.forName(classname);
                if (type != null) {
                    Class<?> typeClass = Class.forName(type);
                    this.indexers.add(typeClass, (Object)((Indexer)clazz.newInstance()));
                    continue;
                }
                this.genericIndexers.add((Indexer)clazz.newInstance());
            }
            catch (Throwable t) {
                this.reportInstantiationException(t, classname);
            }
        }
        List<Class> classes = manager.getIndexers();
        for (Class clazz : classes) {
            try {
                this.genericIndexers.add((Indexer)clazz.newInstance());
            }
            catch (Throwable t) {
                this.reportInstantiationException(t, clazz.getName());
            }
        }
        MultiMap<Class, Class> classMap = manager.getIndexerMap();
        for (Class key : classMap.keySet()) {
            for (Class clazz : classMap.get((Object)key)) {
                try {
                    this.indexers.add((Object)key, (Object)((Indexer)clazz.newInstance()));
                }
                catch (Throwable t) {
                    this.reportInstantiationException(t, clazz.getName());
                }
            }
        }
    }

    private void reportInstantiationException(Throwable t, String classname) {
        if (!invalidIndexers.contains(classname)) {
            invalidIndexers.add(classname);
            IndexLogger.getLogger().log(Level.SEVERE, "Unable to create Indexer: " + classname, t);
        }
    }

    private TextBuffer getTextBuffer(TextNode node) throws IOException {
        InputStream is = null;
        try {
            is = URLFileSystem.openInputStream((URL)node.getURL());
            InputStreamReader isr = new InputStreamReader(is, node.getLoadEncoding());
            TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
            textBuffer.read((Reader)isr);
            TextBuffer textBuffer2 = textBuffer;
            return textBuffer2;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private Collection<Indexer> getIndexers(Node node) {
        Class clazz = node.getClass();
        while (clazz != null) {
            Collection list = this.indexers.get((Object)clazz);
            if (list != null) {
                ArrayList<Indexer> copy = new ArrayList<Indexer>();
                copy.addAll(list);
                return copy;
            }
            clazz = clazz.getSuperclass();
        }
        return Collections.emptyList();
    }

    static URL ra$url(IndexingContextImpl indexingContextImpl) {
        return indexingContextImpl.url;
    }

    static void mav$invokeIndexer(IndexingContextImpl indexingContextImpl, Indexer indexer, DataCollector dataCollector) {
        indexingContextImpl.invokeIndexer(indexer, dataCollector);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ Collection v$indexers;
        private final /* synthetic */ DataCollector v$data;
        final /* synthetic */ IndexingContextImpl this$0;

        public void run() {
            if (IndexLogger.getLogger().isLoggable(Level.FINEST)) {
                String path = URLFileSystem.getPlatformPathName((URL)IndexingContextImpl.ra$url(this.this$0));
                IndexLogger.getLogger().finest("Indexing " + path);
            }
            for (Indexer indexer : this.v$indexers) {
                IndexingContextImpl.mav$invokeIndexer(this.this$0, indexer, this.v$data);
            }
        }

        public 1(IndexingContextImpl indexingContextImpl, Collection collection, DataCollector dataCollector) {
            this.v$data = dataCollector;
            this.v$indexers = collection;
            this.this$0 = indexingContextImpl;
        }
    }
}

