/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Iterator;
import javax.swing.Timer;
import oracle.ide.index.file.FileChange;
import oracle.ide.index.file.FileTableManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.index.file.ActiveRootManager;
import oracle.ideimpl.index.file.FileChangeImpl;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;

public class NodeTracker
extends NodeListener {
    private final FileTableManager fileTableManager = FileTableManager.getFileTableManager();
    private static final int TIMER_DELAY = 200;

    public static void install() {
        new NodeTracker();
    }

    private NodeTracker() {
        Node.addNodeListenerForTypeHierarchy(TextNode.class, (NodeListener)this);
        1NodeRunnable r = new 1NodeRunnable();
        Iterator iterator = NodeFactory.getOpenNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!(node instanceof TextNode)) continue;
            1NodeRunnable.wa$node(r, (TextNode)node);
            1NodeRunnable.ra$node(r).runUnderReadLock((Runnable)r);
        }
    }

    public void nodeOpened(NodeEvent e) {
        this.nodeOpened((TextNode)e.getNode());
    }

    public void nodeDeleted(NodeEvent e) {
        URL nodeURL = e.getNodeURL();
        URL parent = URLFileSystem.getParent((URL)nodeURL);
        if (parent != null) {
            this.fileTableManager.invalidateDir(parent, false);
        }
    }

    public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
        URL oldParent = URLFileSystem.getParent((URL)oldURL);
        URL newParent = URLFileSystem.getParent((URL)newURL);
        if (oldParent != null) {
            this.fileTableManager.invalidateDir(oldParent, false);
        }
        if (newParent != null && !URLFileSystem.equals((URL)oldParent, (URL)newParent)) {
            this.fileTableManager.invalidateDir(newParent, false);
        }
    }

    private void nodeOpened(TextNode node) {
        TextBufferTracker tracker = new TextBufferTracker(node);
        node.addTextBufferListener((TextBufferListener)tracker);
        node.addNodeListener((NodeListener)tracker);
    }

    static void mav$nodeOpened(NodeTracker nodeTracker, TextNode textNode) {
        nodeTracker.nodeOpened(textNode);
    }

    class 1NodeRunnable
    implements Runnable {
        private TextNode node;

        public void run() {
            if (this.node.isOpen()) {
                NodeTracker.mav$nodeOpened(NodeTracker.this, this.node);
            }
        }

        1NodeRunnable() {
        }

        static void wa$node(1NodeRunnable nodeRunnable, TextNode textNode) {
            nodeRunnable.node = textNode;
        }

        static TextNode ra$node(1NodeRunnable nodeRunnable) {
            return nodeRunnable.node;
        }
    }

    private class TextBufferTracker
    extends NodeListener
    implements TextBufferListener,
    ActionListener {
        private URL url;
        private Timer timer;
        private boolean reloading;

        private void $init$() {
            this.reloading = false;
        }

        public TextBufferTracker(TextNode node) {
            this.$init$();
            this.url = node.getURL();
            node.addTextBufferListener((TextBufferListener)this);
            this.timer = new Timer(200, this);
            this.timer.setRepeats(false);
        }

        public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
            this.url = newURL;
        }

        public void nodeClosed(NodeEvent e) {
            e.getNode().removeNodeListener((NodeListener)this);
        }

        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
            if (!this.reloading) {
                this.restartTimer();
            }
        }

        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
            if (!this.reloading) {
                this.restartTimer();
            }
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
            if (attribute == 3) {
                this.reloading = true;
            } else if (attribute == 4) {
                this.reloading = false;
                this.bufferChanged();
            }
        }

        public void bufferChanged() {
            Node node = NodeFactory.find((URL)this.url);
            long timestamp = node == null ? (long)-1 : node.getTimestampLoadedUnsafe();
            FileChangeImpl change = new FileChangeImpl(FileChange.Type.TEXT_BUFFER_MODIFIED, this.url, timestamp);
            ActiveRootManager.getInstance().notifyRoots(change);
        }

        public void actionPerformed(ActionEvent event) {
            this.bufferChanged();
        }

        private void restartTimer() {
            this.timer.restart();
        }
    }
}

