/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.persistence.NameSpace;

public abstract class ProjectStorage {
    private static final String DIRECTORY_NAME = ".data";
    @GuardedBy(value="itself")
    private static final HashMap<String, ProjectLocalStorage> LOCAL_STORAGES = new HashMap();
    @GuardedBy(value="LOCAL_STORAGES")
    private static final HashMap<String, List<Thread>> LOCKED_CLOSED = new HashMap();
    private static final Logger logger = Logger.getLogger("oracle.ideimpl.index.ProjectStorage");
    protected Project project;

    public static final URL getLocalStorageLocation(Project project) {
        URL output = project.getProperties().getURL("oracle.jdevimpl.config.JProjectPaths/outputDirectory");
        if (output != null) {
            return URLFactory.newDirURL((URL)output, (String)DIRECTORY_NAME);
        }
        return null;
    }

    public static final String getLocalStoragePath(Project project) {
        URL location = ProjectStorage.getLocalStorageLocation(project);
        if (location != null && "file".equals(location.getProtocol())) {
            return location.getPath();
        }
        return null;
    }

    public static boolean checkLocalStoragePath(String path) {
        File file = new File(path);
        return file.exists() || file.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final ProjectStorage getProjectStorage(Project project) {
        String path = ProjectStorage.getLocalStoragePath(project);
        if (path == null) return new SharedProjectStorage(project);
        HashMap<String, ProjectLocalStorage> hashMap = LOCAL_STORAGES;
        synchronized (hashMap) {
            while (true) {
                if (!LOCKED_CLOSED.containsKey(path)) {
                    ProjectLocalStorage instance = LOCAL_STORAGES.get(path);
                    if (instance == null && ProjectStorage.checkLocalStoragePath(path)) {
                        logger.finer("Opening project storage for " + project.getShortLabel());
                        instance = new ProjectLocalStorage(project, path);
                        LOCAL_STORAGES.put(path, instance);
                    }
                    if (instance == null) return new SharedProjectStorage(project);
                    ProjectLocalStorage projectLocalStorage = instance;
                    ProjectLocalStorage.wa$refCount(projectLocalStorage, ProjectLocalStorage.ra$refCount(projectLocalStorage) + 1);
                    return instance;
                }
                try {
                    LOCAL_STORAGES.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void lockClosed(Project project) throws InterruptedException {
        String path = ProjectStorage.getLocalStoragePath(project);
        if (path != null) {
            HashMap<String, ProjectLocalStorage> hashMap = LOCAL_STORAGES;
            synchronized (hashMap) {
                List<Thread> threads = LOCKED_CLOSED.get(path);
                if (threads == null) {
                    logger.finer("Locking project storage for " + project.getShortLabel());
                    threads = new ArrayList<Thread>(3);
                    LOCKED_CLOSED.put(path, threads);
                }
                threads.add(Thread.currentThread());
                while (LOCAL_STORAGES.containsKey(path)) {
                    try {
                        LOCAL_STORAGES.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void allowOpen(Project project) {
        String path = ProjectStorage.getLocalStoragePath(project);
        if (path != null) {
            HashMap<String, ProjectLocalStorage> hashMap = LOCAL_STORAGES;
            synchronized (hashMap) {
                List<Thread> threads = LOCKED_CLOSED.get(path);
                if (threads == null || !threads.contains(Thread.currentThread())) {
                    logger.severe("Unmatched call to allowOpen");
                } else {
                    threads.remove(Thread.currentThread());
                    if (threads.isEmpty()) {
                        logger.finer("Unlocking project storage for " + project.getShortLabel());
                        LOCKED_CLOSED.remove(path);
                        LOCAL_STORAGES.notifyAll();
                    }
                }
            }
        }
    }

    protected ProjectStorage(Project project) {
        this.project = project;
    }

    public abstract NameSpace getNameSpace(String var1, int var2);

    public abstract void deleteNameSpace(String var1);

    public void release() {
    }

    static HashMap ra$LOCAL_STORAGES() {
        return LOCAL_STORAGES;
    }

    static Logger ra$logger() {
        return logger;
    }

    private static class SharedProjectStorage
    extends ProjectStorage {
        public SharedProjectStorage(Project project) {
            super(project);
        }

        public NameSpace getNameSpace(String name, int type) {
            return NameSpace.getNameSpace((String)this.getProjectNameSpace(name), (int)type);
        }

        public void deleteNameSpace(String name) {
            NameSpace.deleteNameSpace((String)this.getProjectNameSpace(name));
        }

        private String getProjectNameSpace(String name) {
            return this.project.getURL().toString() + "-" + name;
        }
    }

    private static class ProjectLocalStorage
    extends ProjectStorage {
        private String path;
        private int refCount;

        public ProjectLocalStorage(Project project, String path) {
            super(project);
            this.path = path;
        }

        public NameSpace getNameSpace(String name, int type) {
            return NameSpace.getLocalNameSpace((String)this.path, (String)name, (int)type);
        }

        public void deleteNameSpace(String name) {
            NameSpace.deleteLocalNameSpace((String)this.path, (String)name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            HashMap hashMap = ProjectStorage.ra$LOCAL_STORAGES();
            synchronized (hashMap) {
                if (--this.refCount == 0) {
                    ProjectStorage.ra$logger().finer("Closing project storage for " + this.project.getShortLabel());
                    if (this.path != null) {
                        NameSpace.closeStorage((String)this.path);
                    }
                    ProjectStorage.ra$LOCAL_STORAGES().remove(this.path);
                    ProjectStorage.ra$LOCAL_STORAGES().notifyAll();
                }
            }
        }

        static int ra$refCount(ProjectLocalStorage projectLocalStorage) {
            return projectLocalStorage.refCount;
        }

        static void wa$refCount(ProjectLocalStorage projectLocalStorage, int n) {
            projectLocalStorage.refCount = n;
        }
    }
}

