/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import net.jcip.annotations.GuardedBy;
import oracle.ide.index.file.FileChange;
import oracle.ide.index.file.FileChangeListener;
import oracle.ide.index.file.FileTableManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideimpl.index.IndexLogger;
import oracle.ideimpl.index.file.ActiveRootManager;
import oracle.ideimpl.index.file.ContentSetRootListener;
import oracle.ideimpl.index.file.FileTableManagerImpl;
import oracle.ideimpl.index.util.ContentSetRoot;
import oracle.javatools.util.ModelUtil;

public class ProjectTracker
extends NodeListener {
    @GuardedBy(value="itself")
    private static final HashMap<Project, ProjectListener> projectListeners = new HashMap();
    @GuardedBy(value="ProjectTracker.class")
    private static ProjectTracker instance;

    private ProjectTracker() {
        Node.addNodeListenerForType(Project.class, (NodeListener)this);
        Iterator iterator = NodeFactory.getOpenNodes();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Project)) continue;
            this.projectOpened((Project)object);
        }
    }

    public static synchronized ProjectTracker getProjectTracker() {
        if (instance == null) {
            instance = new ProjectTracker();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileChangeListener(Workspace workspace, Project project, FileChangeListener listener) {
        HashMap<Project, ProjectListener> hashMap = projectListeners;
        synchronized (hashMap) {
            ProjectListener projectListener = projectListeners.get(project);
            if (projectListener == null) {
                projectListener = new ProjectListener(project);
                projectListeners.put(project, projectListener);
            }
            projectListener.addFileChangeListener(workspace, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileChangeListener(Workspace workspace, Project project, FileChangeListener listener) {
        HashMap<Project, ProjectListener> hashMap = projectListeners;
        synchronized (hashMap) {
            ProjectListener projectListener = projectListeners.get(project);
            if (projectListener != null) {
                projectListener.removeFileChangeListener(workspace, listener);
            }
        }
    }

    public void nodeOpened(NodeEvent e) {
        Node node = e.getNode();
        if (node instanceof Project) {
            this.projectOpened((Project)node);
        }
    }

    public void nodeClosed(NodeEvent e) {
        Node node = e.getNode();
        if (node instanceof Project) {
            this.projectClosed((Project)node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectOpened(Project project) {
        HashMap<Project, ProjectListener> hashMap = projectListeners;
        synchronized (hashMap) {
            ProjectListener projectListener = projectListeners.get(project);
            if (projectListener == null) {
                projectListener = new ProjectListener(project);
                projectListeners.put(project, projectListener);
            }
            projectListener.pinFileTables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectClosed(Project project) {
        HashMap<Project, ProjectListener> hashMap = projectListeners;
        synchronized (hashMap) {
            ProjectListener projectListener = projectListeners.get(project);
            if (projectListener != null) {
                projectListener.unpinFileTables();
            }
        }
    }

    static HashMap ra$projectListeners() {
        return projectListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProjectListener
    implements Observer,
    ContentSetRootListener {
        private int pinCount;
        private Project project;
        private Collection<ContentSetRoot> roots;
        private CopyOnWriteArrayList<ListenerRecord> listeners;

        private void $init$() {
            this.listeners = new CopyOnWriteArrayList();
        }

        public ProjectListener(Project project) {
            this.$init$();
            this.project = project;
            project.attach((Observer)this);
            this.updateRoots();
        }

        public void addFileChangeListener(Workspace workspace, FileChangeListener listener) {
            this.listeners.add(new ListenerRecord(workspace, listener));
        }

        public void removeFileChangeListener(Workspace workspace, FileChangeListener listener) {
            this.listeners.remove(new ListenerRecord(workspace, listener));
            if (this.listeners.isEmpty() && this.pinCount == 0) {
                this.dispose();
            }
        }

        public void pinFileTables() {
            if (++this.pinCount == 1) {
                FileTableManagerImpl ftm = (FileTableManagerImpl)FileTableManager.getFileTableManager();
                for (ContentSetRoot root : this.roots) {
                    ftm.pinFileTable(this.project, root.getURL(), root.getFilters());
                }
            }
        }

        public void unpinFileTables() {
            if (--this.pinCount == 0) {
                boolean dispose = this.listeners.isEmpty();
                FileTableManagerImpl ftm = (FileTableManagerImpl)FileTableManager.getFileTableManager();
                for (ContentSetRoot root : this.roots) {
                    ftm.unpinFileTable(this.project, root.getURL(), root.getFilters());
                }
                if (dispose) {
                    this.dispose();
                }
            }
        }

        private void dispose() {
            ProjectTracker.ra$projectListeners().remove(this.project);
            this.project.detach((Observer)this);
            ActiveRootManager arm = ActiveRootManager.getInstance();
            for (ContentSetRoot root : this.roots) {
                arm.removeRootListener(root, this);
            }
        }

        @Override
        public void filesChanged(Collection<FileChange> changes) {
            this.invokeListeners(changes);
        }

        public void invokeListeners(Collection<FileChange> changes) {
            if (IndexLogger.getLogger().isLoggable(Level.FINEST)) {
                for (FileChange change : changes) {
                    IndexLogger.getLogger().finest(change.toString());
                }
            }
            for (ListenerRecord record : this.listeners) {
                this.invokeListener(record, changes);
            }
        }

        private void invokeListener(ListenerRecord record, Collection<FileChange> changes) {
            FileChangeListener listener = record.getListener();
            try {
                long start = System.nanoTime();
                listener.filesChanged(record.getWorkspace(), this.project, changes);
                long time = System.nanoTime() - start;
                PerformanceLogger.get().log("FileChangeListener.filesChanged", listener.getClass().getName(), time);
            }
            catch (Exception e) {
                IndexLogger.getLogger().log(Level.SEVERE, "Exception in FileChangeListener " + listener.getClass().getName(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Object observed, UpdateMessage change) {
            int id = change.getMessageID();
            if (id == UpdateMessage.CHILD_ADDED) {
                FileTableManagerImpl ftm = (FileTableManagerImpl)FileTableManager.getFileTableManager();
                for (Object object : change.getAddObjects()) {
                    Node node;
                    URL dir;
                    if (!(object instanceof Node) || (dir = URLFileSystem.getParent((URL)(node = (Node)object).getURL())) == null) continue;
                    ftm.invalidateDir(dir, false);
                }
            } else if (id == UpdateMessage.PROPERTY_SET && change.containsProperty("contentProvidersPath")) {
                HashMap hashMap = ProjectTracker.ra$projectListeners();
                synchronized (hashMap) {
                    this.updateRoots();
                }
            }
        }

        private void updateRoots() {
            Collection<ContentSetRoot> newRoots = ContentSetRoot.getContentSetRoots(this.project);
            Collection<ContentSetRoot> oldRoots = this.roots;
            this.roots = newRoots;
            ActiveRootManager arm = ActiveRootManager.getInstance();
            FileTableManagerImpl ftm = (FileTableManagerImpl)FileTableManager.getFileTableManager();
            for (ContentSetRoot root : newRoots) {
                if (oldRoots != null && oldRoots.contains(root)) continue;
                arm.addRootListener(root, this);
                if (this.pinCount <= 0) continue;
                ftm.pinFileTable(this.project, root.getURL(), root.getFilters());
            }
            if (oldRoots != null) {
                for (ContentSetRoot root : oldRoots) {
                    if (newRoots.contains(root)) continue;
                    arm.removeRootListener(root, this);
                    if (this.pinCount <= 0) continue;
                    ftm.unpinFileTable(this.project, root.getURL(), root.getFilters());
                }
            }
        }
    }

    private static final class ListenerRecord {
        private final Workspace workspace;
        private final FileChangeListener listener;

        public ListenerRecord(Workspace workspace, FileChangeListener listener) {
            this.workspace = workspace;
            this.listener = listener;
        }

        public Workspace getWorkspace() {
            return this.workspace;
        }

        public FileChangeListener getListener() {
            return this.listener;
        }

        public int hashCode() {
            int hash = this.listener.hashCode();
            if (this.workspace != null) {
                hash = hash * 31 + this.workspace.hashCode();
            }
            return hash;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ListenerRecord)) {
                return false;
            }
            ListenerRecord other = (ListenerRecord)object;
            return ModelUtil.areEqual((Object)this.workspace, (Object)other.workspace) && this.listener.equals(other.listener);
        }
    }
}

