/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.file;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import oracle.ide.index.file.FileChange;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemListener;
import oracle.ideimpl.index.IndexLogger;
import oracle.ideimpl.index.file.ContentSetRootListener;
import oracle.ideimpl.index.file.FileChangeImpl;
import oracle.ideimpl.index.file.GlobalFilters;
import oracle.ideimpl.index.util.ContentSetRoot;
import oracle.javatools.util.Maps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ActiveRootManager {
    private static final int CACHE_SIZE = 100;
    @GuardedBy(value="ActiveRootManager.class")
    private static ActiveRootManager instance;
    @GuardedBy(value="itself")
    private final Map<ContentSetRoot, ActiveRootListener> activeRoots;
    @GuardedBy(value="activeRoots")
    private final Map<URL, Collection<ContentSetRoot>> cache;

    private void $init$() {
        this.activeRoots = new HashMap<ContentSetRoot, ActiveRootListener>();
        this.cache = new Maps.CacheMap(100, Maps.CacheMap.NONCANONICAL);
    }

    private ActiveRootManager() {
        this.$init$();
    }

    public static synchronized ActiveRootManager getInstance() {
        if (instance == null) {
            instance = new ActiveRootManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ContentSetRoot> getRootsContaining(URL url) {
        Map<ContentSetRoot, ActiveRootListener> map = this.activeRoots;
        synchronized (map) {
            Collection<ContentSetRoot> cachedRoots = this.cache.get(url);
            if (cachedRoots != null) {
                Collection<ContentSetRoot> collection = cachedRoots;
                return collection;
            }
            ArrayList<ContentSetRoot> roots = new ArrayList<ContentSetRoot>();
            for (ContentSetRoot root : this.activeRoots.keySet()) {
                if (!root.contains(url)) continue;
                roots.add(root);
            }
            roots.trimToSize();
            this.cache.put(url, roots);
            ArrayList<ContentSetRoot> arrayList = roots;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRootListener(ContentSetRoot root, ContentSetRootListener listener) {
        Map<ContentSetRoot, ActiveRootListener> map = this.activeRoots;
        synchronized (map) {
            ActiveRootListener arl = this.activeRoots.get(root);
            if (arl == null) {
                arl = new ActiveRootListener(root);
                this.activeRoots.put(root, arl);
                this.cache.clear();
                IndexLogger.getLogger().finest("Activated " + URLFileSystem.getPlatformPathName((URL)root.getURL()));
            }
            arl.addRootListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRootListener(ContentSetRoot root, ContentSetRootListener listener) {
        Map<ContentSetRoot, ActiveRootListener> map = this.activeRoots;
        synchronized (map) {
            ActiveRootListener arl = this.activeRoots.get(root);
            if (arl != null) {
                arl.removeRootListener(listener);
                this.cache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRoots(FileChange change) {
        URL url = change.getURL();
        if (GlobalFilters.accept(url)) {
            ArrayList<ActiveRootListener> listeners = new ArrayList<ActiveRootListener>();
            Map<ContentSetRoot, ActiveRootListener> map = this.activeRoots;
            synchronized (map) {
                for (ContentSetRoot root : this.getRootsContaining(url)) {
                    listeners.add(this.activeRoots.get(root));
                }
            }
            for (ActiveRootListener listener : listeners) {
                listener.invokeListeners(change);
            }
        }
    }

    static Map ra$activeRoots(ActiveRootManager activeRootManager) {
        return activeRootManager.activeRoots;
    }

    static Map ra$cache(ActiveRootManager activeRootManager) {
        return activeRootManager.cache;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ActiveRootListener
    implements URLFileSystemListener {
        private ContentSetRoot root;
        private CopyOnWriteArrayList<ContentSetRootListener> listeners;

        private void $init$() {
            this.listeners = new CopyOnWriteArrayList();
        }

        public ActiveRootListener(ContentSetRoot root) {
            this.$init$();
            this.root = root;
            URLFileSystem.addURLFileSystemListener((URL)root.getURL(), (URLFileSystemListener)this);
        }

        public void addRootListener(ContentSetRootListener listener) {
            this.listeners.add(listener);
        }

        public void removeRootListener(ContentSetRootListener listener) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispose() {
            Map map = ActiveRootManager.ra$activeRoots(ActiveRootManager.this);
            synchronized (map) {
                ActiveRootManager.ra$activeRoots(ActiveRootManager.this).remove(this.root);
                ActiveRootManager.ra$cache(ActiveRootManager.this).clear();
            }
            IndexLogger.getLogger().finest("Deactivated " + URLFileSystem.getPlatformPathName((URL)this.root.getURL()));
            URLFileSystem.removeURLFileSystemListener((URL)this.root.getURL(), (URLFileSystemListener)this);
        }

        public void notifyEvent(URLFileSystemEvent event) {
            URL url = event.getURL();
            if (!this.root.contains(url) || !GlobalFilters.accept(url)) {
                return;
            }
            int type = event.getEventType();
            if (type == 3) {
                this.invokeListeners(new FileChangeImpl(FileChange.Type.FILE_REMOVED, url, -1));
            } else if (type == 1) {
                long timestamp = URLFileSystem.lastModified((URL)url);
                this.invokeListeners(new FileChangeImpl(FileChange.Type.FILE_ADDED, url, timestamp));
            } else if (type == 2) {
                long timestamp = URLFileSystem.lastModified((URL)url);
                this.invokeListeners(new FileChangeImpl(FileChange.Type.FILE_CHANGED, url, timestamp));
            } else if (type == 4) {
                long timestamp = URLFileSystem.lastModified((URL)url);
                this.invokeListeners(new FileChangeImpl(FileChange.Type.FILE_REMOVED, event.getOldURL(), -1));
                this.invokeListeners(new FileChangeImpl(FileChange.Type.FILE_ADDED, url, timestamp));
            }
        }

        public void invokeListeners(FileChange change) {
            this.invokeListeners(Collections.singleton(change));
        }

        public void invokeListeners(Collection<FileChange> changes) {
            for (ContentSetRootListener listener : this.listeners) {
                listener.filesChanged(changes);
            }
        }
    }
}

