/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.file;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import oracle.ide.index.file.FileTable;
import oracle.ide.index.file.FileTableManager;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.model.Project;
import oracle.ide.util.PatternFilters;
import oracle.ideimpl.index.file.AbstractFileTable;
import oracle.ideimpl.index.file.ActiveRootManager;
import oracle.ideimpl.index.file.DefaultFileTableFactory;
import oracle.ideimpl.index.file.FileTableFactory;
import oracle.ideimpl.index.util.ContentSetRoot;
import oracle.javatools.util.Maps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTableManagerImpl
extends FileTableManager {
    private static final FileTableFactory DEFAULT_FACTORY = new DefaultFileTableFactory();
    private List<FileTableFactory> factories;
    protected static final Map<ContentSetRoot, AbstractFileTable> TABLES = new Maps.ManagedCacheMap(Maps.CacheMap.HARD, FileTable.class.getSimpleName());

    private void $init$() {
        this.factories = new ArrayList<FileTableFactory>(3);
    }

    public void addFileTableFactory(FileTableFactory factory) {
        this.factories.add(factory);
    }

    public void removeFileTableFactory(FileTableFactory factory) {
        this.factories.remove(factory);
    }

    public void pinFileTable(Project project, URL root, PatternFilters filters) {
        AbstractFileTable table = this.getFileTableImpl(project, root, filters);
        ++table.refCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpinFileTable(Project project, URL root, PatternFilters filters) {
        ContentSetRoot key = new ContentSetRoot(project, root, filters);
        Map<ContentSetRoot, AbstractFileTable> map = TABLES;
        synchronized (map) {
            AbstractFileTable table = TABLES.get(key);
            if (table != null) {
                table.release();
            }
        }
    }

    @Override
    public FileTable getFileTable(Project project, URL root, PatternFilters filters) throws InterruptedException, ExecutionException {
        AbstractFileTable table = this.getFileTableImpl(project, root, filters);
        BackgroundTask<FileTable> task = null;
        try {
            task = table.getUpdateTask();
            FileTable snapshot = (FileTable)task.get();
            ++table.refCount;
            FileTable fileTable = snapshot;
            return fileTable;
        }
        catch (InterruptedException e) {
            if (task != null) {
                task.cancel(true);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFileTable getTableForRoot(ContentSetRoot root) {
        Map<ContentSetRoot, AbstractFileTable> map = TABLES;
        synchronized (map) {
            AbstractFileTable abstractFileTable = TABLES.get(root);
            return abstractFileTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AbstractFileTable> getTablesForRoots(Collection<ContentSetRoot> roots) {
        ArrayList<AbstractFileTable> tables = new ArrayList<AbstractFileTable>(roots.size());
        Map<ContentSetRoot, AbstractFileTable> map = TABLES;
        synchronized (map) {
            for (ContentSetRoot root : roots) {
                AbstractFileTable table = TABLES.get(root);
                if (table == null) continue;
                tables.add(table);
            }
        }
        return Collections.unmodifiableCollection(tables);
    }

    @Override
    public void invalidateFile(URL file) {
        Collection<ContentSetRoot> roots = ActiveRootManager.getInstance().getRootsContaining(file);
        for (AbstractFileTable table : this.getTablesForRoots(roots)) {
            table.invalidateFile(file);
        }
    }

    @Override
    public void invalidateDir(URL directory, boolean subdirs) {
        Collection<ContentSetRoot> roots = ActiveRootManager.getInstance().getRootsContaining(directory);
        for (AbstractFileTable table : this.getTablesForRoots(roots)) {
            table.invalidateDir(directory, subdirs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll() {
        Map<ContentSetRoot, AbstractFileTable> map = TABLES;
        synchronized (map) {
            for (AbstractFileTable table : TABLES.values()) {
                table.invalidateDir(table.root.getURL(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractFileTable getFileTableImpl(Project project, URL root, PatternFilters filters) {
        AbstractFileTable table;
        ContentSetRoot key = new ContentSetRoot(project, root, filters);
        Map<ContentSetRoot, AbstractFileTable> map = TABLES;
        synchronized (map) {
            table = TABLES.get(key);
            if (table == null) {
                table = this.createFileTable(project, root, filters);
                TABLES.put(key, table);
            }
        }
        return table;
    }

    private AbstractFileTable createFileTable(Project project, URL root, PatternFilters filters) {
        for (FileTableFactory factory : this.factories) {
            if (!factory.canCreateFileTable(project, root, filters)) continue;
            return factory.createFileTable(project, root, filters);
        }
        return DEFAULT_FACTORY.createFileTable(project, root, filters);
    }

    public FileTableManagerImpl() {
        this.$init$();
    }
}

