/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.file;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import oracle.ide.model.Project;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ArraySortedSet;
import oracle.ide.util.PatternFilters;
import oracle.ideimpl.index.file.AbstractFileTable;
import oracle.ideimpl.index.file.DifferenceFileTable;
import oracle.ideimpl.index.file.DirEntry;
import oracle.ideimpl.index.file.FileEntry;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileTable
extends DifferenceFileTable {
    private static final char[] EMPTY_CHARS = new char[0];
    private long lastModified;

    protected JarFileTable(Project project, URL root, PatternFilters filters) {
        super(project, root, filters);
    }

    @Override
    public boolean isModified() {
        URL jarFileURL = JarUtil.getJarFileURL((URL)this.root.getURL());
        return this.lastModified != URLFileSystem.lastModified((URL)jarFileURL);
    }

    @Override
    public ArraySortedSet<DirEntry> getDirEntries() {
        ArraySortedSet dirs = new ArraySortedSet(AbstractFileTable.DIR_COMPARATOR);
        try {
            this.bailIfCancelled();
            JarIndex jarIndex = JarUtil.getJarIndex((URL)this.root.getURL());
            String[] entries = jarIndex.getEntries();
            int numEntries = entries.length;
            this.bailIfCancelled();
            String rootPrefix = JarUtil.getJarEntry((URL)this.root.getURL());
            int rootLen = rootPrefix != null ? rootPrefix.length() : 0;
            this.bailIfCancelled();
            URL jarFileURL = JarUtil.getJarFileURL((URL)this.root.getURL());
            this.lastModified = URLFileSystem.lastModified((URL)jarFileURL);
            int i = 0;
            while (i < numEntries) {
                block13: {
                    String entry;
                    block12: {
                        this.bailIfCancelled();
                        entry = entries[i];
                        if (rootLen <= 0) break block12;
                        if (!entry.startsWith(rootPrefix)) break block13;
                        entry = entry.substring(rootLen);
                    }
                    if (entry.length() != 0) {
                        char[] filename;
                        char[] directory;
                        int lastSlash = entry.lastIndexOf(47);
                        if (lastSlash == -1) {
                            directory = EMPTY_CHARS;
                            filename = entry.toCharArray();
                        } else {
                            directory = this.charPool.add(entry.substring(0, lastSlash + 1));
                            filename = this.charPool.add(entry.substring(lastSlash + 1));
                        }
                        if (filename.length != 0) {
                            int lastDot = entry.lastIndexOf(46);
                            char[] extension = lastDot >= 0 && lastDot > lastSlash ? this.charPool.add(entry.substring(lastDot)) : EMPTY_CHARS;
                            if (filename[0] != '.') {
                                this.lookupDir.path = directory;
                                DirEntry dir = (DirEntry)dirs.lookup((Object)this.lookupDir);
                                if (dir == null) {
                                    dir = new DirEntry(directory);
                                    dirs.add((Object)dir);
                                }
                                int size = jarIndex.getSize(entries[i]);
                                dir.files.add((Object)new FileEntry(filename, directory, extension, this.lastModified, size));
                            }
                        }
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            dirs.clear();
        }
        return dirs;
    }

    @Override
    protected AssemblyFactory getStorageFactory() {
        return new JarFileTableStorageFactory(super.getStorageFactory());
    }

    @Override
    protected void loadFromStorage(Object object) {
        JarFileTableStorage storage = (JarFileTableStorage)object;
        this.lastModified = JarFileTableStorage.ra$lastModified(storage);
        super.loadFromStorage(JarFileTableStorage.ra$parentData(storage));
    }

    @Override
    protected Object saveToStorage() {
        return new JarFileTableStorage(super.saveToStorage(), this.lastModified);
    }

    private static final class JarFileTableStorage {
        private Object parentData;
        private long lastModified;

        public JarFileTableStorage(Object parentData, long lastModified) {
            this.parentData = parentData;
            this.lastModified = lastModified;
        }

        static long ra$lastModified(JarFileTableStorage jarFileTableStorage) {
            return jarFileTableStorage.lastModified;
        }

        static Object ra$parentData(JarFileTableStorage jarFileTableStorage) {
            return jarFileTableStorage.parentData;
        }
    }

    private static final class JarFileTableStorageFactory
    extends ObjectFactory {
        private AssemblyFactory parentFactory;

        public JarFileTableStorageFactory(AssemblyFactory parentFactory) {
            this.parentFactory = parentFactory;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            Object parentData = this.parentFactory.assemble(input);
            long lastModified = input.readLong();
            return new JarFileTableStorage(parentData, lastModified);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            JarFileTableStorage storage = (JarFileTableStorage)object;
            this.parentFactory.disassemble(JarFileTableStorage.ra$parentData(storage), output);
            output.writeLong(JarFileTableStorage.ra$lastModified(storage));
        }
    }
}

