/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.gotofile;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.index.IndexLogger;
import oracle.ideimpl.index.gotofile.GotoFilePanel;
import oracle.ideimpl.index.res.IndexingArb;

public final class GotoFileDialog
extends JEWTDialog {
    private GotoFilePanel panel;

    public static void showDialog(Context context) {
        GotoFileDialog dialog = new GotoFileDialog(context);
        try {
            boolean ok = WizardLauncher.runDialog((JDialog)((Object)dialog));
            if (ok) {
                URL url = dialog.getURL();
                Project project = dialog.getProject();
                GotoFileDialog.openEditor(project, url);
            }
        }
        finally {
            dialog.disposePanel();
        }
    }

    public static void openEditor(Project project, URL url) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            Context newContext = Context.newIdeContext((Node)node);
            newContext.setProject(project);
            1 r = new 1(newContext);
            SwingUtilities.invokeLater(r);
        }
        catch (Throwable t) {
            IndexLogger.getLogger().log(Level.SEVERE, "Unable to open editor for " + URLFileSystem.getPlatformPathName((URL)url), t);
        }
    }

    private GotoFileDialog(Context context) {
        super((Frame)Ide.getMainWindow(), IndexingArb.getString(2), 7);
        2 actionListener = new 2();
        3 changeListener = new 3();
        this.panel = new GotoFilePanel(context, actionListener, changeListener);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.panel, "f1_idegotofile_html");
        this.setContent(this.panel);
        this.setInitialFocus(this.panel.getInitialFocus());
        this.setOKButtonEnabled(false);
    }

    private URL getURL() {
        return this.panel.getURL();
    }

    private Project getProject() {
        return this.panel.getProject();
    }

    private void disposePanel() {
        this.panel.dispose();
    }

    static void mav$dismissDialog(GotoFileDialog gotoFileDialog, boolean bl) {
        gotoFileDialog.dismissDialog(bl);
    }

    static final class 1
    implements Runnable {
        private final /* synthetic */ Context v$newContext;

        public void run() {
            EditorManager editorManager = EditorManager.getEditorManager();
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(this.v$newContext);
            openEditorOptions.setFlags(8, true);
            editorManager.openEditor(openEditorOptions);
        }

        public 1(Context context) {
            this.v$newContext = context;
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            GotoFileDialog.mav$dismissDialog(GotoFileDialog.this, false);
        }
    }

    final class 3
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == "hasResult") {
                Boolean value = (Boolean)e.getNewValue();
                GotoFileDialog.this.setOKButtonEnabled(value);
            }
        }
    }
}

