/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.gotofile;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLComparator;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.WildcardURLFilter;
import oracle.ideimpl.index.IndexThreadFactory;
import oracle.ideimpl.index.res.IndexingArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.insight.CamelCaseInsightInputFilter;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.editor.insight.ReadOnlyListModel;
import oracle.javatools.util.CamelCaseFilter;
import oracle.javatools.util.Executors;

public final class IndexPopup {
    public static final String PROPERTY_HAS_RESULT = "hasResult";
    private Project project;
    private JTextField field;
    private ActionListener actionListener;
    private PropertyChangeListener changeListener;
    private JWindow popupWindow;
    private ListInsightView popupList;
    private ResultItem lastDefaultItem;
    private boolean inNavigation;
    private FieldListener fieldListener;
    private URLComparator comparator;
    private ExecutorService indexScheduler;
    private ExecutorService filterScheduler;
    private Future<List<ResultItem>> indexTask;
    private Future filterTask;
    private int lastLength;
    private boolean gotLonger;
    private String previousText;
    private final ResultItem[] noDataItems;

    private void $init$() {
        this.comparator = new URLComparator();
        this.indexScheduler = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new IndexThreadFactory("goto-file-index"), new ThreadPoolExecutor.DiscardPolicy());
        this.filterScheduler = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new IndexThreadFactory("goto-file-filter"), new ThreadPoolExecutor.DiscardPolicy());
        this.lastLength = 0;
        this.previousText = "";
        this.noDataItems = new ResultItem[]{new NoResultItem()};
    }

    public static final IndexPopup createIndexPopup(Context context, JTextField field, ActionListener actionListener, PropertyChangeListener changeListener) {
        return new IndexPopup(context, field, actionListener, changeListener);
    }

    private IndexPopup(Context context, JTextField field, ActionListener actionListener, PropertyChangeListener changeListener) {
        this.$init$();
        this.field = field;
        this.actionListener = actionListener;
        this.changeListener = changeListener;
        this.project = context.getProject();
        if (this.project == null) {
            this.project = Ide.getDefaultProject();
        }
        this.previousText = field.getText();
        Caret oldCaret = field.getCaret();
        DefaultCaret newCaret = new DefaultCaret();
        newCaret.setBlinkRate(oldCaret.getBlinkRate());
        field.setCaret(newCaret);
        this.fieldListener = new FieldListener(null);
        field.addCaretListener(this.fieldListener);
        field.addKeyListener(this.fieldListener);
        field.addFocusListener(this.fieldListener);
        field.addAncestorListener(this.fieldListener);
        this.indexTask = this.indexScheduler.submit(new IndexTask(null));
    }

    public URL getURL() {
        ResultItem item = this.getSelectedItem();
        return item == null ? null : item.getURL();
    }

    public Project getProject() {
        ResultItem item = this.getSelectedItem();
        return item == null ? null : item.getProject();
    }

    private ResultItem getSelectedItem() {
        if (this.lastDefaultItem != null) {
            return this.lastDefaultItem;
        }
        return this.getPoplistItem();
    }

    public void dispose() {
        Executors.shutdownNow((ExecutorService)this.indexScheduler);
        Executors.shutdownNow((ExecutorService)this.filterScheduler);
        if (this.popupList != null) {
            this.popupList.removeListSelectionListener((ListSelectionListener)this.fieldListener);
            this.popupList.removeMouseListener((MouseListener)this.fieldListener);
            this.popupList = null;
        }
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
            this.popupWindow.dispose();
            this.popupWindow = null;
        }
        if (this.field != null) {
            this.field.removeCaretListener(this.fieldListener);
            this.field.removeKeyListener(this.fieldListener);
            this.field.removeFocusListener(this.fieldListener);
            this.field.removeAncestorListener(this.fieldListener);
            this.field = null;
        }
    }

    private void updatePopup() {
        if (this.field != null && this.field.isVisible() && this.field.hasFocus()) {
            int caretPosition = this.field.getCaretPosition();
            if (caretPosition > 0) {
                String text = this.field.getText().substring(0, caretPosition);
                this.scheduleFilter(text);
            } else {
                this.hidePopup();
                this.fireChangeEvent(false);
            }
        }
    }

    private void hidePopup() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
        }
    }

    private void scheduleFilter(String text) {
        if (this.filterTask != null) {
            this.filterTask.cancel(true);
        }
        this.filterTask = this.filterScheduler.submit(new FilterTask(text));
    }

    private void displayResults(ResultData data) {
        ListDataItem[] resultItems;
        if (this.field == null || !this.field.isVisible()) {
            return;
        }
        String fieldText = this.field.getText();
        if (!fieldText.equals(data.getPrefix())) {
            return;
        }
        if (this.popupWindow == null) {
            this.popupList = new ListInsightView((ListCellRenderer)((Object)new ResultRenderer(null)));
            this.popupList.addListSelectionListener((ListSelectionListener)this.fieldListener);
            this.popupList.addMouseListener((MouseListener)this.fieldListener);
            this.popupList.setData((InsightData)data);
            JScrollPane scroller = new JScrollPane((Component)this.popupList);
            scroller.setHorizontalScrollBarPolicy(31);
            Window parentWindow = SwingUtilities.getWindowAncestor(this.field);
            this.popupWindow = new JWindow(parentWindow);
            this.popupWindow.getContentPane().add(scroller);
            this.popupWindow.setFocusableWindowState(false);
        } else {
            this.popupList.setData((InsightData)data);
        }
        if (!this.popupWindow.isVisible()) {
            Point location = this.field.getLocationOnScreen();
            location.y += this.field.getHeight() + 2;
            this.popupWindow.setLocation(location);
        }
        if ((resultItems = data.getData()).length == 0) {
            this.lastDefaultItem = null;
            this.popupWindow.setVisible(false);
            this.fireChangeEvent(false);
        } else {
            String replaceText;
            this.inNavigation = true;
            try {
                this.popupList.selectDefault();
            }
            finally {
                this.inNavigation = false;
            }
            this.lastDefaultItem = (ResultItem)((Object)data.getDefault());
            this.fireChangeEvent(true);
            if (this.gotLonger && resultItems != this.noDataItems && (replaceText = CamelCaseInsightInputFilter.INSTANCE.findCommonPrefix(resultItems, fieldText)) != null) {
                this.inNavigation = true;
                try {
                    int selectStart = this.field.getCaretPosition();
                    int selectEnd = replaceText.length();
                    this.field.setText(replaceText);
                    this.field.setCaretPosition(selectEnd);
                    this.field.moveCaretPosition(selectStart);
                    this.lastLength = replaceText.length();
                }
                finally {
                    this.inNavigation = false;
                }
            }
            if (this.popupWindow.isVisible() || this.field == null || !this.field.getText().equals(this.previousText)) {
                this.popupWindow.pack();
                this.popupWindow.setVisible(true);
            }
        }
    }

    private ResultItem getPoplistItem() {
        ResultItem item;
        if (this.popupList != null && (item = (ResultItem)((Object)this.popupList.getSelectedValue())) != this.noDataItems[0]) {
            return item;
        }
        return null;
    }

    private void fireChangeEvent(boolean hasResult) {
        if (this.changeListener != null) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, PROPERTY_HAS_RESULT, hasResult ^ true, hasResult);
            this.changeListener.propertyChange(e);
        }
    }

    static boolean ra$inNavigation(IndexPopup indexPopup) {
        return indexPopup.inNavigation;
    }

    static ListInsightView ra$popupList(IndexPopup indexPopup) {
        return indexPopup.popupList;
    }

    static ResultItem mav$getPoplistItem(IndexPopup indexPopup) {
        return indexPopup.getPoplistItem();
    }

    static void wa$lastDefaultItem(IndexPopup indexPopup, ResultItem resultItem) {
        indexPopup.lastDefaultItem = resultItem;
    }

    static ResultItem ra$lastDefaultItem(IndexPopup indexPopup) {
        return indexPopup.lastDefaultItem;
    }

    static void wa$inNavigation(IndexPopup indexPopup, boolean bl) {
        indexPopup.inNavigation = bl;
    }

    static JTextField ra$field(IndexPopup indexPopup) {
        return indexPopup.field;
    }

    static ActionListener ra$actionListener(IndexPopup indexPopup) {
        return indexPopup.actionListener;
    }

    static void wa$previousText(IndexPopup indexPopup, String string) {
        indexPopup.previousText = string;
    }

    static void mav$hidePopup(IndexPopup indexPopup) {
        indexPopup.hidePopup();
    }

    static JWindow ra$popupWindow(IndexPopup indexPopup) {
        return indexPopup.popupWindow;
    }

    static void mav$updatePopup(IndexPopup indexPopup) {
        indexPopup.updatePopup();
    }

    static int ra$lastLength(IndexPopup indexPopup) {
        return indexPopup.lastLength;
    }

    static void wa$gotLonger(IndexPopup indexPopup, boolean bl) {
        indexPopup.gotLonger = bl;
    }

    static void wa$lastLength(IndexPopup indexPopup, int n) {
        indexPopup.lastLength = n;
    }

    static URLComparator ra$comparator(IndexPopup indexPopup) {
        return indexPopup.comparator;
    }

    static Project ra$project(IndexPopup indexPopup) {
        return indexPopup.project;
    }

    static Future ra$indexTask(IndexPopup indexPopup) {
        return indexPopup.indexTask;
    }

    static ResultItem[] ra$noDataItems(IndexPopup indexPopup) {
        return indexPopup.noDataItems;
    }

    static void mav$displayResults(IndexPopup indexPopup, ResultData resultData) {
        indexPopup.displayResults(resultData);
    }

    static Future ra$filterTask(IndexPopup indexPopup) {
        return indexPopup.filterTask;
    }

    private final class FieldListener
    implements CaretListener,
    KeyListener,
    FocusListener,
    AncestorListener,
    MouseListener,
    ListSelectionListener {
        public void caretUpdate(CaretEvent e) {
            if (!IndexPopup.ra$inNavigation(IndexPopup.this) && IndexPopup.ra$field(IndexPopup.this) != null) {
                int newLength = IndexPopup.ra$field(IndexPopup.this).getText().length();
                IndexPopup.wa$gotLonger(IndexPopup.this, newLength > IndexPopup.ra$lastLength(IndexPopup.this));
                IndexPopup.wa$lastLength(IndexPopup.this, newLength);
                IndexPopup.mav$updatePopup(IndexPopup.this);
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        /*
         * Exception decompiling
         */
        public void keyPressed(KeyEvent e) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void keyReleased(KeyEvent e) {
        }

        public void focusGained(FocusEvent e) {
            if (IndexPopup.ra$popupWindow(IndexPopup.this) != null && !IndexPopup.ra$popupWindow(IndexPopup.this).isVisible()) {
                IndexPopup.mav$updatePopup(IndexPopup.this);
            }
        }

        public void focusLost(FocusEvent e) {
            if (!e.isTemporary() && IndexPopup.ra$popupList(IndexPopup.this) != null) {
                ResultItem item = IndexPopup.mav$getPoplistItem(IndexPopup.this);
                if (item != null) {
                    IndexPopup.ra$field(IndexPopup.this).setText(item.toString());
                }
                IndexPopup.mav$hidePopup(IndexPopup.this);
            }
        }

        public void ancestorAdded(AncestorEvent event) {
        }

        public void ancestorRemoved(AncestorEvent event) {
        }

        public void ancestorMoved(AncestorEvent event) {
            IndexPopup.mav$hidePopup(IndexPopup.this);
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1 && IndexPopup.ra$popupList(IndexPopup.this) != null) {
                ResultItem item = IndexPopup.mav$getPoplistItem(IndexPopup.this);
                if (item != null) {
                    if (IndexPopup.ra$actionListener(IndexPopup.this) != null) {
                        ActionEvent actionEvent = new ActionEvent(this, 1001, null);
                        IndexPopup.ra$actionListener(IndexPopup.this).actionPerformed(actionEvent);
                    } else {
                        IndexPopup.ra$field(IndexPopup.this).setText(item.toString());
                        IndexPopup.wa$previousText(IndexPopup.this, IndexPopup.ra$field(IndexPopup.this).getText());
                        IndexPopup.mav$hidePopup(IndexPopup.this);
                    }
                }
                e.consume();
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!IndexPopup.ra$inNavigation(IndexPopup.this) && IndexPopup.ra$popupList(IndexPopup.this) != null) {
                IndexPopup.wa$lastDefaultItem(IndexPopup.this, IndexPopup.mav$getPoplistItem(IndexPopup.this));
                if (IndexPopup.ra$lastDefaultItem(IndexPopup.this) != null) {
                    IndexPopup.wa$inNavigation(IndexPopup.this, true);
                    try {
                        String text = IndexPopup.ra$lastDefaultItem(IndexPopup.this).getName();
                        if (!IndexPopup.ra$field(IndexPopup.this).getText().equals(text)) {
                            IndexPopup.ra$field(IndexPopup.this).setText(text);
                        }
                    }
                    finally {
                        IndexPopup.wa$inNavigation(IndexPopup.this, false);
                    }
                }
            }
        }

        private FieldListener() {
        }

        FieldListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class NoResultItem
    extends ResultItem {
        public NoResultItem() {
            super(null, null);
        }

        public Icon getIcon() {
            return null;
        }

        public String toString() {
            return IndexingArb.getString(1);
        }

        public String getDisplayText() {
            return this.toString();
        }

        public String getName() {
            return this.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultItem
    extends ListDataItem {
        private Project project;
        private URL url;
        private String filename;
        private Icon icon;
        private String displayText;

        public ResultItem(Project project, URL url) {
            this.project = project;
            this.url = url;
            if (url != null) {
                this.filename = URLFileSystem.getFileName((URL)url);
            }
        }

        public Project getProject() {
            return this.project;
        }

        public URL getURL() {
            return this.url;
        }

        public String getFilename() {
            return this.filename;
        }

        public Icon getIcon() {
            if (this.icon == null) {
                try {
                    Node node = NodeFactory.findOrCreate((URL)this.url);
                    this.icon = node.getIcon();
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
            }
            return this.icon;
        }

        public String toString() {
            return this.filename;
        }

        public String getDisplayText() {
            if (this.displayText == null) {
                URL parent = URLFileSystem.getParent((URL)this.url);
                if (parent != null) {
                    ContentSet content = ProjectContent.getInstance((PropertyStorage)this.project).getAllContents();
                    String path = content.toRelativePath(parent);
                    if (path == null) {
                        path = URLFileSystem.getPlatformPathName((URL)parent);
                    } else if (path.endsWith("/")) {
                        path = path.substring(0, path.length() - 1);
                    }
                    path = path.trim();
                    if (path.length() > 0) {
                        this.displayText = IndexingArb.format(4, this.filename, this.project.getShortLabel(), path);
                    }
                }
                if (this.displayText == null) {
                    this.displayText = IndexingArb.format(5, this.filename, this.project.getShortLabel());
                }
            }
            return this.displayText;
        }

        public String getName() {
            return this.filename;
        }

        public int compareTo(Object object) {
            ResultItem other = (ResultItem)((Object)object);
            return IndexPopup.ra$comparator(IndexPopup.this).compare((Object)this.url, (Object)other.url);
        }
    }

    private static final class ResultData
    implements ListInsightData {
        private ResultItem[] items;
        private ReadOnlyListModel model;
        private String prefix;

        public ResultData(ResultItem[] items, String prefix) {
            CamelCaseInsightInputFilter.INSTANCE.sort((ListDataItem[])items, prefix);
            this.items = items;
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public ListModel getListModel() {
            if (this.model == null) {
                this.model = new ReadOnlyListModel((Object[])this.items);
            }
            return this.model;
        }

        public ResultItem[] getData() {
            return this.items;
        }

        public Object[] getMatchingData() {
            return this.items;
        }

        public int getMatchingDataCount() {
            return this.items.length;
        }

        public Object getDefault() {
            this.getListModel();
            return CamelCaseInsightInputFilter.INSTANCE.findClosestDataItem((ListDataItem[])this.items, this.prefix);
        }

        public boolean complete(Object selectedObject) {
            return false;
        }

        public void partialComplete() {
        }
    }

    private static final class ResultRenderer
    extends ListDataItemCellRenderer {
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            Dimension newSize = new Dimension(Math.max(size.width, 200), size.height);
            return newSize;
        }

        private ResultRenderer() {
        }

        ResultRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IndexTask
    implements Callable<List<ResultItem>> {
        @Override
        public List<ResultItem> call() throws InterruptedException, ExecutionException {
            ArrayList<ResultItem> results = new ArrayList<ResultItem>();
            this.getResults(IndexPopup.ra$project(IndexPopup.this), results);
            DependencyConfiguration dc = DependencyConfiguration.getInstance((Project)IndexPopup.ra$project(IndexPopup.this));
            Iterator iterator = dc.getAllDependenciesList().iterator();
            while (iterator.hasNext()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                Dependable dependable = (Dependable)iterator.next();
                Element source = dependable.getSource();
                if (!(source instanceof Project)) continue;
                Project current = (Project)source;
                this.getResults(current, results);
            }
            results.trimToSize();
            return results;
        }

        private void getResults(Project project, List<ResultItem> results) throws InterruptedException, ExecutionException {
            QueryCriteria criteria = new QueryCriteria();
            criteria.put("file.all", "file.all");
            IndexManager indexManager = IndexManager.getIndexManager();
            Index index = indexManager.getIndex(project);
            try {
                URL[] urls;
                BackgroundTask<URL[]> task = index.query(criteria);
                URL[] uRLArray = urls = (URL[])task.get();
                int n = 0;
                while (n < uRLArray.length) {
                    URL url = uRLArray[n];
                    results.add(new ResultItem(project, url));
                    ++n;
                }
            }
            finally {
                index.release();
            }
        }

        private IndexTask() {
        }

        IndexTask(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FilterTask
    implements Callable {
        private String filter;

        public FilterTask(String filter) {
            this.filter = filter;
        }

        public Object call() throws InterruptedException, ExecutionException {
            if (!IndexPopup.ra$indexTask(IndexPopup.this).isDone()) {
                ResultData noData = new ResultData(IndexPopup.ra$noDataItems(IndexPopup.this), this.filter);
                1 r = new 1(this, noData);
                SwingUtilities.invokeLater(r);
            }
            List results = (List)IndexPopup.ra$indexTask(IndexPopup.this).get();
            CamelCaseFilter camelFilter = new CamelCaseFilter(this.filter);
            Pattern pattern = null;
            if (WildcardURLFilter.hasWildcard((String)this.filter)) {
                try {
                    String str = this.filter.endsWith("*") ? this.filter : this.filter + "*";
                    String regexp = WildcardURLFilter.wildcard2Regexp((String)str);
                    pattern = Pattern.compile(regexp, 2);
                }
                catch (PatternSyntaxException e) {
                    // empty catch block
                }
            }
            ArrayList<ResultItem> filtered = new ArrayList<ResultItem>();
            for (ResultItem item : results) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                String suffix = URLFileSystem.getSuffix((URL)item.getURL());
                if (".jpr".equals(suffix) || ".jws".equals(suffix)) continue;
                String filename = item.getFilename();
                if (pattern != null && pattern.matcher(filename).matches()) {
                    filtered.add(item);
                }
                if (!camelFilter.matches(filename)) continue;
                filtered.add(item);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ResultItem[] items = filtered.toArray(new ResultItem[filtered.size()]);
            ResultData data = new ResultData(items, this.filter);
            2 r = new 2(this, data);
            SwingUtilities.invokeLater(r);
            return null;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ ResultData v$noData;
            final /* synthetic */ FilterTask this$0;

            public void run() {
                IndexPopup.mav$displayResults(this.this$0.IndexPopup.this, this.v$noData);
            }

            public 1(FilterTask filterTask, ResultData resultData) {
                this.v$noData = resultData;
                this.this$0 = filterTask;
            }
        }

        final class 2
        implements Runnable {
            private final /* synthetic */ ResultData v$data;
            final /* synthetic */ FilterTask this$0;

            public void run() {
                if (!IndexPopup.ra$filterTask(this.this$0.IndexPopup.this).isCancelled()) {
                    IndexPopup.mav$displayResults(this.this$0.IndexPopup.this, this.v$data);
                }
            }

            public 2(FilterTask filterTask, ResultData resultData) {
                this.v$data = resultData;
                this.this$0 = filterTask;
            }
        }
    }
}

