/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.task;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.ide.index.task.BackgroundTask;
import oracle.ideimpl.index.task.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackgroundTaskImpl<V>
implements BackgroundTask<V> {
    private Future<V> future;
    private ProgressMonitor progress;
    private int refCount;
    private Object lock;

    private void $init$() {
        this.refCount = 1;
        this.lock = new Object();
    }

    public BackgroundTaskImpl(Future<V> future) {
        this(future, null);
    }

    public BackgroundTaskImpl(Future<V> future, ProgressMonitor progress) {
        this.$init$();
        this.future = future;
        this.progress = progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference() {
        Object object = this.lock;
        synchronized (object) {
            ++this.refCount;
        }
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    @Override
    public boolean cancel() {
        return this.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.lock;
        synchronized (object) {
            if (--this.refCount == 0) {
                boolean bl = this.future.cancel(mayInterruptIfRunning);
                return bl;
            }
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public int getProgress() {
        if (this.progress != null) {
            return this.progress.getProgress();
        }
        return this.isDone() ? 100 : 0;
    }

    @Override
    public String getProgressText() {
        if (this.progress != null) {
            return this.progress.getProgressText();
        }
        return "";
    }
}

