/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentSetRoot {
    protected final Project project;
    protected final URL url;
    protected final PatternFilters filters;

    public static Collection<ContentSetRoot> getContentSetRoots(Project project) {
        ContentSet content = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        return ContentSetRoot.getContentSetRoots(project, content);
    }

    public static Collection<ContentSetRoot> getContentSetRoots(Project project, ContentSet content) {
        ArrayList<ContentSetRoot> roots = new ArrayList<ContentSetRoot>();
        LinkedList<ContentSet> sets = new LinkedList<ContentSet>();
        sets.add(content);
        while (!sets.isEmpty()) {
            URL[] urls;
            ContentSet current = (ContentSet)sets.removeFirst();
            PatternFilters filters = current.getPatternFilters();
            URL[] uRLArray = urls = current.getURLPath().getEntries();
            int n = 0;
            while (n < uRLArray.length) {
                URL url = uRLArray[n];
                roots.add(new ContentSetRoot(project, url, filters));
                ++n;
            }
            int count = current.countContentSets();
            int i = 0;
            while (i < count) {
                sets.add(current.getContentSet(i));
                ++i;
            }
        }
        roots.trimToSize();
        return Collections.unmodifiableList(roots);
    }

    public ContentSetRoot(Project project, URL url, PatternFilters filters) {
        this.project = project;
        this.url = url;
        this.filters = ContentSetRoot.sanitizeFilters(filters);
    }

    public Project getProject() {
        return this.project;
    }

    public URL getURL() {
        return this.url;
    }

    public PatternFilters getFilters() {
        return this.filters;
    }

    public boolean contains(URL url) {
        String path = URLFileSystem.toRelativeSpec((URL)url, (URL)this.url, (boolean)true);
        return path != null && (this.filters == null || this.filters.isIncluded(path));
    }

    public int hashCode() {
        int hash = this.project.hashCode();
        hash = hash * 31 + this.url.hashCode();
        if (this.filters != null) {
            hash = hash * 31 + this.filters.hashCode();
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ContentSetRoot)) {
            return false;
        }
        ContentSetRoot other = (ContentSetRoot)object;
        return this.project.equals((Object)other.project) && this.url.equals(other.url) && ModelUtil.areEqual((Object)this.filters, (Object)other.filters);
    }

    private static PatternFilters sanitizeFilters(PatternFilters filters) {
        if (filters == null || !filters.containsFilters()) {
            return null;
        }
        PatternFilter[] pf = filters.getFilters();
        if (pf != null && pf.length == 1 && pf[0].isInclude() && "**".equals(pf[0].getPattern())) {
            return null;
        }
        return filters;
    }
}

