/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.docgen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.docgen.OracleXMLDocGen;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class OracleXMLDocGenDOM
extends OracleXMLDocGen {
    static final int MAX_CHUNK_SIZE = 32512;
    Document doc = null;
    Node currNode = null;
    Hashtable namespaces = null;
    Node firstElementAppended = null;
    boolean firstElementSeen = false;
    boolean rootSupplied = false;
    Node rootNode = null;
    DocumentFragment docFrag = null;

    public OracleXMLDocGenDOM() {
    }

    public OracleXMLDocGenDOM(Node node) {
        if (node == null) {
            throw new OracleXMLSQLException(this.msg.getMessage0("XSUE-0014"));
        }
        this.rootNode = node;
        this.rootSupplied = true;
    }

    public void createNewDocument(boolean bl) {
        if (this.docFrag != null) {
            return;
        }
        if (!this.rootSupplied) {
            this.doc = new XMLDocument();
            this.currNode = this.doc;
        } else if (this.firstElementSeen) {
            Node node = this.firstElementAppended;
            while (node != null) {
                Node node2 = node.getNextSibling();
                this.rootNode.removeChild(node);
                node = node2;
            }
            this.currNode = this.rootNode;
        } else {
            this.doc = this.rootNode.getOwnerDocument();
            this.currNode = this.rootNode;
        }
        if (this.encoding != null) {
            ((XMLDocument)this.doc).setEncoding(this.encoding);
        }
    }

    public void createProcessingInstruction(String string, String string2) {
        if (this.docFrag != null) {
            return;
        }
        if (!this.rootSupplied) {
            this.piT = string;
            this.piD = string2;
            this.doc.appendChild(this.doc.createProcessingInstruction(string, string2));
        }
    }

    public void setVersion(String string) {
        if (this.docFrag != null) {
            return;
        }
        if (!this.rootSupplied) {
            this.version = string;
            ((XMLDocument)this.doc).setVersion(string);
        }
    }

    public void setEncoding(String string) {
        this.encoding = string == null || string.length() == 0 ? null : string;
        if (this.doc != null) {
            ((XMLDocument)this.doc).setEncoding(this.encoding);
        }
    }

    public Object startNewElement(String string) {
        Element element = this.doc.createElement(string);
        this.currNode.appendChild(element);
        if (!this.firstElementSeen) {
            this.firstElementSeen = true;
            this.firstElementAppended = element;
        }
        this.currNode = element;
        return null;
    }

    public void addTextValue(String string, boolean bl) {
        this.checkLegalXMLChars(string);
        Text text = this.doc.createTextNode(string);
        this.currNode.appendChild(text);
    }

    public void addTextValue(Reader reader, boolean bl) throws IOException {
        char[] cArray = new char[32512];
        String string = new String();
        int n = 0;
        while ((n = reader.read(cArray, 0, 32512)) != -1) {
            string = string + new String(cArray, 0, n);
        }
        this.checkLegalXMLChars(string);
        this.addTextValue(string, bl);
    }

    public void endElement(Object object) {
        if (this.currNode == this.firstElementAppended && this.namespaces != null) {
            String string = null;
            Enumeration enumeration = this.namespaces.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                this.addAttribute("xmlns:" + string, (String)this.namespaces.get(string));
            }
        }
        this.currNode = this.currNode.getParentNode();
    }

    public void addAttribute(String string, String string2) {
        this.checkLegalXMLChars(string2);
        Attr attr = this.doc.createAttribute(string);
        attr.setValue(string2);
        ((Element)this.currNode).setAttributeNode(attr);
    }

    public void insertXMLFragment(Reader reader) throws IOException, XMLParseException, SAXException {
        FragmentReader fragmentReader = new FragmentReader(reader);
        DOMParser dOMParser = new DOMParser();
        dOMParser.setErrorStream((OutputStream)System.err);
        dOMParser.showWarnings(false);
        dOMParser.parse((Reader)fragmentReader);
        XMLDocument xMLDocument = dOMParser.getDocument();
        Node node = xMLDocument.getDocumentElement();
        node = ((XMLDocument)this.doc).adoptNode(node);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            this.currNode.appendChild(node3);
        }
    }

    public void insertXMLFragment(Document document) {
        Node node = document.getFirstChild();
        node = ((XMLDocument)this.doc).adoptNode(node);
        this.currNode.appendChild(node);
    }

    public String getXMLDocumentString() {
        if (this.docFrag != null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ((XMLDocument)this.doc).print(printWriter);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new OracleXMLSQLException(iOException.getMessage(), "ERROR_TAG");
        }
    }

    public Document getXMLDocumentDOM() {
        return this.doc;
    }

    public void print(Writer writer) throws IOException {
        ((XMLDocument)this.doc).print(new PrintWriter(writer));
    }

    public boolean applyStylesheet(XSLProcessor xSLProcessor, XSLStylesheet xSLStylesheet) {
        try {
            XMLDocumentFragment xMLDocumentFragment = xSLProcessor.processXSL(xSLStylesheet, (XMLDocument)this.doc);
            this.createNewDocument(true);
            if (!this.rootSupplied) {
                if (this.version != null) {
                    this.setVersion(this.version);
                }
                if (this.piT != null) {
                    this.doc.appendChild(this.doc.createProcessingInstruction(this.piT, this.piD));
                }
            }
            this.currNode.appendChild((Node)xMLDocumentFragment);
            return true;
        }
        catch (XSLException xSLException) {
            throw new OracleXMLSQLException((Exception)((Object)xSLException));
        }
    }

    public Object getDocFragment() {
        return this.docFrag;
    }

    public void appendDTD(String string) {
    }

    public OracleXMLDocGen newDocGenDoc(boolean bl) {
        OracleXMLDocGenDOM oracleXMLDocGenDOM = new OracleXMLDocGenDOM();
        if (this.encoding != null) {
            oracleXMLDocGenDOM.setEncoding(this.encoding);
        }
        if (bl) {
            oracleXMLDocGenDOM.doc = this.doc;
            oracleXMLDocGenDOM.docFrag = this.doc.createDocumentFragment();
            oracleXMLDocGenDOM.currNode = oracleXMLDocGenDOM.docFrag;
        } else {
            oracleXMLDocGenDOM.doc = new XMLDocument();
            oracleXMLDocGenDOM.currNode = oracleXMLDocGenDOM.doc;
        }
        return oracleXMLDocGenDOM;
    }

    public void docAppend(OracleXMLDocGen oracleXMLDocGen) {
        if (this.docFrag != null) {
            return;
        }
        this.currNode.appendChild((DocumentFragment)oracleXMLDocGen.getDocFragment());
    }

    public String addNamespace(String string, String string2) {
        if (!this.firstElementSeen) {
            return null;
        }
        if (this.namespaces == null) {
            this.namespaces = new Hashtable(4);
        }
        return this.namespaces.put(string, string2);
    }

    public boolean supportMetatype(int n) {
        return n == 2;
    }

    private static class FragmentReader
    extends Reader {
        private Reader src;
        int loc;
        char[] opentag = new char[]{'<', 'A', '>', '\n'};
        char[] closetag = new char[]{'<', '/', 'A', '>'};

        public FragmentReader(Reader reader) {
            this.src = reader instanceof BufferedReader ? reader : new BufferedReader(reader);
            this.loc = 0;
        }

        public void close() throws IOException {
            this.src.close();
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3;
            int n4;
            int n5 = 0;
            if (n2 < this.closetag.length) {
                throw new IOException();
            }
            if (this.loc == 4) {
                return -1;
            }
            if (this.loc == 0) {
                n4 = n;
                for (n3 = 0; n4 < n + n2 && n3 < this.opentag.length; ++n4, ++n3) {
                    ++n5;
                    cArray[n4] = this.opentag[n3];
                }
                this.loc = 1;
            }
            if (this.loc == 1) {
                char[] cArray2 = new char[7];
                n3 = this.src.read(cArray2, 0, 6);
                if (n3 == 6 && cArray2[0] == '<' && cArray2[1] == '?' && cArray2[2] == 'x' && cArray2[3] == 'm' && cArray2[4] == 'l' && cArray2[5] == ' ') {
                    while (this.src.read() != 63 || this.src.read() != 62) {
                    }
                } else {
                    if (n2 < n5 + 6) {
                        throw new IOException();
                    }
                    System.arraycopy(cArray2, 0, cArray, n + n5, 6);
                    n5 += 6;
                }
                this.loc = 2;
                if (n2 - n5 == 0) {
                    return n5;
                }
            }
            if (this.loc == 2 && (n5 += this.src.read(cArray, n + n5, n2 - n5)) <= n2) {
                this.loc = 3;
                if (n2 - n5 < this.closetag.length) {
                    return n5;
                }
            }
            if (this.loc == 3) {
                n4 = n + n5;
                n3 = 0;
                while (n4 < n + n2 && n3 < this.closetag.length) {
                    cArray[n4] = this.closetag[n3];
                    ++n4;
                    ++n3;
                    ++n5;
                }
                this.loc = 4;
            }
            return n5;
        }
    }
}

