/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.docgen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.sql.CLOB;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.docgen.OracleXMLDocGen;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class OracleXMLDocGenLob
extends OracleXMLDocGen {
    static final int MAX_CHUNK_SIZE = 32512;
    Hashtable namespaces = null;
    OracleConnection conn = null;
    char[] buf = null;
    int buflen = 0;
    int currSize = 0;
    long currPos = 1L;
    private int appendLen;
    private int appendSpaceLeft;
    private int appendStart;
    private static final char[] LPAREN_WQMARK = new char[]{'<', '?'};
    private static final char[] LPAREN_WSLASH = new char[]{'<', '/'};
    private static final char[] RPAREN_WQMARK = new char[]{'?', '>', '\n'};
    private static final char[] RPAREN_WSLASH = new char[]{'/', '>', '\n'};
    private static final char[] SYMB = new char[]{'=', '\"'};
    private static final char[] WSPCS = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private static final char[] LESS_THAN_REP = new char[]{'&', 'l', 't', ';'};
    private static final char[] GREATER_THAN_REP = new char[]{'&', 'g', 't', ';'};
    private static final char[] AMP_REP = new char[]{'&', 'a', 'm', 'p', ';'};
    private static final char[] QUOTE_REP = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    private int level = 0;
    private int entryLevel = 0;
    private CLOB clb = null;
    static final int UNINITIALIZED_STATE = 0;
    static final int NEWELEMENT_STATE = 1;
    static final int ENDELEMENT_STATE = 2;
    static final int ADDTEXTVALUE_STATE = 3;
    static final int ADDATTRIBUTE_STATE = 4;
    private int docState = 0;
    private boolean isFragment = false;

    public OracleXMLDocGenLob(Connection connection, CLOB cLOB, int n) {
        this.conn = (OracleConnection)connection;
        this.clb = cLOB;
        this.buflen = n;
        this.buf = new char[this.buflen];
    }

    public OracleXMLDocGenLob(Connection connection, CLOB cLOB) {
        try {
            this.conn = (OracleConnection)connection;
            this.clb = cLOB;
            this.buflen = this.getBufferSize();
            this.buf = new char[this.buflen];
        }
        catch (SQLException sQLException) {
            throw new OracleXMLSQLException(sQLException);
        }
    }

    private int getBufferSize() throws SQLException {
        int n = this.clb.getChunkSize();
        if (n >= 32512 || n <= 0) {
            return 32512;
        }
        return 32512 / n * n;
    }

    public void createNewDocument(boolean bl) {
        if (bl) {
            this.level = 0;
            this.docState = 0;
            this.currSize = 0;
            if (this.currPos == 1L) {
                return;
            }
            OracleCallableStatement oracleCallableStatement = null;
            try {
                oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall("begin dbms_lob.trim(?,0); end;");
                oracleCallableStatement.setCLOB(1, this.clb);
                oracleCallableStatement.execute();
                oracleCallableStatement.close();
            }
            catch (Exception exception) {
                throw new OracleXMLSQLException(exception);
            }
            finally {
                oracleCallableStatement = null;
            }
        }
    }

    public void createProcessingInstruction(String string, String string2) {
        if (this.isFragment) {
            return;
        }
        this.append(LPAREN_WQMARK);
        this.append(string);
        this.append(WSPCS, 0, 1);
        this.append(string2);
        this.append(RPAREN_WQMARK);
    }

    public void setVersion(String string) {
        if (this.isFragment) {
            return;
        }
        if (this.encoding == null) {
            this.createProcessingInstruction("xml", "version = '" + string + "'");
        } else {
            this.createProcessingInstruction("xml", "version = '" + string + "' " + "encoding = '" + this.encoding + "'");
        }
    }

    public Object startNewElement(String string) {
        if (this.docState == 4 || this.docState == 1) {
            this.append(RPAREN_WQMARK, 1, 3);
        }
        this.addIndent(this.level);
        this.append(LPAREN_WQMARK, 0, 1);
        this.append(string);
        ++this.level;
        this.docState = 1;
        return string;
    }

    public void addTextValue(String string, boolean bl) {
        this.checkLegalXMLChars(string);
        this.append(RPAREN_WQMARK, 1, 2);
        if (string != null) {
            if (bl) {
                this.convertString(string);
            } else {
                this.append(string);
            }
        }
        this.docState = 3;
    }

    public void addTextValue(Reader reader, boolean bl) throws IOException {
        this.append(RPAREN_WQMARK, 1, 2);
        if (reader != null) {
            if (bl) {
                while ((this.appendLen = reader.read(this.buf)) != -1) {
                    String string = new String(this.buf, 0, this.appendLen);
                    this.checkLegalXMLChars(string);
                    this.convertString(string);
                }
            } else {
                this.append(reader);
            }
        }
        this.docState = 3;
    }

    private void convertString(String string) {
        int n = 0;
        int n2 = string.length();
        block6: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != '&' && c != '<' && c != '>' && c != '\"') continue;
            this.append(string, n, i);
            n = i + 1;
            switch (c) {
                case '<': {
                    this.append(LESS_THAN_REP);
                    continue block6;
                }
                case '>': {
                    this.append(GREATER_THAN_REP);
                    continue block6;
                }
                case '&': {
                    this.append(AMP_REP);
                    continue block6;
                }
                case '\"': {
                    this.append(QUOTE_REP);
                }
            }
        }
        if (n < n2) {
            this.append(string, n, n2);
        }
    }

    public void endElement(Object object) {
        String string = (String)object;
        --this.level;
        if (this.docState == 4 || this.docState == 1) {
            this.append(RPAREN_WSLASH);
        } else {
            if (this.docState != 3) {
                this.addIndent(this.level);
            }
            this.append(LPAREN_WSLASH);
            this.append(string);
            this.append(RPAREN_WSLASH, 1, 3);
        }
        this.docState = 2;
    }

    public void addAttribute(String string, String string2) {
        this.checkLegalXMLChars(string2);
        this.append(WSPCS, 0, 1);
        this.append(string);
        this.append(SYMB, 0, 2);
        this.convertString(string2);
        this.append(SYMB, 1, 2);
    }

    public String getXMLDocumentString() {
        try {
            return this.clb.getSubString(1L, (int)this.clb.length());
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception.getMessage());
        }
    }

    private void addIndent(int n) {
        if (n <= 9) {
            this.append(WSPCS, 0, 3 * n);
        } else {
            for (int i = n / 9; i > 0; --i) {
                this.append(WSPCS);
            }
            this.append(WSPCS, 0, 3 * (n % 9));
        }
    }

    public void appendDTD(String string) {
        this.append(string);
    }

    public void insertXMLFragment(Reader reader) throws IOException, XMLParseException, SAXException {
        String string;
        boolean bl = true;
        this.append(">\n");
        if (reader == null) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            if (bl && string.startsWith("<?xml ")) {
                bl = false;
                if (string.endsWith("?>")) continue;
                int n = string.lastIndexOf("?>");
                this.addIndent(this.level);
                this.append(string.substring(n + 2));
                this.append("\n");
                continue;
            }
            this.addIndent(this.level);
            this.append(string);
            this.append("\n");
            bl = false;
        }
        this.addIndent(this.level - 1);
        this.docState = 3;
    }

    public void insertXMLFragment(Document document) {
        try {
            PrintWriter printWriter = new PrintWriter(this.clb.getCharacterOutputStream());
            ((XMLDocument)document).print(printWriter);
            printWriter.flush();
            this.currPos = this.clb.length() + 1L;
        }
        catch (Exception exception) {
            exception.fillInStackTrace();
            throw new OracleXMLSQLException(exception);
        }
    }

    public Object getDocFragment() {
        if (!this.isFragment) {
            return null;
        }
        return new String(this.buf);
    }

    public OracleXMLDocGen newDocGenDoc(boolean bl) {
        return null;
    }

    public void docAppend(OracleXMLDocGen oracleXMLDocGen) {
        if (this.isFragment) {
            return;
        }
        if (this.docState == 4 || this.docState == 1) {
            this.append(RPAREN_WSLASH, 1, 3);
            this.docState = 2;
        }
        this.append((String)oracleXMLDocGen.getDocFragment());
    }

    public String addNamespace(String string, String string2) {
        if (this.namespaces == null) {
            this.namespaces = new Hashtable(4);
        }
        return this.namespaces.put(string, string2);
    }

    public void flush() {
        try {
            if (this.currSize > 0) {
                char[] cArray = new char[this.currSize];
                System.arraycopy(this.buf, 0, cArray, 0, this.currSize);
                this.checkLegalXMLChars(new String(cArray));
                this.clb.putChars(this.currPos, cArray);
                this.currPos += (long)this.currSize;
                this.currSize = 0;
            }
        }
        catch (SQLException sQLException) {
            throw new OracleXMLSQLException(sQLException);
        }
    }

    private void append(char[] cArray) {
        this.append(cArray, 0, cArray.length);
    }

    private void append(String string) {
        this.append(string, 0, string.length());
    }

    private void append(Reader reader) {
        try {
            this.flush();
            while ((this.appendLen = reader.read(this.buf)) != -1) {
                this.currSize += this.appendLen;
                if (this.currSize != this.buflen) continue;
                this.checkLegalXMLChars(new String(this.buf));
                this.clb.putChars(this.currPos, this.buf);
                this.currPos += (long)this.buflen;
                this.currSize = 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new OracleXMLSQLException(exception);
        }
    }

    private void append(char[] cArray, int n, int n2) {
        this.checkLegalXMLChars(new String(cArray));
        try {
            this.appendStart = n;
            while (this.appendStart < n2) {
                if (this.currSize == this.buflen) {
                    this.checkLegalXMLChars(new String(this.buf));
                    this.clb.putChars(this.currPos, this.buf);
                    this.currPos += (long)this.buflen;
                    this.currSize = 0;
                }
                this.appendLen = this.buflen - this.currSize < n2 - this.appendStart ? this.buflen - this.currSize : n2 - this.appendStart;
                System.arraycopy(cArray, this.appendStart, this.buf, this.currSize, this.appendLen);
                this.appendStart += this.appendLen;
                this.currSize += this.appendLen;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
            throw new OracleXMLSQLException(sQLException);
        }
    }

    private void append(String string, int n, int n2) {
        this.checkLegalXMLChars(string);
        try {
            this.appendStart = n;
            while (this.appendStart < n2) {
                if (this.currSize == this.buflen) {
                    this.clb.putChars(this.currPos, this.buf);
                    this.currPos += (long)this.buflen;
                    this.currSize = 0;
                }
                this.appendLen = this.buflen - this.currSize < n2 - this.appendStart ? this.buflen - this.currSize : n2 - this.appendStart;
                string.getChars(this.appendStart, this.appendStart + this.appendLen, this.buf, this.currSize);
                this.appendStart += this.appendLen;
                this.currSize += this.appendLen;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
            throw new OracleXMLSQLException(sQLException);
        }
    }

    public boolean supportMetatype(int n) {
        return n == 1;
    }
}

