/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.query;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.core.OracleXMLConvert;
import oracle.xml.sql.dataset.OracleXMLDataSet;
import oracle.xml.sql.dml.OracleXMLSave;
import oracle.xml.sql.docgen.OracleXMLDocGen;
import oracle.xml.sql.docgen.OracleXMLDocGenDOM;
import oracle.xml.sql.docgen.OracleXMLDocGenSAX;
import oracle.xml.sql.docgen.OracleXMLDocGenString;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class OracleXMLQuery {
    public static final int MAXROWS_NONE = 0;
    public static final int MAXROWS_ALL = -1;
    public static final int MAXROWS_DEFAULT = -1;
    public static final int SKIPROWS_NONE = 0;
    public static final int SKIPROWS_ALL = -1;
    public static final int SKIPROWS_DEFAULT = 0;
    public static final int NONE = 0;
    public static final int DTD = 1;
    public static final int SCHEMA = 2;
    public static final String ROWSET_TAG = "ROWSET";
    public static final String ROW_TAG = "ROW";
    public static final String ERROR_TAG = "ERROR";
    public static final String ROWIDATTR_TAG = "num";
    private String encoding = null;
    private boolean encSet = false;
    private boolean useStrictLegalXMLCharCheck = false;
    OracleXMLConvert conv;
    XSLProcessor xslp = null;
    XSLStylesheet xslt = null;

    public OracleXMLQuery(Connection connection, String string) {
        this.conv = new OracleXMLConvert(connection, string);
    }

    public OracleXMLQuery(Connection connection, ResultSet resultSet) {
        this.conv = new OracleXMLConvert(connection, resultSet);
        this.conv.keepObjectOpen(true);
    }

    public OracleXMLQuery(OracleXMLDataSet oracleXMLDataSet) {
        this.conv = new OracleXMLConvert(null, oracleXMLDataSet);
        this.conv.keepObjectOpen(true);
    }

    public void bindValue(String string, String string2) {
        this.conv.bindValue(string, string2);
    }

    public void clearBindValues() {
        this.conv.clearBindValues();
    }

    public void resetResultSet() {
        this.conv.resetResultSet();
    }

    public String getXMLString() {
        return this.getXMLString(false);
    }

    public String getXMLString(int n) {
        return this.getXMLString(null, n);
    }

    public String getXMLString(boolean bl) {
        return this.getXMLString(null, bl ? 1 : 0);
    }

    public String getXMLString(Node node) {
        return this.getXMLString(node, 0);
    }

    public String getXMLString(Node node, int n) {
        OracleXMLDocGen oracleXMLDocGen = this.xslt != null ? new OracleXMLDocGenString() : (n == 2 ? new OracleXMLDocGenDOM() : (node != null ? new OracleXMLDocGenDOM(node) : new OracleXMLDocGenString()));
        oracleXMLDocGen.setStrictLegalXMLCharCheck(this.useStrictLegalXMLCharCheck);
        if (this.encSet) {
            oracleXMLDocGen.setEncoding(this.encoding);
        }
        this.conv.setRootNodeSupplied(node != null);
        this.conv.getXML(oracleXMLDocGen, n);
        this.conv.setRootNodeSupplied(false);
        if (this.xslt != null) {
            oracleXMLDocGen.applyStylesheet(this.xslp, this.xslt);
        }
        return oracleXMLDocGen.getXMLDocumentString();
    }

    public Document getXMLDOM() {
        return this.getXMLDOM(false);
    }

    public Document getXMLDOM(Node node) {
        return this.getXMLDOM(node, 0);
    }

    public Document getXMLDOM(int n) {
        return this.getXMLDOM(null, n);
    }

    public Document getXMLDOM(boolean bl) {
        return this.getXMLDOM(null, bl ? 1 : 0);
    }

    public Document getXMLDOM(Node node, int n) {
        OracleXMLDocGenDOM oracleXMLDocGenDOM;
        if (node != null) {
            oracleXMLDocGenDOM = new OracleXMLDocGenDOM(node);
            this.conv.setRootNodeSupplied(true);
        } else {
            oracleXMLDocGenDOM = new OracleXMLDocGenDOM();
            this.conv.setRootNodeSupplied(false);
        }
        oracleXMLDocGenDOM.setStrictLegalXMLCharCheck(this.useStrictLegalXMLCharCheck);
        if (this.encSet) {
            oracleXMLDocGenDOM.setEncoding(this.encoding);
        }
        this.conv.getXML(oracleXMLDocGenDOM, n == 1 ? 0 : n);
        this.conv.setRootNodeSupplied(false);
        if (this.xslt != null) {
            oracleXMLDocGenDOM.applyStylesheet(this.xslp, this.xslt);
        }
        return oracleXMLDocGenDOM.getXMLDocumentDOM();
    }

    public void getXMLStream(Node node, int n, Writer writer) {
        OracleXMLDocGenDOM oracleXMLDocGenDOM;
        if (node != null) {
            oracleXMLDocGenDOM = new OracleXMLDocGenDOM(node);
            this.conv.setRootNodeSupplied(true);
        } else {
            oracleXMLDocGenDOM = new OracleXMLDocGenDOM();
            this.conv.setRootNodeSupplied(false);
        }
        oracleXMLDocGenDOM.setStrictLegalXMLCharCheck(this.useStrictLegalXMLCharCheck);
        if (this.encSet) {
            oracleXMLDocGenDOM.setEncoding(this.encoding);
        }
        this.conv.getXML(oracleXMLDocGenDOM, n == 1 ? 0 : n);
        this.conv.setRootNodeSupplied(false);
        try {
            XMLDocument xMLDocument = (XMLDocument)oracleXMLDocGenDOM.getXMLDocumentDOM();
            if (this.xslt != null) {
                this.xslp.processXSL(this.xslt, xMLDocument, new PrintWriter(writer));
            } else {
                xMLDocument.print(new PrintWriter(writer));
            }
        }
        catch (Exception exception) {
            exception.fillInStackTrace();
            throw new OracleXMLSQLException(exception);
        }
    }

    public void getXMLSAX(ContentHandler contentHandler) {
        OracleXMLDocGenSAX oracleXMLDocGenSAX = new OracleXMLDocGenSAX(contentHandler);
        oracleXMLDocGenSAX.setStrictLegalXMLCharCheck(this.useStrictLegalXMLCharCheck);
        this.conv.getXML(oracleXMLDocGenSAX, 0);
    }

    public void getXML(OracleXMLDocGen oracleXMLDocGen) {
        this.getXML(oracleXMLDocGen, 0);
    }

    public void getXML(OracleXMLDocGen oracleXMLDocGen, boolean bl) {
        this.getXML(oracleXMLDocGen, bl ? 1 : 0);
    }

    public void getXML(OracleXMLDocGen oracleXMLDocGen, int n) {
        if (this.encSet) {
            oracleXMLDocGen.setEncoding(this.encoding);
        }
        this.conv.setRootNodeSupplied(false);
        this.conv.getXML(oracleXMLDocGen, n);
        if (this.xslt != null) {
            oracleXMLDocGen.applyStylesheet(this.xslp, this.xslt);
        }
    }

    public long getNumRowsProcessed() {
        return this.conv.getNumRowsProcessed();
    }

    public String getXMLMetaData(int n, boolean bl) {
        OracleXMLDocGenString oracleXMLDocGenString = new OracleXMLDocGenString();
        oracleXMLDocGenString.setStrictLegalXMLCharCheck(this.useStrictLegalXMLCharCheck);
        oracleXMLDocGenString.setEncoding(this.encoding);
        oracleXMLDocGenString.createNewDocument(false);
        this.getXMLMetaData(n, bl, oracleXMLDocGenString);
        this.conv.setDocType(1);
        return oracleXMLDocGenString.getXMLDocumentString();
    }

    public void getXMLMetaData(int n, boolean bl, OracleXMLDocGen oracleXMLDocGen) {
        if (this.encSet) {
            oracleXMLDocGen.setEncoding(this.encoding);
        }
        if (bl) {
            this.conv.setDocType(2);
        } else {
            this.conv.setDocType(0);
        }
        this.conv.getXML(oracleXMLDocGen, n);
        this.conv.setDocType(1);
    }

    public Document[] getXMLSchema() {
        return this.conv.getSchema(false);
    }

    public void setMetaHeader(Reader reader) {
        this.conv.setMetaHeader(reader);
    }

    public void setDataHeader(Reader reader, String string) {
        this.conv.setDataHeader(reader, string);
    }

    public void setEncoding(String string) {
        this.encoding = string;
        this.encSet = true;
    }

    public void setStrictLegalXMLCharCheck(boolean bl) {
        this.useStrictLegalXMLCharCheck = bl;
    }

    public void setDateFormat(String string) {
        this.conv.setDateFormat(string);
    }

    public void setRowsetTag(String string) {
        this.conv.setRowsetTag(string);
    }

    public void setRowTag(String string) {
        this.conv.setRowTag(string);
    }

    public void setErrorTag(String string) {
        this.conv.setErrorTag(string);
    }

    public void setRowIdAttrName(String string) {
        this.conv.setRowIdAttrName(string);
    }

    public void setRowIdAttrValue(String string) {
        this.conv.setRowIdAttrValue(string);
    }

    public void setRowIdColumn(String string) {
        this.conv.setRowIdAttrValue(string);
    }

    public void setCollIdAttrName(String string) {
        this.conv.setCollIdAttrName(string);
    }

    public void setCollIdAttr(String string) {
        this.conv.setCollIdAttrName(string);
    }

    public void useTypeForCollElemTag(boolean bl) {
        this.conv.useTypeForCollElemTag(bl);
    }

    public void useNullAttributeIndicator(boolean bl) {
        this.conv.useNullAttrId(bl);
    }

    public void setStylesheetHeader(String string) {
        this.conv.setStylesheetHeader(string);
    }

    public void setStyleSheet(String string) {
        this.conv.setStylesheetHeader(string);
    }

    public void setStylesheetHeader(String string, String string2) {
        this.conv.setStylesheetHeader(string, string2);
    }

    public void setStyleSheet(String string, String string2) {
        this.conv.setStylesheetHeader(string, string2);
    }

    public void setXSLT(String string, String string2) {
        if (string == null) {
            this.xslt = null;
        } else {
            try {
                if (this.xslp == null) {
                    this.xslp = new XSLProcessor();
                    this.xslp.setBaseURL(OracleXMLSave.getURL(string2));
                }
                this.xslt = this.xslp.newXSLStylesheet(OracleXMLSave.getURL(string));
            }
            catch (XSLException xSLException) {
                throw new OracleXMLSQLException((Exception)((Object)xSLException));
            }
        }
    }

    public void setXSLT(Reader reader, String string) {
        if (reader == null) {
            this.xslt = null;
        } else {
            try {
                if (this.xslp == null) {
                    this.xslp = new XSLProcessor();
                    this.xslp.setBaseURL(OracleXMLSave.getURL(string));
                }
                this.xslt = this.xslp.newXSLStylesheet(reader);
            }
            catch (XSLException xSLException) {
                throw new OracleXMLSQLException((Exception)((Object)xSLException));
            }
        }
    }

    public void setXSLTParam(String string, String string2) {
        if (this.xslp == null) {
            return;
        }
        try {
            this.xslp.setParam("", string, (Object)string2);
        }
        catch (XSLException xSLException) {
            throw new OracleXMLSQLException((Exception)((Object)xSLException));
        }
    }

    public void removeXSLTParam(String string) {
        if (this.xslp == null) {
            return;
        }
        try {
            this.xslp.removeParam("", string);
        }
        catch (XSLException xSLException) {
            throw new OracleXMLSQLException((Exception)((Object)xSLException));
        }
    }

    public void setSQLToXMLNameEscaping(boolean bl) {
        if (bl) {
            this.conv.setMiscFlags(4);
        } else {
            this.conv.clearMiscFlags(4);
        }
    }

    public void useLowerCaseTagNames() {
        this.conv.setTagNameCase(1);
    }

    public void useUpperCaseTagNames() {
        this.conv.setTagNameCase(2);
    }

    public void setException(Exception exception) {
        this.conv.setException(exception);
    }

    public void setRaiseException(boolean bl) {
        this.conv.setRaiseException(bl);
    }

    public void setRaiseNoRowsException(boolean bl) {
        this.conv.setRaiseNoRowsException(bl);
    }

    public void setMaxRows(int n) {
        this.conv.setMaxRows(n);
    }

    public void setSkipRows(int n) {
        this.conv.setSkipRows(n);
    }

    public void close() {
        this.conv.close();
    }

    public void keepObjectOpen(boolean bl) {
        this.conv.keepObjectOpen(bl);
    }

    public void keepCursorState(boolean bl) {
        this.conv.keepObjectOpen(bl);
    }

    public Object getInternalObj() {
        return this.conv;
    }
}

