/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticComboBoxButton;
import com.jgoodies.looks.plastic.PlasticComboBoxEditor;
import com.jgoodies.looks.plastic.PlasticIconFactory;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class PlasticComboBoxUI
extends MetalComboBoxUI {
    protected EditorActionListener editorActionListener;

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.editorActionListener = null;
    }

    public void configureEditor() {
        super.configureEditor();
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            if (this.editorActionListener == null) {
                this.editorActionListener = new EditorActionListener();
            }
            this.comboBox.getEditor().addActionListener(this.editorActionListener);
        }
    }

    public void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.editorActionListener != null) {
            this.comboBox.getEditor().removeActionListener(this.editorActionListener);
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticComboBoxUI();
    }

    protected ComboBoxEditor createEditor() {
        return new PlasticComboBoxEditor.UIResource();
    }

    protected ComboPopup createPopup() {
        return new PlasticComboPopup(this.comboBox);
    }

    private Insets getEditorInsets() {
        if (this.editor instanceof JComponent) {
            return ((JComponent)this.editor).getInsets();
        }
        return new Insets(0, 0, 0, 0);
    }

    private int getEditableButtonWidth() {
        return UIManager.getInt("ScrollBar.width") - 1;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof PlasticComboBoxButton) {
            PlasticComboBoxButton plasticComboBoxButton = (PlasticComboBoxButton)this.arrowButton;
            Insets insets = plasticComboBoxButton.getInsets();
            Insets insets2 = plasticComboBoxButton.getMargin();
            Insets insets3 = this.comboBox.getInsets();
            dimension = this.getDisplaySize();
            dimension.height += 2;
            dimension.width += insets3.left + insets3.right;
            dimension.width += insets.left + insets.right;
            dimension.width += insets2.left + insets2.right;
            dimension.width += plasticComboBoxButton.getComboIcon().getIconWidth();
            dimension.height += insets3.top + insets3.bottom;
            dimension.height += insets.top + insets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            dimension = this.getDisplaySize();
            Insets insets = this.comboBox.getInsets();
            Insets insets4 = this.getEditorInsets();
            int n = this.getEditableButtonWidth();
            dimension.width += insets.left + insets.right;
            dimension.width += insets4.left + insets4.right - 1;
            dimension.width += n;
            dimension.height += insets.top + insets.bottom;
        } else {
            dimension = super.getMinimumSize(jComponent);
        }
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    protected JButton createArrowButton() {
        return new PlasticComboBoxButton(this.comboBox, PlasticIconFactory.getComboBoxButtonIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
    }

    protected LayoutManager createLayoutManager() {
        return new PlasticComboBoxLayoutManager();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            if (this.isToolBarComboBox(jComponent)) {
                jComponent.setOpaque(false);
            }
        }
        this.paint(graphics, jComponent);
    }

    protected boolean isToolBarComboBox(JComponent jComponent) {
        Container container = jComponent.getParent();
        return container != null && (container instanceof JToolBar || container.getParent() instanceof JToolBar);
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new PlasticPropertyChangeListener();
    }

    private class PlasticComboPopup
    extends MetalComboBoxUI.MetalComboPopup {
        private PlasticComboPopup(JComboBox jComboBox) {
            super(PlasticComboBoxUI.this, jComboBox);
        }

        protected void configureList() {
            super.configureList();
            this.list.setForeground(UIManager.getColor("MenuItem.foreground"));
            this.list.setBackground(UIManager.getColor("MenuItem.background"));
        }

        protected void configureScroller() {
            super.configureScroller();
            this.scroller.getVerticalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        }

        public void reshape(int n, int n2, int n3, int n4) {
            int n5 = this.getMaximumSize().width;
            if (n3 > n5) {
                n3 = n5;
            }
            super.reshape(n, n2, n3, n4);
        }

        protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
            JScrollBar jScrollBar;
            Rectangle rectangle = super.computePopupBounds(n, n2, n3, n4);
            JViewport jViewport = this.scroller.getViewport();
            int n5 = (jViewport != null ? jViewport.getPreferredSize().width : 0) + ((jScrollBar = this.scroller.getVerticalScrollBar()) != null ? jScrollBar.getPreferredSize().width : 0);
            if (rectangle.width < n5) {
                rectangle.width = n5;
            }
            return rectangle;
        }
    }

    private class PlasticPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        private PlasticPropertyChangeListener() {
            super(PlasticComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("editable")) {
                PlasticComboBoxButton plasticComboBoxButton = (PlasticComboBoxButton)PlasticComboBoxUI.this.arrowButton;
                plasticComboBoxButton.setIconOnly(PlasticComboBoxUI.this.comboBox.isEditable());
                PlasticComboBoxUI.this.comboBox.repaint();
            } else if (string.equals("background")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                PlasticComboBoxUI.this.arrowButton.setBackground(color);
                PlasticComboBoxUI.this.listBox.setBackground(color);
            } else if (string.equals("foreground")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                PlasticComboBoxUI.this.arrowButton.setForeground(color);
                PlasticComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }

    private class PlasticComboBoxLayoutManager
    extends MetalComboBoxUI.MetalComboBoxLayoutManager {
        private PlasticComboBoxLayoutManager() {
            super(PlasticComboBoxUI.this);
        }

        public void layoutContainer(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            if (!jComboBox.isEditable()) {
                super.layoutContainer(container);
                return;
            }
            int n = jComboBox.getWidth();
            int n2 = jComboBox.getHeight();
            Insets insets = PlasticComboBoxUI.super.getInsets();
            int n3 = PlasticComboBoxUI.this.getEditableButtonWidth();
            int n4 = n2 - (insets.top + insets.bottom);
            if (PlasticComboBoxUI.this.arrowButton != null) {
                if (jComboBox.getComponentOrientation().isLeftToRight()) {
                    PlasticComboBoxUI.this.arrowButton.setBounds(n - (insets.right + n3), insets.top, n3, n4);
                } else {
                    PlasticComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, n3, n4);
                }
            }
            if (PlasticComboBoxUI.this.editor != null) {
                PlasticComboBoxUI.this.editor.setBounds(PlasticComboBoxUI.super.rectangleForCurrentValue());
            }
        }
    }

    protected class EditorActionListener
    implements ActionListener {
        protected EditorActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PlasticComboBoxUI.this.comboBox.getModel().setSelectedItem(PlasticComboBoxUI.this.comboBox.getEditor().getItem());
        }
    }
}

