/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.looks.plastic.PlasticBorders;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToolBarUI;

public class PlasticToolBarUI
extends MetalToolBarUI {
    private static final String PROPERTY_PREFIX = "ToolBar.";
    private PropertyChangeListener listener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticToolBarUI();
    }

    protected Border createRolloverBorder() {
        return PlasticBorders.getRolloverButtonBorder();
    }

    protected void setBorderToRollover(Component component) {
        if (component instanceof AbstractButton) {
            super.setBorderToRollover(component);
        } else if (component instanceof Container) {
            Container container = (Container)component;
            int n = 0;
            while (n < container.getComponentCount()) {
                super.setBorderToRollover(container.getComponent(n));
                ++n;
            }
        }
    }

    protected void installDefaults() {
        super.installDefaults();
        this.installSpecialBorder();
        this.setRolloverBorders(true);
    }

    protected void installListeners() {
        super.installListeners();
        this.listener = this.createBorderStyleListener();
        this.toolBar.addPropertyChangeListener(this.listener);
    }

    protected void uninstallListeners() {
        this.toolBar.removePropertyChangeListener(this.listener);
        super.uninstallListeners();
    }

    private PropertyChangeListener createBorderStyleListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("jgoodies.headerStyle") || string.equals("Plastic.borderStyle")) {
                    PlasticToolBarUI.this.installSpecialBorder();
                }
            }
        };
    }

    private void installSpecialBorder() {
        String string;
        BorderStyle borderStyle = BorderStyle.from(this.toolBar, "Plastic.borderStyle");
        if (borderStyle == BorderStyle.EMPTY) {
            string = "emptyBorder";
        } else if (borderStyle == BorderStyle.ETCHED) {
            string = "etchedBorder";
        } else if (borderStyle == BorderStyle.SEPARATOR) {
            string = "separatorBorder";
        } else {
            HeaderStyle headerStyle = HeaderStyle.from(this.toolBar);
            if (headerStyle == HeaderStyle.BOTH) {
                string = "headerBorder";
            } else if (headerStyle == HeaderStyle.SINGLE && this.is3D()) {
                string = "etchedBorder";
            } else {
                return;
            }
        }
        LookAndFeel.installBorder(this.toolBar, PROPERTY_PREFIX + string);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        if (this.is3D()) {
            Rectangle rectangle = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
            PlasticUtils.addLight3DEffekt(graphics, rectangle, true);
        }
        this.paint(graphics, jComponent);
    }

    private boolean is3D() {
        if (PlasticUtils.force3D(this.toolBar)) {
            return true;
        }
        if (PlasticUtils.forceFlat(this.toolBar)) {
            return false;
        }
        return PlasticUtils.is3D(PROPERTY_PREFIX) && HeaderStyle.from(this.toolBar) != null && BorderStyle.from(this.toolBar, "Plastic.borderStyle") != BorderStyle.EMPTY;
    }
}

