/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.access.OracleAccessibleRole;

public class TitledPane
extends LWComponent
implements Accessible {
    private Component _title;
    private Component _content;
    private static final Border _sInnerBorder = new TitledBorder((String)null);
    private static final int _LABEL_INSET = 10;
    private static final int _COMPONENT_INSET = 5;

    public TitledPane() {
        this(null, null);
    }

    public TitledPane(Component component, Component component2) {
        this.setTitle(component);
        this.setContent(component2);
        super.setLayout(new Layout());
        this.setAlignmentX(0.0f);
    }

    public void setTitle(Component component) {
        if (component != this._title) {
            if (this._title != null) {
                this.remove(this._title);
                this._title = null;
            }
            if (component != null) {
                this._title = component;
                this.add(component);
            }
        }
    }

    public Component getTitle() {
        return this._title;
    }

    public void setContent(Component component) {
        if (component != this._content) {
            if (this._content != null) {
                this.remove(this._content);
                this._content = null;
            }
            if (component != null) {
                this._content = component;
                this.add(component);
            }
        }
    }

    public Component getContent() {
        return this._content;
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    void __doLayout() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this._getSize(this._title, true);
        Insets insets = _sInnerBorder.getBorderInsets(this);
        int n = dimension.width - 30;
        int n2 = dimension2.width;
        if (n < n2) {
            n2 = n;
        }
        int n3 = 15 + (int)((float)(n - n2) * this.getAlignmentX());
        if (this._title != null) {
            this._title.setBounds(n3, 0, n2, dimension2.height);
        }
        if (this._content != null) {
            this._content.setBounds(insets.left, dimension2.height, dimension.width - (insets.left + insets.right), dimension.height - (dimension2.height + insets.bottom));
        }
        super.setBorder(new CompoundBorder(new EmptyBorder(dimension2.height / 2, 0, 0, 0), _sInnerBorder));
    }

    public void setBorder(Border border) {
    }

    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        Color color = graphics.getColor();
        graphics.setColor(this.getBackground());
        if (this._title != null) {
            Rectangle rectangle = this._title.getBounds();
            graphics.fillRect(rectangle.x - 5, rectangle.y, rectangle.width + 10, rectangle.height);
            graphics.setColor(color);
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component != this._title && component != this._content) {
            if (this._title == null) {
                this._title = component;
            } else {
                Component component2 = this._content;
                if (component2 != null) {
                    this.remove(component2);
                }
                this._content = component;
            }
        }
        super.addImpl(component, object, n);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTitledPane();
        }
        return this.accessibleContext;
    }

    Dimension __calculateSize(Dimension dimension, Dimension dimension2) {
        Insets insets = _sInnerBorder.getBorderInsets(this);
        return new Dimension(Math.max(dimension2.width, dimension.width + 30) + insets.left + insets.right, dimension.height + dimension2.height + insets.bottom);
    }

    Dimension _getSize(Component component, boolean bl) {
        if (component == null) {
            return new Dimension(0, 0);
        }
        return bl ? component.getPreferredSize() : component.getMinimumSize();
    }

    private class Layout
    implements LayoutManager {
        private Layout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = TitledPane.this._getSize(TitledPane.this.getTitle(), true);
            Dimension dimension2 = TitledPane.this._getSize(TitledPane.this.getContent(), true);
            return TitledPane.this.__calculateSize(dimension, dimension2);
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = TitledPane.this._getSize(TitledPane.this.getTitle(), false);
            Dimension dimension2 = TitledPane.this._getSize(TitledPane.this.getContent(), false);
            return TitledPane.this.__calculateSize(dimension, dimension2);
        }

        public void layoutContainer(Container container) {
            TitledPane.this.__doLayout();
        }
    }

    protected class AccessibleTitledPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleTitledPane() {
            super(TitledPane.this);
        }

        public String getAccessibleName() {
            String string;
            Component component;
            if (this.accessibleName == null && (component = TitledPane.this.getTitle()) instanceof Accessible && (string = ((Accessible)((Object)component)).getAccessibleContext().getAccessibleName()) != null) {
                return string;
            }
            return super.getAccessibleName();
        }

        public AccessibleRole getAccessibleRole() {
            return OracleAccessibleRole.GROUP_BOX;
        }
    }
}

