/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.button;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.graphics.FontUtils;

class DialogBarLayout
implements LayoutManager2 {
    private static final int _BUTTON_GAP = 1;
    private static final int _LEFT_RIGHT_GAP = 30;
    private static final int _GROUP_GAP = 8;
    private static final int _COMP_INDEX_HELP = 0;
    private static final int _COMP_INDEX_YES = 1;
    private static final int _COMP_INDEX_NO = 2;
    private static final int _COMP_INDEX_CANCEL = 3;
    private static final int _COMP_INDEX_BACK = 4;
    private static final int _COMP_INDEX_NEXT = 5;
    private static final int _COMP_INDEX_FINISH = 6;
    private static final int _COMP_INDEX_APPLY = 7;
    private static final int _COMP_INDEX_SAVE = 8;
    private static final int _COMP_INDEX_NULL = 9;
    private static final int _NUM_COMPS = 10;
    private static final int[] _NORMAL_SPECIAL_START = new int[]{0};
    private static final int[] _NORMAL_SPECIAL_END = new int[]{3, 2, 1, 7, 8, 6, 5, 4};
    private static final int[] _WIZARD_SPECIAL_START = new int[]{0, 7, 8};
    private static final int[] _WIZARD_SPECIAL_END = new int[]{2, 1, 3, 6, 5, 4};
    private Hashtable _compToConstraintMap = new Hashtable(13);
    private Component[] _specialComponents = new Component[10];
    private Container _container;
    private transient Dimension _cellSize = null;
    private static final String _RESERVED_WIZARD_BUTTONS = "WizardReservedButtonSpaces";

    public DialogBarLayout(Container container) {
        this._container = container;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, null);
    }

    public void removeLayoutComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        int n = (Integer)this._compToConstraintMap.remove(component);
        if (this._specialComponents[n] == component) {
            this._specialComponents[n] = null;
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        Component component2;
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (object == null) {
            object = DialogButtonBar.CONSTRAINT_NULL;
        }
        Integer n = (Integer)object;
        this._compToConstraintMap.put(component, n);
        int n2 = n;
        if (n2 != 9 && (component2 = this._specialComponents[n2]) != null) {
            this._compToConstraintMap.put(component, DialogButtonBar.CONSTRAINT_NULL);
        }
        this._specialComponents[n2] = component;
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = null;
        dimension = this._isWizardConfiguration() ? this._calculateSizeInWizard(container) : this._calculateSize(container);
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        Insets insets2 = UIManager.getInsets("EWTDialogButtonBar.margin");
        if (insets2 != null) {
            dimension.width += insets2.left + insets2.right;
            dimension.height += insets2.top + insets2.bottom;
        }
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        Insets insets2 = UIManager.getInsets("EWTDialogButtonBar.margin");
        if (insets2 != null) {
            insets.left += insets2.left;
            insets.right += insets2.right;
            insets.top += insets2.top;
            insets.bottom += insets2.bottom;
        }
        int n = insets.left;
        int n2 = dimension.width - insets.right;
        int n3 = insets.top;
        int n4 = dimension.height - n3 - insets.bottom;
        Dimension dimension2 = this._getCellSize(container);
        int n5 = dimension2.width;
        int n6 = dimension2.height;
        int n7 = n4 - n6;
        if (n7 < 0) {
            n6 = n4;
            n7 = 0;
        }
        n = this._layoutSpecialComponents(this._getSpecialLeft(), true, n, n2, n3, n7, n5, n6);
        n2 = this._layoutSpecialComponents(this._getSpecialRight(), false, n, n2, n3, n7, n5, n6);
        if (this._isWizardConfiguration()) {
            this._layoutNonSpecialComponentsInWizard(container, n, n2, n3, n7, n5, n6);
        } else {
            this._layoutNonSpecialComponents(container, n, n2, n3, n7, n5, n6);
        }
    }

    private void _layoutNonSpecialComponents(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9 = this._getNumVisibleSpecial();
        int n10 = this._getNumVisible(container);
        int n11 = n10 - n9;
        int n12 = n11 * n5;
        if (n11 > 0) {
            n12 += (n11 - 1) * 8;
        }
        if ((n8 = (n7 = n2 - n) - n12) > 0) {
            n += n8;
            n7 -= n8;
        }
        int n13 = container.getComponentCount();
        int n14 = 0;
        while (n14 < n13) {
            Component component = container.getComponent(n14);
            if (component.isVisible() && !this._isSpecial(component)) {
                if (n5 > n7) {
                    n5 = n7;
                }
                int n15 = 0;
                if (n4 > 0) {
                    n15 = (int)((float)n4 * component.getAlignmentY());
                }
                component.setBounds(n, n3 + n15, n5, n6);
                int n16 = n5 + 8;
                n += n16;
                n7 -= n16;
            }
            ++n14;
        }
    }

    private void _layoutNonSpecialComponentsInWizard(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9 = this._getNumVisibleSpecial();
        int n10 = this._getNumVisible(container);
        int n11 = 0;
        int n12 = 0;
        int n13 = container.getComponentCount();
        int n14 = 0;
        while (n14 < n13) {
            Component component = container.getComponent(n14);
            if (component.isVisible() && !this._isSpecial(component)) {
                ++n11;
                Dimension dimension = component.getPreferredSize();
                Font font = component.getFont();
                if (font != null) {
                    dimension.width += 3 * FontUtils.getAverageWidth(font);
                }
                n12 += Math.max(n5, dimension.width);
            }
            ++n14;
        }
        if (n11 > 0) {
            n12 += (n11 - 1) * 8;
        }
        if ((n8 = (n7 = n2 - n) - n12) > 0) {
            n += n8 / 2;
            n7 -= n8 / 2;
        }
        int n15 = 0;
        while (n15 < n13) {
            Component component = container.getComponent(n15);
            if (component.isVisible() && !this._isSpecial(component)) {
                int n16;
                Dimension dimension = component.getPreferredSize();
                Font font = component.getFont();
                if (font != null) {
                    dimension.width += 3 * FontUtils.getAverageWidth(font);
                }
                if ((n16 = Math.max(dimension.width, n5)) > n7) {
                    n16 = n7;
                }
                int n17 = 0;
                if (n4 > 0) {
                    n17 = (int)((float)n4 * component.getAlignmentY());
                }
                component.setBounds(n, n3 + n17, n16, n6);
                int n18 = n16 + 8;
                n += n18;
                n7 -= n18;
            }
            ++n15;
        }
    }

    private int _layoutSpecialComponents(int[] nArray, boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        while (n7 < nArray.length) {
            int n8 = n2 - n;
            int n9 = nArray[n7];
            Component component = this._specialComponents[n9];
            if (component != null && component.isVisible()) {
                Component component2;
                int n10;
                if (n5 > n8) {
                    n5 = n8;
                }
                int n11 = 0;
                if (n4 > 0) {
                    n11 = (int)((float)n4 * component.getAlignmentY());
                }
                int n12 = n;
                if (!bl) {
                    n12 = n2 - n5;
                }
                component.setBounds(n12, n3 + n11, n5, n6);
                int n13 = 8;
                if (n9 == 5 && n7 + 1 < nArray.length && (n10 = nArray[n7 + 1]) == 4 && (component2 = this._specialComponents[n10]) != null && component2.isVisible()) {
                    n13 = 1;
                }
                n10 = n5 + n13;
                if (bl) {
                    n += n10;
                } else {
                    n2 -= n10;
                }
            }
            ++n7;
        }
        if (bl) {
            return n;
        }
        return n2;
    }

    public void invalidateLayout(Container container) {
        this._cellSize = null;
    }

    private Dimension _getCellSize(Container container) {
        if (this._cellSize == null) {
            this._cellSize = this._calculateCellSize(container, this._isWizardConfiguration());
        }
        return this._cellSize;
    }

    private Dimension _calculateSize(Container container) {
        int n = this._getNumVisible(container);
        Dimension dimension = this._getCellSize(container);
        int n2 = dimension.width * n;
        if (n > 0) {
            if (this._isBackAndNextVisible()) {
                n2 += (n - 2) * 8;
                ++n2;
            } else {
                n2 += (n - 1) * 8;
            }
            if (this._isLeftGroupPresent() && this._isRightGroupPresent()) {
                n2 += Math.min(30, dimension.width);
            }
        }
        int n3 = dimension.height;
        return new Dimension(n2, n3);
    }

    private Dimension _calculateSizeInWizard(Container container) {
        int n = container.getComponentCount();
        int n2 = this._getNumVisible(container);
        int n3 = this._getNumVisibleSpecial();
        int n4 = 0;
        Dimension dimension = this._getCellSize(container);
        int n5 = dimension.width * n3;
        int n6 = 0;
        while (n6 < n) {
            Component component = container.getComponent(n6);
            if (component.isVisible() && !this._isSpecial(component)) {
                Dimension dimension2 = component.getPreferredSize();
                Font font = component.getFont();
                if (font != null) {
                    dimension2.width += 3 * FontUtils.getAverageWidth(font);
                }
                n5 += Math.max(dimension2.width, dimension.width);
                ++n4;
            }
            ++n6;
        }
        if (n2 > 0) {
            if (this._isBackAndNextVisible()) {
                n5 += (n2 - 2) * 8;
                ++n5;
            } else {
                n5 += (n2 - 1) * 8;
            }
            int n7 = 0;
            if (this._isLeftGroupPresent()) {
                ++n7;
            }
            if (this._isRightGroupPresent()) {
                ++n7;
            }
            if (n4 != 0) {
                ++n7;
            }
            if (n7 > 1) {
                n5 += (n7 - 1) * Math.min(30, dimension.width);
            }
        }
        return new Dimension(n5, dimension.height);
    }

    private boolean _isLeftGroupPresent() {
        int[] nArray = this._getSpecialStart();
        int n = 0;
        while (n < nArray.length) {
            Component component = this._specialComponents[nArray[n]];
            if (component != null && component.isVisible()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean _isRightGroupPresent() {
        int[] nArray = this._getSpecialEnd();
        int n = 0;
        while (n < nArray.length) {
            Component component = this._specialComponents[nArray[n]];
            if (component != null && component.isVisible()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private Dimension _calculateCellSize(Container container, boolean bl) {
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = 0;
        Font font = null;
        int n4 = 0;
        while (n4 < n) {
            Component component = container.getComponent(n4);
            if (component.isVisible()) {
                Dimension dimension = component.getPreferredSize();
                if (font == null) {
                    font = component.getFont();
                }
                if ((!bl || this._isSpecial(component)) && dimension.width > n3) {
                    n3 = dimension.width;
                }
                if (dimension.height > n2) {
                    n2 = dimension.height;
                }
            }
            ++n4;
        }
        if (font != null) {
            n3 += 3 * FontUtils.getAverageWidth(font);
        }
        return new Dimension(n3, n2);
    }

    private int _getNumVisible(Container container) {
        Object object;
        int n = 0;
        int n2 = container.getComponentCount();
        int n3 = 0;
        while (n3 < n2) {
            if (container.getComponent(n3).isVisible()) {
                ++n;
            }
            ++n3;
        }
        if (this._isWizardConfiguration() && container instanceof JComponent && (object = ((JComponent)container).getClientProperty(_RESERVED_WIZARD_BUTTONS)) instanceof Integer) {
            n += ((Integer)object).intValue();
        }
        return n;
    }

    private boolean _isBackAndNextVisible() {
        Component component = this._specialComponents[4];
        Component component2 = this._specialComponents[5];
        return component != null && component2 != null && component.isVisible() && component2.isVisible();
    }

    private boolean _isSpecial(Component component) {
        return (Integer)this._compToConstraintMap.get(component) != 9;
    }

    private int _getNumVisibleSpecial() {
        int n = 0;
        int n2 = 0;
        while (n2 < 9) {
            Component component = this._specialComponents[n2];
            if (component != null && component.isVisible()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private int[] _getSpecialLeft() {
        if (this._isLeftToRight()) {
            return this._getSpecialStart();
        }
        return this._getSpecialEnd();
    }

    private int[] _getSpecialRight() {
        if (this._isLeftToRight()) {
            return this._getSpecialEnd();
        }
        return this._getSpecialStart();
    }

    private int[] _getSpecialStart() {
        if (this._isWizardConfiguration()) {
            return _WIZARD_SPECIAL_START;
        }
        return _NORMAL_SPECIAL_START;
    }

    private int[] _getSpecialEnd() {
        if (this._isWizardConfiguration()) {
            return _WIZARD_SPECIAL_END;
        }
        return _NORMAL_SPECIAL_END;
    }

    private boolean _isWizardConfiguration() {
        return this._specialComponents[4] != null || this._specialComponents[5] != null || this._specialComponents[6] != null;
    }

    private boolean _isLeftToRight() {
        return true;
    }
}

