/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.chooser.color.ColorPalettePane;
import oracle.bali.ewt.chooser.color.ColorPickerPane;
import oracle.bali.ewt.chooser.color.ColorPickerUtils;
import oracle.bali.ewt.chooser.color.CustomColorPane;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.grid.ProxyInputHandler;
import oracle.bali.ewt.grid.StandardGridKeyHandler;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.util.FocusUtils;

class ColorChoiceListener
extends MouseInputAdapter
implements KeyListener,
ItemListener,
PropertyChangeListener,
FocusListener {
    private static final String _LABELED_BY_PROPERTY = "labeledBy";
    private static GridKeyHandler _sColorGridKeyHandler;
    private ColorChoice _colorChoice;
    private boolean _customPaletteDirty;
    private boolean _selectedColorDirty;

    public ColorChoiceListener(ColorChoice colorChoice) {
        this._colorChoice = colorChoice;
        this._registerColorChoice();
    }

    public void unregisterColorChoice() {
        this._colorChoice.removeKeyListener(this);
        this._colorChoice.removeMouseListener(this);
        this._colorChoice.removeMouseMotionListener(this);
        this._colorChoice.removeFocusListener(this);
        this._colorChoice.removePropertyChangeListener(this);
        this._colorChoice = null;
    }

    public void registerColorPickerPane(ColorPickerPane colorPickerPane) {
        colorPickerPane.addPropertyChangeListener(this);
    }

    public void unregisterColorPickerPane(ColorPickerPane colorPickerPane) {
        colorPickerPane.removePropertyChangeListener(this);
    }

    public void registerToggleButtons(JToggleButton jToggleButton) {
        InputMap inputMap = jToggleButton.getInputMap();
        if (inputMap != null) {
            inputMap.put(KeyStroke.getKeyStroke(10, 0, false), inputMap.get(KeyStroke.getKeyStroke(32, 0, false)));
            inputMap.put(KeyStroke.getKeyStroke(10, 0, true), inputMap.get(KeyStroke.getKeyStroke(32, 0, true)));
        }
        jToggleButton.addKeyListener(this);
        jToggleButton.addItemListener(this);
    }

    public void unregisterToggleButtons(JToggleButton jToggleButton) {
        jToggleButton.removeKeyListener(this);
        jToggleButton.removeItemListener(this);
    }

    public void registerColorGrid(ColorGrid colorGrid) {
        colorGrid.addKeyListener(this);
        colorGrid.addFocusListener(this);
        colorGrid.addPropertyChangeListener(this);
        CellInputHandler cellInputHandler = colorGrid.getDefaultInputHandler();
        colorGrid.setDefaultInputHandler(new ColorGridInputHandler(cellInputHandler));
        colorGrid.setGridKeyHandler(ColorChoiceListener._getWrappingColorGridKeyHandler());
    }

    public void unregisterColorGrid(ColorGrid colorGrid) {
        colorGrid.removeKeyListener(this);
        colorGrid.removeFocusListener(this);
        colorGrid.removePropertyChangeListener(this);
    }

    public void registerCustomButton(JButton jButton) {
        jButton.addKeyListener(this);
    }

    public void unregisterCustomButton(JButton jButton) {
        jButton.removeKeyListener(this);
    }

    public boolean showColorPalettePane(ColorPalettePane colorPalettePane) {
        boolean bl;
        colorPalettePane.addPropertyChangeListener(this);
        this._customPaletteDirty = false;
        this._selectedColorDirty = false;
        this._colorChoice.__setCustomDialogVisible(true);
        this._colorChoice.__setDropDownVisible(false);
        boolean bl2 = bl = ColorPalettePane.showDialog(this._colorChoice, colorPalettePane) == 1;
        if (bl) {
            this._colorChoice.requestFocus();
            this._colorChoice.__setCustomDialogVisible(false);
            this._colorChoice.firePropertyChange("popupVisible", Boolean.TRUE, Boolean.FALSE);
            if (this._customPaletteDirty) {
                TwoDModel twoDModel = this._colorChoice.getCustomColorPalette();
                ColorPickerUtils.copyModel(colorPalettePane.getCustomColorPalette(), twoDModel);
                this._colorChoice.firePropertyChange("customColorPalette", null, twoDModel);
            }
            if (this._selectedColorDirty) {
                this._colorChoice.setSelectedColor(colorPalettePane.getSelectedColor());
            }
        } else {
            this._colorChoice.__setDropDownVisible(true);
            this._colorChoice.__setCustomDialogVisible(false);
            this._setFocusOnCustomButton();
        }
        colorPalettePane.removePropertyChangeListener(this);
        return bl;
    }

    public boolean showCustomColorPane(CustomColorPane customColorPane) {
        boolean bl;
        this._colorChoice.__setCustomDialogVisible(true);
        this._colorChoice.__setDropDownVisible(false);
        boolean bl2 = bl = CustomColorPane.showDialog(this._colorChoice, customColorPane) == 1;
        if (bl) {
            this._colorChoice.requestFocus();
            this._colorChoice.__setCustomDialogVisible(false);
            this._colorChoice.firePropertyChange("popupVisible", Boolean.TRUE, Boolean.FALSE);
        } else {
            this._colorChoice.__setDropDownVisible(true);
            this._colorChoice.__setCustomDialogVisible(false);
            this._setFocusOnCustomButton();
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this._colorChoice && !mouseEvent.isConsumed() && this._colorChoice.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent) && this._colorChoice.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this._colorChoice.__setDropDownVisible(!this._colorChoice.__isDropDownVisible());
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this._colorChoice && this._colorChoice.isEnabled() && !mouseEvent.isConsumed() && this._colorChoice.__isDropDownVisible() && (!this._colorChoice.__canDispatchMouseEventToGrid() || this._dispatchMouseEventToGrid(mouseEvent))) {
            mouseEvent.consume();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this._colorChoice && this._colorChoice.isEnabled() && !mouseEvent.isConsumed() && this._colorChoice.__isDropDownVisible() && this._dispatchMouseEventToGrid(mouseEvent)) {
            mouseEvent.consume();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        if (!component.isEnabled()) {
            return;
        }
        int n = keyEvent.getModifiers();
        int n2 = keyEvent.getKeyCode();
        boolean bl = false;
        switch (n2) {
            case 32: {
                if (n != 0 || component != this._colorChoice || this._colorChoice.__isDropDownVisible()) break;
                this._colorChoice.__setDropDownVisible(true);
                bl = true;
                break;
            }
            case 38: 
            case 40: {
                if (n != 8) break;
                this._colorChoice.__setDropDownVisible(!this._colorChoice.__isDropDownVisible());
                bl = true;
                break;
            }
            case 27: {
                if (n != 0 || !this._colorChoice.__isDropDownVisible()) break;
                this._colorChoice.__setDropDownVisible(false);
                bl = true;
                break;
            }
            case 9: {
                if (keyEvent.isMetaDown() || !this._colorChoice.__isDropDownVisible()) break;
                bl = this._transferFocus(component, !keyEvent.isShiftDown());
            }
        }
        if (!bl && this._colorChoice.__isDropDownVisible()) {
            if (component instanceof ColorGrid) {
                bl = ColorChoiceListener._handleKeyEventInGrid((ColorGrid)component, keyEvent);
            }
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            if (!bl) {
                bl = ColorChoiceListener._processKeyBinding((JComponent)component, keyStroke, keyEvent, 0);
            }
            ColorPickerPane colorPickerPane = this._colorChoice.__getColorPickerPane();
            if (!bl && component == this._colorChoice) {
                ColorGrid colorGrid = colorPickerPane.__getStandardGrid();
                bl = this._dispatchKeyEventToGrid(colorGrid, keyEvent);
            }
            if (!bl) {
                bl = ColorChoiceListener._processWindowBinding(colorPickerPane, keyStroke, keyEvent);
            }
        }
        if (bl || this._colorChoice.__isDropDownVisible()) {
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        if (component == this._colorChoice.getClientProperty(_LABELED_BY_PROPERTY)) {
            int n;
            if (!keyEvent.isConsumed() && keyEvent.getModifiers() == 8 && this._colorChoice.isShowing() && this._colorChoice.isEnabled() && ((n = keyEvent.getKeyCode()) == 0 || n == ((JLabel)component).getDisplayedMnemonic())) {
                this._colorChoice.__setDropDownVisible(true);
            }
        } else if (this._colorChoice.__isDropDownVisible()) {
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            if (!ColorChoiceListener._processKeyBinding((JComponent)component, keyStroke, keyEvent, 0)) {
                ColorChoiceListener._processWindowBinding(this._colorChoice.__getColorPickerPane(), keyStroke, keyEvent);
            }
            keyEvent.consume();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component instanceof ColorGrid) {
            ColorGrid colorGrid = (ColorGrid)component;
            Cell cell = colorGrid.getFocusCell();
            if (cell == null) {
                int n = colorGrid.getNextVisibleColumn(-1);
                int n2 = colorGrid.getNextVisibleRow(-1);
                if (n != -1 && n2 != -1) {
                    colorGrid.scrollCellIntoView(n, n2);
                }
            } else {
                colorGrid.scrollCellIntoView(cell.column, cell.row);
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this._colorChoice && this._colorChoice.__isDropDownVisible()) {
            Cell cell;
            ColorGrid colorGrid = this._colorChoice.__getColorPickerPane().__getStandardGrid();
            if (FocusUtils.getOppositeComponent(focusEvent) != colorGrid && (cell = colorGrid.getFocusCell()) != null) {
                CellInputHandler cellInputHandler = colorGrid.getColumnCellInputHandler(cell.column);
                cellInputHandler.focusLost(null, colorGrid, cell.column, cell.row);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this._colorChoice.__setDropDownVisible(false);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        Object object2 = propertyChangeEvent.getOldValue();
        Object object3 = propertyChangeEvent.getNewValue();
        if (object instanceof ColorPickerPane) {
            String string2 = null;
            if ("automaticSelected".equals(string)) {
                string2 = "automaticSelected";
            } else if ("customColorPalette".equals(string)) {
                string2 = "customColorPalette";
            } else if ("defaultSelected".equals(string)) {
                string2 = "defaultSelected";
            } else if ("selectedColor".equals(string)) {
                string2 = "selectedColor";
            } else if ("customColorNames".equals(string)) {
                string2 = "customColorNames";
            }
            if (string2 != null) {
                this._colorChoice.firePropertyChange(string2, object2, object3);
            }
        } else if (object instanceof ColorPalettePane) {
            if ("colorPalette".equals(string)) {
                this._customPaletteDirty = true;
            } else if ("selectedColor".equals(string)) {
                this._selectedColorDirty = true;
            }
        } else if (object instanceof ColorGrid) {
            Cell cell;
            ColorGrid colorGrid = (ColorGrid)object;
            if (!colorGrid.isCustomGrid() && "focusCell".equals(string) && this._colorChoice.hasFocus() && this._colorChoice.__isDropDownVisible() && (cell = (Cell)object3) != null) {
                Color color = (Color)colorGrid.getModel().getData(cell.column, cell.row);
                String string3 = colorGrid.getAccessibleName(cell.column, cell.row, color);
                this._colorChoice.__fireAccessibleEvent(string3);
            }
        } else if (object == this._colorChoice) {
            if (_LABELED_BY_PROPERTY.equals(string)) {
                if (object2 instanceof JLabel) {
                    ((JLabel)object2).removeKeyListener(this);
                }
                if (object3 instanceof JLabel) {
                    ((JLabel)object3).addKeyListener(this);
                }
            } else if ("popupVisible".equals(string) && Boolean.TRUE.equals(object3) && (!FocusUtils.areNewFocusAPIsAvailable() || FocusUtils.isFocusable(this._colorChoice))) {
                ColorGrid colorGrid = this._colorChoice.__getColorPickerPane().__getStandardGrid();
                Cell cell = colorGrid.getFocusCell();
                if (cell == null) {
                    int n = colorGrid.getNextVisibleColumn(-1);
                    int n2 = colorGrid.getNextVisibleRow(-1);
                    if (n != -1 && n2 != -1) {
                        colorGrid.requestFocus(n, n2, null);
                        colorGrid.scrollCellIntoView(n, n2);
                    }
                } else {
                    CellInputHandler cellInputHandler = colorGrid.getColumnCellInputHandler(cell.column);
                    cellInputHandler.focusGained(null, colorGrid, cell.column, cell.row);
                    colorGrid.scrollCellIntoView(cell.column, cell.row);
                }
            }
        }
    }

    private static GridKeyHandler _getWrappingColorGridKeyHandler() {
        if (_sColorGridKeyHandler == null) {
            _sColorGridKeyHandler = new WrappingColorGridKeyHandler();
        }
        return _sColorGridKeyHandler;
    }

    private static boolean _processKeyBinding(JComponent jComponent, KeyStroke keyStroke, KeyEvent keyEvent, int n) {
        Action action;
        ActionMap actionMap;
        Object object;
        if (!jComponent.isEnabled() || !jComponent.isVisible()) {
            return false;
        }
        InputMap inputMap = jComponent.getInputMap(n);
        if (inputMap != null && (object = inputMap.get(keyStroke)) != null && (actionMap = jComponent.getActionMap()) != null && (action = actionMap.get(object)) != null) {
            return SwingUtilities.notifyAction(action, keyStroke, keyEvent, jComponent, keyEvent.getModifiers());
        }
        return false;
    }

    private static boolean _processWindowBinding(Container container, KeyStroke keyStroke, KeyEvent keyEvent) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JComponent && ColorChoiceListener._processKeyBinding((JComponent)componentArray[n], keyStroke, keyEvent, 2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final boolean _handleKeyEventInGrid(ColorGrid colorGrid, KeyEvent keyEvent) {
        Object object;
        Cell cell = colorGrid.getFocusCell();
        if (cell != null) {
            object = colorGrid.getColumnCellInputHandler(cell.column);
            ((CellInputHandler)object).keyPressed(keyEvent, colorGrid, cell.column, cell.row);
        }
        if (keyEvent.isConsumed()) {
            return true;
        }
        object = colorGrid.getGridKeyHandler();
        if (object != null) {
            object.handleKeyEvent(colorGrid, keyEvent);
        }
        return keyEvent.isConsumed();
    }

    private static boolean _handleMouseEventInGrid(Component component, MouseEvent mouseEvent, ColorGrid colorGrid) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Point point = SwingUtilities.convertPoint(component, n, n2, colorGrid);
        if (colorGrid.contains(point.x, point.y)) {
            Point point2 = colorGrid.convertOuterToCanvas(point.x, point.y);
            int n3 = colorGrid.getColumnAt(point2.x);
            int n4 = colorGrid.getRowAt(point2.y);
            if (n3 != -1 && n4 != -1) {
                CellInputHandler cellInputHandler = colorGrid.getColumnCellInputHandler(n3);
                int n5 = mouseEvent.getID();
                if (n5 == 506) {
                    colorGrid.requestFocus(n3, n4, null);
                    return true;
                }
                if (n5 == 502) {
                    point2.translate(-colorGrid.getColumnPosition(n3), -colorGrid.getRowPosition(n4));
                    MouseEvent mouseEvent2 = new MouseEvent(colorGrid, n5, mouseEvent.getWhen(), mouseEvent.getModifiers(), point2.x, point2.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    cellInputHandler.mouseReleased(mouseEvent2, colorGrid, n3, n4);
                    return mouseEvent2.isConsumed();
                }
            }
        }
        return false;
    }

    private void _registerColorChoice() {
        ColorChoice colorChoice = this._colorChoice;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0, true);
        colorChoice.getInputMap(0).put(keyStroke, "none");
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(10, 0, false);
        colorChoice.getInputMap(0).put(keyStroke2, "none");
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(32, 0, true);
        colorChoice.getInputMap(0).put(keyStroke3, "none");
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(32, 0, false);
        colorChoice.getInputMap(0).put(keyStroke4, "none");
        colorChoice.addKeyListener(this);
        colorChoice.addMouseListener(this);
        colorChoice.addMouseMotionListener(this);
        colorChoice.addFocusListener(this);
        colorChoice.addPropertyChangeListener(this);
    }

    private void _setFocusOnCustomButton() {
        final JButton jButton = this._colorChoice.__getColorPickerPane().__getCustomButton();
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jButton.requestFocus();
                }
            });
        } else {
            jButton.requestFocus();
        }
    }

    private boolean _dispatchKeyEventToGrid(ColorGrid colorGrid, KeyEvent keyEvent) {
        KeyEvent keyEvent2 = new KeyEvent(colorGrid, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
        return ColorChoiceListener._handleKeyEventInGrid(colorGrid, keyEvent2);
    }

    private boolean _dispatchMouseEventToGrid(MouseEvent mouseEvent) {
        Serializable serializable;
        boolean bl = false;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        ColorPickerPane colorPickerPane = this._colorChoice.__getColorPickerPane();
        ColorGrid colorGrid = colorPickerPane.__getStandardGrid();
        JViewport jViewport = null;
        Container container = colorGrid.getParent();
        while (container != null && container != colorPickerPane) {
            if (container instanceof JViewport) {
                jViewport = (JViewport)container;
                break;
            }
            container = container.getParent();
        }
        if (jViewport != null) {
            serializable = SwingUtilities.convertPoint(this._colorChoice, n, n2, jViewport);
            if (!jViewport.contains(serializable.x, serializable.y)) {
                return false;
            }
        }
        if (!(bl = ColorChoiceListener._handleMouseEventInGrid(this._colorChoice, mouseEvent, colorGrid))) {
            serializable = colorPickerPane.__getCustomGrid();
            bl = ColorChoiceListener._handleMouseEventInGrid(this._colorChoice, mouseEvent, (ColorGrid)serializable);
        }
        return bl;
    }

    private boolean _transferFocus(Component component, boolean bl) {
        ColorPickerPane colorPickerPane = this._colorChoice.__getColorPickerPane();
        List list = colorPickerPane.__getFocusCycle();
        int n = list.size();
        if (n > 0) {
            int n2 = -1;
            if (component == this._colorChoice) {
                component = colorPickerPane.__getStandardGrid();
            }
            if ((n2 = list.indexOf(component)) != -1) {
                if (bl) {
                    n2 = n2 == n - 1 ? 0 : n2 + 1;
                } else {
                    int n3 = n2 = n2 == 0 ? n - 1 : n2 - 1;
                }
            }
            if (n2 != -1) {
                ((Component)list.get(n2)).requestFocus();
                return true;
            }
        }
        return false;
    }

    private class ColorGridInputHandler
    extends ProxyInputHandler {
        public ColorGridInputHandler(CellInputHandler cellInputHandler) {
            super(cellInputHandler);
        }

        public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
            CellInputHandler cellInputHandler = NullInputHandler.getCellInputHandler();
            cellInputHandler.mousePressed(mouseEvent, grid, n, n2);
        }

        public void mouseReleased(MouseEvent mouseEvent, Grid grid, int n, int n2) {
            super.mouseReleased(mouseEvent, grid, n, n2);
            if (mouseEvent.isConsumed()) {
                ColorChoiceListener.this._colorChoice.__setDropDownVisible(false);
            }
        }

        public void keyPressed(KeyEvent keyEvent, Grid grid, int n, int n2) {
            int n3 = keyEvent.getModifiers();
            int n4 = keyEvent.getKeyCode();
            if (n3 == 0 && (n4 == 32 || n4 == 10)) {
                ColorGrid colorGrid = (ColorGrid)grid;
                colorGrid.__setSelectedColor(n, n2);
                ColorChoiceListener.this._colorChoice.__setDropDownVisible(false);
                keyEvent.consume();
            }
        }
    }

    private static class WrappingColorGridKeyHandler
    extends StandardGridKeyHandler {
        private WrappingColorGridKeyHandler() {
        }

        protected Cell enter(Grid grid, Cell cell, KeyEvent keyEvent, boolean bl) {
            return cell;
        }

        protected Cell left(Grid grid, Cell cell, KeyEvent keyEvent) {
            int n = -1;
            int n2 = -1;
            if (cell == null) {
                n = grid.getPreviousVisibleRow(grid.getRowCount());
                n2 = grid.getPreviousVisibleColumn(grid.getColumnCount());
            } else {
                n = cell.row;
                n2 = grid.getPreviousVisibleColumn(cell.column);
                if (n2 == -1) {
                    n2 = grid.getPreviousVisibleColumn(grid.getColumnCount());
                }
            }
            if (n2 == -1 || n == -1) {
                return cell;
            }
            return new Cell(n2, n);
        }

        protected Cell right(Grid grid, Cell cell, KeyEvent keyEvent) {
            int n = -1;
            int n2 = -1;
            if (cell == null) {
                n = grid.getNextVisibleRow(-1);
                n2 = grid.getNextVisibleColumn(-1);
            } else {
                n = cell.row;
                n2 = grid.getNextVisibleColumn(cell.column);
                if (n2 == -1) {
                    n2 = grid.getNextVisibleColumn(-1);
                }
            }
            if (n2 == -1 || n == -1) {
                return cell;
            }
            return new Cell(n2, n);
        }

        protected Cell up(Grid grid, Cell cell, KeyEvent keyEvent) {
            int n = -1;
            int n2 = -1;
            if (cell == null) {
                n2 = grid.getPreviousVisibleColumn(grid.getColumnCount());
                n = grid.getPreviousVisibleRow(grid.getRowCount());
            } else {
                n2 = cell.column;
                n = grid.getPreviousVisibleRow(cell.row);
                if (n == -1) {
                    n = grid.getPreviousVisibleColumn(grid.getRowCount());
                }
            }
            if (n2 == -1 || n == -1) {
                return cell;
            }
            return new Cell(n2, n);
        }

        protected Cell down(Grid grid, Cell cell, KeyEvent keyEvent) {
            int n;
            int n2;
            if (cell == null) {
                n2 = grid.getNextVisibleColumn(-1);
                n = grid.getNextVisibleRow(-1);
            } else {
                n2 = cell.column;
                n = grid.getNextVisibleRow(cell.row);
                if (n == -1) {
                    n = grid.getNextVisibleRow(-1);
                }
            }
            if (n2 == -1 || n == -1) {
                return cell;
            }
            return new Cell(n2, n);
        }

        protected Cell pageUp(Grid grid, Cell cell, KeyEvent keyEvent) {
            return this.up(grid, cell, keyEvent);
        }

        protected Cell pageDown(Grid grid, Cell cell, KeyEvent keyEvent) {
            return this.down(grid, cell, keyEvent);
        }

        protected Cell home(Grid grid, Cell cell, KeyEvent keyEvent) {
            return new Cell(grid.getNextVisibleColumn(-1), grid.getNextVisibleRow(-1));
        }

        protected Cell end(Grid grid, Cell cell, KeyEvent keyEvent) {
            return new Cell(grid.getPreviousVisibleColumn(grid.getColumnCount()), grid.getPreviousVisibleRow(grid.getRowCount()));
        }
    }
}

