/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.chooser.color.BaseColorEditor;
import oracle.bali.ewt.chooser.color.ColorPickerUtils;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;

class ColorComponent
extends BaseColorEditor
implements KeyListener {
    private static final String _KEY_ACCESS_NAME = "COLORCHOICE.FULL_ACCESSIBLE_NAME";
    private static final String _KEY_COLOR_VALUE = "COLORPALETTE.TOOLTIP";
    private static final Dimension _SIZE = new Dimension(54, 21);
    private static final String _SELECTED_LABEL = "COLORCHOOSER.SELECTED_COLOR";
    private static final String _ORIGINAL_LABEL = "COLORCHOOSER.ORIGINAL_COLOR";
    private static final String _ORIGINAL_COLOR_NAME = "Current_Color_Panel";
    private JLabel _selectedColorLabel = new JLabel("");
    private JLabel _originalColorLabel;
    private ColorPanel _selectedColorPanel = new ColorPanel();
    private ColorPanel _originalColorPanel;
    private Color _originalColor;

    public ColorComponent() {
        Insets insets;
        this._selectedColorPanel.setBackground(Color.white);
        this._originalColorLabel = new JLabel("");
        this._originalColorLabel.addKeyListener(this);
        this._originalColorPanel = new OriginalColorPanel();
        this._originalColorLabel.setLabelFor(this._originalColorPanel);
        this._originalColorPanel.setName(_ORIGINAL_COLOR_NAME);
        this._originalColorPanel.addKeyListener(this);
        this.setOriginalColor(null);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets = new Insets(0, 0, 0, 12);
        gridBagConstraints.gridx = 0;
        this.add((Component)this._selectedColorLabel, gridBagConstraints);
        this.add((Component)this._originalColorLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        insets.right = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this._selectedColorPanel, gridBagConstraints);
        this.add((Component)this._originalColorPanel, gridBagConstraints);
    }

    public void setOriginalColor(Color color) {
        this._originalColor = color == null ? Color.white : color;
        this._originalColorPanel.setBackground(this._originalColor);
    }

    public Color getOriginalColor() {
        return this._originalColor;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._selectedColorLabel.setEnabled(bl);
        this._selectedColorPanel.setEnabled(bl);
        this._originalColorLabel.setEnabled(bl);
        this._originalColorPanel.setEnabled(bl);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getComponent() == this._originalColorPanel && this.isEnabled() && !keyEvent.isConsumed() && keyEvent.getModifiers() == 0 && keyEvent.getKeyCode() == 32) {
            this._restoreOriginalColor();
            keyEvent.consume();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n;
        if (keyEvent.getComponent() == this._originalColorLabel && this.isEnabled() && !keyEvent.isConsumed() && keyEvent.getModifiers() == 8 && ((n = keyEvent.getKeyCode()) == 0 || n == this._originalColorLabel.getDisplayedMnemonic())) {
            this._restoreOriginalColor();
        }
    }

    protected void colorChanged(Color color) {
        this._selectedColorPanel.setBackground(color);
    }

    protected void updateLabels(Locale locale) {
        String string = BaseColorEditor.__getTranslatedString(locale, _SELECTED_LABEL);
        this._selectedColorLabel.setText(string);
        string = BaseColorEditor.__getTranslatedString(locale, _ORIGINAL_LABEL);
        this._originalColorLabel.setText(StringUtils.stripMnemonic((String)string));
        this._originalColorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
    }

    public void _restoreOriginalColor() {
        if (this.getColor() != this._originalColor) {
            this.storeColor(this._originalColor);
            this._selectedColorPanel.setBackground(this._originalColor);
        }
    }

    private class OriginalColorPanel
    extends ColorPanel
    implements Accessible {
        public OriginalColorPanel() {
            this.enableEvents(20L);
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new Access();
            }
            return this.accessibleContext;
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (this.isEnabled() && !mouseEvent.isConsumed() && mouseEvent.getID() == 501 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (!this.hasFocus()) {
                    this.requestFocus();
                }
                ColorComponent.this._restoreOriginalColor();
                mouseEvent.consume();
            }
        }

        protected void processFocusEvent(FocusEvent focusEvent) {
            super.processFocusEvent(focusEvent);
            this.repaint();
        }

        private class Access
        extends JComponent.AccessibleJComponent {
            private Access() {
                super(OriginalColorPanel.this);
            }

            public String getAccessibleName() {
                String string = super.getAccessibleName();
                if (string == null) {
                    string = "";
                }
                String string2 = ColorComponent.this.__getAccessTranslatedString(ColorComponent._KEY_ACCESS_NAME);
                string = MessageFormat.format(string2, string);
                string2 = ColorComponent.this.__getAccessTranslatedString(ColorComponent._KEY_COLOR_VALUE);
                Color color = ColorComponent.this._originalColor;
                Object[] objectArray = new Object[]{IntegerUtils.getInteger((int)color.getRed()), IntegerUtils.getInteger((int)color.getGreen()), IntegerUtils.getInteger((int)color.getBlue())};
                String string3 = MessageFormat.format(string2, objectArray);
                return string + " " + string3;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LABEL;
            }
        }
    }

    private class ColorPanel
    extends LWComponent {
        private ColorPanel() {
        }

        public Dimension getMinimumSize() {
            return _SIZE;
        }

        public Dimension getPreferredSize() {
            return _SIZE;
        }

        public Dimension getMaximumSize() {
            return _SIZE;
        }

        protected void paintComponent(Graphics graphics) {
            Color color = graphics.getColor();
            ImmInsets immInsets = this.getBorderInsets();
            int n = immInsets.left;
            int n2 = immInsets.top;
            int n3 = this.getWidth() - (immInsets.left + immInsets.right);
            int n4 = this.getHeight() - (immInsets.top + immInsets.bottom);
            Color color2 = this.getBackground();
            graphics.setColor(color2);
            graphics.fillRect(immInsets.left, immInsets.top, n3, n4);
            if (this.hasFocus()) {
                double d = (double)color2.getRed() * 0.3 + (double)color2.getGreen() * 0.59 + (double)color2.getBlue() * 0.11;
                if (d < 61.0) {
                    graphics.setColor(Color.white);
                } else {
                    graphics.setColor(Color.black);
                }
                ColorPickerUtils.paintFocus(graphics, n, n2 += 2, n3, n4 -= 4);
            }
            graphics.setColor(color);
        }
    }
}

