/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.chooser.color.CMYComponent;
import oracle.bali.ewt.chooser.color.ColorComponent;
import oracle.bali.ewt.chooser.color.ColorEditor;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.chooser.color.ColorPickerUtils;
import oracle.bali.ewt.chooser.color.HSBComponent;
import oracle.bali.ewt.chooser.color.HTMLHexComponent;
import oracle.bali.ewt.chooser.color.ImageComponent;
import oracle.bali.ewt.chooser.color.RGBComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class CustomColorPane
extends LWComponent
implements Accessible {
    public static final int COLOR_PICKER_RGB = 1;
    public static final int COLOR_PICKER_HSB = 2;
    public static final int COLOR_PICKER_CMY = 4;
    public static final int COLOR_PICKER_RGBHEX = 8;
    public static final int RGB_TOOLTIP = 0;
    public static final int RGB_HEX_TOOLTIP = 1;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    public static final String PROPERTY_COLOR_PALETTE = "customColorPalette";
    public static final String PROPERTY_CUSTOM_COLOR_NAMES = "customColorNames";
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_TITLE = "CUSTOMCOLORPANE.TITLE";
    private static final String _KEY_STANDARD_PALETTE = "CUSTOMCOLORPANE.STANDARD_PALETTE";
    private static final String _KEY_CUSTOM_PALETTE = "CUSTOMCOLORPANE.CUSTOM_PALETTE";
    private static final String _KEY_COLOR_NAME = "CUSTOMCOLORPANE.COLOR_NAME";
    private static final String _KEY_CUSTOM_BUTTON = "CUSTOMCOLORPANE.CUSTOM_BUTTON";
    private static final int _CUSTOM_ROW_COUNT = 2;
    private static final Color _DEFAULT_COLOR = Color.white;
    private static final String _STANDARD_PALETTE_NAME = "Standard_Palette";
    private static final String _CUSTOM_PALETTE_NAME = "Custom_Palette";
    private static final String _COLOR_NAME = "Color_Name_Field";
    private static final String _CUSTOM_BUTTON_NAME = "Add_to_Custom_Button";
    private static final Dimension _EMPTY_SIZE = new Dimension();
    private boolean _initialized;
    private boolean _ignoreEvents;
    private EventHandler _eventHandler = new EventHandler();
    private JLabel _colorGridLabel;
    private ColorGrid _colorGrid;
    private JLabel _customGridLabel;
    private ColorGrid _customGrid;
    private JPanel _nameComponent;
    private JLabel _nameLabel;
    private JTextField _nameField;
    private boolean _colorNameDirty;
    private boolean _colorNameVisible = true;
    private ImageComponent _imageComponent;
    private ColorComponent _colorComponent;
    private JButton _customColorButton;
    private RGBComponent _rgbComponent;
    private HSBComponent _hsbComponent;
    private CMYComponent _cmyComponent;
    private HTMLHexComponent _rgbHexComponent;
    private ArrayList _colorEditors;
    private JPanel _customColorEditorPanel;
    private GridBagConstraints _customConstraints;

    public CustomColorPane() {
        this(null, null, null);
    }

    public CustomColorPane(Color color) {
        this(null, null, color);
    }

    public CustomColorPane(TwoDModel twoDModel, Color color) {
        this(twoDModel, null, color);
    }

    public CustomColorPane(TwoDModel twoDModel, TwoDModel twoDModel2, Color color) {
        this._createUI();
        this.setToolTipMode(0);
        this.setColorPalette(twoDModel);
        this.setCustomColorPalette(twoDModel2);
        this.setCurrentColor(color);
        this.setSelectedColor(color);
        this._updateNameAndCustomButton();
        this._initialized = true;
    }

    public static int showDialog(Component component, CustomColorPane customColorPane) {
        return CustomColorPane.showDialog(component, customColorPane, null, false);
    }

    public static int showDialog(Component component, CustomColorPane customColorPane, String string, boolean bl) {
        Object object;
        if (customColorPane == null) {
            throw new IllegalArgumentException("CustomColorPane must be non-null");
        }
        Locale locale = LocaleUtils.getDefaultableLocale((Component)customColorPane);
        if (string == null) {
            object = ResourceBundle.getBundle(_RESOURCE, locale);
            string = ((ResourceBundle)object).getString(_KEY_TITLE);
        }
        object = JEWTDialog.createDialog(component, string, 7);
        ((Component)object).setLocale(locale);
        ((JEWTDialog)object).setContent(customColorPane);
        ((JEWTDialog)object).setCenterOver(component);
        ((Dialog)object).setResizable(bl);
        ((JEWTDialog)object).setInitialFocus(customColorPane._getInitialFocus());
        int n = ((JEWTDialog)object).runDialog() ? 1 : 2;
        ((JEWTDialog)object).dispose();
        return n;
    }

    public void setCurrentColor(Color color) {
        if (color == null) {
            color = _DEFAULT_COLOR;
        }
        this._colorComponent.setOriginalColor(color);
    }

    public Color getCurrentColor() {
        return this._colorComponent.getOriginalColor();
    }

    public void setSelectedColor(Color color) {
        if (color != null && color.equals(this.getSelectedColor())) {
            return;
        }
        this._updateSelectedColor(null, color);
    }

    public Color getSelectedColor() {
        return this._colorComponent.getColor();
    }

    public void setColorPalette(TwoDModel twoDModel) {
        this._colorGrid.setColorPalette(twoDModel);
    }

    public TwoDModel getColorPalette() {
        return this._colorGrid.getColorPalette();
    }

    public void setCustomColorPalette(TwoDModel twoDModel) {
        boolean bl;
        boolean bl2 = bl = twoDModel != null && twoDModel.getColumnCount() > 0 && twoDModel.getRowCount() > 0;
        if (bl != this._customGrid.isVisible()) {
            this._customGridLabel.setVisible(bl);
            this._customGrid.setVisible(bl);
            this._customColorButton.setVisible(bl);
            this._updateNameVisibility();
        }
        this._customGrid.setColorPalette(twoDModel);
    }

    public TwoDModel getCustomColorPalette() {
        return this._customGrid.getColorPalette();
    }

    public void setColorNameVisible(boolean bl) {
        this._colorNameVisible = bl;
        this._updateNameVisibility();
    }

    public boolean isColorNameVisible() {
        return this._nameComponent.isVisible();
    }

    public void setCustomColorNames(TwoDModel twoDModel) {
        this._setCustomColorNames(twoDModel, true);
    }

    public TwoDModel getCustomColorNames() {
        return this._customGrid.__getColorNames();
    }

    public String getCustomColorName() {
        if (!this._customGrid.isVisible()) {
            return null;
        }
        TwoDModel twoDModel = this.getCustomColorNames();
        if (twoDModel != null) {
            Object object;
            int n = this._customGrid.__getSelectedColumn();
            int n2 = this._customGrid.__getSelectedRow();
            if (n != -1 && n2 != -1 && n < twoDModel.getColumnCount() && n2 < twoDModel.getRowCount() && (object = twoDModel.getData(n, n2)) instanceof String) {
                return (String)object;
            }
        }
        return null;
    }

    public void setToolTipMode(int n) {
        this._colorGrid.setToolTipMode(n);
        this._customGrid.setToolTipMode(n);
    }

    public int getToolTipMode() {
        return this._colorGrid.getToolTipMode();
    }

    public void setColorPickerMask(int n) {
        Color color = this.getSelectedColor();
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = (n & 4) != 0;
        boolean bl4 = (n & 8) != 0;
        this._rgbComponent.setVisible(bl);
        if (bl) {
            this._rgbComponent.setColor(color);
        }
        this._hsbComponent.setVisible(bl2);
        if (bl2) {
            this._hsbComponent.setColor(color);
        }
        this._cmyComponent.setVisible(bl3);
        if (bl3) {
            this._cmyComponent.setColor(color);
        }
        this._rgbHexComponent.setVisible(bl4);
        if (bl4) {
            this._rgbHexComponent.setColor(color);
        }
    }

    public int getColorPickerMask() {
        int n = 0;
        if (this._rgbComponent.isVisible()) {
            n |= 1;
        }
        if (this._hsbComponent.isVisible()) {
            n |= 2;
        }
        if (this._cmyComponent.isVisible()) {
            n |= 4;
        }
        if (this._rgbHexComponent.isVisible()) {
            n |= 8;
        }
        return n;
    }

    public void addCustomColorEditor(ColorEditor colorEditor) {
        if (colorEditor == null) {
            return;
        }
        if (this._colorEditors == null) {
            this._colorEditors = new ArrayList(2);
        } else if (this._colorEditors.contains(colorEditor)) {
            return;
        }
        this._colorEditors.add(colorEditor);
        this._customColorEditorPanel.add(colorEditor.getComponent(), this._customConstraints);
        colorEditor.setColor(this.getSelectedColor());
        colorEditor.addPropertyChangeListener(this._eventHandler);
        this.revalidate();
        this.repaint();
    }

    public void removeCustomColorEditor(ColorEditor colorEditor) {
        if (colorEditor == null || this._colorEditors == null || !this._colorEditors.contains(colorEditor)) {
            return;
        }
        ((AbstractCollection)this._colorEditors).remove(colorEditor);
        this._customColorEditorPanel.remove(colorEditor.getComponent());
        colorEditor.removePropertyChangeListener(this._eventHandler);
        this.revalidate();
        this.repaint();
    }

    public ColorEditor[] getCustomColorEditors() {
        return this._colorEditors == null ? null : this._colorEditors.toArray(new ColorEditor[0]);
    }

    public void dispose() {
        if (this._eventHandler == null) {
            return;
        }
        this._colorGridLabel = null;
        this._colorGrid.removePropertyChangeListener(this._eventHandler);
        this._colorGrid.dispose();
        this._colorGrid = null;
        TwoDModel twoDModel = this.getCustomColorNames();
        if (twoDModel != null) {
            twoDModel.removeModelListener(this._eventHandler);
        }
        this._customGridLabel = null;
        this._customGrid.removePropertyChangeListener(this._eventHandler);
        this._customGrid.dispose();
        this._customGrid = null;
        this._nameLabel = null;
        this._nameField.getDocument().removeDocumentListener(this._eventHandler);
        this._nameField = null;
        this._imageComponent.removePropertyChangeListener(this._eventHandler);
        this._imageComponent = null;
        this._colorComponent.removePropertyChangeListener(this._eventHandler);
        this._colorComponent = null;
        this._customColorButton.removeActionListener(this._eventHandler);
        this._customColorButton = null;
        this._rgbComponent.removePropertyChangeListener(this._eventHandler);
        this._rgbComponent = null;
        this._cmyComponent.removePropertyChangeListener(this._eventHandler);
        this._cmyComponent = null;
        this._hsbComponent.removePropertyChangeListener(this._eventHandler);
        this._hsbComponent = null;
        this._rgbHexComponent.removePropertyChangeListener(this._eventHandler);
        this._rgbHexComponent = null;
        ColorEditor[] colorEditorArray = this.getCustomColorEditors();
        int n = colorEditorArray == null ? 0 : colorEditorArray.length;
        int n2 = 0;
        while (n2 < n) {
            colorEditorArray[n2].removePropertyChangeListener(this._eventHandler);
            ++n2;
        }
        if (this._colorEditors != null) {
            this._colorEditors.clear();
        }
        this._colorEditors = null;
        this._customColorEditorPanel = null;
        this._customConstraints = null;
        this._eventHandler = null;
    }

    public void setLayout(LayoutManager layoutManager) {
        throw new IllegalArgumentException("setLayout() not supported");
    }

    public void addNotify() {
        super.addNotify();
        this._updateLabels(this.getLocale());
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._initialized) {
            this._updateLabels(locale);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._colorGridLabel.setEnabled(bl);
        this._colorGrid.setEnabled(bl);
        this._customGridLabel.setEnabled(bl);
        this._customGrid.setEnabled(bl);
        this._updateNameAndCustomButton();
        this._imageComponent.setEnabled(bl);
        this._colorComponent.setEnabled(bl);
        this._rgbComponent.setEnabled(bl);
        this._hsbComponent.setEnabled(bl);
        this._cmyComponent.setEnabled(bl);
        this._rgbHexComponent.setEnabled(bl);
        ColorEditor[] colorEditorArray = this.getCustomColorEditors();
        int n = colorEditorArray == null ? 0 : colorEditorArray.length;
        int n2 = 0;
        while (n2 < n) {
            colorEditorArray[n2].getComponent().setEnabled(bl);
            ++n2;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCustomColorPane();
        }
        return this.accessibleContext;
    }

    private void _createUI() {
        this._createComponents();
        this._layoutComponents();
    }

    private void _createComponents() {
        this._colorGridLabel = new JLabel();
        this._colorGrid = new ColorGrid();
        this._colorGrid.setName(_STANDARD_PALETTE_NAME);
        this._colorGrid.__setSelectedSlotEnabled(true);
        this._colorGridLabel.setLabelFor(this._colorGrid);
        this._colorGrid.addPropertyChangeListener(this._eventHandler);
        this._customGridLabel = new JLabel();
        this._customGrid = new ColorGrid(true);
        this._customGrid.setName(_CUSTOM_PALETTE_NAME);
        this._customGrid.__setSelectedSlotEnabled(true);
        this._customGridLabel.setLabelFor(this._customGrid);
        this._customGrid.addPropertyChangeListener(this._eventHandler);
        this._nameComponent = new JPanel();
        this._nameLabel = new JLabel();
        this._nameField = new JTextField(7);
        this._nameField.setName(_COLOR_NAME);
        this._nameLabel.setLabelFor(this._nameField);
        this._nameField.getDocument().addDocumentListener(this._eventHandler);
        this._imageComponent = new ImageComponent();
        this._imageComponent.addPropertyChangeListener(this._eventHandler);
        this._colorComponent = new ColorComponent();
        this._colorComponent.addPropertyChangeListener(this._eventHandler);
        this._customColorButton = new JButton();
        this._customColorButton.setName(_CUSTOM_BUTTON_NAME);
        this._customColorButton.putClientProperty(PushButton.LEFTMOST_BUTTON_KEY, Boolean.TRUE);
        this._customColorButton.putClientProperty(PushButton.RIGHTMOST_BUTTON_KEY, Boolean.TRUE);
        this._customColorButton.addActionListener(this._eventHandler);
        this._rgbComponent = new RGBComponent();
        this._rgbComponent.addPropertyChangeListener(this._eventHandler);
        this._hsbComponent = new HSBComponent();
        this._hsbComponent.addPropertyChangeListener(this._eventHandler);
        this._cmyComponent = new CMYComponent();
        this._cmyComponent.addPropertyChangeListener(this._eventHandler);
        this._rgbHexComponent = new HTMLHexComponent();
        this._rgbHexComponent.addPropertyChangeListener(this._eventHandler);
    }

    private void _layoutComponents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this._createTopPanel(), "Center");
        jPanel.add((Component)this._createBottomPanel(), "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "West");
        super.setLayout(new BorderLayout());
        this.add((Component)jPanel2, "North");
    }

    private JPanel _createTopPanel() {
        TopLeftPanel topLeftPanel = new TopLeftPanel();
        ImageComponent imageComponent = this._imageComponent;
        JPanel jPanel = new JPanel(new BorderLayout(0, 12));
        jPanel.add((Component)this._colorComponent, "Center");
        jPanel.add((Component)this._customColorButton, "South");
        JPanel jPanel2 = new JPanel(new TopLayout(24, 10));
        jPanel2.add((Component)topLeftPanel, "Left");
        jPanel2.add((Component)imageComponent, "RightTop");
        jPanel2.add((Component)jPanel, "RightBottom");
        return jPanel2;
    }

    private JPanel _createBottomPanel() {
        JPanel jPanel = new JPanel(new BottomLayout(24, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        jPanel.add(this._rgbComponent);
        jPanel.add(this._hsbComponent);
        jPanel.add(this._cmyComponent);
        jPanel.add(this._rgbHexComponent);
        this._customColorEditorPanel = new JPanel(new GridBagLayout());
        this._customConstraints = new GridBagConstraints();
        this._customConstraints.anchor = 18;
        this._customConstraints.insets = new Insets(0, 0, 0, 24);
        jPanel.add((Component)this._customColorEditorPanel, 0);
        return jPanel;
    }

    private void _updateLabels(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, locale);
        String string = null;
        string = resourceBundle.getString(_KEY_STANDARD_PALETTE);
        this._colorGridLabel.setText(StringUtils.stripMnemonic((String)string));
        this._colorGridLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = resourceBundle.getString(_KEY_CUSTOM_PALETTE);
        this._customGridLabel.setText(StringUtils.stripMnemonic((String)string));
        this._customGridLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = resourceBundle.getString(_KEY_COLOR_NAME);
        this._nameLabel.setText(StringUtils.stripMnemonic((String)string));
        this._nameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = resourceBundle.getString(_KEY_CUSTOM_BUTTON);
        this._customColorButton.setText(StringUtils.stripMnemonic((String)string));
        this._customColorButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this._rgbComponent.setLocale(locale);
        this._hsbComponent.setLocale(locale);
        this._cmyComponent.setLocale(locale);
        this._rgbHexComponent.setLocale(locale);
        this._imageComponent.setLocale(locale);
        this._colorComponent.setLocale(locale);
        ColorEditor[] colorEditorArray = this.getCustomColorEditors();
        int n = colorEditorArray == null ? 0 : colorEditorArray.length;
        int n2 = 0;
        while (n2 < n) {
            colorEditorArray[n2].getComponent().setLocale(locale);
            ++n2;
        }
        this._colorGrid.setLocale(locale);
        this._customGrid.setLocale(locale);
    }

    private Component _getInitialFocus() {
        if (this._customGrid.isVisible() && this._customGrid.__getSelectedColumn() != -1 && this._customGrid.__getSelectedRow() != -1) {
            return this._customGrid;
        }
        return this._colorGrid;
    }

    private void _updateNameVisibility() {
        boolean bl;
        boolean bl2 = bl = this._colorNameVisible && this._customGrid.isVisible();
        if (bl != this.isColorNameVisible()) {
            this._nameComponent.setVisible(bl);
            this._updateColorNameField();
        }
    }

    private void _updateSelectedColor(Object object, Color color) {
        if (!this._ignoreEvents) {
            this._ignoreEvents = true;
            if (color == null) {
                color = _DEFAULT_COLOR;
            }
            Color color2 = this.getSelectedColor();
            this._updateColorGrids(object, color);
            this._updateColorEditors(object, color);
            this._ignoreEvents = false;
            this.firePropertyChange(PROPERTY_SELECTED_COLOR, color2, color);
        }
    }

    private void _updateColorGrids(Object object, Color color) {
        block8: {
            if (object == this._colorGrid) {
                this._customGrid.setSelectedColor(null);
            } else if (object == this._customGrid) {
                this._colorGrid.setSelectedColor(null);
            } else {
                try {
                    this._colorGrid.setSelectedColor(color);
                    this._customGrid.setSelectedColor(null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this._colorGrid.setSelectedColor(null);
                    if (!this._customGrid.isVisible()) break block8;
                    try {
                        this._customGrid.setSelectedColor(color);
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        this._customGrid.setSelectedColor(null);
                    }
                }
            }
        }
    }

    private void _updateColorEditors(Object object, Color color) {
        ColorEditor[] colorEditorArray;
        if (object != this._rgbComponent && this._rgbComponent.isVisible()) {
            this._rgbComponent.setColor(color);
        }
        if (object != this._hsbComponent && this._hsbComponent.isVisible()) {
            this._hsbComponent.setColor(color);
        }
        if (object != this._cmyComponent && this._cmyComponent.isVisible()) {
            this._cmyComponent.setColor(color);
        }
        if (object != this._rgbHexComponent && this._rgbHexComponent.isVisible()) {
            this._rgbHexComponent.setColor(color);
        }
        if (object != this._imageComponent) {
            this._imageComponent.setColor(color);
        }
        if (object != this._colorComponent) {
            this._colorComponent.setColor(color);
        }
        int n = (colorEditorArray = this.getCustomColorEditors()) == null ? 0 : colorEditorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColorEditor colorEditor = colorEditorArray[n2];
            if (object != colorEditor && colorEditor.getComponent().isVisible()) {
                colorEditor.setColor(color);
            }
            ++n2;
        }
    }

    private void _updateCustomSlot() {
        this._updateNameAndCustomButton();
        this._updateColorNameField();
    }

    private void _updateNameAndCustomButton() {
        boolean bl = this.isEnabled() && this._customGrid.isVisible() && this._customGrid.__getSelectedSlotColumn() != -1 && this._customGrid.__getSelectedSlotRow() != -1;
        this._customColorButton.setEnabled(bl);
        this._nameLabel.setEnabled(bl);
        this._nameField.setEnabled(bl);
    }

    private void _setCustomColorNames(TwoDModel twoDModel, boolean bl) {
        TwoDModel twoDModel2 = this.getCustomColorNames();
        if (twoDModel2 != twoDModel) {
            if (twoDModel2 != null) {
                twoDModel2.removeModelListener(this._eventHandler);
            }
            if (twoDModel != null) {
                twoDModel.addModelListener(this._eventHandler);
            }
            this._customGrid.__setColorNames(twoDModel);
            if (bl) {
                this.firePropertyChange(PROPERTY_CUSTOM_COLOR_NAMES, twoDModel2, twoDModel);
            }
        }
    }

    private void _updateCustomColorName(String string) {
        int n = this._customGrid.__getSelectedColumn();
        int n2 = this._customGrid.__getSelectedRow();
        if (n != -1 && n2 != -1 && string != null && (string = string.trim()).length() > 0) {
            TwoDModel twoDModel = this.getCustomColorNames();
            int n3 = this._customGrid.getColumnCount();
            int n4 = this._customGrid.getRowCount();
            ArrayTwoDModel arrayTwoDModel = null;
            if (twoDModel == null) {
                arrayTwoDModel = new ArrayTwoDModel(n3, n4);
            } else {
                int n5 = twoDModel.getColumnCount();
                int n6 = twoDModel.getRowCount();
                if (n > n5 - 1 || n2 > n6 - 1) {
                    n5 = Math.max(n5, n3);
                    n6 = Math.max(n6, n4);
                    arrayTwoDModel = new ArrayTwoDModel(n5, n6);
                    ColorPickerUtils.copyModel(twoDModel, arrayTwoDModel);
                }
            }
            if (arrayTwoDModel != null) {
                twoDModel = arrayTwoDModel;
                this._setCustomColorNames(twoDModel, false);
            }
            twoDModel.setData(n, n2, string);
            this.firePropertyChange(PROPERTY_CUSTOM_COLOR_NAMES, null, twoDModel);
        }
    }

    private void _updateColorNameField() {
        if (this.isColorNameVisible()) {
            String string = null;
            TwoDModel twoDModel = this.getCustomColorNames();
            if (twoDModel != null) {
                Object object;
                int n = this._customGrid.__getSelectedSlotColumn();
                int n2 = this._customGrid.__getSelectedSlotRow();
                if (n != -1 && n2 != -1 && n < twoDModel.getColumnCount() && n2 < twoDModel.getRowCount() && (object = twoDModel.getData(n, n2)) instanceof String) {
                    string = (String)object;
                }
            }
            this._nameField.setText(string);
        }
        this._colorNameDirty = false;
    }

    private class EventHandler
    implements PropertyChangeListener,
    ActionListener,
    TwoDModelListener,
    DocumentListener {
        private EventHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getSource();
            if (object instanceof ColorGrid) {
                if ("model".equals(string)) {
                    if (object == CustomColorPane.this._customGrid) {
                        CustomColorPane.super.firePropertyChange(CustomColorPane.PROPERTY_COLOR_PALETTE, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                    }
                } else if (CustomColorPane.PROPERTY_SELECTED_COLOR.equals(string)) {
                    CustomColorPane.this._updateSelectedColor(object, (Color)propertyChangeEvent.getNewValue());
                } else if ("slotChanged".equals(string)) {
                    ColorGrid colorGrid = object == CustomColorPane.this._colorGrid ? CustomColorPane.this._customGrid : CustomColorPane.this._colorGrid;
                    colorGrid.__setSelectedSlot(-1, -1, false);
                    CustomColorPane.this._updateCustomSlot();
                }
            } else if (object instanceof ColorEditor && "color".equals(string)) {
                CustomColorPane.this._updateSelectedColor(object, (Color)propertyChangeEvent.getNewValue());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == CustomColorPane.this._customColorButton && CustomColorPane.this._customGrid.__replaceSelectedSlotColor(CustomColorPane.this.getSelectedColor())) {
                if (CustomColorPane.this._colorNameDirty) {
                    CustomColorPane.this._updateCustomColorName(CustomColorPane.this._nameField.getText());
                    CustomColorPane.this._colorNameDirty = false;
                }
                CustomColorPane.super.firePropertyChange(CustomColorPane.PROPERTY_COLOR_PALETTE, null, CustomColorPane.this.getCustomColorPalette());
            }
        }

        public void columnsAdded(TwoDModelEvent twoDModelEvent) {
            CustomColorPane.this._updateColorNameField();
        }

        public void columnsRemoved(TwoDModelEvent twoDModelEvent) {
            CustomColorPane.this._updateColorNameField();
        }

        public void rowsAdded(TwoDModelEvent twoDModelEvent) {
            CustomColorPane.this._updateColorNameField();
        }

        public void rowsRemoved(TwoDModelEvent twoDModelEvent) {
            CustomColorPane.this._updateColorNameField();
        }

        public void invalidateColumns(TwoDModelEvent twoDModelEvent) {
            CustomColorPane.this._updateColorNameField();
        }

        public void invalidateRows(TwoDModelEvent twoDModelEvent) {
            CustomColorPane.this._updateColorNameField();
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            CustomColorPane.this._updateColorNameField();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            CustomColorPane.this._colorNameDirty = true;
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            CustomColorPane.this._colorNameDirty = true;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            CustomColorPane.this._colorNameDirty = true;
        }
    }

    private class AccessibleCustomColorPane
    extends JComponent.AccessibleJComponent {
        private AccessibleCustomColorPane() {
            super(CustomColorPane.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COLOR_CHOOSER;
        }
    }

    private class BottomLayout
    implements LayoutManager {
        public static final int CUSTOM_EDITORS = 0;
        private int _hGap;
        private int _vGap;

        public BottomLayout(int n, int n2) {
            this._hGap = n;
            this._vGap = n2;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            Cloneable cloneable;
            Serializable serializable;
            Serializable serializable2;
            Serializable serializable3;
            Serializable serializable4;
            Dimension dimension = new Dimension();
            int n = 0;
            int n2 = 0;
            Component component = this._getComponent(1);
            if (component != null) {
                serializable4 = component.getPreferredSize();
                dimension.width += ((Dimension)serializable4).width;
                dimension.height = Math.max(dimension.height, ((Dimension)serializable4).height);
                ++n;
            }
            if ((serializable4 = this._getComponent(2)) != null) {
                serializable3 = ((Component)serializable4).getPreferredSize();
                dimension.width += ((Dimension)serializable3).width;
                dimension.height = Math.max(dimension.height, ((Dimension)serializable3).height);
                ++n;
            }
            if ((serializable3 = this._getComponent(4)) != null) {
                serializable2 = ((Component)serializable3).getPreferredSize();
                dimension.width += ((Dimension)serializable2).width;
                dimension.height = Math.max(dimension.height, ((Dimension)serializable2).height);
                ++n;
            }
            if (n != 0) {
                ++n2;
                dimension.width += (n - 1) * this._hGap;
            }
            if ((serializable2 = this._getComponent(8)) != null) {
                serializable = ((Component)serializable2).getPreferredSize();
                dimension.width = Math.max(dimension.width, ((Dimension)serializable).width);
                dimension.height += ((Dimension)serializable).height;
                ++n2;
            }
            if ((serializable = this._getComponent(0)) != null) {
                cloneable = ((Component)serializable).getPreferredSize();
                dimension.width = Math.max(dimension.width, cloneable.width);
                dimension.height += cloneable.height;
                ++n2;
            }
            if (n2 != 0) {
                dimension.height += (n2 - 1) * this._vGap;
                cloneable = container.getInsets();
                dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
                dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
            }
            return dimension;
        }

        public void layoutContainer(Container container) {
            Serializable serializable;
            Serializable serializable2;
            Serializable serializable3;
            Serializable serializable4;
            Insets insets = container.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = 0;
            Component component = this._getComponent(1);
            if (component != null) {
                serializable4 = component.getPreferredSize();
                component.setBounds(n, n2, ((Dimension)serializable4).width, ((Dimension)serializable4).height);
                n += ((Dimension)serializable4).width + this._hGap;
                n3 = Math.max(n3, ((Dimension)serializable4).height);
            }
            if ((serializable4 = this._getComponent(2)) != null) {
                serializable3 = ((Component)serializable4).getPreferredSize();
                ((Component)serializable4).setBounds(n, n2, ((Dimension)serializable3).width, ((Dimension)serializable3).height);
                n += ((Dimension)serializable3).width + this._hGap;
                n3 = Math.max(n3, ((Dimension)serializable3).height);
            }
            if ((serializable3 = this._getComponent(4)) != null) {
                serializable2 = ((Component)serializable3).getPreferredSize();
                ((Component)serializable3).setBounds(n, n2, ((Dimension)serializable2).width, ((Dimension)serializable2).height);
                n += ((Dimension)serializable2).width;
                n3 = Math.max(n3, ((Dimension)serializable2).height);
            }
            if (component != null || serializable4 != null || serializable3 != null) {
                n2 += n3 + this._vGap;
            }
            n = insets.left;
            serializable2 = this._getComponent(8);
            if (serializable2 != null) {
                serializable = ((Component)serializable2).getPreferredSize();
                ((Component)serializable2).setBounds(n, n2, ((Dimension)serializable).width, ((Dimension)serializable).height);
                n2 += ((Dimension)serializable).height + this._vGap;
            }
            n = insets.left;
            serializable = this._getComponent(0);
            if (serializable != null) {
                Dimension dimension = ((Component)serializable).getPreferredSize();
                ((Component)serializable).setBounds(n, n2, dimension.width, dimension.height);
            }
        }

        private Component _getComponent(int n) {
            JPanel jPanel = null;
            if (n == 1) {
                jPanel = CustomColorPane.this._rgbComponent;
            } else if (n == 2) {
                jPanel = CustomColorPane.this._hsbComponent;
            } else if (n == 4) {
                jPanel = CustomColorPane.this._cmyComponent;
            } else if (n == 8) {
                jPanel = CustomColorPane.this._rgbHexComponent;
            } else if (n == 0 && CustomColorPane.this._customColorEditorPanel != null && CustomColorPane.this._customColorEditorPanel.getComponentCount() > 0) {
                jPanel = CustomColorPane.this._customColorEditorPanel;
            }
            if (jPanel != null && jPanel.isVisible()) {
                return jPanel;
            }
            return null;
        }
    }

    private class TopLayout
    implements LayoutManager {
        public static final String LEFT = "Left";
        public static final String RIGHT_TOP = "RightTop";
        public static final String RIGHT_BOTTOM = "RightBottom";
        private int _hGap;
        private int _vGap;
        private Component _left;
        private Component _rightBottom;
        private Component _rightTop;

        public TopLayout(int n, int n2) {
            this._hGap = n;
            this._vGap = n2;
        }

        public void addLayoutComponent(String string, Component component) {
            if (LEFT.equals(string)) {
                this._left = component;
            } else if (RIGHT_TOP.equals(string)) {
                this._rightTop = component;
            } else if (RIGHT_BOTTOM.equals(string)) {
                this._rightBottom = component;
            }
        }

        public void removeLayoutComponent(Component component) {
            if (component == this._left) {
                this._left = null;
            } else if (component == this._rightTop) {
                this._rightTop = null;
            } else if (component == this._rightBottom) {
                this._rightBottom = null;
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            Component component = this._getComponent(LEFT);
            Component component2 = this._getComponent(RIGHT_TOP);
            Component component3 = this._getComponent(RIGHT_BOTTOM);
            Dimension dimension2 = component != null ? component.getPreferredSize() : _EMPTY_SIZE;
            Dimension dimension3 = component2 != null ? component2.getPreferredSize() : _EMPTY_SIZE;
            Dimension dimension4 = component3 != null ? component3.getPreferredSize() : _EMPTY_SIZE;
            int n = dimension3.height + this._vGap + dimension4.height;
            if (component instanceof TopLeftPanel) {
                TopLeftPanel topLeftPanel = (TopLeftPanel)component;
                boolean bl = false;
                int n2 = n - dimension2.height;
                if (n2 > 0) {
                    if (topLeftPanel.isNameComponentHorizontal()) {
                        int n3 = topLeftPanel.getNameLabelHeight();
                        int n4 = topLeftPanel.getNameFieldHeight();
                        int n5 = Math.max(n3, n4);
                        int n6 = n3 + topLeftPanel.getVerticalGap() + n4;
                        if (n6 <= n2 + n5) {
                            topLeftPanel.layoutNameComponent(false);
                            bl = true;
                        }
                    }
                } else if (!topLeftPanel.isNameComponentHorizontal()) {
                    topLeftPanel.layoutNameComponent(true);
                    bl = true;
                }
                if (bl) {
                    dimension2 = topLeftPanel.getPreferredSize();
                }
            }
            int n7 = Math.max(dimension3.width, dimension4.width);
            dimension.width = dimension2.width + this._hGap + n7;
            dimension.height = Math.max(dimension2.height, n);
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Insets insets = container.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            Component component = this._getComponent(LEFT);
            Component component2 = this._getComponent(RIGHT_TOP);
            Component component3 = this._getComponent(RIGHT_BOTTOM);
            Dimension dimension2 = component != null ? component.getPreferredSize() : _EMPTY_SIZE;
            Dimension dimension3 = component2 != null ? component2.getPreferredSize() : _EMPTY_SIZE;
            Dimension dimension4 = dimension = component3 != null ? component3.getPreferredSize() : _EMPTY_SIZE;
            if (component != null) {
                component.setBounds(n, n2, dimension2.width, dimension2.height);
                n += dimension2.width + this._hGap;
            }
            if (component2 != null) {
                component2.setBounds(n, n2, dimension3.width, dimension3.height);
                n2 += dimension3.height + this._vGap;
            }
            if (component3 != null) {
                if (component2 instanceof ImageComponent && dimension2.width < Math.max(dimension3.width, dimension.width)) {
                    ImageComponent imageComponent = (ImageComponent)component2;
                    int n3 = imageComponent.__getImageCanvasWidth() - dimension.width;
                    n += n3 > 0 ? n3 / 2 : 0;
                }
                component3.setBounds(n, n2, dimension.width, dimension.height);
            }
        }

        private Component _getComponent(String string) {
            Component component = null;
            if (LEFT.equals(string)) {
                component = this._left;
            } else if (RIGHT_TOP.equals(string)) {
                component = this._rightTop;
            } else if (RIGHT_BOTTOM.equals(string)) {
                component = this._rightBottom;
            }
            if (component != null && component.isVisible()) {
                return component;
            }
            return null;
        }
    }

    private class TopLeftPanel
    extends JPanel {
        private boolean _horizontal;

        public TopLeftPanel() {
            this.setLayout(new BorderLayout(0, 5));
            JPanel jPanel = this._createColorGridPanel();
            this.add((Component)jPanel, "Center");
            CustomColorPane.this._nameComponent.setLayout(new BorderLayout(12, 5));
            CustomColorPane.this._nameComponent.add((Component)CustomColorPane.this._nameLabel, "West");
            this.layoutNameComponent(true);
            this.add((Component)CustomColorPane.this._nameComponent, "South");
        }

        public boolean isNameComponentHorizontal() {
            return this._horizontal;
        }

        public void layoutNameComponent(boolean bl) {
            if (this._horizontal != bl) {
                this._horizontal = bl;
                this.remove(CustomColorPane.this._nameField);
                String string = bl ? "Center" : "South";
                CustomColorPane.this._nameComponent.add((Component)CustomColorPane.this._nameField, string);
            }
        }

        public int getNameLabelHeight() {
            return ((CustomColorPane)CustomColorPane.this)._nameLabel.getPreferredSize().height;
        }

        public int getNameFieldHeight() {
            return ((CustomColorPane)CustomColorPane.this)._nameField.getPreferredSize().height;
        }

        public int getVerticalGap() {
            return 5;
        }

        private JPanel _createColorGridPanel() {
            JPanel jPanel = new JPanel(new BorderLayout(0, 5));
            jPanel.add((Component)CustomColorPane.this._colorGridLabel, "North");
            jPanel.add((Component)CustomColorPane.this._colorGrid, "West");
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            jPanel2.add((Component)CustomColorPane.this._customGridLabel, gridBagConstraints);
            jPanel2.add((Component)CustomColorPane.this._customGrid, gridBagConstraints);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)jPanel, "North");
            jPanel3.add((Component)jPanel2, "West");
            return jPanel3;
        }
    }
}

