/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.text.MessageFormat;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.chooser.color.BaseColorEditor;
import oracle.bali.ewt.chooser.color.ColorPickerUtils;
import oracle.bali.ewt.imageCanvas.ImageCanvas;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;

class ImageComponent
extends BaseColorEditor {
    private static final String _KEY_LABEL = "COLORCHOOSER.COLOR_SELECTOR";
    private static final String _KEY_BRI_DESC = "COLORCHOOSER.BRIGHTNESS_DESCRIPTION";
    private static final String _KEY_COLOR_VALUE = "COLORPALETTE.TOOLTIP";
    private static final int _WIDTH = 175;
    private static final int _HEIGHT = 175;
    private static final int _RIGHT = 174;
    private static final int _BOTTOM = 174;
    private static final int _IMAGE_SIZE = 30625;
    private static final int _BRI_WIDTH = 19;
    private static final int _BRI_IMAGE_SIZE = 3325;
    private static final int _GAUGE_WIDTH = 5;
    private static final int _HALF_ARROW_HEIGHT = 4;
    private static final Dimension _SIZE_GAUGE = new Dimension(5, 183);
    private static final int _MIN_BRI_VALUE = 0;
    private static final int _MAX_BRI_VALUE = 100;
    private static final int _IMAGE_CANVAS = 0;
    private static final int _BRI_CANVAS = 1;
    private static final int _BRI_COMP = 2;
    private static final Border[] _BORDER = new Border[3];
    private static final String _COLOR_CANVAS_NAME = "All_Colors_Canvas";
    private static final String _BRIGHTNESS_SLIDER_NAME = "Brightness_Selector_Slider";
    private float _x = 0.0f;
    private float _y = 0.0f;
    private float _brightness = 174.0f;
    private JLabel _label = new JLabel("");
    private Canvas _imageCanvas = new Canvas();
    private BrightnessComponent _briComponent;

    public ImageComponent() {
        this._label.setLabelFor(this._imageCanvas);
        this._imageCanvas.setName(_COLOR_CANVAS_NAME);
        this._briComponent = new BrightnessComponent();
        this._briComponent.setName(_BRIGHTNESS_SLIDER_NAME);
        JPanel jPanel = new JPanel(new BorderLayout(1, 0));
        jPanel.add((Component)this._imageCanvas, "West");
        jPanel.add((Component)this._briComponent, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        this.setLayout(new BorderLayout(0, 3));
        this.add((Component)this._label, "North");
        this.add((Component)jPanel2, "West");
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._label.setEnabled(bl);
        this._imageCanvas.setEnabled(bl);
        this._briComponent.setEnabled(bl);
    }

    protected void colorChanged(Color color) {
        this._updateLocation(color);
    }

    protected void updateLabels(Locale locale) {
        String string = BaseColorEditor.__getTranslatedString(locale, _KEY_LABEL);
        this._label.setText(StringUtils.stripMnemonic((String)string));
        this._label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
    }

    protected void updateAccessibleNames() {
        String string = this.__getTranslatedString(_KEY_BRI_DESC);
        this._briComponent.getAccessibleContext().setAccessibleName(string);
    }

    int __getImageCanvasWidth() {
        return this._imageCanvas.getPreferredSize().width;
    }

    private static Border _getBorder(int n) {
        Border border = _BORDER[n];
        if (border == null) {
            AbstractBorderPainter abstractBorderPainter = null;
            if (n == 0) {
                abstractBorderPainter = new FocusPainter(new FixedBorderPainter(new ImageCanvasBorder(), 3, 0, 2, 0));
            } else if (n == 1) {
                abstractBorderPainter = new FixedBorderPainter(new BrightnessCanvasBorder(), 3, 0, 2, 0);
            } else if (n == 2) {
                abstractBorderPainter = new FocusPainter(null);
            }
            ImageComponent._BORDER[n] = border = new BorderAdapter(abstractBorderPainter);
        }
        return border;
    }

    private boolean _updateColor(Object object, float f, float f2) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 174.0f) {
            f2 = 174.0f;
        }
        if (object == this._imageCanvas) {
            if (f < 0.0f) {
                f = 0.0f;
            } else if (f > 174.0f) {
                f = 174.0f;
            }
        }
        if (object == this._imageCanvas && f == this._x && f2 == this._y || object == this._briComponent && f2 == this._brightness) {
            return false;
        }
        String string = this._imageCanvas.getCurrentAccessibleName();
        float f3 = this._brightness;
        if (object == this._imageCanvas) {
            this._x = f;
            this._y = f2;
        } else {
            this._brightness = f2;
        }
        Color color = Color.getHSBColor(1.0f - this._x / 174.0f, this._y / 174.0f, 1.0f - this._brightness / 174.0f);
        this.storeColor(color);
        if (object == this._imageCanvas) {
            String string2 = this._imageCanvas.getCurrentAccessibleName();
            this._imageCanvas.fireAccessibleEvent(string, string2);
            this._imageCanvas.repaint();
            this._briComponent.setBrightnessImage();
        } else {
            this._briComponent.fireAccessibleEvent(f3, this._brightness);
            this._briComponent.repaint();
        }
        return true;
    }

    private void _updateLocation(Color color) {
        float f = this._x;
        float f2 = this._y;
        float f3 = this._brightness;
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this._x = 174.0f - fArray[0] * 174.0f;
        this._y = fArray[1] * 174.0f;
        this._brightness = 174.0f - fArray[2] * 174.0f;
        if (f != this._x || f2 != this._y) {
            this._imageCanvas.repaint();
            this._briComponent.setBrightnessImage();
        }
        if (f3 != this._brightness) {
            this._briComponent.repaint();
        }
    }

    private void _handleKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() != 401 || keyEvent.isConsumed() || !this.isEnabled() || keyEvent.getModifiers() != 0) {
            return;
        }
        Component component = keyEvent.getComponent();
        float f = this._x;
        float f2 = component == this._imageCanvas ? this._y : this._brightness;
        switch (keyEvent.getKeyCode()) {
            case 38: {
                f2 -= 1.0f;
                break;
            }
            case 40: {
                f2 += 1.0f;
                break;
            }
            case 37: {
                if (component == this._imageCanvas) {
                    f -= 1.0f;
                    break;
                }
                return;
            }
            case 39: {
                if (component == this._imageCanvas) {
                    f += 1.0f;
                    break;
                }
                return;
            }
            default: {
                return;
            }
        }
        if (this._updateColor(component, f, f2)) {
            keyEvent.consume();
        }
    }

    private void _handleMouseEvents(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        if (n != 501 && n != 506 && n != 502 || !SwingUtilities.isLeftMouseButton(mouseEvent) || !this.isEnabled() || mouseEvent.isConsumed()) {
            return;
        }
        Component component = mouseEvent.getComponent();
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        Insets insets = this._getImageInset();
        n2 -= insets.left;
        n3 -= insets.top;
        if (n == 501 && !component.hasFocus()) {
            component.requestFocus();
        }
        if (this._updateColor(component, n2, n3)) {
            mouseEvent.consume();
        }
    }

    private Insets _getImageInset() {
        return this._imageCanvas.getInsets();
    }

    private class BrightnessComponent
    extends LWComponent
    implements Accessible {
        private ImageCanvas _briCanvas;
        private Gauge _briGauge = new Gauge();

        public BrightnessComponent() {
            this._briCanvas = new ImageCanvas();
            this._briCanvas.setBorder(ImageComponent._getBorder(1));
            this.setBorder(ImageComponent._getBorder(2));
            this.setBrightnessImage();
            this.setLayout(new BorderLayout());
            this.add((Component)this._briCanvas, "West");
            this.add((Component)this._briGauge, "Center");
            this.enableEvents(60L);
        }

        public void setBrightnessImage() {
            int[] nArray = new int[3325];
            int n = 0;
            float f = 1.0f - ImageComponent.this._x / 174.0f;
            float f2 = ImageComponent.this._y / 174.0f;
            float f3 = 1.0f;
            float f4 = 0.0057142857f;
            int n2 = 0;
            while (n2 < 175) {
                int n3 = Color.HSBtoRGB(f, f2, f3);
                int n4 = 0;
                while (n4 < 19) {
                    nArray[n++] = n3;
                    ++n4;
                }
                f3 -= f4;
                ++n2;
            }
            MemoryImageSource memoryImageSource = new MemoryImageSource(19, 175, nArray, 0, 19);
            Image image = this.createImage(memoryImageSource);
            this._briCanvas.setImage(image);
        }

        public void fireAccessibleEvent(float f, float f2) {
            if (this.accessibleContext != null) {
                int n = (int)((1.0f - f / 174.0f) * 100.0f);
                int n2 = (int)((1.0f - f2 / 174.0f) * 100.0f);
                this.accessibleContext.firePropertyChange("AccessibleValue", IntegerUtils.getInteger((int)n), IntegerUtils.getInteger((int)n2));
            }
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this._briGauge.setEnabled(bl);
            this._briCanvas.setEnabled(bl);
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new Access();
            }
            return this.accessibleContext;
        }

        protected void processComponentKeyEvent(KeyEvent keyEvent) {
            super.processComponentKeyEvent(keyEvent);
            ImageComponent.this._handleKeyEvent(keyEvent);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            ImageComponent.this._handleMouseEvents(mouseEvent);
        }

        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            super.processMouseMotionEvent(mouseEvent);
            ImageComponent.this._handleMouseEvents(mouseEvent);
        }

        protected void processFocusEvent(FocusEvent focusEvent) {
            super.processFocusEvent(focusEvent);
            this.repaint();
        }

        private class Access
        extends JComponent.AccessibleJComponent
        implements AccessibleValue {
            private Access() {
                super(BrightnessComponent.this);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.SLIDER;
            }

            public AccessibleValue getAccessibleValue() {
                return this;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
                accessibleStateSet.add(AccessibleState.VERTICAL);
                return accessibleStateSet;
            }

            public Number getCurrentAccessibleValue() {
                int n = (int)((1.0f - ImageComponent.this._brightness / 174.0f) * 100.0f);
                return IntegerUtils.getInteger((int)n);
            }

            public Number getMaximumAccessibleValue() {
                return IntegerUtils.getInteger((int)100);
            }

            public Number getMinimumAccessibleValue() {
                return IntegerUtils.getInteger((int)0);
            }

            public boolean setCurrentAccessibleValue(Number number) {
                ImageComponent.this._updateColor(BrightnessComponent.this, ImageComponent.this._x, number.floatValue());
                return true;
            }
        }

        private class Gauge
        extends JPanel {
            public Gauge() {
                this.setPreferredSize(_SIZE_GAUGE);
            }

            public void paintComponent(Graphics graphics) {
                Color color = graphics.getColor();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics.setColor(Color.black);
                int n = (int)ImageComponent.this._brightness + 4;
                graphics.drawLine(0, n, 0, n);
                graphics.drawLine(1, n - 1, 1, n + 1);
                graphics.drawLine(2, n - 2, 2, n + 2);
                graphics.drawLine(3, n - 3, 3, n + 3);
                graphics.drawLine(4, n - 4, 4, n + 4);
                graphics.setColor(color);
            }
        }
    }

    private class Canvas
    extends ImageCanvas {
        public Canvas() {
            this.setBorder(ImageComponent._getBorder(0));
            this.setImage(this._createImage());
            this.enableEvents(60L);
        }

        public String getCurrentAccessibleName() {
            if (this.accessibleContext != null) {
                return this.accessibleContext.getAccessibleName();
            }
            return null;
        }

        public void fireAccessibleEvent(String string, String string2) {
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleName", string, string2);
            }
        }

        public void paintCanvasInterior(Graphics graphics) {
            super.paintCanvasInterior(graphics);
            Color color = graphics.getColor();
            int n = (int)ImageComponent.this._x;
            int n2 = (int)ImageComponent.this._y;
            graphics.setColor(Color.black);
            graphics.fillRect(n - 1, n2 - 11, 3, 7);
            graphics.fillRect(n - 1, n2 + 5, 3, 7);
            graphics.fillRect(n - 9, n2 - 1, 7, 3);
            graphics.fillRect(n + 3, n2 - 1, 7, 3);
            graphics.setColor(color);
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new Access();
            }
            return this.accessibleContext;
        }

        protected void processComponentKeyEvent(KeyEvent keyEvent) {
            super.processComponentKeyEvent(keyEvent);
            ImageComponent.this._handleKeyEvent(keyEvent);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            ImageComponent.this._handleMouseEvents(mouseEvent);
        }

        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            super.processMouseMotionEvent(mouseEvent);
            ImageComponent.this._handleMouseEvents(mouseEvent);
        }

        protected void processFocusEvent(FocusEvent focusEvent) {
            super.processFocusEvent(focusEvent);
            this.repaint();
        }

        private Image _createImage() {
            int[] nArray = new int[30625];
            int n = 0;
            float f = 0.0057142857f;
            float f2 = 0.0f;
            int n2 = 0;
            while (n2 < 175) {
                float f3 = 1.0f;
                int n3 = 0;
                while (n3 < 175) {
                    nArray[n++] = Color.HSBtoRGB(f3, f2, 1.0f);
                    f3 -= f;
                    ++n3;
                }
                f2 += f;
                ++n2;
            }
            MemoryImageSource memoryImageSource = new MemoryImageSource(175, 175, nArray, 0, 175);
            return this.createImage(memoryImageSource);
        }

        private class Access
        extends ImageCanvas.AccessibleImageCanvas {
            private Access() {
                super(Canvas.this);
            }

            public String getAccessibleName() {
                String string = super.getAccessibleName();
                if (string == null) {
                    string = "";
                }
                String string2 = ImageComponent.this.__getAccessTranslatedString(ImageComponent._KEY_COLOR_VALUE);
                Color color = ImageComponent.this.getColor();
                Object[] objectArray = new Object[]{IntegerUtils.getInteger((int)color.getRed()), IntegerUtils.getInteger((int)color.getGreen()), IntegerUtils.getInteger((int)color.getBlue())};
                String string3 = MessageFormat.format(string2, objectArray);
                return string + " " + string3;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PANEL;
            }
        }
    }

    private static class FocusPainter
    extends AbstractBorderPainter {
        private static final ImmInsets _INSET = new ImmInsets(2, 0, 2, 0);

        public FocusPainter(Painter painter) {
            super(painter);
        }

        protected ImmInsets getOwnInsets(PaintContext paintContext) {
            return _INSET;
        }

        protected Painter getContentPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
            Painter painter2 = super.getContentPainterAt(paintContext, n, n2, n3, n4, painter);
            if (painter == this && painter2 != null || painter2 == null && n3 >= 0 && n4 >= 0 && n3 < n && n4 < n2) {
                painter2 = this;
            }
            return painter2;
        }

        protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            if ((paintContext.getPaintState() & 0x40) != 0) {
                Color color = graphics.getColor();
                graphics.setColor(Color.black);
                ColorPickerUtils.paintFocus(graphics, n, n2, n3, n4);
                graphics.setColor(color);
            }
        }

        protected boolean isBorderTransparent(PaintContext paintContext) {
            return true;
        }

        protected ImmInsets getOwnFillInsets(PaintContext paintContext) {
            return ImmInsets.getEmptyInsets();
        }
    }

    private static class BrightnessCanvasBorder
    extends AbstractBorderPainter {
        private static final ImmInsets _INSET = new ImmInsets(1, 2, 2, 1);

        private BrightnessCanvasBorder() {
        }

        protected ImmInsets getOwnInsets(PaintContext paintContext) {
            return _INSET;
        }

        protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            int n5 = paintContext.getPaintState();
            boolean bl = (n5 & 4) != 0;
            UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
            Color color2 = uIDefaults.getColor(LookAndFeel.CONTROL_SHADOW);
            Color color3 = uIDefaults.getColor(LookAndFeel.CONTROL);
            int n6 = n2 + n4 - 1;
            int n7 = n + n3 - 1;
            graphics.setColor(bl ? color2 : color3);
            graphics.drawLine(n, n2 + 1, n, n6 - 1);
            graphics.setColor(bl ? color3 : color2);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n6 - 1);
            graphics.setColor(bl ? color3 : Color.white);
            graphics.drawLine(n + 2, n6 - 1, n7 - 1, n6 - 1);
            graphics.setColor(bl ? color2 : color3);
            graphics.drawLine(n + 1, n6, n7, n6);
            if (bl) {
                graphics.setColor(color2);
                graphics.drawLine(n, n2, n, n2);
                graphics.drawLine(n, n6, n, n6);
            }
            graphics.setColor(bl ? color2 : Color.white);
            graphics.drawLine(n7, n2, n7, n6 - 1);
            graphics.setColor(color2);
            graphics.drawLine(n + 1, n2, n7 - 1, n2);
            graphics.setColor(color);
        }

        protected boolean isBorderTransparent(PaintContext paintContext) {
            return false;
        }

        protected ImmInsets getOwnFillInsets(PaintContext paintContext) {
            return ImmInsets.getEmptyInsets();
        }
    }

    private static class ImageCanvasBorder
    extends AbstractBorderPainter {
        private static final ImmInsets _INSET = new ImmInsets(1, 2, 2, 2);

        private ImageCanvasBorder() {
        }

        protected ImmInsets getOwnInsets(PaintContext paintContext) {
            return _INSET;
        }

        protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            int n5 = paintContext.getPaintState();
            boolean bl = (n5 & 4) != 0;
            UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
            Color color2 = uIDefaults.getColor(LookAndFeel.CONTROL_SHADOW);
            Color color3 = uIDefaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
            Color color4 = uIDefaults.getColor(LookAndFeel.CONTROL);
            int n6 = n2 + n4 - 1;
            int n7 = n + n3 - 1;
            graphics.setColor(color2);
            graphics.drawLine(n, n2, n, n6);
            graphics.setColor(bl ? color4 : color3);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n6 - 1);
            graphics.setColor(color4);
            graphics.drawLine(n + 2, n6 - 1, n7 - 1, n6 - 1);
            graphics.setColor(bl ? color2 : Color.white);
            graphics.drawLine(n + 1, n6, n7, n6);
            graphics.setColor(color4);
            graphics.drawLine(n7 - 1, n2 + 1, n7 - 1, n6 - 2);
            graphics.setColor(bl ? color2 : Color.white);
            graphics.drawLine(n7, n2 + 1, n7, n6 - 1);
            graphics.setColor(bl ? color2 : color3);
            graphics.drawLine(n + 1, n2, n7 - 2, n2);
            graphics.setColor(color2);
            if (bl) {
                graphics.drawLine(n7 - 1, n2, n7, n2);
            } else {
                graphics.drawLine(n7 - 1, n2, n7 - 1, n2);
            }
            graphics.setColor(color);
        }

        protected boolean isBorderTransparent(PaintContext paintContext) {
            return false;
        }

        protected ImmInsets getOwnFillInsets(PaintContext paintContext) {
            return ImmInsets.getEmptyInsets();
        }
    }
}

