/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDecoration;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.elaf.EWTTreeUI;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;

public class DTreeButtonDecoration
implements DTreeDecoration {
    private Icon _expandedIcon;
    private Icon _collapsedIcon;

    public ImmInsets getDecorationInsets(DTree dTree) {
        return new ImmInsets(0, dTree.getIndentWidth(), 0, 0);
    }

    public Icon getCollapsedIcon() {
        return this._collapsedIcon;
    }

    public Icon getExpandedIcon() {
        return this._expandedIcon;
    }

    public void processMouseEvent(MouseEvent mouseEvent, DTreeItem dTreeItem) {
        if (mouseEvent.getID() == 501 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            DTree dTree = dTreeItem.getTree();
            int n = dTreeItem.getX();
            int n2 = dTree.getIndentWidth();
            int n3 = mouseEvent.getX();
            if (dTreeItem.isExpandable() && n3 > n - n2 && n3 < n) {
                dTreeItem.setExpanded(!dTreeItem.isExpanded());
                mouseEvent.consume();
                return;
            }
        }
    }

    public void paintDecoration(PaintContext paintContext, Graphics graphics, DTreeItem dTreeItem, int n, int n2) {
        if (this.getHasButton(dTreeItem)) {
            Icon icon;
            DTree dTree = dTreeItem.getTree();
            Icon icon2 = icon = dTreeItem.isExpanded() ? this.getExpandedIcon() : this.getCollapsedIcon();
            if (icon == null) {
                EWTTreeUI eWTTreeUI = dTree.getUI();
                icon = eWTTreeUI.getExpansionButtonIcon(dTree, dTreeItem);
            }
            if (icon == null) {
                return;
            }
            int n3 = icon.getIconHeight();
            int n4 = icon.getIconWidth();
            int n5 = dTree.getIndentWidth();
            int n6 = n - n5 + (n5 - n4) / 2;
            int n7 = (n2 - n3) / 2;
            if ((n5 - n4) % 2 == 1) {
                ++n6;
            }
            icon.paintIcon(dTree, graphics, n6, n7);
        }
    }

    public void setCollapsedIcon(Icon icon) {
        this._collapsedIcon = icon;
    }

    public void setExpandedIcon(Icon icon) {
        this._expandedIcon = icon;
    }

    protected boolean getHasButton(DTreeItem dTreeItem) {
        return dTreeItem.isExpandable();
    }
}

