/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager2;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;

public class DialogHeader
extends JPanel {
    private static final int _UI_IMAGE_HEIGHT = 40;
    private static final int _UI_IMAGE_WIDTH = 40;
    private static final Border _BORDER = new HeaderBorder();
    private String _headerTitle;
    private JLabel _headerImageLabel;
    private MultiLineLabel _headerDescription;

    public DialogHeader() {
        this._init();
    }

    public DialogHeader(String string, Image image) {
        this._init();
        this.setHeaderDescription(string);
        this.setHeaderImage(image);
    }

    public void setHeaderImage(Image image) {
        if (this._headerImageLabel == null) {
            if (image == null) {
                return;
            }
            this._headerImageLabel = new JLabel();
        }
        ImageIcon imageIcon = null;
        if (image != null) {
            ImageUtils.loadImage(image);
            imageIcon = new ImageIcon(image);
        }
        this._headerImageLabel.setIcon(imageIcon);
        this._checkHeader();
    }

    public Image getHeaderImage() {
        if (this._headerImageLabel == null) {
            return null;
        }
        Icon icon = this._headerImageLabel.getIcon();
        return icon == null ? null : ((ImageIcon)icon).getImage();
    }

    public void setHeaderTitle(String string) {
        this._headerTitle = string;
    }

    public String getHeaderTitle() {
        return this._headerTitle;
    }

    public void setHeaderDescription(String string) {
        if (this._headerDescription == null) {
            if (string == null || "".equals(string)) {
                return;
            }
            this._headerDescription = new MultiLineLabel(WordWrapper.getTextWrapper(), string);
            this._headerDescription.setPreferredAspectRatio(9.7f);
            this._headerDescription.setVerticalShrinking(true);
        } else {
            this._headerDescription.setText(string);
        }
        this._checkHeader();
    }

    public String getHeaderDescription() {
        return this._headerDescription == null ? null : this._headerDescription.getText();
    }

    public void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            Color color = this.getBackground();
            if (color == null) {
                color = UIManager.getColor("Panel.background");
            }
            if (graphics instanceof Graphics2D) {
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Color.white, n, 0.0f, color);
                ((Graphics2D)graphics).setPaint(gradientPaint);
            }
            graphics.fillRect(0, 0, n, n2);
        }
    }

    private void _init() {
        this.setBorder(_BORDER);
        this.setLayout(new HeaderLayout());
    }

    private void _checkHeader() {
        if (this._headerImageLabel != null) {
            if (this._headerImageLabel.getIcon() == null) {
                this.remove(this._headerImageLabel);
            } else {
                this.add(this._headerImageLabel);
            }
        }
        if (this._headerDescription != null) {
            if (this._headerDescription.getText() == null || "".equals(this._headerDescription.getText())) {
                this.remove(this._headerDescription);
            } else {
                this.add(this._headerDescription);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private static class HeaderBorder
    implements Border {
        private static final Insets _INSETS = new Insets(10, 10, 12, 10);

        private HeaderBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            int n5 = n2 + n4 - 1;
            int n6 = n + n3 - 1;
            Color color = graphics.getColor();
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawLine(n, n5 - 1, n6 - 1, n5 - 1);
            graphics.setColor(Color.white);
            graphics.drawLine(n, n5, n6, n5);
            graphics.drawLine(n6, n5 - 1, n6, n5 - 1);
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component) {
            return _INSETS;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class HeaderLayout
    implements LayoutManager2 {
        private static final int _HGAP = 15;

        private HeaderLayout() {
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Cloneable cloneable;
            Dimension dimension = new Dimension();
            if (DialogHeader.this._headerImageLabel != null) {
                cloneable = DialogHeader.this._headerImageLabel.getPreferredSize();
                dimension.width += cloneable.width;
                dimension.height = cloneable.height;
            }
            if (DialogHeader.this._headerDescription != null) {
                cloneable = DialogHeader.this._headerDescription.getPreferredSize();
                if (DialogHeader.this._headerImageLabel != null) {
                    dimension.width += 15;
                }
                dimension.width += cloneable.width;
                dimension.height = Math.max(cloneable.height, dimension.height);
            }
            cloneable = container.getInsets();
            dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
            dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            int n = container.getHeight() - (insets.top + insets.bottom);
            int n2 = container.getWidth() - insets.right;
            if (DialogHeader.this._headerImageLabel != null) {
                Dimension dimension = DialogHeader.this._headerImageLabel.getPreferredSize();
                DialogHeader.this._headerImageLabel.setBounds(n2 -= dimension.width, insets.top, dimension.width, Math.min(n, dimension.height));
                n2 -= 15;
            }
            if (DialogHeader.this._headerDescription != null) {
                DialogHeader.this._headerDescription.setBounds(insets.left, insets.top, n2 -= insets.left, n);
            }
        }

        public Dimension maximumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }
    }
}

