/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.drawer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.drawer.DrawerPopup;
import oracle.bali.ewt.elaf.EWTDrawerUI;
import oracle.bali.ewt.elaf.EWTLookAndFeel;

public class Drawer
extends JButton
implements SwingConstants {
    private Closer _closer;
    private Component _content;
    private DrawerPopup _popup;
    private JLayeredPane _owner;
    private int _orientation;
    private static boolean _sInstalled = false;

    public Drawer() {
        this((Component)null, (Icon)null);
    }

    public Drawer(Component component) {
        this(component, null);
    }

    public Drawer(Icon icon) {
        this((Component)null, icon);
    }

    public Drawer(Component component, Icon icon) {
        super(icon);
        if (!_sInstalled) {
            _sInstalled = true;
            try {
                EWTLookAndFeel.installEWTLookAndFeel();
            }
            catch (Exception exception) {
                System.err.println("Could not install EWT look-and-feel:");
                exception.printStackTrace();
            }
        }
        this.setRequestFocusEnabled(false);
        this.setModel(new Model());
        this._content = component;
        this._orientation = 4;
        this._popup = new DrawerPopup(this);
        this._popup.setContent(component);
        this.updateUI();
    }

    public Component getContent() {
        return this._content;
    }

    public void setContent(Component component) {
        if (this.isOpen()) {
            throw new IllegalStateException("Drawer is open");
        }
        Component component2 = this._content;
        if (component2 != component) {
            this._popup.setContent(component);
        }
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void setOrientation(int n) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException();
        }
        int n2 = this._orientation;
        if (n2 != n) {
            this._orientation = n;
            this.revalidate();
            Border border = this.getBorder();
            if (border == null || border instanceof UIResource) {
                this.setBorder(this.getEWTDrawerUI().getBorder(this));
            }
            this.firePropertyChange("orientation", n2, n);
        }
    }

    public boolean isOpen() {
        return this._owner != null;
    }

    public final void setOpen(boolean bl) {
        if (bl) {
            this.openPopup();
        } else {
            this.closePopup();
        }
    }

    public void openPopup() {
        if (this._owner != null) {
            return;
        }
        DrawerPopup drawerPopup = this._popup;
        if (drawerPopup == null) {
            return;
        }
        this._addOrRemoveListeners(true);
        Dimension dimension = this._getPopupSize();
        int n = this.getOrientation();
        boolean bl = false;
        int n2 = this.getEWTDrawerUI().getPopUpOverlap(this);
        int n3 = this.getEWTDrawerUI().getPerpendicularInsets(this);
        int n4 = this.getX();
        int n5 = this.getY();
        JLayeredPane jLayeredPane = null;
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof JRootPane) {
                if (!(container.getParent() instanceof JInternalFrame)) {
                    jLayeredPane = ((JRootPane)container).getLayeredPane();
                    break;
                }
            } else {
                Point point = container.getLocation();
                n4 += point.x;
                n5 += point.y;
            }
            container = container.getParent();
        }
        if (jLayeredPane == null) {
            throw new IllegalStateException("No root pane");
        }
        int n6 = 0;
        int n7 = 0;
        if (this._isHorizontal()) {
            n5 += n3;
            n7 = this.getHeight() - 2 * n3;
            if (n == 4) {
                int n8 = this.getWidth();
                n6 = Math.min(dimension.width, jLayeredPane.getWidth() - (n8 + n4));
                n4 = n4 + n8 - n2;
            } else {
                n6 = Math.min(dimension.width, n4);
                n4 = n4 - n6 + n2;
            }
        } else {
            n4 += n3;
            n6 = this.getWidth() - 2 * n3;
            if (n == 1) {
                n7 = Math.min(dimension.height, n5);
                n5 = n5 - n7 + n2;
            } else {
                int n9 = this.getHeight();
                n7 = Math.min(dimension.height, jLayeredPane.getHeight() - (n9 + n5));
                n5 = n5 + n9 - n2;
            }
        }
        drawerPopup.setVisible(false);
        drawerPopup.setBounds(n4, n5, n6, n7);
        jLayeredPane.add(drawerPopup, JLayeredPane.POPUP_LAYER, 0);
        drawerPopup.setVisible(true);
        this._owner = jLayeredPane;
        drawerPopup.open();
    }

    public void closePopup() {
        DrawerPopup drawerPopup = this._popup;
        if (drawerPopup != null) {
            drawerPopup.close();
            this.popupClosed();
        }
    }

    public void closePopupLater() {
        DrawerPopup drawerPopup = this._popup;
        if (drawerPopup != null) {
            drawerPopup.closeLater();
        }
    }

    public void updateUI() {
        if (this._orientation == 0) {
            return;
        }
        this.setUI(UIManager.getUI(this));
        DrawerPopup drawerPopup = this._popup;
        if (!this.isOpen() && drawerPopup != null) {
            drawerPopup.updateComponentTreeUI();
        }
    }

    public String getUIClassID() {
        return "EWTDrawerUI";
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public Insets getInsets() {
        return this.getBorder().getBorderInsets(this);
    }

    public Insets getInsets(Insets insets) {
        return this.getInsets();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this._getPopupSize();
        int n = this.getEWTDrawerUI().getPerpendicularInsets(this) * 2;
        if (this._isHorizontal()) {
            if (dimension.height < dimension2.height + n) {
                dimension.height = dimension2.height + n;
            }
        } else if (dimension.width < dimension2.width + n) {
            dimension.width = dimension2.width + n;
        }
        return dimension;
    }

    public void setBorder(Border border) {
        if (border == null && this.getParent() instanceof JToolBar) {
            border = this.getEWTDrawerUI().getBorder(this);
        }
        super.setBorder(border);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        this.setOpen(!this.isOpen());
    }

    public void removeNotify() {
        super.removeNotify();
        this.closePopup();
    }

    protected final EWTDrawerUI getEWTDrawerUI() {
        return (EWTDrawerUI)((Object)this.getUI());
    }

    final void popupClosed() {
        this._addOrRemoveListeners(false);
        JLayeredPane jLayeredPane = this._owner;
        if (jLayeredPane != null) {
            DrawerPopup drawerPopup = this._popup;
            if (drawerPopup == null) {
                return;
            }
            this._owner = null;
            jLayeredPane.remove(drawerPopup);
            jLayeredPane.repaint(drawerPopup.getX(), drawerPopup.getY(), drawerPopup.getWidth(), drawerPopup.getHeight());
        }
    }

    private void _addOrRemoveListeners(boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Closer closer = this._getCloser();
            Container container = this;
            while (container != null) {
                if (bl) {
                    container.addComponentListener(closer);
                } else {
                    container.removeComponentListener(closer);
                }
                if (container instanceof Window) {
                    if (bl) {
                        ((Window)container).addWindowListener(closer);
                        break;
                    }
                    ((Window)container).removeWindowListener(closer);
                    break;
                }
                container = container.getParent();
            }
        }
    }

    private boolean _isHorizontal() {
        int n = this.getOrientation();
        return n == 2 || n == 4;
    }

    private Dimension _getPopupSize() {
        DrawerPopup drawerPopup = this._popup;
        drawerPopup.setFont(this.getFont());
        drawerPopup.setLocale(this.getLocale());
        return drawerPopup.getPreferredSize();
    }

    private Closer _getCloser() {
        if (this._closer == null) {
            this._closer = new Closer();
        }
        return this._closer;
    }

    private class Closer
    extends WindowAdapter
    implements ComponentListener {
        private Closer() {
        }

        public void windowIconified(WindowEvent windowEvent) {
            Drawer.this.closePopup();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            Drawer.this.closePopup();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            Drawer.this.closePopup();
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            Drawer.this.closePopup();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            Drawer.this.closePopup();
        }
    }

    private class Model
    extends DefaultButtonModel {
        private Model() {
        }

        public boolean isRollover() {
            return super.isRollover() || Drawer.this.isOpen();
        }
    }
}

