/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import oracle.bali.ewt.button.ContinuousButtonModel;
import oracle.bali.ewt.elaf.EWTSpinButtonUI;
import oracle.bali.ewt.spinBox.SpinAccelerator;
import oracle.bali.ewt.spinBox.SpinButton;

public abstract class BasicEWTSpinButtonUI
extends EWTSpinButtonUI {
    AbstractButton _increment;
    AbstractButton _decrement;
    SpinButton _spinner;
    private Internal _internal;
    private static final String _INCREMENT_NAME = "Increment_Button";
    private static final String _DECREMENT_NAME = "Decrement_Button";

    public void installUI(JComponent jComponent) {
        this._spinner = (SpinButton)jComponent;
        this._increment = this.createIncrementButton(jComponent);
        this._decrement = this.createDecrementButton(jComponent);
        this._increment.setName(_INCREMENT_NAME);
        this._decrement.setName(_DECREMENT_NAME);
        this._increment.setModel(new Model(this._increment));
        this._decrement.setModel(new Model(this._decrement));
        this._updateEnabled();
        jComponent.add(this._increment);
        jComponent.add(this._decrement);
        this._internal = new Internal();
        this._spinner.addPropertyChangeListener(this._internal);
        this._spinner.setLayout(this._internal);
    }

    public void uninstallUI(JComponent jComponent) {
        this._spinner.removePropertyChangeListener(this._internal);
        this._spinner.setLayout(null);
        jComponent.remove(this._increment);
        jComponent.remove(this._decrement);
        ContinuousButtonModel continuousButtonModel = (ContinuousButtonModel)this._increment.getModel();
        continuousButtonModel.stopTimer();
        continuousButtonModel = (ContinuousButtonModel)this._decrement.getModel();
        continuousButtonModel.stopTimer();
        this._spinner = null;
        this._increment = null;
        this._decrement = null;
    }

    protected BasicEWTSpinButtonUI() {
    }

    public AbstractButton getIncrementButton(JComponent jComponent) {
        return this._increment;
    }

    public AbstractButton getDecrementButton(JComponent jComponent) {
        return this._decrement;
    }

    protected abstract AbstractButton createIncrementButton(JComponent var1);

    protected abstract AbstractButton createDecrementButton(JComponent var1);

    void _updateEnabled() {
        boolean bl;
        SpinButton spinButton = this._spinner;
        boolean bl2 = bl = spinButton.isEnabled() && spinButton.isIncrementEnabled();
        if (!bl) {
            this._increment.getModel().setPressed(false);
            this._increment.getModel().setArmed(false);
        }
        this._increment.setEnabled(bl);
        boolean bl3 = bl = spinButton.isEnabled() && spinButton.isDecrementEnabled();
        if (!bl) {
            this._decrement.getModel().setPressed(false);
            this._decrement.getModel().setArmed(false);
        }
        this._decrement.setEnabled(bl);
    }

    private class Model
    extends ContinuousButtonModel {
        public Model(AbstractButton abstractButton) {
            super(abstractButton);
        }

        public SpinAccelerator getAccelerator() {
            return BasicEWTSpinButtonUI.this._spinner.getAccelerator();
        }

        protected void processPulse() {
            int n = this.getButton() == BasicEWTSpinButtonUI.this._increment ? 1 : 2;
            BasicEWTSpinButtonUI.this._spinner.fireSpinButtonEvent(n);
        }
    }

    private class Internal
    implements LayoutManager,
    PropertyChangeListener {
        private Internal() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = BasicEWTSpinButtonUI.this._increment.getPreferredSize();
            Dimension dimension2 = BasicEWTSpinButtonUI.this._decrement.getPreferredSize();
            return new Dimension(Math.max(dimension.width, dimension2.width), dimension.height + dimension2.height);
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            BasicEWTSpinButtonUI.this._increment.setBounds(0, 0, n, n2 /= 2);
            BasicEWTSpinButtonUI.this._decrement.setBounds(0, n2, n, n2);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || "enabled".equals(string) || "incrementEnabled".equals(string) || "decrementEnabled".equals(string)) {
                BasicEWTSpinButtonUI.this._updateEnabled();
            } else if ("incrementArmed".equals(string)) {
                if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    ((ContinuousButtonModel)BasicEWTSpinButtonUI.this._decrement.getModel()).setArmedState(false);
                    ((ContinuousButtonModel)BasicEWTSpinButtonUI.this._increment.getModel()).setArmedState(true);
                } else {
                    ((ContinuousButtonModel)BasicEWTSpinButtonUI.this._increment.getModel()).setArmedState(false);
                }
            } else if ("decrementArmed".equals(string)) {
                if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    ((ContinuousButtonModel)BasicEWTSpinButtonUI.this._increment.getModel()).setArmedState(false);
                    ((ContinuousButtonModel)BasicEWTSpinButtonUI.this._decrement.getModel()).setArmedState(true);
                } else {
                    ((ContinuousButtonModel)BasicEWTSpinButtonUI.this._decrement.getModel()).setArmedState(false);
                }
            }
        }
    }
}

