/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Image;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.elaf.EWTPivotHeaderUI;
import oracle.bali.ewt.elaf.basic.BasicTableGeometryHelper;
import oracle.bali.ewt.elaf.basic.PivotHeaderGrippyPainter;
import oracle.bali.ewt.elaf.basic.PivotHeaderGrippyPainterWithBorder;
import oracle.bali.ewt.elaf.oracle.OracleEWTTableUI;
import oracle.bali.ewt.elaf.oracle.OraclePivotCellBorderPainter;
import oracle.bali.ewt.elaf.oracle.OracleUIUtils;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;

public class OracleEWTPivotHeaderUI
extends EWTPivotHeaderUI {
    private static OracleEWTPivotHeaderUI _sInstance;
    private static OracleEWTTableUI _sTableUI;

    private OracleEWTPivotHeaderUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (_sInstance == null) {
            _sInstance = new OracleEWTPivotHeaderUI();
            _sTableUI = (OracleEWTTableUI)OracleEWTTableUI.createUI(jComponent);
        }
        return _sInstance;
    }

    public void installUI(JComponent jComponent) {
        boolean bl;
        _sTableUI.installUI(jComponent);
        jComponent.setOpaque(true);
        SpreadTable spreadTable = (SpreadTable)jComponent;
        spreadTable.getGrid().setBackground(UIManager.getColor(LookAndFeel.CONTROL));
        spreadTable.setBorder(null);
        Grid grid = spreadTable.getGrid();
        grid.setBorder(null);
        grid.setUpperLeft(false);
        grid.setLowerRight(false);
        boolean bl2 = bl = ((PivotHeader)jComponent).getOrientation() == 0;
        if (bl) {
            grid.setLowerLeft(false);
        } else {
            grid.setUpperRight(false);
        }
        grid.setOverlayBorderVisible(false);
        Header header = spreadTable.getRowHeader();
        if (header != null) {
            header.setLastEdge(false);
            header.setBorder(null);
            header.setDefaultPainter(this.getDefaultHeaderItemPainter(jComponent, !bl));
        }
        if ((header = spreadTable.getColumnHeader()) != null) {
            header.setLastEdge(false);
            header.setBorder(null);
            header.setDefaultPainter(this.getDefaultHeaderItemPainter(jComponent, !bl));
        }
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if ("PivotHeader.DefaultAppearance".equals(object)) {
            return OracleEWTPivotHeaderUI._getDefaultAppearance();
        }
        return null;
    }

    public Painter getDefaultHeaderItemPainter(JComponent jComponent, boolean bl) {
        return PivotHeaderGrippyPainter.getPainter(bl, false);
    }

    public Painter getDefaultHeaderItemPainterWithBorder(JComponent jComponent) {
        return PivotHeaderGrippyPainterWithBorder.getPainter(false);
    }

    public Painter getCornerPainter(JComponent jComponent, int n) {
        return _sTableUI.getCornerPainter(jComponent, n);
    }

    public Image getDrillImage(JComponent jComponent) {
        return OracleUIUtils.getImage("drillTriangle.gif");
    }

    public Image getDrilledImage(JComponent jComponent) {
        return OracleUIUtils.getImage("drilledTriangle.gif");
    }

    public Color getSwapForegroundColor(JComponent jComponent, Appearance appearance) {
        return UIManager.getColor("darkIntensity");
    }

    public Color getSwapBackgroundColor(JComponent jComponent, Appearance appearance) {
        Color color = appearance.getBackground();
        if (color == null) {
            color = jComponent.getBackground();
        }
        return ColorUtils.darkerShadeColor(color);
    }

    public void updateGeometry(JComponent jComponent) {
        BasicTableGeometryHelper.updateGeometry((SpreadTable)jComponent);
    }

    private static Appearance _getDefaultAppearance() {
        Appearance appearance = (Appearance)UIManager.get("Grid.DefaultAppearance");
        appearance = appearance.copy();
        appearance.setInsets(ImmInsets.getEmptyInsets());
        appearance.setForeground(UIManager.getColor(LookAndFeel.CONTROL_TEXT));
        appearance.setBackground(UIManager.getColor(LookAndFeel.CONTROL));
        appearance.setBorderPainter(OraclePivotCellBorderPainter.getBorderPainter());
        return appearance;
    }
}

