/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;

public class GraphicUtils {
    private static final String SWING_AATEXT_PROPERTY = "swing.aatext";
    private static final boolean useAAText;
    private static final boolean isAtLeastJava16;
    private static Map _sDesktopHints;
    private static PropertyChangeListener _sDesktopHintsListener;
    private static final String AWT_FONT_DESKTOPHINTS = "awt.font.desktophints";

    public static void drawLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        if (n != n3 && n2 != n4) {
            return;
        }
        if (n5 == 0 || n5 == 1) {
            graphics.drawLine(n, n2, n3, n4);
            return;
        }
        if (n == n3) {
            n9 = n - n5 / 2;
            n8 = n5;
            if (n2 < n4) {
                n7 = n2;
                n6 = n4 - n2 + 1;
            } else {
                n7 = n4;
                n6 = n2 - n4 + 1;
            }
        } else {
            n7 = n2 - n5 / 2;
            n6 = n5;
            if (n < n3) {
                n9 = n;
                n8 = n3 - n + 1;
            } else {
                n9 = n3;
                n8 = n - n3 + 1;
            }
        }
        graphics.fillRect(n9, n7, n8, n6);
    }

    public static void drawRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n5 == 0 || n5 == 1) {
            graphics.drawRect(n, n2, n3, n4);
            return;
        }
        int n7 = n5 / 2;
        int n8 = n - n7;
        int n9 = n8 + n3 + n5 - 1;
        int n10 = n6 = n2;
        GraphicUtils.drawLine(graphics, n8, n10, n9, n6, n5);
        n10 = n6 = n2 + n4;
        GraphicUtils.drawLine(graphics, n8, n10, n9, n6, n5);
        n10 = n2 + n7;
        n6 = n2 + n4 - n7 - 1;
        n8 = n9 = n;
        GraphicUtils.drawLine(graphics, n8, n10, n9, n6, n5);
        n8 = n9 = n + n3;
        GraphicUtils.drawLine(graphics, n8, n10, n9, n6, n5);
    }

    public static void drawDottedLine(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n == n3) {
            if (n2 > n4) {
                int n5 = n4;
                n4 = n2;
                n2 = n5;
            }
            if ((n & 1 ^ n2 & 1) != 0) {
                ++n2;
            }
            while (n2 <= n4) {
                graphics.drawLine(n, n2, n, n2);
                n2 += 2;
            }
        } else {
            if (n2 != n4) {
                throw new IllegalArgumentException("Only horizontal and vertical lines");
            }
            if (n > n3) {
                int n6 = n3;
                n3 = n;
                n = n6;
            }
            if ((n & 1 ^ n2 & 1) != 0) {
                ++n;
            }
            while (n <= n3) {
                graphics.drawLine(n, n2, n, n2);
                n += 2;
            }
        }
    }

    public static boolean useTextAntialiasing() {
        return useAAText;
    }

    private static boolean drawTextAntialiased(Graphics graphics) {
        return GraphicUtils.useTextAntialiasing() && graphics != null && graphics instanceof Graphics2D;
    }

    public static void drawChars(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4) {
        if (n2 <= 0) {
            return;
        }
        if (GraphicUtils.drawTextAntialiased(graphics)) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.drawChars(cArray, n, n2, n3, n4);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            return;
        }
        if (!isAtLeastJava16) {
            graphics.drawChars(cArray, n, n2, n3, n4);
            return;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(((Graphics2D)graphics).getRenderingHints());
        try {
            GraphicUtils.addDesktopRenderingHints(graphics);
            graphics.drawChars(cArray, n, n2, n3, n4);
            Object var9_9 = null;
            ((Graphics2D)graphics).setRenderingHints(hashMap);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            ((Graphics2D)graphics).setRenderingHints(hashMap);
            throw throwable;
        }
    }

    public static void drawString(Graphics graphics, AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        if (attributedCharacterIterator == null) {
            return;
        }
        if (GraphicUtils.drawTextAntialiased(graphics)) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
            TextLayout textLayout = new TextLayout(attributedCharacterIterator, fontRenderContext);
            textLayout.draw(graphics2D, n, n2);
            return;
        }
        if (!isAtLeastJava16) {
            graphics.drawString(attributedCharacterIterator, n, n2);
            return;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(((Graphics2D)graphics).getRenderingHints());
        try {
            GraphicUtils.addDesktopRenderingHints(graphics);
            graphics.drawString(attributedCharacterIterator, n, n2);
            Object var8_8 = null;
            ((Graphics2D)graphics).setRenderingHints(hashMap);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ((Graphics2D)graphics).setRenderingHints(hashMap);
            throw throwable;
        }
    }

    public static void drawString(Graphics graphics, String string, int n, int n2) {
        if (string == null || string.length() <= 0) {
            return;
        }
        if (GraphicUtils.drawTextAntialiased(graphics)) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.drawString(string, n, n2);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            return;
        }
        if (!isAtLeastJava16) {
            graphics.drawString(string, n, n2);
            return;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(((Graphics2D)graphics).getRenderingHints());
        try {
            GraphicUtils.addDesktopRenderingHints(graphics);
            graphics.drawString(string, n, n2);
            Object var7_7 = null;
            ((Graphics2D)graphics).setRenderingHints(hashMap);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ((Graphics2D)graphics).setRenderingHints(hashMap);
            throw throwable;
        }
    }

    public static void drawString(Graphics2D graphics2D, String string, float f, float f2) {
        if (string == null || string.length() <= 0) {
            return;
        }
        if (GraphicUtils.useTextAntialiasing()) {
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.drawString(string, f, f2);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            return;
        }
        if (!isAtLeastJava16) {
            graphics2D.drawString(string, f, f2);
            return;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(graphics2D.getRenderingHints());
        try {
            GraphicUtils.addDesktopRenderingHints(graphics2D);
            graphics2D.drawString(string, f, f2);
            Object var6_6 = null;
            graphics2D.setRenderingHints(hashMap);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            graphics2D.setRenderingHints(hashMap);
            throw throwable;
        }
    }

    public static void addDesktopRenderingHints(Graphics graphics) {
        if (!isAtLeastJava16) {
            return;
        }
        if (graphics == null) {
            throw new IllegalArgumentException("graphics parameter is null");
        }
        if (_sDesktopHints == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            _sDesktopHints = (Map)toolkit.getDesktopProperty(AWT_FONT_DESKTOPHINTS);
            if (_sDesktopHintsListener == null) {
                _sDesktopHintsListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        _sDesktopHints = null;
                    }
                };
                toolkit.addPropertyChangeListener(AWT_FONT_DESKTOPHINTS, _sDesktopHintsListener);
            }
        }
        if (_sDesktopHints != null) {
            ((Graphics2D)graphics).addRenderingHints(_sDesktopHints);
        }
    }

    public static void withDesktopRenderingHints(Graphics graphics, Runnable runnable) {
        if (graphics == null) {
            throw new IllegalArgumentException("graphics parameter is null");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("task parameter is null");
        }
        if (!isAtLeastJava16) {
            runnable.run();
            return;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(((Graphics2D)graphics).getRenderingHints());
        try {
            GraphicUtils.addDesktopRenderingHints(graphics);
            runnable.run();
            Object var4_3 = null;
            ((Graphics2D)graphics).setRenderingHints(hashMap);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((Graphics2D)graphics).setRenderingHints(hashMap);
            throw throwable;
        }
    }

    private GraphicUtils() {
    }

    static {
        String string = null;
        try {
            string = System.getProperty("java.version", "1.0");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            string = "1.0";
        }
        boolean bl = isAtLeastJava16 = !string.startsWith("1.0") && !string.startsWith("1.1") && !string.startsWith("1.2") && !string.startsWith("1.3") && !string.startsWith("1.5");
        if (string.startsWith("1.5")) {
            String string2 = null;
            try {
                string2 = System.getProperty(SWING_AATEXT_PROPERTY, "false");
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                string2 = "false";
            }
            useAAText = Boolean.valueOf(string2);
        } else {
            useAAText = false;
        }
    }
}

