/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.TwoDSelection;

public abstract class AbstractGridSelectionManager
implements GridSelectionManager {
    private GeometryChangeListener _listener;
    private PropertyChangeSupport _propertyChangeSupport;
    private VetoableChangeSupport _vetoableChangeSupport;

    protected AbstractGridSelectionManager() {
    }

    public TwoDModelListener getTwoDModelListener() {
        if (this._listener == null) {
            this._listener = new GeometryChangeListener();
        }
        return this._listener;
    }

    protected void rowsAdded(int n, int n2) {
    }

    protected void rowsRemoved(int n, int n2) {
    }

    protected void columnsAdded(int n, int n2) {
    }

    protected void columnsRemoved(int n, int n2) {
    }

    public abstract TwoDSelection getSelection();

    public abstract void addSelection(TwoDSelection var1) throws PropertyVetoException;

    public abstract void removeSelection(TwoDSelection var1) throws PropertyVetoException;

    public abstract void setSelection(TwoDSelection var1, Cell var2) throws PropertyVetoException;

    public TwoDSelection getRepaintSelection(TwoDSelection twoDSelection, TwoDSelection twoDSelection2) {
        return twoDSelection.add(twoDSelection2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoableChangeSupport == null) {
            this._vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this._vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoableChangeSupport != null) {
            this._vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this._vetoableChangeSupport != null) {
            this._vetoableChangeSupport.fireVetoableChange(string, object, object2);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    private class GeometryChangeListener
    implements TwoDModelListener {
        private GeometryChangeListener() {
        }

        public void rowsAdded(TwoDModelEvent twoDModelEvent) {
            int n = twoDModelEvent.getRowStartIndex();
            int n2 = twoDModelEvent.getRowCount();
            AbstractGridSelectionManager.this.rowsAdded(n, n2);
        }

        public void rowsRemoved(TwoDModelEvent twoDModelEvent) {
            int n = twoDModelEvent.getRowStartIndex();
            int n2 = twoDModelEvent.getRowCount();
            AbstractGridSelectionManager.this.rowsRemoved(n, n2);
        }

        public void invalidateRows(TwoDModelEvent twoDModelEvent) {
        }

        public void columnsAdded(TwoDModelEvent twoDModelEvent) {
            int n = twoDModelEvent.getColumnStartIndex();
            int n2 = twoDModelEvent.getColumnCount();
            AbstractGridSelectionManager.this.columnsAdded(n, n2);
        }

        public void columnsRemoved(TwoDModelEvent twoDModelEvent) {
            int n = twoDModelEvent.getColumnStartIndex();
            int n2 = twoDModelEvent.getColumnCount();
            AbstractGridSelectionManager.this.columnsRemoved(n, n2);
        }

        public void invalidateColumns(TwoDModelEvent twoDModelEvent) {
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
        }
    }
}

