/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.spinBox.ArraySpinBoxModel;
import oracle.bali.ewt.spinBox.NumericSpinBoxModel;
import oracle.bali.ewt.spinBox.SpinBox;
import oracle.bali.ewt.spinBox.SpinBoxModel;
import oracle.bali.ewt.spinBox.SpinBuddy;

public class SpinBoxInputHandler
extends CellInputHandler {
    private boolean _ignoreStateChange = false;
    private static final String _ASSERT_STRING = "SpinBoxInputHandler.setModelValue() does not recognize the SpinBoxModel.  Clients must override this method to initialize their SpinBoxModel class.";
    private KeyListener _keyListener;
    private SpinBox _spinBox;
    boolean _dirty;

    public SpinBoxInputHandler() {
        this(null);
    }

    public SpinBoxInputHandler(SpinBox spinBox) {
        if (spinBox != null) {
            this._spinBox = spinBox;
            this._initSpinBox(spinBox);
        }
    }

    public void updateUI() {
        if (this._spinBox != null) {
            SwingUtilities.updateComponentTreeUI(this._spinBox);
        }
    }

    public void setModel(SpinBoxModel spinBoxModel) {
        SpinBox spinBox = this.getSpinBox(null, -1, -1);
        spinBox.setModel(spinBoxModel);
    }

    public SpinBoxModel getModel() {
        SpinBox spinBox = this.getSpinBox(null, -1, -1);
        return spinBox.getModel();
    }

    public void setSpinBuddy(SpinBuddy spinBuddy) {
        SpinBox spinBox = this.getSpinBox(null, -1, -1);
        spinBox.setSpinBuddy(spinBuddy);
    }

    public SpinBuddy getSpinBuddy() {
        SpinBox spinBox = this.getSpinBox(null, -1, -1);
        return spinBox.getSpinBuddy();
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        super.mousePressed(mouseEvent, grid, n, n2);
        Cell cell = grid.getFocusCell();
        if (cell != null && cell.column == n && cell.row == n2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            grid.startCellEdit(n, n2);
        }
    }

    public void focusGained(AWTEvent aWTEvent, Grid grid, int n, int n2) {
        if (aWTEvent instanceof MouseEvent) {
            grid.startCellEdit(n, n2);
        }
    }

    public boolean isDirty(Grid grid, int n, int n2) {
        return this._dirty;
    }

    public SpinBox getSpinBox(Grid grid, int n, int n2) {
        return (SpinBox)this.getEditControl(grid, n, n2);
    }

    public synchronized Component getEditControl(Grid grid, int n, int n2) {
        if (this._spinBox == null) {
            this._spinBox = this.createSpinBox();
            this._initSpinBox(this._spinBox);
        }
        return this._spinBox;
    }

    public void startEdit(Grid grid, int n, int n2, Object object) {
        SpinBox spinBox = this.getSpinBox(grid, n, n2);
        this._ignoreStateChange = true;
        SpinBoxModel spinBoxModel = spinBox.getModel();
        this.setModelValue(spinBoxModel, object);
        spinBox.setModel(spinBoxModel);
        this._ignoreStateChange = false;
    }

    public synchronized Object commitEdit(Grid grid, int n, int n2) {
        SpinBox spinBox = this.getSpinBox(grid, n, n2);
        return spinBox.getValue();
    }

    public Component[] getFocusableComponents(Grid grid, int n, int n2) {
        Component[] componentArray = super.getFocusableComponents(grid, n, n2);
        Component[] componentArray2 = new Component[componentArray.length + 1];
        SpinBox spinBox = this.getSpinBox(grid, n, n2);
        int n3 = 0;
        while (n3 < componentArray.length) {
            componentArray2[n3] = componentArray[n3];
            ++n3;
        }
        componentArray2[componentArray.length] = (Component)((Object)spinBox.getSpinBuddy());
        return componentArray2;
    }

    protected SpinBox createSpinBox() {
        return new SpinBox();
    }

    protected void setModelValue(SpinBoxModel spinBoxModel, Object object) {
        if (spinBoxModel instanceof ArraySpinBoxModel) {
            ArraySpinBoxModel arraySpinBoxModel = (ArraySpinBoxModel)spinBoxModel;
            Object[] objectArray = arraySpinBoxModel.getArray();
            boolean bl = false;
            int n = 0;
            while (n < objectArray.length) {
                if (object == objectArray[n] || object != null && objectArray[n] != null && object.equals(objectArray[n])) {
                    arraySpinBoxModel.setIndex(n);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                arraySpinBoxModel.setIndex(0);
                this._dirty = true;
            }
        } else if (spinBoxModel instanceof NumericSpinBoxModel) {
            NumericSpinBoxModel numericSpinBoxModel = (NumericSpinBoxModel)spinBoxModel;
            if (object != null && object instanceof Number) {
                int n = ((Number)object).intValue();
                numericSpinBoxModel.setValue(n);
            } else {
                numericSpinBoxModel.setValue(0);
                this._dirty = true;
            }
        }
    }

    private void _initSpinBox(SpinBox spinBox) {
        if (spinBox.getBorder() instanceof UIResource) {
            spinBox.setBorder(new EmptyBorder(0, 2, 0, 0));
        }
        spinBox.addChangeListener(new Dirty());
    }

    private class Dirty
    implements ChangeListener {
        private Dirty() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!SpinBoxInputHandler.this._ignoreStateChange) {
                SpinBoxInputHandler.this._dirty = true;
            }
        }
    }
}

