/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.util.FocusUtils;

public class TextFieldInputHandler
extends CellInputHandler {
    boolean _dirty;
    private JTextField _textField;
    private String _initText = null;
    private static TextFieldInputHandler _sInputHandler;

    public final JTextField getJTextField() {
        return (JTextField)this.getEditControl(null, -1, -1);
    }

    public void updateUI() {
        if (this._textField != null) {
            SwingUtilities.updateComponentTreeUI(this._textField);
        }
    }

    public void focusGained(AWTEvent aWTEvent, Grid grid, int n, int n2) {
        if (aWTEvent instanceof MouseEvent) {
            grid.startCellEdit(n, n2);
        }
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        super.mousePressed(mouseEvent, grid, n, n2);
        Cell cell = grid.getFocusCell();
        if (cell != null && cell.column == n && cell.row == n2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            grid.startCellEdit(n, n2);
        }
    }

    public void keyPressed(KeyEvent keyEvent, Grid grid, int n, int n2) {
        super.keyPressed(keyEvent, grid, n, n2);
        if (!FocusUtils.areNewFocusAPIsAvailable() && keyEvent.getKeyCode() == 127) {
            JTextField jTextField = this.getJTextField();
            if (jTextField.isEditable()) {
                this._initText = "";
            }
            grid.startCellEdit(n, n2);
            keyEvent.consume();
        }
    }

    public void keyTyped(KeyEvent keyEvent, Grid grid, int n, int n2) {
        super.keyTyped(keyEvent, grid, n, n2);
        JTextField jTextField = this.getJTextField();
        if (jTextField.isEditable()) {
            char c = keyEvent.getKeyChar();
            this._initText = c == '\b' || c == '\u007f' ? "" : String.valueOf(c);
        } else {
            jTextField.selectAll();
        }
        keyEvent.consume();
    }

    public synchronized Component getEditControl(Grid grid, int n, int n2) {
        if (this._textField == null) {
            this._textField = this.createTextField();
            this._initTextField(this._textField);
            this._addKeyListener(this._textField);
        }
        return this._textField;
    }

    public boolean isDirty(Grid grid, int n, int n2) {
        return this._dirty;
    }

    public void startEdit(Grid grid, int n, int n2, Object object) {
        JTextField jTextField = this.getJTextField();
        if (this._initText == null) {
            jTextField.setText((String)object);
            if (object != null) {
                jTextField.selectAll();
            }
            this._dirty = false;
        } else if ("".equals(this._initText)) {
            jTextField.setText(this._initText);
            this._dirty = true;
        } else {
            jTextField.setText(this._initText);
            String string = jTextField.getText();
            if (string == null || "".equals(string)) {
                jTextField.setText((String)object);
                if (object != null) {
                    jTextField.selectAll();
                }
                this._initText = null;
                this._dirty = false;
            }
        }
    }

    public synchronized Object commitEdit(Grid grid, int n, int n2) {
        JTextField jTextField = this.getJTextField();
        String string = jTextField.getText();
        return string;
    }

    public static CellInputHandler getCellInputHandler() {
        if (_sInputHandler == null) {
            _sInputHandler = TextFieldInputHandler.createTextFieldInputHandler();
        }
        return _sInputHandler;
    }

    public static TextFieldInputHandler createTextFieldInputHandler() {
        return new TextFieldInputHandler();
    }

    public static TextFieldInputHandler createTextFieldInputHandler(JTextField jTextField) {
        return new TextFieldInputHandler(jTextField);
    }

    protected TextFieldInputHandler() {
        this(null);
    }

    protected TextFieldInputHandler(JTextField jTextField) {
        if (jTextField != null) {
            this._textField = jTextField;
            this._initTextField(jTextField);
            this._addKeyListener(jTextField);
        }
    }

    protected JTextField createTextField() {
        return new JTextField();
    }

    private void _initTextField(JTextField jTextField) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Dirty dirty = new Dirty();
        jTextField.getKeymap().removeKeyStrokeBinding(keyStroke);
        jTextField.getDocument().addDocumentListener(dirty);
        if (jTextField.getBorder() instanceof UIResource) {
            jTextField.setBorder(new EmptyBorder(0, 2, 0, 0));
        }
        jTextField.addFocusListener(dirty);
    }

    private void _addKeyListener(JTextField jTextField) {
        jTextField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                    keyEvent.consume();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                    keyEvent.consume();
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
    }

    private class Dirty
    extends FocusAdapter
    implements DocumentListener {
        private Dirty() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            TextFieldInputHandler.this._dirty = true;
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            TextFieldInputHandler.this._dirty = true;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
            JTextField jTextField = (JTextField)focusEvent.getSource();
            if (TextFieldInputHandler.this._initText != null && jTextField.getText().length() == 1) {
                jTextField.select(1, 1);
            }
            TextFieldInputHandler.this._initText = null;
        }
    }
}

