/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.event.KeyEvent;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.StandardGridKeyHandler;
import oracle.bali.ewt.selection.Cell;

public class WrappingGridKeyHandler
extends StandardGridKeyHandler {
    private static WrappingGridKeyHandler _sManager;

    protected Cell up(Grid grid, Cell cell, KeyEvent keyEvent) {
        Cell cell2 = super.up(grid, cell, keyEvent);
        if (cell2 == cell) {
            int n = grid.getColumnCount();
            int n2 = grid.getRowCount();
            int n3 = grid.getPreviousVisibleRow(n2);
            int n4 = grid.getPreviousVisibleColumn(cell.column);
            if (n4 == -1) {
                n4 = grid.getPreviousVisibleColumn(n);
            }
            cell2 = new Cell(n4, n3);
        }
        return cell2;
    }

    protected Cell down(Grid grid, Cell cell, KeyEvent keyEvent) {
        Cell cell2 = super.down(grid, cell, keyEvent);
        if (cell2 == cell) {
            int n = grid.getNextVisibleRow(-1);
            int n2 = grid.getNextVisibleColumn(cell.column);
            if (n2 == -1) {
                n2 = grid.getNextVisibleColumn(-1);
            }
            cell2 = new Cell(n2, n);
        }
        return cell2;
    }

    protected Cell left(Grid grid, Cell cell, KeyEvent keyEvent) {
        Cell cell2 = super.left(grid, cell, keyEvent);
        if (cell2 == cell) {
            int n = grid.getColumnCount();
            int n2 = grid.getRowCount();
            int n3 = grid.getPreviousVisibleRow(cell.row);
            int n4 = grid.getPreviousVisibleColumn(n);
            if (n3 == -1) {
                n3 = grid.getPreviousVisibleRow(n2);
            }
            cell2 = new Cell(n4, n3);
        }
        return cell2;
    }

    protected Cell right(Grid grid, Cell cell, KeyEvent keyEvent) {
        Cell cell2 = super.right(grid, cell, keyEvent);
        if (cell2 == cell) {
            int n = grid.getNextVisibleRow(cell.row);
            int n2 = grid.getNextVisibleColumn(-1);
            if (n == -1) {
                n = grid.getNextVisibleColumn(-1);
            }
            cell2 = new Cell(n2, n);
        }
        return cell2;
    }

    public static GridKeyHandler getGridKeyHandler() {
        if (_sManager == null) {
            _sManager = new WrappingGridKeyHandler();
        }
        return _sManager;
    }
}

