/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import oracle.bali.ewt.LWComponent;

public class NamelessCardLayout
implements LayoutManager2 {
    private static NamelessCardLayout _sNamelessCardLayout;

    public static final LayoutManager2 getLayoutManager() {
        if (_sNamelessCardLayout == null) {
            _sNamelessCardLayout = new NamelessCardLayout();
        }
        return _sNamelessCardLayout;
    }

    public void addLayoutComponent(Component component, Object object) {
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            Component component = container.getComponent(n4);
            Dimension dimension = component.getPreferredSize();
            if (dimension.width > n2) {
                n2 = dimension.width;
            }
            if (dimension.height > n3) {
                n3 = dimension.height;
            }
            ++n4;
        }
        return new Dimension(insets.left + insets.right + n2, insets.top + insets.bottom + n3);
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            Component component = container.getComponent(n4);
            Dimension dimension = component.getMinimumSize();
            if (dimension.width > n2) {
                n2 = dimension.width;
            }
            if (dimension.height > n3) {
                n3 = dimension.height;
            }
            ++n4;
        }
        return new Dimension(insets.left + insets.right + n2, insets.top + insets.bottom + n3);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        Dimension dimension = container.getSize();
        int n2 = 0;
        while (n2 < n) {
            Component component = container.getComponent(n2);
            if (component.isVisible()) {
                component.setBounds(insets.left, insets.top, dimension.width - (insets.left + insets.right), dimension.height - (insets.top + insets.bottom));
            }
            ++n2;
        }
    }

    public static void flipToComponent(Component component) {
        Container container = component.getParent();
        if (container == null) {
            throw new IllegalArgumentException();
        }
        LWComponent lWComponent = null;
        if (container instanceof LWComponent) {
            lWComponent = (LWComponent)container;
            lWComponent.freezeRepaints();
        }
        try {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n = container.getComponentCount();
                int n2 = 0;
                while (n2 < n) {
                    Component component2;
                    component2.setVisible((component2 = container.getComponent(n2)) == component);
                    ++n2;
                }
            }
            container.validate();
            Object var9_8 = null;
            if (lWComponent != null) {
                lWComponent.unfreezeRepaints();
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (lWComponent != null) {
                lWComponent.unfreezeRepaints();
            }
            throw throwable;
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    private NamelessCardLayout() {
    }
}

