/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.model;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.model.AbstractBooleanModel;
import oracle.bali.ewt.model.ObjectModel;

public class ComparisonBooleanModel
extends AbstractBooleanModel {
    public static final int COMPARISON_EQUALS = 1;
    public static final int COMPARISON_NOT_EQUALS = -2;
    public static final int COMPARISON_GREATER_THAN = 2;
    public static final int COMPARISON_GREATER_THAN_OR_EQUALS = 3;
    public static final int COMPARISON_LESS_THAN = -4;
    public static final int COMPARISON_LESS_THAN_OR_EQUALS = -3;
    private ObjectModel _leftSideModel;
    private ObjectModel _rightSideModel;
    private Object _rightSide;
    private int _comparison;
    private transient boolean _state;

    public ComparisonBooleanModel(ObjectModel objectModel, ObjectModel objectModel2, int n) {
        this._init(objectModel, objectModel2, null, n);
    }

    public ComparisonBooleanModel(ObjectModel objectModel, Object object, int n) {
        this._init(objectModel, null, object, n);
    }

    public static ComparisonBooleanModel createExistsModel(ObjectModel objectModel) {
        return new ComparisonBooleanModel(objectModel, null, -2);
    }

    public boolean getState() {
        return this._state;
    }

    private void _init(ObjectModel objectModel, ObjectModel objectModel2, Object object, int n) {
        if (objectModel == null) {
            throw new IllegalArgumentException("Left side model required");
        }
        if (n < -4 || n > 3) {
            throw new IllegalArgumentException("Unknown comparison");
        }
        this._comparison = n;
        this._leftSideModel = objectModel;
        this._rightSideModel = objectModel2;
        this._rightSide = object;
        Changer changer = new Changer();
        this._state = this._calculateState();
        objectModel.addChangeListener(changer);
        if (objectModel2 != null) {
            objectModel2.addChangeListener(changer);
        }
    }

    private boolean _calculateState() {
        boolean bl;
        Object object = this._leftSideModel.getObject();
        Object object2 = this._rightSideModel != null ? this._rightSideModel.getObject() : this._rightSide;
        boolean bl2 = false;
        int n = this._comparison;
        if ((n & 1) == 0) {
            n ^= 0xFFFFFFFF;
            bl2 = true;
        }
        boolean bl3 = bl = object == object2 || object != null && object.equals(object2);
        if (!bl && n != 1) {
            if (object == null || object2 == null) {
                return false;
            }
            if (!(object instanceof Number) || !(object2 instanceof Number)) {
                throw new IllegalArgumentException("Numeric comparisons only allowed on numbers");
            }
            Number number = (Number)object;
            Number number2 = (Number)object2;
            if (n == -3) {
                boolean bl4 = bl2 = !bl2;
            }
            if (number instanceof Long) {
                bl = number.longValue() > number2.longValue();
            } else {
                boolean bl5 = bl = number.doubleValue() > number2.doubleValue();
            }
        }
        if (bl2) {
            bl = !bl;
        }
        return bl;
    }

    private void _updateState() {
        boolean bl = this._calculateState();
        if (bl != this._state) {
            this._state = bl;
            this.fireStateChanged();
        }
    }

    private class Changer
    implements ChangeListener {
        private Changer() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ComparisonBooleanModel.this._updateState();
        }
    }
}

