/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import oracle.bali.ewt.olaf.AlignedPainterJoiner;
import oracle.bali.ewt.olaf.IconTextGapPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.PainterUI;
import oracle.bali.ewt.olaf.ViewPainter;
import oracle.bali.ewt.painter.AlignmentPainter;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.share.util.IntegerUtils;

public class OracleLabelUI
extends BasicLabelUI
implements PainterUI {
    private static Painter _sPainter;
    private static final OracleLabelUI _sInstance;

    public static ComponentUI createUI(JComponent jComponent) {
        return _sInstance;
    }

    public PaintContext getPaintContext(JComponent jComponent) {
        return new PaintCtxt((JLabel)jComponent);
    }

    public Painter getPainter(JComponent jComponent) {
        if (((JLabel)jComponent).getIcon() == null) {
            return OracleUIUtils.getLabelTextPainter();
        }
        if (_sPainter == null) {
            _sPainter = new AlignmentPainter(new AlignedPainterJoiner(OracleUIUtils.getIconPainter(), new IconTextGapPainter(OracleUIUtils.getLabelTextPainter())), true);
        }
        return _sPainter;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        OracleUIUtils.putPaintContext(jComponent, this.getPaintContext(jComponent));
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        OracleUIUtils.removePaintContext(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics;
        Font font;
        Dimension dimension = OracleUIUtils.getPreferredSize(this, jComponent);
        PaintContext paintContext = OracleUIUtils.getPaintContext(jComponent);
        if (paintContext.getPaintData(PaintContext.ICON_KEY) == null && (font = jComponent.getFont()) != null && (fontMetrics = ((Component)jComponent).getFontMetrics(font)) != null) {
            dimension.height = Math.max(dimension.height, fontMetrics.getAscent() + fontMetrics.getDescent());
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return OracleUIUtils.getMinimumSize(this, jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return OracleUIUtils.getMaximumSize(this, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        OracleUIUtils.paint(this, graphics, jComponent);
    }

    public boolean contains(JComponent jComponent, int n, int n2) {
        return OracleUIUtils.contains(this, jComponent, n, n2);
    }

    static {
        _sInstance = new OracleLabelUI();
    }

    static class PaintCtxt
    extends JPaintContext
    implements SwingConstants {
        private JLabel _label;
        private boolean _hasFocus;

        public PaintCtxt(JLabel jLabel) {
            super(jLabel);
            this._label = jLabel;
        }

        public void setHasFocus(boolean bl) {
            this._hasFocus = bl;
        }

        public int getPaintState() {
            int n = super.getPaintState();
            n = this._hasFocus ? (n |= 0x40) : (n &= 0xFFFFFFBF);
            return n;
        }

        public Object getPaintData(Object object) {
            JLabel jLabel = this._label;
            if (PaintContext.LABEL_KEY.equals(object)) {
                return jLabel.getText();
            }
            if (PaintContext.ICON_KEY.equals(object)) {
                Icon icon = null;
                if (!jLabel.isEnabled()) {
                    icon = jLabel.getDisabledIcon();
                }
                if (icon == null) {
                    icon = jLabel.getIcon();
                }
                return icon;
            }
            if (ViewPainter.VIEW_KEY.equals(object)) {
                return ViewPainter.getHTMLView(jLabel);
            }
            if (AlignedPainterJoiner.HORIZONTAL_TEXT_POSITION.equals(object)) {
                return IntegerUtils.getInteger((int)jLabel.getHorizontalTextPosition());
            }
            if (AlignedPainterJoiner.VERTICAL_TEXT_POSITION.equals(object)) {
                return IntegerUtils.getInteger((int)jLabel.getVerticalTextPosition());
            }
            if (PaintContext.MNEMONIC_INDEX_KEY.equals(object)) {
                return JPaintContext.getMnemonicIndex(jLabel.getText(), jLabel.getDisplayedMnemonic());
            }
            return null;
        }

        public float getInteriorAlignmentX() {
            int n = OracleUIUtils.getActualHorizontalAlignment(this, this._label.getHorizontalAlignment());
            return n == 2 ? 0.0f : (n == 4 ? 1.0f : 0.5f);
        }

        public float getInteriorAlignmentY() {
            int n = this._label.getVerticalAlignment();
            return n == 1 ? 0.0f : (n == 3 ? 1.0f : 0.5f);
        }
    }
}

