/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.graphics.ImageStrip;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleInsetBorderPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.painter.AndOrStatePainterSwitcher;
import oracle.bali.ewt.painter.FilledRectPainter;
import oracle.bali.ewt.painter.FixedColorPainter;
import oracle.bali.ewt.painter.ImageSetPainter;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class OracleSliderUI
extends BasicSliderUI
implements MouseListener {
    private boolean _armed;
    private static Painter _sTrackPainter;
    private static Insets _sFocusInsets;

    public OracleSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new OracleSliderUI((JSlider)jComponent);
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if (object.equals("Slider.vertThumbPainter")) {
            return new ImageSetPainter((ImageSet)uIDefaults.get("Slider.vertThumbSet"));
        }
        if (object.equals("Slider.vertThumbSet")) {
            return new ImageStrip((Image)uIDefaults.get("Slider.vertThumbStrip"), 5);
        }
        if (object.equals("Slider.horzThumbPainter")) {
            return new ImageSetPainter((ImageSet)uIDefaults.get("Slider.horzThumbSet"));
        }
        if (object.equals("Slider.horzThumbSet")) {
            return new ImageStrip((Image)uIDefaults.get("Slider.horzThumbStrip"), 5);
        }
        return null;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        OracleUIUtils.putPaintContext(jComponent, new Ctxt(this.slider));
        jComponent.setOpaque(false);
    }

    public boolean isArmed() {
        return this._armed;
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        OracleUIUtils.removePaintContext(jComponent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.slider.isEnabled() && this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this._setArmed(true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this._setArmed(false);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected Dimension getThumbSize() {
        if (this._isHorizontal()) {
            return new Dimension(17, 13);
        }
        return new Dimension(13, 17);
    }

    public void paintFocus(Graphics graphics) {
        PaintContext paintContext = OracleUIUtils.getPaintContext(this.slider);
        Painter painter = OracleUIUtils.getFocusPainter();
        Color color = graphics.getColor();
        graphics.setColor(paintContext.getPaintUIDefaults().getColor("controlText"));
        painter.paint(paintContext, graphics, this.focusRect.x, this.focusRect.y, this.focusRect.width, this.focusRect.height);
        graphics.setColor(color);
    }

    protected void paintHorizontalLabel(Graphics graphics, int n, Component component) {
        Color color = this._setLabelColor(component);
        super.paintHorizontalLabel(graphics, n, component);
        component.setForeground(color);
    }

    protected void paintVerticalLabel(Graphics graphics, int n, Component component) {
        Color color = this._setLabelColor(component);
        super.paintVerticalLabel(graphics, n, component);
        component.setForeground(color);
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        Color color = this._setTickColor(graphics);
        super.paintMinorTickForHorizSlider(graphics, rectangle, n);
        graphics.setColor(color);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        Color color = this._setTickColor(graphics);
        super.paintMajorTickForHorizSlider(graphics, rectangle, n);
        graphics.setColor(color);
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        Color color = this._setTickColor(graphics);
        super.paintMinorTickForVertSlider(graphics, rectangle, n);
        graphics.setColor(color);
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        Color color = this._setTickColor(graphics);
        super.paintMajorTickForVertSlider(graphics, rectangle, n);
        graphics.setColor(color);
    }

    public void paintThumb(Graphics graphics) {
        String string = this._isHorizontal() ? "Slider.horzThumbPainter" : "Slider.vertThumbPainter";
        Painter painter = OracleUIUtils.getPainter(this.slider, string);
        PaintContext paintContext = OracleUIUtils.getPaintContext(this.slider);
        painter.paint(paintContext, graphics, this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height);
    }

    public void paintTrack(Graphics graphics) {
        Painter painter = OracleSliderUI._getTrackPainter();
        PaintContext paintContext = OracleUIUtils.getPaintContext(this.slider);
        int n = this.trackRect.x;
        int n2 = this.trackRect.y;
        int n3 = this.trackRect.width;
        int n4 = this.trackRect.height;
        if (this._isHorizontal()) {
            n -= this.trackBuffer;
            n3 += 2 * this.trackBuffer;
        } else {
            n2 -= this.trackBuffer;
            n4 += 2 * this.trackBuffer;
        }
        painter.paint(paintContext, graphics, n, n2, n3, n4);
    }

    protected void installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
        this.focusInsets = OracleSliderUI._getFocusInsets();
    }

    protected void installListeners(JSlider jSlider) {
        super.installListeners(jSlider);
        jSlider.addMouseListener(this);
    }

    protected void uninstallListeners(JSlider jSlider) {
        super.uninstallListeners(jSlider);
        jSlider.removeMouseListener(this);
    }

    private boolean _isHorizontal() {
        return this.slider.getOrientation() == 0;
    }

    private void _setArmed(boolean bl) {
        if (bl != this._armed) {
            this._armed = bl;
            this.slider.repaint();
        }
    }

    private static Insets _getFocusInsets() {
        if (_sFocusInsets == null) {
            _sFocusInsets = new Insets(4, 2, 4, 2);
        }
        return _sFocusInsets;
    }

    private static Painter _getTrackPainter() {
        if (_sTrackPainter == null) {
            _sTrackPainter = new OracleInsetBorderPainter(new AndOrStatePainterSwitcher(new FixedColorPainter(FilledRectPainter.getPainter(), ColorScheme.NORMAL_INTENSITY), new FixedColorPainter(FilledRectPainter.getPainter(), "Slider.sliderColor"), 2, 2, 0, 0), true);
        }
        return _sTrackPainter;
    }

    private Color _setLabelColor(Component component) {
        PaintContext paintContext = OracleUIUtils.getPaintContext(this.slider);
        Color color = paintContext.getPaintForeground();
        if (color == ColorScheme.__sControlText) {
            color = paintContext.getPaintUIDefaults().getColor("controlText");
        }
        Color color2 = component.getForeground();
        component.setForeground(color);
        return color2;
    }

    private Color _setTickColor(Graphics graphics) {
        PaintContext paintContext = OracleUIUtils.getPaintContext(this.slider);
        Color color = paintContext.getPaintForeground();
        if (color == ColorScheme.__sControlText) {
            color = paintContext.getPaintUIDefaults().getColor("controlText");
        }
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        return color2;
    }

    private class Ctxt
    extends JPaintContext {
        public Ctxt(JComponent jComponent) {
            super(jComponent);
        }

        public int getPaintState() {
            int n = super.getPaintState();
            if (OracleSliderUI.this.isArmed()) {
                n |= 2;
            }
            return n;
        }
    }
}

