/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleThumbPainter;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;

class OracleSplitPanePainter
extends AbstractPainter {
    private static final int _GRIPPY_SIZE = 3;
    private static final int _GRIPPY_GAP = 5;
    private static final int _GRIPPY_STRIDE = 8;
    private static final int _MIN_GRIPPIES = 3;
    private static final int _MIN_PERP_GRIPPY_SIZE = 5;
    private static final int _MIN_ORIENT_GRIPPY_SIZE = 19;
    private boolean _isHorizontal;

    public OracleSplitPanePainter(boolean bl) {
        this._isHorizontal = bl;
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        if (this._isHorizontal) {
            return new Dimension(19, 5);
        }
        return new Dimension(5, 19);
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return 135;
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(paintContext.getPaintBackground());
        graphics.fillRect(n, n2, n3, n4);
        int n5 = paintContext.getPaintState();
        if ((n5 & 5) == 0) {
            int n6;
            int n7 = n6 = this._isHorizontal ? n3 : n4;
            if (n6 >= 19) {
                int n8 = n6 / 40;
                if ((n8 |= 1) < 3) {
                    n8 = 3;
                }
                int n9 = n8 * 3 + (n8 - 1) * 5;
                int n10 = 3;
                int n11 = 3;
                int n12 = 0;
                int n13 = 0;
                if (this._isHorizontal) {
                    n10 = n9;
                    n12 = 8;
                } else {
                    n11 = n9;
                    n13 = 8;
                }
                int n14 = n + (n3 - n10) / 2;
                int n15 = n2 + (n4 - n11) / 2;
                UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
                Color color2 = uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
                Color color3 = uIDefaults.getColor(ColorScheme.CONTROL_SHADOW_DARK);
                boolean bl = (n5 & 2) != 0;
                while (n8 > 0) {
                    OracleThumbPainter.__drawGrippy(graphics, n14, n15, color2, color3, bl);
                    --n8;
                    n14 += n12;
                    n15 += n13;
                }
            }
        }
        graphics.setColor(color);
    }
}

