/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Position;
import oracle.bali.share.nls.StringUtils;
import sun.awt.shell.ShellFolder;
import sun.security.action.GetPropertyAction;

public class OracleFileChooserUI
extends BasicFileChooserUI {
    private JPanel centerPanel;
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private JPanel listViewPanel;
    private JPanel detailsViewPanel;
    private JPanel currentViewPanel;
    private FocusListener editorFocusListener = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                OracleFileChooserUI.this.applyEdit();
            }
        }
    };
    private boolean useShellFolder;
    private ListSelectionModel listSelectionModel;
    private JList list;
    private JTable detailsTable;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private static final Dimension hstrut5 = new Dimension(5, 1);
    private static final Dimension hstrut11 = new Dimension(11, 1);
    private static final Dimension vstrut5 = new Dimension(1, 5);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 500;
    private static int MIN_HEIGHT = 326;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_PREF_WIDTH = 405;
    private static int LIST_PREF_HEIGHT = 135;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private static final int COLUMN_FILENAME = 0;
    private static final int COLUMN_FILESIZE = 1;
    private static final int COLUMN_FILETYPE = 2;
    private static final int COLUMN_FILEDATE = 3;
    private static final int COLUMN_FILEATTR = 4;
    private static final int COLUMN_COLCOUNT = 5;
    private int[] COLUMN_WIDTHS = new int[]{150, 75, 130, 130, 40};
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private String fileNameHeaderText = null;
    private String fileSizeHeaderText = null;
    private String fileTypeHeaderText = null;
    private String fileDateHeaderText = null;
    private String fileAttrHeaderText = null;
    private String listViewAccessibleName;
    int lastIndex = -1;
    File editFile = null;
    int editX = 20;
    JTextField editCell = null;
    static final int space = 10;
    private static boolean disableFileChooserSpeedFixProperty = false;
    private static final String _BUNDLE = "oracle.bali.ewt.olaf.resource.OLAFBundle";
    private static final String _KEY_NAME = "FILECHOOSER.NAME";
    private static final String _KEY_SIZE = "FILECHOOSER.SIZE";
    private static final String _KEY_TYPE = "FILECHOOSER.TYPE";
    private static final String _KEY_DATE = "FILECHOOSER.DATE";
    private static final String _KEY_ATTR = "FILECHOOSER.ATTR";
    private static final String _KEY_OPEN = "FILECHOOSER.OPEN";
    private static final String _KEY_SAVE = "FILECHOOSER.SAVE";
    private static final String _KEY_HELP = "COMMON.HELP";
    private static final String _KEY_CANCEL = "COMMON.CANCEL";
    private static final String _KEY_LOOKIN = "FILECHOOSER.LOOKIN";
    private static final String _KEY_FILETYPES = "FILECHOOSER.FILETYPES";
    private static final String _KEY_UP = "FILECHOOSER.UP";
    private static final String _KEY_HOME = "FILECHOOSER.HOME";
    private static final String _KEY_FOLDER = "FILECHOOSER.FOLDER";
    private static final String _KEY_PREVIEW = "FILECHOOSER.PREVIEW";
    private static final String _KEY_LIST = "FILECHOOSER.LIST";
    private static final String _KEY_DETAILS = "FILECHOOSER.DETAILS";
    private static final String _KEY_FILENAME = "FILECHOOSER.FILENAME";
    private static final String _KEY_FILES = "FILECHOOSER.FILES";
    private static final String _KEY_PREVIEW_LABEL = "FILECHOOSER.PREVIEW_LABEL";
    private static final String _KEY_READONLY = "FILECHOOSER.READONLY";
    private static final String _KEY_HIDDEN = "FILECHOOSER.HIDDEN";
    private static final String _KEY_READONLY_AND_HIDDEN = "FILECHOOSER.READONLY_AND_HIDDEN";
    private KeyListener _keyHandler;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Object;

    public static ComponentUI createUI(JComponent jComponent) {
        return new OracleFileChooserUI((JFileChooser)jComponent);
    }

    public OracleFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
        this.bottomPanel = null;
        this.buttonPanel = null;
    }

    public void installComponents(JFileChooser jFileChooser) {
        Object object;
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        jFileChooser.setBorder(new EmptyBorder(12, 12, 11, 11));
        jFileChooser.setLayout(new BorderLayout(0, 11));
        JPanel jPanel = new JPanel(new BorderLayout(11, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel.add((Component)jPanel2, "After");
        jFileChooser.add((Component)jPanel, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        jPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.getAccessibleContext().setAccessibleDescription(this.lookInLabelText);
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.0f);
        this.directoryComboBox.setMaximumRowCount(8);
        jPanel.add((Component)this.directoryComboBox, "Center");
        JButton jButton = new JButton(this.getChangeToParentDirectoryAction());
        jButton.setText(null);
        jButton.setIcon(this.upFolderIcon);
        jButton.setToolTipText(this.upFolderToolTipText);
        jButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        jButton.setAlignmentX(0.0f);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(shrinkwrap);
        jPanel2.add(jButton);
        jPanel2.add(Box.createRigidArea(hstrut5));
        File file = fileSystemView.getHomeDirectory();
        String string = this.homeFolderToolTipText;
        if (fileSystemView.isRoot(file)) {
            string = this.getFileView(jFileChooser).getName(file);
        }
        JButton jButton2 = new JButton(this.homeFolderIcon);
        jButton2.setToolTipText(string);
        jButton2.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        jButton2.setAlignmentX(0.0f);
        jButton2.setAlignmentY(0.5f);
        jButton2.setMargin(shrinkwrap);
        jButton2.addActionListener(this.getGoHomeAction());
        jPanel2.add(jButton2);
        jPanel2.add(Box.createRigidArea(hstrut5));
        jButton2 = new JButton(this.getNewFolderAction());
        jButton2.setText(null);
        jButton2.setIcon(this.newFolderIcon);
        jButton2.setToolTipText(this.newFolderToolTipText);
        jButton2.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        jButton2.setAlignmentX(0.0f);
        jButton2.setAlignmentY(0.5f);
        jButton2.setMargin(shrinkwrap);
        jPanel2.add(jButton2);
        jPanel2.add(Box.createRigidArea(hstrut5));
        ButtonGroup buttonGroup = new ButtonGroup();
        class ViewButtonListener
        implements ActionListener {
            JFileChooser fc;

            ViewButtonListener(JFileChooser jFileChooser) {
                this.fc = jFileChooser;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                JPanel jPanel = OracleFileChooserUI.this.currentViewPanel;
                if (jToggleButton == OracleFileChooserUI.this.detailsViewButton) {
                    if (OracleFileChooserUI.this.detailsViewPanel == null) {
                        OracleFileChooserUI.this.detailsViewPanel = OracleFileChooserUI.this.createDetailsView(this.fc);
                        OracleFileChooserUI.this.detailsViewPanel.setPreferredSize(LIST_PREF_SIZE);
                    }
                    OracleFileChooserUI.this.currentViewPanel = OracleFileChooserUI.this.detailsViewPanel;
                } else {
                    OracleFileChooserUI.this.currentViewPanel = OracleFileChooserUI.this.listViewPanel;
                }
                if (OracleFileChooserUI.this.currentViewPanel != jPanel) {
                    OracleFileChooserUI.this.centerPanel.remove(jPanel);
                    OracleFileChooserUI.this.centerPanel.add((Component)OracleFileChooserUI.this.currentViewPanel, "Center");
                    OracleFileChooserUI.this.centerPanel.revalidate();
                    OracleFileChooserUI.this.centerPanel.repaint();
                }
            }
        }
        ViewButtonListener viewButtonListener = new ViewButtonListener(jFileChooser);
        this.listViewButton = new JToggleButton(this.listViewIcon);
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.getAccessibleContext().setAccessibleName(this.listViewButtonAccessibleName);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkwrap);
        this.listViewButton.addActionListener(viewButtonListener);
        jPanel2.add(this.listViewButton);
        buttonGroup.add(this.listViewButton);
        this.detailsViewButton = new JToggleButton(this.detailsViewIcon);
        this.detailsViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailsViewButton.getAccessibleContext().setAccessibleName(this.detailsViewButtonAccessibleName);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(shrinkwrap);
        this.detailsViewButton.addActionListener(viewButtonListener);
        jPanel2.add(this.detailsViewButton);
        buttonGroup.add(this.detailsViewButton);
        this.useShellFolder = false;
        Object object2 = fileSystemView.getRoots();
        if (object2 != null && ((File[])object2).length == 1 && (object = (File[])ShellFolder.get("fileChooserComboBoxFolders")) != null && ((File[])object).length > 0 && object2[0] == object[0]) {
            this.useShellFolder = true;
        }
        this.centerPanel = new JPanel(new BorderLayout());
        this._keyHandler = new KeyEventHandler();
        this.listViewPanel = this.createList(jFileChooser);
        this.listSelectionModel = this.list.getSelectionModel();
        this.listViewPanel.setPreferredSize(LIST_PREF_SIZE);
        this.centerPanel.add((Component)this.listViewPanel, "Center");
        this.currentViewPanel = this.listViewPanel;
        this.centerPanel.add((Component)this.getAccessoryPanel(), "After");
        object2 = jFileChooser.getAccessory();
        if (object2 != null) {
            this.getAccessoryPanel().add((Component)object2);
        }
        jFileChooser.add((Component)this.centerPanel, "Center");
        object = this.getBottomPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 1));
        jFileChooser.add((Component)object, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        ((Container)object).add(jPanel3);
        ((Container)object).add(Box.createRigidArea(vstrut5));
        AlignedLabel alignedLabel = new AlignedLabel(this.fileNameLabelText);
        alignedLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        jPanel3.add(alignedLabel);
        this.fileNameTextField = new JTextField(35){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        jPanel3.add(this.fileNameTextField);
        alignedLabel.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (!OracleFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    OracleFileChooserUI.this.listSelectionModel.clearSelection();
                }
            }
        });
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFile()));
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        ((Container)object).add(jPanel4);
        AlignedLabel alignedLabel2 = new AlignedLabel(this.filesOfTypeLabelText);
        alignedLabel2.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        jPanel4.add(alignedLabel2);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        this.filterComboBox.getAccessibleContext().setAccessibleDescription(this.filesOfTypeLabelText);
        alignedLabel2.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        jPanel4.add(this.filterComboBox);
        this.getButtonPanel().setLayout(new ButtonAreaLayout());
        this.approveButton = new JButton(this.getApproveButtonText(jFileChooser));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.getButtonPanel().add(this.approveButton);
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (jFileChooser.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        OracleFileChooserUI.groupLabels(new AlignedLabel[]{alignedLabel, alignedLabel2});
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        Locale locale = jFileChooser.getLocale();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_BUNDLE, locale);
        this.listViewAccessibleName = StringUtils.stripMnemonic((String)resourceBundle.getString(_KEY_FILES));
        String string = resourceBundle.getString(_KEY_SAVE);
        String string2 = resourceBundle.getString(_KEY_OPEN);
        String string3 = resourceBundle.getString(_KEY_CANCEL);
        String string4 = resourceBundle.getString(_KEY_HELP);
        this.saveButtonText = StringUtils.stripMnemonic((String)string);
        this.openButtonText = StringUtils.stripMnemonic((String)string2);
        this.cancelButtonText = StringUtils.stripMnemonic((String)string3);
        this.helpButtonText = StringUtils.stripMnemonic((String)string4);
        this.directoryOpenButtonText = this.openButtonText;
        this.saveButtonMnemonic = StringUtils.getMnemonicKeyCode((String)string);
        this.openButtonMnemonic = StringUtils.getMnemonicKeyCode((String)string2);
        this.cancelButtonMnemonic = StringUtils.getMnemonicKeyCode((String)string3);
        this.helpButtonMnemonic = StringUtils.getMnemonicKeyCode((String)string4);
        this.directoryOpenButtonMnemonic = this.openButtonMnemonic;
        this.saveButtonToolTipText = null;
        this.openButtonToolTipText = null;
        this.cancelButtonToolTipText = null;
        this.helpButtonToolTipText = null;
        this.directoryOpenButtonToolTipText = this.openButtonToolTipText;
        String string5 = resourceBundle.getString(_KEY_LOOKIN);
        this.lookInLabelMnemonic = StringUtils.getMnemonicKeyCode((String)string5);
        this.saveInLabelText = this.lookInLabelText = StringUtils.stripMnemonic((String)string5);
        String string6 = resourceBundle.getString(_KEY_FILENAME);
        this.fileNameLabelMnemonic = StringUtils.getMnemonicKeyCode((String)string6);
        this.fileNameLabelText = StringUtils.stripMnemonic((String)string6);
        String string7 = resourceBundle.getString(_KEY_FILETYPES);
        this.filesOfTypeLabelMnemonic = StringUtils.getMnemonicKeyCode((String)string7);
        this.filesOfTypeLabelText = StringUtils.stripMnemonic((String)string7);
        this.upFolderAccessibleName = this.upFolderToolTipText = resourceBundle.getString(_KEY_UP);
        this.homeFolderAccessibleName = this.homeFolderToolTipText = resourceBundle.getString(_KEY_HOME);
        this.newFolderAccessibleName = this.newFolderToolTipText = resourceBundle.getString(_KEY_FOLDER);
        this.listViewButtonAccessibleName = this.listViewButtonToolTipText = resourceBundle.getString(_KEY_LIST);
        this.detailsViewButtonAccessibleName = this.detailsViewButtonToolTipText = resourceBundle.getString(_KEY_DETAILS);
        this.fileNameHeaderText = resourceBundle.getString(_KEY_NAME);
        this.fileSizeHeaderText = resourceBundle.getString(_KEY_SIZE);
        this.fileTypeHeaderText = resourceBundle.getString(_KEY_TYPE);
        this.fileDateHeaderText = resourceBundle.getString(_KEY_DATE);
        this.fileAttrHeaderText = resourceBundle.getString(_KEY_ATTR);
    }

    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jFileChooser, actionMap);
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (OracleFileChooserUI.this.editFile != null) {
                    OracleFileChooserUI.this.cancelEdit();
                } else {
                    OracleFileChooserUI.this.getFileChooser().cancelSelection();
                }
            }

            public boolean isEnabled() {
                return OracleFileChooserUI.this.getFileChooser().isEnabled();
            }
        };
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("approveSelection", this.getApproveSelectionAction());
        actionMapUIResource.put("cancelSelection", abstractAction);
        actionMapUIResource.put("Go Up", this.getChangeToParentDirectoryAction());
        actionMapUIResource.put("editFileName", this.getEditAction());
        return actionMapUIResource;
    }

    private Action getEditAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = OracleFileChooserUI.this.getFileChooser();
                int n = OracleFileChooserUI.this.list.getSelectionModel().getMinSelectionIndex();
                if (!(n < 0 || OracleFileChooserUI.this.editFile != null || jFileChooser.isMultiSelectionEnabled() && jFileChooser.getSelectedFiles().length > 1)) {
                    OracleFileChooserUI.this.editFileName(n);
                }
            }
        };
    }

    protected JPanel createList(JFileChooser jFileChooser) {
        JPanel jPanel = new JPanel(new BorderLayout());
        final JFileChooser jFileChooser2 = jFileChooser;
        this.list = new JList(){

            public int getNextMatch(String string, int n, Position.Bias bias) {
                ListModel listModel = this.getModel();
                int n2 = listModel.getSize();
                if (string == null || n < 0 || n >= n2) {
                    throw new IllegalArgumentException();
                }
                boolean bl = bias == Position.Bias.Backward;
                int n3 = n;
                while (bl ? n3 >= 0 : n3 < n2) {
                    String string2 = jFileChooser2.getName((File)listModel.getElementAt(n3));
                    if (string2.regionMatches(true, 0, string, 0, string.length())) {
                        return n3;
                    }
                    n3 += bl ? -1 : 1;
                }
                return -1;
            }
        };
        this.list.setCellRenderer(new FileRenderer());
        this.list.setLayoutOrientation(1);
        this.list.setVisibleRowCount(-1);
        this.list.addKeyListener(this._keyHandler);
        this.list.getAccessibleContext().setAccessibleName(this.listViewAccessibleName);
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
        }
        this.list.setModel(this.getModel());
        this.list.addListSelectionListener(this.createListSelectionListener(jFileChooser));
        this.list.addMouseListener(this.createDoubleClickListener(jFileChooser, this.list));
        this.list.addMouseListener(this.createSingleClickListener(jFileChooser, this.list));
        this.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected JPanel createDetailsView(JFileChooser jFileChooser) {
        final JFileChooser jFileChooser2 = jFileChooser;
        JPanel jPanel = new JPanel(new BorderLayout());
        DetailsTableModel detailsTableModel = new DetailsTableModel(jFileChooser2);
        this.detailsTable = new JTable(detailsTableModel){

            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
                if (keyEvent.getKeyCode() == 27 && this.getCellEditor() == null) {
                    jFileChooser2.dispatchEvent(keyEvent);
                    return true;
                }
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }
        };
        this.detailsTable.setComponentOrientation(jFileChooser2.getComponentOrientation());
        this.detailsTable.setAutoResizeMode(0);
        this.detailsTable.setShowGrid(false);
        this.detailsTable.setSelectionModel(this.listSelectionModel);
        this.detailsTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.detailsTable.getInputMap(1).put(keyStroke, "NONE");
        this.detailsTable.addKeyListener(this._keyHandler);
        Font font = this.detailsTable.getFont();
        FontMetrics fontMetrics = this.detailsTable.getFontMetrics(font);
        this.detailsTable.setRowHeight(fontMetrics.getHeight() + fontMetrics.getDescent());
        TableColumnModel tableColumnModel = this.detailsTable.getColumnModel();
        TableColumn[] tableColumnArray = new TableColumn[5];
        for (int i = 0; i < 5; ++i) {
            tableColumnArray[i] = tableColumnModel.getColumn(i);
            tableColumnArray[i].setPreferredWidth(this.COLUMN_WIDTHS[i]);
        }
        if (!System.getProperty("os.name").startsWith("Windows")) {
            tableColumnModel.removeColumn(tableColumnArray[2]);
            tableColumnModel.removeColumn(tableColumnArray[4]);
        }
        DetailsTableCellRenderer detailsTableCellRenderer = new DetailsTableCellRenderer(jFileChooser2);
        this.detailsTable.setDefaultRenderer(class$java$io$File == null ? (class$java$io$File = OracleFileChooserUI.class$("java.io.File")) : class$java$io$File, detailsTableCellRenderer);
        this.detailsTable.setDefaultRenderer(class$java$util$Date == null ? (class$java$util$Date = OracleFileChooserUI.class$("java.util.Date")) : class$java$util$Date, detailsTableCellRenderer);
        this.detailsTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = OracleFileChooserUI.class$("java.lang.Object")) : class$java$lang$Object, detailsTableCellRenderer);
        final JTextField jTextField = new JTextField();
        jTextField.addFocusListener(this.editorFocusListener);
        tableColumnArray[0].setCellEditor(new DefaultCellEditor(jTextField){

            public boolean isCellEditable(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    int n = OracleFileChooserUI.this.detailsTable.rowAtPoint(mouseEvent.getPoint());
                    return mouseEvent.getClickCount() == 1 && OracleFileChooserUI.this.detailsTable.isRowSelected(n);
                }
                return super.isCellEditable(eventObject);
            }

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                if (object instanceof File) {
                    jTextField.setText(jFileChooser2.getName((File)object));
                    jTextField.requestFocus();
                    jTextField.selectAll();
                }
                return component;
            }
        });
        JList jList = new JList(detailsTableModel.listModel){
            JTable table;
            {
                this.table = OracleFileChooserUI.this.detailsTable;
            }

            public int locationToIndex(Point point) {
                return this.table.rowAtPoint(point);
            }

            public Rectangle getCellBounds(int n, int n2) {
                Rectangle rectangle = this.table.getCellRect(n, 0, false);
                Rectangle rectangle2 = this.table.getCellRect(n2, 0, false);
                return rectangle.union(rectangle2);
            }

            public Object getSelectedValue() {
                return this.table.getValueAt(this.table.getSelectedRow(), 0);
            }

            public Component add(Component component) {
                if (component instanceof JTextField) {
                    return this.table.add(component);
                }
                return super.add(component);
            }

            public void repaint() {
                if (this.table != null) {
                    this.table.repaint();
                }
            }

            public TransferHandler getTransferHandler() {
                if (this.table != null) {
                    return this.table.getTransferHandler();
                }
                return super.getTransferHandler();
            }

            public void setTransferHandler(TransferHandler transferHandler) {
                if (this.table != null) {
                    this.table.setTransferHandler(transferHandler);
                } else {
                    super.setTransferHandler(transferHandler);
                }
            }

            public boolean getDragEnabled() {
                if (this.table != null) {
                    return this.table.getDragEnabled();
                }
                return super.getDragEnabled();
            }

            public void setDragEnabled(boolean bl) {
                if (this.table != null) {
                    this.table.setDragEnabled(bl);
                } else {
                    super.setDragEnabled(bl);
                }
            }
        };
        jList.setSelectionModel(this.listSelectionModel);
        this.detailsTable.addMouseListener(this.createDoubleClickListener(jFileChooser2, jList));
        this.detailsTable.getAccessibleContext().setAccessibleName(this.listViewAccessibleName);
        JScrollPane jScrollPane = new JScrollPane(this.detailsTable);
        jScrollPane.setComponentOrientation(jFileChooser2.getComponentOrientation());
        LookAndFeel.installColors(jScrollPane.getViewport(), "Table.background", "Table.foreground");
        jScrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                JScrollPane jScrollPane = (JScrollPane)componentEvent.getComponent();
                OracleFileChooserUI.this.fixNameColumnWidth(jScrollPane.getViewport().getSize().width);
                jScrollPane.removeComponentListener(this);
            }
        });
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void fixNameColumnWidth(int n) {
        TableColumn tableColumn = this.detailsTable.getColumnModel().getColumn(0);
        int n2 = this.detailsTable.getPreferredSize().width;
        if (n2 < n) {
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n - n2);
        }
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new BasicFileChooserUI.SelectionListener(){

            /*
             * Enabled aggressive block sorting
             */
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                File[] fileArray;
                JFileChooser jFileChooser;
                block7: {
                    int n;
                    Object[] objectArray;
                    FileSystemView fileSystemView;
                    block9: {
                        JList jList;
                        block6: {
                            block8: {
                                if (listSelectionEvent.getValueIsAdjusting()) return;
                                jFileChooser = OracleFileChooserUI.this.getFileChooser();
                                fileSystemView = jFileChooser.getFileSystemView();
                                jList = (JList)listSelectionEvent.getSource();
                                if (!jFileChooser.isMultiSelectionEnabled()) break block6;
                                fileArray = null;
                                objectArray = jList.getSelectedValues();
                                if (objectArray == null) break block7;
                                if (objectArray.length != 1 || !((File)objectArray[0]).isDirectory() || !jFileChooser.isTraversable((File)objectArray[0])) break block8;
                                if (jFileChooser.getFileSelectionMode() != 0 && fileSystemView.isFileSystem((File)objectArray[0])) break block8;
                                OracleFileChooserUI.this.setDirectorySelected(true);
                                OracleFileChooserUI.this.setDirectory((File)objectArray[0]);
                                break block7;
                            }
                            fileArray = new File[objectArray.length];
                            n = 0;
                            break block9;
                        }
                        File file = (File)jList.getSelectedValue();
                        if (file != null && file.isDirectory() && jFileChooser.isTraversable(file)) {
                            if (jFileChooser.getFileSelectionMode() == 0 || !fileSystemView.isFileSystem(file)) {
                                OracleFileChooserUI.this.setDirectorySelected(true);
                                OracleFileChooserUI.this.setDirectory(file);
                                jFileChooser.setSelectedFile(null);
                                return;
                            }
                        }
                        OracleFileChooserUI.this.setDirectorySelected(false);
                        if (file == null) return;
                        jFileChooser.setSelectedFile(file);
                        return;
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        boolean bl;
                        File file = (File)objectArray[i];
                        boolean bl2 = file.isDirectory();
                        boolean bl3 = disableFileChooserSpeedFixProperty ? file.isFile() : (bl = !bl2);
                        if ((!jFileChooser.isFileSelectionEnabled() || !bl) && (!jFileChooser.isDirectorySelectionEnabled() || !fileSystemView.isFileSystem(file) || !bl2)) continue;
                        fileArray[n++] = file;
                    }
                    if (n == 0) {
                        fileArray = null;
                    } else if (n < objectArray.length) {
                        File[] fileArray2 = new File[n];
                        System.arraycopy(fileArray, 0, fileArray2, 0, n);
                        fileArray = fileArray2;
                    }
                    OracleFileChooserUI.this.setDirectorySelected(false);
                }
                jFileChooser.setSelectedFiles(fileArray);
            }
        };
    }

    private MouseListener createSingleClickListener(JFileChooser jFileChooser, JList jList) {
        return new SingleClickListener(jList);
    }

    private int getEditIndex() {
        return this.lastIndex;
    }

    private void setEditIndex(int n) {
        this.lastIndex = n;
    }

    private void resetEditIndex() {
        this.lastIndex = -1;
    }

    private void cancelEdit() {
        if (this.editFile != null) {
            this.editFile = null;
            this.list.remove(this.editCell);
            this.centerPanel.repaint();
        } else if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().cancelCellEditing();
        }
    }

    private void editFileName(int n) {
        this.ensureIndexIsVisible(n);
        if (this.listViewPanel.isVisible()) {
            this.editFile = (File)this.getModel().getElementAt(n);
            Rectangle rectangle = this.list.getCellBounds(n, n);
            if (this.editCell == null) {
                this.editCell = new JTextField();
                this.editCell.addActionListener(new EditActionListener());
                this.editCell.addFocusListener(this.editorFocusListener);
                this.editCell.setNextFocusableComponent(this.list);
            }
            this.list.add(this.editCell);
            this.editCell.setText(this.getFileChooser().getName(this.editFile));
            if (this.list.getComponentOrientation().isLeftToRight()) {
                this.editCell.setBounds(this.editX + rectangle.x, rectangle.y, rectangle.width - this.editX, rectangle.height);
            } else {
                this.editCell.setBounds(rectangle.x, rectangle.y, rectangle.width - this.editX, rectangle.height);
            }
            this.editCell.requestFocus();
            this.editCell.selectAll();
        } else if (this.detailsViewPanel.isVisible()) {
            this.detailsTable.editCellAt(n, 0);
        }
    }

    private void applyEdit() {
        if (this.editFile != null && this.editFile.exists()) {
            JFileChooser jFileChooser = this.getFileChooser();
            String string = jFileChooser.getName(this.editFile);
            String string2 = this.editFile.getName();
            String string3 = this.editCell.getText().trim();
            if (!string3.equals(string)) {
                FileSystemView fileSystemView;
                File file;
                int n;
                String string4 = string3;
                int n2 = string2.length();
                if (n2 > (n = string.length()) && string2.charAt(n) == '.') {
                    string4 = string3 + string2.substring(n);
                }
                if (!(file = (fileSystemView = jFileChooser.getFileSystemView()).createFileObject(this.editFile.getParentFile(), string4)).exists() && this.getModel().renameFile(this.editFile, file) && fileSystemView.isParent(jFileChooser.getCurrentDirectory(), file)) {
                    if (jFileChooser.isMultiSelectionEnabled()) {
                        jFileChooser.setSelectedFiles(new File[]{file});
                    } else {
                        jFileChooser.setSelectedFile(file);
                    }
                }
            }
        }
        if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().stopCellEditing();
        }
        this.cancelEdit();
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        this.list.removeKeyListener(this._keyHandler);
        if (this.detailsTable != null) {
            this.detailsTable.removeKeyListener(this._keyHandler);
        }
        super.uninstallUI(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = OracleFileChooserUI.PREF_SIZE.width;
        Dimension dimension = jComponent.getLayout().preferredLayoutSize(jComponent);
        if (dimension != null) {
            return new Dimension(dimension.width < n ? n : dimension.width, dimension.height < OracleFileChooserUI.PREF_SIZE.height ? OracleFileChooserUI.PREF_SIZE.height : dimension.height);
        }
        return new Dimension(n, OracleFileChooserUI.PREF_SIZE.height);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileSelected() {
        if (this.getFileChooser().isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            Object[] objectArray = this.getFileChooser().getSelectedFiles();
            Object[] objectArray2 = this.list.getSelectedValues();
            if (disableFileChooserSpeedFixProperty) {
                int n;
                boolean bl;
                int n2;
                for (n2 = 0; n2 < objectArray2.length; ++n2) {
                    bl = false;
                    for (n = 0; n < objectArray.length; ++n) {
                        if (!((File)objectArray[n]).equals(objectArray2[n2])) continue;
                        bl = true;
                        break;
                    }
                    if (bl || (n = this.getModel().indexOf(objectArray2[n2])) < 0) continue;
                    this.listSelectionModel.removeSelectionInterval(n, n);
                }
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    bl = false;
                    for (n = 0; n < objectArray2.length; ++n) {
                        if (!((File)objectArray[n2]).equals(objectArray2[n])) continue;
                        bl = true;
                        break;
                    }
                    if (bl || (n = this.getModel().indexOf(objectArray[n2])) < 0) continue;
                    this.listSelectionModel.addSelectionInterval(n, n);
                }
            } else {
                this.listSelectionModel.setValueIsAdjusting(true);
                try {
                    int n;
                    Arrays.sort(objectArray);
                    Arrays.sort(objectArray2);
                    int n3 = 0;
                    int n4 = 0;
                    while (n3 < objectArray.length && n4 < objectArray2.length) {
                        int n5;
                        n = ((File)objectArray[n3]).compareTo((File)objectArray2[n4]);
                        if (n < 0) {
                            n5 = this.getModel().indexOf(objectArray[n3]);
                            this.listSelectionModel.addSelectionInterval(n5, n5);
                            ++n3;
                            continue;
                        }
                        if (n > 0) {
                            n5 = this.getModel().indexOf(objectArray2[n4]);
                            this.listSelectionModel.removeSelectionInterval(n5, n5);
                            ++n4;
                            continue;
                        }
                        ++n3;
                        ++n4;
                    }
                    while (n3 < objectArray.length) {
                        n = this.getModel().indexOf(objectArray[n3]);
                        this.listSelectionModel.addSelectionInterval(n, n);
                        ++n3;
                    }
                    while (n4 < objectArray2.length) {
                        n = this.getModel().indexOf(objectArray2[n4]);
                        this.listSelectionModel.removeSelectionInterval(n, n);
                        ++n4;
                    }
                }
                finally {
                    this.listSelectionModel.setValueIsAdjusting(false);
                }
            }
        } else {
            int n;
            JFileChooser jFileChooser = this.getFileChooser();
            File file = null;
            file = this.isDirectorySelected() ? this.getDirectory() : jFileChooser.getSelectedFile();
            if (file != null && (n = this.getModel().indexOf(file)) >= 0) {
                this.listSelectionModel.setSelectionInterval(n, n);
                this.ensureIndexIsVisible(n);
            } else {
                this.listSelectionModel.clearSelection();
            }
        }
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser jFileChooser = this.getFileChooser();
        if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            if (fileArray.length > 1) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(this.fileNameString(fileArray[i]));
            if (fileArray.length <= 1) continue;
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    private void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        File file = (File)propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (file != null && (jFileChooser.isFileSelectionEnabled() && !file.isDirectory() || file.isDirectory() && jFileChooser.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(file));
            this.setFileSelected();
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        File[] fileArray = (File[])propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (fileArray != null && fileArray.length > 0 && (fileArray.length > 1 || jFileChooser.isDirectorySelectionEnabled() || !fileArray[0].isDirectory())) {
            this.setFileName(this.fileNameString(fileArray));
            this.setFileSelected();
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        this.ensureIndexIsVisible(0);
        File file = jFileChooser.getCurrentDirectory();
        if (file != null) {
            this.directoryComboBoxModel.addItem(file);
            this.getNewFolderAction().setEnabled(file.canWrite());
            this.getChangeToParentDirectoryAction().setEnabled(!fileSystemView.isRoot(file));
            if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
                if (fileSystemView.isFileSystem(file)) {
                    this.setFileName(file.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null && jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled() && jFileChooser.getFileSystemView().isFileSystem(file)) {
            this.setFileName(file.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doMultiSelectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.listSelectionModel.setSelectionMode(2);
        } else {
            this.listSelectionModel.setSelectionMode(0);
            this.listSelectionModel.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAccessoryPanel() != null) {
            JComponent jComponent;
            if (propertyChangeEvent.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
            }
            if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        if (jFileChooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    OracleFileChooserUI.this.doSelectedFileChanged(propertyChangeEvent);
                } else if (string.equals("SelectedFilesChangedProperty")) {
                    OracleFileChooserUI.this.doSelectedFilesChanged(propertyChangeEvent);
                } else if (string.equals("directoryChanged")) {
                    OracleFileChooserUI.this.doDirectoryChanged(propertyChangeEvent);
                } else if (string.equals("fileFilterChanged")) {
                    OracleFileChooserUI.this.doFilterChanged(propertyChangeEvent);
                } else if (string.equals("fileSelectionChanged")) {
                    OracleFileChooserUI.this.doFileSelectionModeChanged(propertyChangeEvent);
                } else if (string.equals("MultiSelectionEnabledChangedProperty")) {
                    OracleFileChooserUI.this.doMultiSelectionChanged(propertyChangeEvent);
                } else if (string.equals("AccessoryChangedProperty")) {
                    OracleFileChooserUI.this.doAccessoryChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonTextChangedProperty") || string.equals("ApproveButtonToolTipTextChangedProperty")) {
                    OracleFileChooserUI.this.doApproveButtonTextChanged(propertyChangeEvent);
                } else if (string.equals("DialogTypeChangedProperty")) {
                    OracleFileChooserUI.this.doDialogTypeChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                    OracleFileChooserUI.this.doApproveButtonMnemonicChanged(propertyChangeEvent);
                } else if (string.equals("ControlButtonsAreShownChangedProperty")) {
                    OracleFileChooserUI.this.doControlButtonsChanged(propertyChangeEvent);
                } else if (string.equals("CancelSelection")) {
                    OracleFileChooserUI.this.applyEdit();
                } else if (string.equals("componentOrientation")) {
                    ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                    JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                    if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                        jFileChooser.applyComponentOrientation(componentOrientation);
                    }
                    if (OracleFileChooserUI.this.detailsTable != null) {
                        OracleFileChooserUI.this.detailsTable.setComponentOrientation(componentOrientation);
                        OracleFileChooserUI.this.detailsTable.getParent().getParent().setComponentOrientation(componentOrientation);
                    }
                } else if (string.equals("ancestor") && propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() != null) {
                    OracleFileChooserUI.this.fileNameTextField.selectAll();
                    OracleFileChooserUI.this.fileNameTextField.requestFocus();
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    private void ensureIndexIsVisible(int n) {
        if (n >= 0) {
            this.list.ensureIndexIsVisible(n);
            if (this.detailsTable != null) {
                this.detailsTable.scrollRectToVisible(this.detailsTable.getCellRect(n, 0, true));
            }
        }
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        this.ensureIndexIsVisible(this.getModel().indexOf(file));
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getModel().validateFileCache();
    }

    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    public void setFileName(String string) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(string);
        }
    }

    protected void setDirectorySelected(boolean bl) {
        super.setDirectorySelected(bl);
        JFileChooser jFileChooser = this.getFileChooser();
        if (bl) {
            this.approveButton.setText(this.directoryOpenButtonText);
            this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
        } else {
            this.approveButton.setText(this.getApproveButtonText(jFileChooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String string) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getSelectedFile();
        if (!listSelectionEvent.getValueIsAdjusting() && file != null && !this.getFileChooser().isTraversable(file)) {
            this.setFileName(this.fileNameString(file));
        }
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    private static void groupLabels(AlignedLabel[] alignedLabelArray) {
        for (int i = 0; i < alignedLabelArray.length; ++i) {
            AlignedLabel.access$4202(alignedLabelArray[i], alignedLabelArray);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            String string = System.getProperty("java.version");
            if (string != null && string.startsWith("1.4")) {
                String string2 = AccessController.doPrivileged(new GetPropertyAction("swing.disableFileChooserSpeedFix"));
                disableFileChooserSpeedFixProperty = string2 != null && !string2.equalsIgnoreCase("false");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class KeyEventHandler
    extends KeyAdapter {
        private KeyEventHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                File file;
                if (keyEvent.getModifiers() != 2) {
                    return;
                }
                JFileChooser jFileChooser = OracleFileChooserUI.this.getFileChooser();
                if (jFileChooser.isDirectorySelectionEnabled() && (file = (File)OracleFileChooserUI.this.list.getSelectedValue()) != null) {
                    if (file.isDirectory()) {
                        jFileChooser.setCurrentDirectory(file);
                    }
                    keyEvent.consume();
                }
            }
        }
    }

    private class AlignedLabel
    extends JLabel {
        private AlignedLabel[] group;
        private int maxWidth = 0;

        AlignedLabel(String string) {
            super(string);
            this.setAlignmentX(0.0f);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 11, dimension.height);
        }

        private int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                int n;
                int n2 = 0;
                for (n = 0; n < this.group.length; ++n) {
                    n2 = Math.max(this.group[n].getSuperPreferredWidth(), n2);
                }
                for (n = 0; n < this.group.length; ++n) {
                    this.group[n].maxWidth = n2;
                }
            }
            return this.maxWidth;
        }

        private int getSuperPreferredWidth() {
            return super.getPreferredSize().width;
        }

        static /* synthetic */ AlignedLabel[] access$4202(AlignedLabel alignedLabel, AlignedLabel[] alignedLabelArray) {
            alignedLabel.group = alignedLabelArray;
            return alignedLabelArray;
        }
    }

    private static class ButtonAreaLayout
    implements LayoutManager {
        private int hGap = 5;
        private int topMargin = 17;

        private ButtonAreaLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Component[] componentArray = container.getComponents();
            if (componentArray != null && componentArray.length > 0) {
                int n;
                int n2;
                int n3 = componentArray.length;
                Dimension[] dimensionArray = new Dimension[n3];
                Insets insets = container.getInsets();
                int n4 = insets.top + this.topMargin;
                int n5 = 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    dimensionArray[n2] = componentArray[n2].getPreferredSize();
                    n5 = Math.max(n5, dimensionArray[n2].width);
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    n2 = container.getSize().width - insets.left - n5;
                    n = this.hGap + n5;
                } else {
                    n2 = insets.left;
                    n = -(this.hGap + n5);
                }
                for (int i = n3 - 1; i >= 0; --i) {
                    componentArray[i].setBounds(n2, n4, n5, dimensionArray[i].height);
                    n2 -= n;
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            Component[] componentArray;
            if (container != null && (componentArray = container.getComponents()) != null && componentArray.length > 0) {
                int n = componentArray.length;
                int n2 = 0;
                Insets insets = container.getInsets();
                int n3 = this.topMargin + insets.top + insets.bottom;
                int n4 = insets.left + insets.right;
                int n5 = 0;
                for (int i = 0; i < n; ++i) {
                    Dimension dimension = componentArray[i].getPreferredSize();
                    n2 = Math.max(n2, dimension.height);
                    n5 = Math.max(n5, dimension.width);
                }
                return new Dimension(n4 + n * n5 + (n - 1) * this.hGap, n3 + n2);
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = (File)OracleFileChooserUI.this.directoryComboBox.getSelectedItem();
            OracleFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = OracleFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (string == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                OracleFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                OracleFileChooserUI.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = OracleFileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                for (int i = 0; i < this.filters.length; ++i) {
                    if (this.filters[i] != fileFilter) continue;
                    bl = true;
                }
                if (!bl) {
                    OracleFileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return OracleFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return OracleFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null && object instanceof FileFilter) {
                this.setText(((FileFilter)object).getDescription());
            }
            return this;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = OracleFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File file = OracleFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.addItem(file);
            }
        }

        private void addItem(File file) {
            if (file == null) {
                return;
            }
            this.directories.clear();
            File[] fileArray = OracleFileChooserUI.this.useShellFolder ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(fileArray));
            File file2 = null;
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                file2 = file;
            }
            try {
                ShellFolder shellFolder;
                File file3 = shellFolder = ShellFolder.getShellFolder(file2);
                Vector<ShellFolder> vector = new Vector<ShellFolder>(10);
                do {
                    vector.addElement((ShellFolder)file3);
                } while ((file3 = ((File)file3).getParentFile()) != null);
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    file3 = (File)vector.get(i);
                    if (!this.directories.contains(file3)) continue;
                    int n2 = this.directories.indexOf(file3);
                    for (int j = i - 1; j >= 0; --j) {
                        this.directories.insertElementAt(vector.get(j), n2 + i - j);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(shellFolder);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i = 0; i < this.depths.length; ++i) {
                File file = (File)this.directories.get(i);
                File file2 = file.getParentFile();
                this.depths[i] = 0;
                if (file2 == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!file2.equals((File)this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int n) {
            return this.depths != null && n >= 0 && n < this.depths.length ? this.depths[n] : 0;
        }

        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int n) {
            return this.directories.elementAt(n);
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (component.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(component, graphics, n + this.depth * 10, n2);
            } else {
                this.icon.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Icon icon;
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object == null) {
                this.setText("");
                return this;
            }
            File file = (File)object;
            this.setText(OracleFileChooserUI.this.getFileChooser().getName(file));
            this.ii.icon = icon = OracleFileChooserUI.this.getFileChooser().getIcon(file);
            this.ii.depth = OracleFileChooserUI.this.directoryComboBoxModel.getDepth(n);
            this.setIcon(this.ii);
            return this;
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            File file = (File)object;
            String string = OracleFileChooserUI.this.getFileChooser().getName(file);
            this.setText(string);
            Icon icon = OracleFileChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            if (bl) {
                OracleFileChooserUI.this.editX = icon.getIconWidth() + 4;
            }
            return this;
        }
    }

    class EditActionListener
    implements ActionListener {
        EditActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OracleFileChooserUI.this.applyEdit();
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        JList list;

        public SingleClickListener(JList jList) {
            this.list = jList;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (mouseEvent.getClickCount() == 1) {
                    JFileChooser jFileChooser = OracleFileChooserUI.this.getFileChooser();
                    int n = this.list.locationToIndex(mouseEvent.getPoint());
                    if ((!jFileChooser.isMultiSelectionEnabled() || jFileChooser.getSelectedFiles().length <= 1) && n >= 0 && this.list.isSelectedIndex(n) && OracleFileChooserUI.this.getEditIndex() == n && OracleFileChooserUI.this.editFile == null) {
                        OracleFileChooserUI.this.editFileName(n);
                    } else if (n >= 0) {
                        OracleFileChooserUI.this.setEditIndex(n);
                    } else {
                        OracleFileChooserUI.this.resetEditIndex();
                    }
                } else {
                    OracleFileChooserUI.this.resetEditIndex();
                }
            }
        }
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        DelayedSelectionUpdater() {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            OracleFileChooserUI.this.setFileSelected();
        }
    }

    class DetailsTableCellRenderer
    extends DefaultTableCellRenderer {
        JFileChooser chooser;
        DateFormat df;

        DetailsTableCellRenderer(JFileChooser jFileChooser) {
            this.chooser = jFileChooser;
            this.df = DateFormat.getDateTimeInstance(3, 3, jFileChooser.getLocale());
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 1 || n2 == 4) {
                this.setHorizontalAlignment(11);
            } else {
                this.setHorizontalAlignment(10);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public void setValue(Object object) {
            this.setIcon(null);
            if (object instanceof File) {
                File file = (File)object;
                String string = this.chooser.getName(file);
                this.setText(string);
                Icon icon = this.chooser.getIcon(file);
                this.setIcon(icon);
            } else if (object instanceof Date) {
                this.setText(object == null ? "" : this.df.format((Date)object));
            } else {
                super.setValue(object);
            }
        }
    }

    class DetailsTableModel
    extends AbstractTableModel
    implements ListDataListener {
        String[] columnNames;
        JFileChooser chooser;
        ListModel listModel;

        DetailsTableModel(JFileChooser jFileChooser) {
            this.columnNames = new String[]{OracleFileChooserUI.this.fileNameHeaderText, OracleFileChooserUI.this.fileSizeHeaderText, OracleFileChooserUI.this.fileTypeHeaderText, OracleFileChooserUI.this.fileDateHeaderText, OracleFileChooserUI.this.fileAttrHeaderText};
            this.chooser = jFileChooser;
            this.listModel = OracleFileChooserUI.this.getModel();
            this.listModel.addListDataListener(this);
        }

        public int getRowCount() {
            return this.listModel.getSize();
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return class$java$io$File == null ? (class$java$io$File = OracleFileChooserUI.class$("java.io.File")) : class$java$io$File;
                }
                case 3: {
                    return class$java$util$Date == null ? (class$java$util$Date = OracleFileChooserUI.class$("java.util.Date")) : class$java$util$Date;
                }
            }
            return super.getColumnClass(n);
        }

        public Object getValueAt(int n, int n2) {
            File file = (File)this.listModel.getElementAt(n);
            switch (n2) {
                case 0: {
                    return file;
                }
                case 1: {
                    if (!file.exists() || file.isDirectory()) {
                        return null;
                    }
                    long l = file.length() / 1024L;
                    if (l < 1024L) {
                        return (l == 0L ? 1L : l) + " KB";
                    }
                    if ((l /= 1024L) < 1024L) {
                        return l + " MB";
                    }
                    return (l /= 1024L) + " GB";
                }
                case 2: {
                    if (!file.exists()) {
                        return null;
                    }
                    return this.chooser.getFileSystemView().getSystemTypeDescription(file);
                }
                case 3: {
                    if (!file.exists() || this.chooser.getFileSystemView().isFileSystemRoot(file)) {
                        return null;
                    }
                    long l = file.lastModified();
                    return l == 0L ? null : new Date(l);
                }
                case 4: {
                    if (!file.exists() || this.chooser.getFileSystemView().isFileSystemRoot(file)) {
                        return null;
                    }
                    String string = "";
                    if (!file.canWrite()) {
                        string = string + "R";
                    }
                    if (file.isHidden()) {
                        string = string + "H";
                    }
                    return string;
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                JFileChooser jFileChooser = OracleFileChooserUI.this.getFileChooser();
                File file = (File)this.getValueAt(n, n2);
                if (file != null) {
                    String string = jFileChooser.getName(file);
                    String string2 = file.getName();
                    String string3 = ((String)object).trim();
                    if (!string3.equals(string)) {
                        FileSystemView fileSystemView;
                        File file2;
                        int n3;
                        String string4 = string3;
                        int n4 = string2.length();
                        if (n4 > (n3 = string.length()) && string2.charAt(n3) == '.') {
                            string4 = string3 + string2.substring(n3);
                        }
                        if (!(file2 = (fileSystemView = jFileChooser.getFileSystemView()).createFileObject(file.getParentFile(), string4)).exists() && OracleFileChooserUI.this.getModel().renameFile(file, file2) && fileSystemView.isParent(jFileChooser.getCurrentDirectory(), file2)) {
                            if (jFileChooser.isMultiSelectionEnabled()) {
                                jFileChooser.setSelectedFiles(new File[]{file2});
                            } else {
                                jFileChooser.setSelectedFile(file2);
                            }
                        }
                    }
                }
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }
    }
}

