/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.shuttle;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.Reorderable;
import oracle.bali.ewt.shuttle.Shuttle;

class ShuttleDnDSupport
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
Transferable {
    private static final DataFlavor BogusSerializableData_FLAVOR = ShuttleDnDSupport.getFlavor(class$oracle$bali$ewt$shuttle$ShuttleDnDSupport$BogusSerializableData == null ? (class$oracle$bali$ewt$shuttle$ShuttleDnDSupport$BogusSerializableData = ShuttleDnDSupport.class$("oracle.bali.ewt.shuttle.ShuttleDnDSupport$BogusSerializableData")) : class$oracle$bali$ewt$shuttle$ShuttleDnDSupport$BogusSerializableData);
    private static final Image _DEFAULT_DRAG_IMAGE;
    private Shuttle _shuttle;
    private Component _sourceOfDrag;
    private DataFlavor[] _dataFlavors;
    private DragGestureRecognizer[] _dragGestureRecognizers;
    private DropTarget[] _droptargets;
    static /* synthetic */ Class class$oracle$bali$ewt$shuttle$ShuttleDnDSupport$BogusSerializableData;

    public ShuttleDnDSupport(Shuttle shuttle) {
        if (shuttle == null) {
            throw new IllegalArgumentException("Shuttle can't be null");
        }
        this._shuttle = shuttle;
        this._init();
    }

    public void dispose() {
        if (this._dragGestureRecognizers == null) {
            return;
        }
        if (this._dragGestureRecognizers[0] != null) {
            this._dragGestureRecognizers[0].setComponent(null);
        }
        if (this._dragGestureRecognizers[1] != null) {
            this._dragGestureRecognizers[1].setComponent(null);
        }
        if (this._droptargets[0] != null) {
            this._droptargets[0].setComponent(null);
        }
        if (this._droptargets[1] != null) {
            this._droptargets[1].setComponent(null);
        }
        this._dragGestureRecognizers = null;
        this._droptargets = null;
        this._sourceOfDrag = null;
        this._dataFlavors = null;
        this._shuttle = null;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Component component = dragGestureEvent.getComponent();
        ItemPicker itemPicker = this._getPickerForComp(component);
        if (itemPicker.isItemSelected() && ((ItemPickerDnD)((Object)itemPicker)).isOkayToDrag(dragGestureEvent.getDragOrigin())) {
            this._sourceOfDrag = component;
            dragGestureEvent.startDrag(null, _DEFAULT_DRAG_IMAGE, new Point(0, 0), this, this);
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        ItemPicker itemPicker = this._getPickerForComp(dropTargetDragEvent.getDropTargetContext().getComponent());
        ((ItemPickerDnD)((Object)itemPicker)).dragEnter(dropTargetDragEvent.getLocation(), this._handleDrag(dropTargetDragEvent));
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        ItemPicker itemPicker = this._getPickerForComp(dropTargetDragEvent.getDropTargetContext().getComponent());
        ((ItemPickerDnD)((Object)itemPicker)).dragOver(dropTargetDragEvent.getLocation(), this._handleDrag(dropTargetDragEvent));
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        ItemPicker itemPicker = this._getPickerForComp(dropTargetDragEvent.getDropTargetContext().getComponent());
        ((ItemPickerDnD)((Object)itemPicker)).dropActionChanged(dropTargetDragEvent.getLocation(), this._handleDrag(dropTargetDragEvent));
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        ItemPicker itemPicker = this._getPickerForComp(dropTargetEvent.getDropTargetContext().getComponent());
        ((ItemPickerDnD)((Object)itemPicker)).dragExit();
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        Component component = dropTargetDropEvent.getDropTargetContext().getComponent();
        ItemPicker itemPicker = this._getPickerForComp(component);
        ItemPickerDnD itemPickerDnD = (ItemPickerDnD)((Object)itemPicker);
        if (dropTargetDropEvent.isDataFlavorSupported(this._dataFlavors[0])) {
            boolean bl2 = component == this._sourceOfDrag;
            int n = 2;
            if (bl2) {
                if (itemPicker instanceof Reorderable) {
                    Transferable[] transferableArray = itemPicker.getAllSelectableItems();
                    Transferable[] transferableArray2 = itemPicker.getSelectedItems();
                    if (transferableArray2 != null && transferableArray != null && transferableArray2.length != transferableArray.length && (dropTargetDropEvent.getDropAction() & 2) != 0) {
                        bl = true;
                    }
                }
            } else {
                if (this._shuttle.getMode() == 1 && this._getPickerForComp(component) == this._shuttle.getToPicker()) {
                    n = 1;
                }
                if ((dropTargetDropEvent.getDropAction() & n) != 0) {
                    bl = true;
                }
            }
            if (bl && (bl = itemPickerDnD.isOkayToDrop(dropTargetDropEvent.getLocation()))) {
                dropTargetDropEvent.acceptDrop(n);
                itemPickerDnD.drop(dropTargetDropEvent.getLocation(), bl);
                dropTargetDropEvent.dropComplete(true);
                if (bl2) {
                    this._shuttle.__processDnDReorder(itemPicker);
                } else if (itemPicker == this._shuttle.getToPicker()) {
                    this._shuttle.__processMove();
                } else {
                    this._shuttle.__processRemove();
                }
            }
        }
        if (!bl) {
            dropTargetDropEvent.rejectDrop();
            itemPickerDnD.drop(dropTargetDropEvent.getLocation(), bl);
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this._dataFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this._dataFlavors[0] == dataFlavor || BogusSerializableData_FLAVOR.equals(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(dataFlavor)) {
            return null;
        }
        if (BogusSerializableData_FLAVOR.equals(dataFlavor)) {
            return null;
        }
        return null;
    }

    private boolean _handleDrag(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl = false;
        int n = 2;
        if (dropTargetDragEvent.isDataFlavorSupported(this._dataFlavors[0])) {
            Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
            ItemPickerDnD itemPickerDnD = (ItemPickerDnD)((Object)this._getPickerForComp(component));
            if (component == this._sourceOfDrag) {
                ItemPicker itemPicker = this._getPickerForComp(component);
                if (itemPicker instanceof Reorderable) {
                    Transferable[] transferableArray = itemPicker.getAllSelectableItems();
                    Transferable[] transferableArray2 = itemPicker.getSelectedItems();
                    if (transferableArray2 != null && transferableArray != null && transferableArray2.length != transferableArray.length && (dropTargetDragEvent.getDropAction() & 2) != 0) {
                        bl = true;
                    }
                }
            } else {
                if (this._shuttle.getMode() == 1 && this._getPickerForComp(component) == this._shuttle.getToPicker()) {
                    n = 1;
                }
                if ((dropTargetDragEvent.getDropAction() & n) != 0) {
                    bl = true;
                }
            }
            if (bl) {
                bl = itemPickerDnD.isOkayToDrop(dropTargetDragEvent.getLocation());
            }
        }
        if (bl) {
            dropTargetDragEvent.acceptDrag(n);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
        return bl;
    }

    private ItemPicker _getPickerForComp(Component component) {
        ItemPicker itemPicker = this._shuttle.getFromPicker();
        if (itemPicker instanceof ItemPickerDnD && component == ((ItemPickerDnD)((Object)itemPicker)).getDnDComponent()) {
            return this._shuttle.getFromPicker();
        }
        return this._shuttle.getToPicker();
    }

    private void _init() {
        Component component;
        ItemPicker itemPicker = this._shuttle.getFromPicker();
        ItemPicker itemPicker2 = this._shuttle.getToPicker();
        boolean bl = itemPicker instanceof ItemPickerDnD;
        boolean bl2 = itemPicker2 instanceof ItemPickerDnD;
        int n = 2;
        if (bl && bl2 && this._shuttle.getMode() == 1) {
            n = 1;
            if (itemPicker instanceof Reorderable) {
                n = 3;
            }
        }
        this._dragGestureRecognizers = new DragGestureRecognizer[2];
        this._droptargets = new DropTarget[2];
        if (bl && bl2 || bl && itemPicker instanceof Reorderable) {
            component = ((ItemPickerDnD)((Object)itemPicker)).getDnDComponent();
            this._dragGestureRecognizers[0] = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(component, n, this);
            this._droptargets[0] = new DropTarget(component, n, this);
        }
        if (bl && bl2 || bl2 && itemPicker2 instanceof Reorderable) {
            component = ((ItemPickerDnD)((Object)itemPicker2)).getDnDComponent();
            this._dragGestureRecognizers[1] = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(component, 2, this);
            this._droptargets[1] = new DropTarget(component, 2, this);
        }
        try {
            this._dataFlavors = new DataFlavor[]{new ShuttleDataFlavor(), BogusSerializableData_FLAVOR};
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static DataFlavor getFlavor(Class clazz) {
        try {
            return new DataFlavor("application/x-java-jvm-local-objectref; class=" + clazz.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static boolean _sNeedsNullDragImageWorkaround() {
        return "Mac OS X".equals(System.getProperty("os.name"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (ShuttleDnDSupport._sNeedsNullDragImageWorkaround()) {
            BufferedImage bufferedImage = new BufferedImage(1, 1, 6);
            bufferedImage.setRGB(0, 0, -16777216);
            _DEFAULT_DRAG_IMAGE = bufferedImage;
        } else {
            _DEFAULT_DRAG_IMAGE = null;
        }
    }

    private final class BogusSerializableData
    implements Serializable {
    }

    static interface ItemPickerDnD {
        public Component getDnDComponent();

        public boolean isOkayToDrag(Point var1);

        public boolean isOkayToDrop(Point var1);

        public void dragEnter(Point var1, boolean var2);

        public void dragOver(Point var1, boolean var2);

        public void dragExit();

        public void dropActionChanged(Point var1, boolean var2);

        public void drop(Point var1, boolean var2);

        public void processDnDReorder();
    }

    private class ShuttleDataFlavor
    extends DataFlavor {
        ShuttleDataFlavor() throws ClassNotFoundException {
            super("application/x-java-jvm-local-objectref;class=oracle.bali.ewt.shuttle.Shuttle");
        }

        public boolean equals(Object object) {
            if (object instanceof ShuttleDataFlavor) {
                return ShuttleDnDSupport.this._shuttle == ((ShuttleDataFlavor)object)._getShuttle();
            }
            return false;
        }

        private Shuttle _getShuttle() {
            return ShuttleDnDSupport.this._shuttle;
        }
    }
}

