/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.text;

import java.awt.Component;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.util.IntegerUtils;

public class NumberTextField
extends JTextField {
    private static final char _PLUS = '+';
    private static final String _PLUS_STRING = "+";
    private static final char _NULL_CHAR = '\u0000';
    private static final int _MAX_DECIMAL_DIGITS = 340;
    private Class _type;
    private boolean _signed = true;
    private boolean _decimal;
    private int _decimalDigits = -1;
    private DecimalFormat _format;
    private DecimalFormat _oldFormat;
    private static final Class _DEFAULT_CLASS = class$java$lang$Integer == null ? (class$java$lang$Integer = NumberTextField.class$("java.lang.Integer")) : class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;

    public NumberTextField() {
        this((Number)null);
    }

    public NumberTextField(Number number) {
        Class<?> clazz = number == null ? _DEFAULT_CLASS : number.getClass();
        this.setDataType(clazz);
        this.setNumber(number);
    }

    public NumberTextField(int n) {
        this((Number)null, n);
    }

    public NumberTextField(Number number, int n) {
        super(n);
        Class<?> clazz = number == null ? _DEFAULT_CLASS : number.getClass();
        this.setDataType(clazz);
        this.setNumber(number);
    }

    public Number getNumber() {
        Number number;
        String string = this.getText();
        try {
            number = this._getNumber(string);
        }
        catch (NumberFormatException numberFormatException) {
            number = null;
        }
        return number;
    }

    public void setNumber(Number number) {
        if (number == null) {
            this.setText("");
        } else {
            String string = this.convertNumberToString(this._parseNumber(number));
            this.setText(string);
        }
    }

    public void setDataType(Class clazz) {
        if (this._isDataTypeEqual(clazz)) {
            this._type = clazz;
            return;
        }
        Number number = this.getNumber();
        this._type = clazz;
        if (number != null) {
            this.setNumber(number);
        }
        this.setDecimal(this._isDecimal(this._type));
    }

    public Class getDataType() {
        return this._type;
    }

    public boolean isSigned() {
        return this._signed;
    }

    public void setSigned(boolean bl) {
        if (bl != this.isSigned()) {
            this._signed = bl;
            if (!bl) {
                DecimalFormatSymbols decimalFormatSymbols = this._getFormat().getDecimalFormatSymbols();
                char c = decimalFormatSymbols.getMinusSign();
                String string = this.getText();
                int n = string.indexOf(c);
                if (n != -1) {
                    this.setText(string.substring(n + 1));
                } else {
                    n = string.indexOf(43);
                    if (n != -1) {
                        this.setText(string.substring(n + 1));
                    }
                }
            }
        }
    }

    public boolean isDecimal() {
        return this._decimal;
    }

    public void setDecimal(boolean bl) {
        this.setDecimal(bl, -1);
    }

    public void setDecimal(boolean bl, int n) {
        Class clazz;
        if (bl && !this._isDecimal(clazz = this.getDataType())) {
            return;
        }
        if (n <= -1) {
            n = 340;
        }
        int n2 = this.getMaximumDecimalDigits();
        if (bl != this.isDecimal() || n != n2) {
            this._decimal = bl;
            if (n != n2) {
                this._format = null;
                this._decimalDigits = n;
                if (bl) {
                    this._getFormat();
                }
            }
            if (!bl) {
                DecimalFormatSymbols decimalFormatSymbols = this._getFormat().getDecimalFormatSymbols();
                char c = decimalFormatSymbols.getDecimalSeparator();
                String string = this.getText();
                int n3 = string.indexOf(c);
                String string2 = null;
                if (n3 != -1) {
                    if (n3 == 0) {
                        string2 = string.substring(1);
                    } else {
                        String string3 = string.substring(0, n3);
                        string2 = string3 + string.substring(n3 + 1);
                    }
                }
                if (string2 != null) {
                    this.setText(string2);
                }
            }
        }
    }

    public int getMaximumDecimalDigits() {
        return ((NumberFormat)this._getFormat()).getMaximumFractionDigits();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this._resetFormat();
    }

    public void replaceSelection(String string) {
        Document document = this.getDocument();
        String string2 = null;
        int n = -1;
        int n2 = -1;
        if (document != null) {
            try {
                Caret caret = this.getCaret();
                n = Math.min(caret.getDot(), caret.getMark());
                n2 = Math.max(caret.getDot(), caret.getMark());
                if (n != n2) {
                    string2 = document.getText(n, n2 - n);
                    document.remove(n, n2 - n);
                }
                if (string != null && string.length() > 0) {
                    document.insertString(n, string, null);
                }
            }
            catch (BadLocationException badLocationException) {
                if (string2 != null) {
                    try {
                        document.insertString(n, string2, null);
                        this.select(n, n2);
                    }
                    catch (BadLocationException badLocationException2) {
                        // empty catch block
                    }
                }
                this.getToolkit().beep();
            }
        }
    }

    protected Document createDefaultModel() {
        return new NumberTextFieldDocument();
    }

    protected boolean validateNumber(Number number) {
        return true;
    }

    protected String convertNumberToString(Number number) {
        if (this._format != null) {
            int n;
            int n2;
            String string;
            int n3;
            float f;
            if ((this._type == Float.TYPE || this._type == (class$java$lang$Float == null ? (class$java$lang$Float = NumberTextField.class$("java.lang.Float")) : class$java$lang$Float)) && ((f = number.floatValue()) <= 9999999.0f || f >= 0.001f) && (n3 = (string = number.toString()).indexOf(".")) != -1 && (n2 = string.substring(n3 + 1, string.length()).length()) < (n = this.getMaximumDecimalDigits())) {
                this._format.setMaximumFractionDigits(n2);
                String string2 = this._format.format(number);
                this._format.setMaximumFractionDigits(n);
                return string2;
            }
            return this._format.format(number);
        }
        return number.toString();
    }

    protected char getDecimalSeparator() {
        return '\u0000';
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleNumberTextField();
        }
        return this.accessibleContext;
    }

    private Number _getNumber(String string) throws NumberFormatException {
        Number number = null;
        if (string.startsWith(_PLUS_STRING)) {
            string = string.substring(1);
        }
        if (this._type == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberTextField.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            if ("".equals(string)) {
                throw new NumberFormatException();
            }
            return new BigDecimal(string);
        }
        if (this._type == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberTextField.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return new BigInteger(string);
        }
        DecimalFormat decimalFormat = this._getFormat();
        try {
            number = decimalFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new NumberFormatException();
        }
        Object var4_5 = null;
        if (this._type == Byte.TYPE || this._type == (class$java$lang$Byte == null ? (class$java$lang$Byte = NumberTextField.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            if (number.doubleValue() > 127.0 || number.doubleValue() < -128.0) {
                throw new NumberFormatException();
            }
            if (!(number instanceof Byte)) {
                number = new Byte(number.byteValue());
            }
        } else if (this._type == Short.TYPE || this._type == (class$java$lang$Short == null ? (class$java$lang$Short = NumberTextField.class$("java.lang.Short")) : class$java$lang$Short)) {
            if (number.doubleValue() > 32767.0 || number.doubleValue() < -32768.0) {
                throw new NumberFormatException();
            }
            if (!(number instanceof Short)) {
                number = new Short(number.shortValue());
            }
        } else if (this._type == Integer.TYPE || this._type == (class$java$lang$Integer == null ? (class$java$lang$Integer = NumberTextField.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            if (number.doubleValue() > 2.147483647E9 || number.doubleValue() < -2.147483648E9) {
                throw new NumberFormatException();
            }
            if (!(number instanceof Integer)) {
                number = IntegerUtils.getInteger((int)number.intValue());
            }
        } else if (this._type == Long.TYPE || this._type == (class$java$lang$Long == null ? (class$java$lang$Long = NumberTextField.class$("java.lang.Long")) : class$java$lang$Long)) {
            if (number.doubleValue() > 9.223372036854776E18 || number.doubleValue() < -9.223372036854776E18) {
                throw new NumberFormatException();
            }
            if (!(number instanceof Long)) {
                number = new Long(number.longValue());
            }
        } else if (this._type == Float.TYPE || this._type == (class$java$lang$Float == null ? (class$java$lang$Float = NumberTextField.class$("java.lang.Float")) : class$java$lang$Float)) {
            if (Math.abs(number.doubleValue()) > 3.4028234663852886E38 || number.doubleValue() != 0.0 && Math.abs(number.doubleValue()) < (double)1.4E-45f) {
                throw new NumberFormatException();
            }
            if (!(number instanceof Float)) {
                number = new Float(number.floatValue());
            }
        } else if (!(number instanceof Double)) {
            number = new Double(number.doubleValue());
        }
        return number;
    }

    private Number _parseNumber(Number number) {
        Number number2 = null;
        number2 = this._type == Byte.TYPE || this._type == (class$java$lang$Byte == null ? (class$java$lang$Byte = NumberTextField.class$("java.lang.Byte")) : class$java$lang$Byte) ? (Number)new Byte(number.byteValue()) : (Number)(this._type == Short.TYPE || this._type == (class$java$lang$Short == null ? (class$java$lang$Short = NumberTextField.class$("java.lang.Short")) : class$java$lang$Short) ? (Number)new Short(number.shortValue()) : (Number)(this._type == Integer.TYPE || this._type == (class$java$lang$Integer == null ? (class$java$lang$Integer = NumberTextField.class$("java.lang.Integer")) : class$java$lang$Integer) ? (Number)IntegerUtils.getInteger((int)number.intValue()) : (Number)(this._type == Long.TYPE || this._type == (class$java$lang$Long == null ? (class$java$lang$Long = NumberTextField.class$("java.lang.Long")) : class$java$lang$Long) ? (Number)new Long(number.longValue()) : (Number)(this._type == Float.TYPE || this._type == (class$java$lang$Float == null ? (class$java$lang$Float = NumberTextField.class$("java.lang.Float")) : class$java$lang$Float) ? (Number)new Float(number.floatValue()) : (Number)(this._type == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberTextField.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) ? (Number)(number instanceof BigDecimal ? number : (number instanceof BigInteger ? new BigDecimal((BigInteger)number) : new BigDecimal(number.doubleValue()))) : (Number)(this._type == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberTextField.class$("java.math.BigInteger")) : class$java$math$BigInteger) ? (Number)(number instanceof BigInteger ? number : new BigInteger(number.toString())) : (Number)new Double(number.doubleValue())))))));
        return number2;
    }

    private boolean _isDecimal(Class clazz) {
        return clazz == (class$java$lang$Double == null ? (class$java$lang$Double = NumberTextField.class$("java.lang.Double")) : class$java$lang$Double) || clazz == Double.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = NumberTextField.class$("java.lang.Float")) : class$java$lang$Float) || clazz == Float.TYPE || clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberTextField.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
    }

    private boolean _isDataTypeEqual(Class clazz) {
        return !(this._type != clazz && (this._type != (class$java$lang$Byte == null ? (class$java$lang$Byte = NumberTextField.class$("java.lang.Byte")) : class$java$lang$Byte) && this._type != Byte.TYPE || clazz != (class$java$lang$Byte == null ? (class$java$lang$Byte = NumberTextField.class$("java.lang.Byte")) : class$java$lang$Byte) && clazz != Byte.TYPE) && (this._type != (class$java$lang$Short == null ? (class$java$lang$Short = NumberTextField.class$("java.lang.Short")) : class$java$lang$Short) && this._type != Short.TYPE || clazz != (class$java$lang$Short == null ? (class$java$lang$Short = NumberTextField.class$("java.lang.Short")) : class$java$lang$Short) && clazz != Short.TYPE) && (this._type != (class$java$lang$Integer == null ? (class$java$lang$Integer = NumberTextField.class$("java.lang.Integer")) : class$java$lang$Integer) && this._type != Integer.TYPE || clazz != (class$java$lang$Integer == null ? (class$java$lang$Integer = NumberTextField.class$("java.lang.Integer")) : class$java$lang$Integer) && clazz != Integer.TYPE) && (this._type != (class$java$lang$Long == null ? (class$java$lang$Long = NumberTextField.class$("java.lang.Long")) : class$java$lang$Long) && this._type != Long.TYPE || clazz != (class$java$lang$Long == null ? (class$java$lang$Long = NumberTextField.class$("java.lang.Long")) : class$java$lang$Long) && clazz != Long.TYPE) && (this._type != (class$java$lang$Float == null ? (class$java$lang$Float = NumberTextField.class$("java.lang.Float")) : class$java$lang$Float) && this._type != Float.TYPE || clazz != (class$java$lang$Float == null ? (class$java$lang$Float = NumberTextField.class$("java.lang.Float")) : class$java$lang$Float) && clazz != Float.TYPE) && (this._type != (class$java$lang$Double == null ? (class$java$lang$Double = NumberTextField.class$("java.lang.Double")) : class$java$lang$Double) && this._type != Double.TYPE || clazz != (class$java$lang$Double == null ? (class$java$lang$Double = NumberTextField.class$("java.lang.Double")) : class$java$lang$Double) && clazz != Double.TYPE));
    }

    private synchronized void _resetFormat() {
        this._oldFormat = this._format;
        this._format = null;
        this._getFormat();
    }

    private synchronized DecimalFormat _getFormat() {
        if (this._format == null) {
            Number number = null;
            if (this._oldFormat != null) {
                try {
                    number = this._oldFormat.parse(this.getText());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
            this._format = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            ((NumberFormat)this._format).setGroupingUsed(false);
            this._format.setMaximumFractionDigits(this._decimalDigits);
            char c = this.getDecimalSeparator();
            if (c != '\u0000') {
                DecimalFormatSymbols decimalFormatSymbols = this._format.getDecimalFormatSymbols();
                decimalFormatSymbols.setDecimalSeparator(c);
                this._format.setDecimalFormatSymbols(decimalFormatSymbols);
            }
            if (number != null) {
                this.setNumber(number);
            }
        }
        return this._format;
    }

    private boolean _validateNumberString(String string, int n) {
        int n2;
        DecimalFormatSymbols decimalFormatSymbols = this._getFormat().getDecimalFormatSymbols();
        String string2 = this.getText();
        int n3 = string2.length();
        char c = decimalFormatSymbols.getMinusSign();
        char c2 = decimalFormatSymbols.getDecimalSeparator();
        int n4 = string2.indexOf(c);
        int n5 = string2.indexOf(43);
        int n6 = 0;
        int n7 = 0;
        while (n7 < string.length()) {
            n6 = n + n7;
            char c3 = string.charAt(n7);
            if (c3 >= '0' && c3 <= '9') {
                if (n6 == 0 && this.isSigned() && (n4 >= 0 || n5 >= 0)) {
                    return false;
                }
            } else if (c3 == c || c3 == '+') {
                if (!this.isSigned() || n6 != 0 || n4 >= 0 || n5 >= 0) {
                    return false;
                }
            } else if (c3 == c2 && this.isDecimal()) {
                int n8 = string2.indexOf(c2);
                if (n8 >= 0) {
                    return false;
                }
                if (this.isSigned() && n6 == 0 && (n4 >= 0 || n5 >= 0)) {
                    return false;
                }
            } else {
                return false;
            }
            ++n7;
        }
        String string3 = null;
        string3 = n == 0 ? string + string2 : (n >= n3 ? string2 + string : string2.substring(0, n) + string + string2.substring(n, n3));
        Number number = null;
        try {
            number = this._getNumber(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return string3.equals(String.valueOf('+')) || string3.equals(String.valueOf(c)) || string3.equals(String.valueOf(c2)) || string3.equals(String.valueOf('+') + c2) || string3.equals(String.valueOf(c) + c2);
        }
        if (string3 != null && (n2 = string3.indexOf(c2)) != -1) {
            int n9 = ((NumberFormat)this._getFormat()).getMaximumFractionDigits();
            if (string3.length() - n2 - 1 > n9) {
                return false;
            }
        }
        return this.validateNumber(number);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NumberTextFieldDocument
    extends PlainDocument {
        private NumberTextFieldDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || string.length() == 0) {
                return;
            }
            if (!NumberTextField.this._validateNumberString(string, n)) {
                throw new BadLocationException(null, n);
            }
            super.insertString(n, string, attributeSet);
        }
    }

    public class AccessibleNumberTextField
    extends JTextComponent.AccessibleJTextComponent
    implements AccessibleValue {
        public AccessibleNumberTextField() {
            super(NumberTextField.this);
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return NumberTextField.this.getNumber();
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (NumberTextField.this.validateNumber(number)) {
                NumberTextField.this.setNumber(number);
                return true;
            }
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SINGLE_LINE);
            return accessibleStateSet;
        }
    }
}

