/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.util;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;

public class WindowUtils {
    public static final int DIALOG_MAXIMUM_WIDTH;
    public static final int DIALOG_MAXIMUM_HEIGHT;
    private static WindowCloser _sWindowCloser;

    public static Window getActiveWindow() {
        return ActiveWindowTracker.getWindowTracker().getActiveWindow();
    }

    public static void registerApplet(Applet applet) {
        ActiveWindowTracker.getWindowTracker().registerApplet(applet);
    }

    public static void unregisterApplet(Applet applet) {
        ActiveWindowTracker.getWindowTracker().unregisterApplet(applet);
    }

    public static void registerWindow(Window window) {
        ActiveWindowTracker.getWindowTracker().registerWindow(window);
    }

    public static void unregisterWindow(Window window) {
        ActiveWindowTracker.getWindowTracker().unregisterWindow(window);
    }

    public static Window getWindow(Component component) {
        while (component != null) {
            if (component instanceof Window) {
                return (Window)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static Frame parentFrame(Component component) {
        while (component != null) {
            if (component instanceof Frame) {
                return (Frame)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static WindowListener getWindowCloser() {
        if (_sWindowCloser == null) {
            _sWindowCloser = new WindowCloser();
        }
        return _sWindowCloser;
    }

    public static void centerWindow(Window window) {
        int n;
        Dimension dimension = window.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = (dimension2.width - dimension.width) / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = (dimension2.height - dimension.height) / 2) < 0) {
            n = 0;
        }
        ((Component)window).setLocation(n2, n);
    }

    public static void centerWindow(Window window, Component component) {
        if (component == null || !component.isShowing()) {
            WindowUtils.centerWindow(window);
            return;
        }
        Point point = component.getLocationOnScreen();
        Dimension dimension = component.getSize();
        Dimension dimension2 = window.getSize();
        int n = point.x + (dimension.width - dimension2.width) / 2;
        int n2 = point.y + (dimension.height - dimension2.height) / 3;
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        if (n + dimension2.width > dimension3.width) {
            n = dimension3.width - dimension2.width;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 + dimension2.height > dimension3.height) {
            n2 = dimension3.height - dimension2.height;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        ((Component)window).setLocation(n, n2);
    }

    static boolean shouldRepaintOnActiveChange() {
        Object object = UIManager.getDefaults().get("LookAndFeel.requiresActiveChangeRepaint");
        return Boolean.TRUE.equals(object);
    }

    private WindowUtils() {
    }

    static {
        int n = 800;
        int n2 = 600;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width < n) {
            n = dimension.width;
        }
        if (dimension.height < n2) {
            n2 = dimension.height;
        }
        DIALOG_MAXIMUM_WIDTH = n;
        DIALOG_MAXIMUM_HEIGHT = n2;
    }

    private static class WindowCloser
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            windowEvent.getWindow().hide();
        }
    }

    private static class ActiveWindowTracker
    extends WindowAdapter {
        private static ActiveWindowTracker _sWindowTracker;
        private boolean _receivingAppletActivates = false;
        private Window _activeWindow;
        private Applet _applet;
        private Frame _appletFrame;

        private ActiveWindowTracker() {
        }

        static ActiveWindowTracker getWindowTracker() {
            if (_sWindowTracker == null) {
                _sWindowTracker = new ActiveWindowTracker();
            }
            return _sWindowTracker;
        }

        public void windowActivated(WindowEvent windowEvent) {
            Window window;
            boolean bl = WindowUtils.shouldRepaintOnActiveChange();
            Window window2 = windowEvent.getWindow();
            if (window2 == this._appletFrame) {
                this._receivingAppletActivates = true;
            }
            if ((window = this._activeWindow) != window2) {
                this._activeWindow = window2;
                if (bl) {
                    this._repaint(window2);
                }
                if (!this._receivingAppletActivates) {
                    if (window == null && this._appletFrame != null) {
                        if (bl) {
                            this._repaint(this._appletFrame);
                        }
                    } else if (this._applet != null && bl) {
                        this._repaint(this._applet);
                    }
                }
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            Applet applet;
            boolean bl = WindowUtils.shouldRepaintOnActiveChange();
            Window window = windowEvent.getWindow();
            if (window == this._appletFrame) {
                this._receivingAppletActivates = true;
            }
            if (window == this._activeWindow) {
                this._activeWindow = null;
            }
            if (bl) {
                this._repaint(window);
            }
            if (!this._receivingAppletActivates && (applet = this._applet) != null && bl) {
                applet.repaint(200L);
            }
        }

        public Window getActiveWindow() {
            if (!this._receivingAppletActivates && this._activeWindow == null) {
                return this._appletFrame;
            }
            return this._activeWindow;
        }

        public void registerWindow(Window window) {
            window.addWindowListener(this);
            if (this._activeWindow == null && window.getFocusOwner() != null) {
                this._activeWindow = window;
            }
        }

        public void unregisterWindow(Window window) {
            window.removeWindowListener(this);
        }

        public void registerApplet(Applet applet) {
            Frame frame;
            this._applet = applet;
            this._appletFrame = frame = WindowUtils.parentFrame(applet);
            if (frame != null) {
                WindowUtils.registerWindow(frame);
            }
        }

        public void unregisterApplet(Applet applet) {
            if (this._applet == applet) {
                WindowUtils.unregisterWindow(this._appletFrame);
                this._applet = null;
                this._appletFrame = null;
            }
        }

        private void _repaint(Container container) {
            if (container instanceof RootPaneContainer) {
                ((RootPaneContainer)((Object)container)).getRootPane().repaint();
            } else {
                container.repaint();
            }
            Component[] componentArray = container.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                Component component = componentArray[n];
                if (!JComponent.isLightweightComponent(component)) {
                    if (component instanceof Container) {
                        this._repaint((Container)component);
                    } else {
                        component.repaint();
                    }
                }
                ++n;
            }
        }
    }
}

