/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.validate;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.JComponent;
import oracle.bali.ewt.validate.DefaultValidationMessageModel;
import oracle.bali.ewt.validate.DefaultValidationPainter;
import oracle.bali.ewt.validate.NullValidationPainter;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessage;
import oracle.bali.ewt.validate.ValidationMessageModel;
import oracle.bali.ewt.validate.ValidationMessageModelEvent;
import oracle.bali.ewt.validate.ValidationMessageModelListener;
import oracle.bali.ewt.validate.ValidationPainter;
import oracle.bali.ewt.validate.Validator;
import oracle.bali.share.event.ListenerManager;

public abstract class AbstractValidationComponent
implements ValidationComponent {
    private Component _component;
    private ValidationMessageModel _model;
    private ValidationPainter _painter;
    private HashMap _validatorMap;
    private HashMap _msgMap;
    private PropertyChangeSupport _propertySupport;
    private ListenerManager _listenerManager;
    private Listener _listener;

    public AbstractValidationComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        this._component = component;
        this._validatorMap = new HashMap(1);
        this._msgMap = new HashMap(1);
        this._listener = new Listener();
        this.setValidationMessageModel(new DefaultValidationMessageModel());
        if (component instanceof JComponent) {
            this.setValidationPainter(DefaultValidationPainter.getValidationPainter());
        } else {
            this.setValidationPainter(NullValidationPainter.getValidationPainter());
        }
    }

    public Component getComponent() {
        return this._component;
    }

    public void addValidator(Object object, Validator validator) {
        ArrayList<Validator> arrayList = (ArrayList<Validator>)this._validatorMap.get(object);
        if (arrayList == null) {
            arrayList = new ArrayList<Validator>(2);
            this._validatorMap.put(object, arrayList);
        }
        if (!arrayList.contains(validator)) {
            arrayList.add(validator);
        }
    }

    public void removeValidator(Object object, Validator validator) {
        ArrayList arrayList = (ArrayList)this._validatorMap.get(object);
        if (arrayList != null) {
            ((AbstractCollection)arrayList).remove(validator);
        }
    }

    public Validator[] getValidators(Object object) {
        ArrayList arrayList = (ArrayList)this._validatorMap.get(object);
        if (arrayList != null) {
            return arrayList.toArray(new Validator[0]);
        }
        return null;
    }

    public void setValidationMessageModel(ValidationMessageModel validationMessageModel) {
        if (this._model != validationMessageModel) {
            ValidationMessageModel validationMessageModel2 = this._model;
            if (validationMessageModel2 != null) {
                validationMessageModel2.removeValidationMessageListener(this._listener);
            }
            if (validationMessageModel == null) {
                validationMessageModel = new DefaultValidationMessageModel();
            }
            this._model = validationMessageModel;
            this._model.addValidationMessageListener(this._listener);
            this.firePropertyChange("validationModel", validationMessageModel2, this._model);
        }
    }

    public ValidationMessageModel getValidationMessageModel() {
        return this._model;
    }

    public void setValidationPainter(ValidationPainter validationPainter) {
        if (validationPainter == null) {
            validationPainter = NullValidationPainter.getValidationPainter();
        }
        this._painter = validationPainter;
    }

    public ValidationPainter getValidationPainter() {
        return this._painter;
    }

    public void validateComponent(Object object) {
        Validator[] validatorArray = this.getValidators(object);
        if (validatorArray == null || validatorArray.length == 0) {
            return;
        }
        ValidationMessageModel validationMessageModel = this.getValidationMessageModel();
        Component component = this.getComponent();
        Object object2 = this.getData();
        ValidationMessageModel validationMessageModel2 = (ValidationMessageModel)this._msgMap.get(object);
        if (validationMessageModel2 != null) {
            validationMessageModel.removeValidationMessages(validationMessageModel2.getValidationMessages());
            validationMessageModel2.clear();
        } else {
            validationMessageModel2 = new DefaultValidationMessageModel();
            this._msgMap.put(object, validationMessageModel2);
        }
        int n = 0;
        while (n < validatorArray.length) {
            ValidationMessage[] validationMessageArray = validatorArray[n].validate(component, object2);
            if (validationMessageArray != null) {
                validationMessageModel.addValidationMessages(validationMessageArray);
                validationMessageModel2.addValidationMessages(validationMessageArray);
            }
            ++n;
        }
    }

    public boolean isValid() {
        return this.getValidationMessageModel().isEmpty();
    }

    public synchronized void addValidationMessageModelListener(ValidationMessageModelListener validationMessageModelListener) {
        if (this._listenerManager == null) {
            this._listenerManager = new ListenerManager();
        }
        this._listenerManager.addListener((EventListener)validationMessageModelListener);
    }

    public synchronized void removeValidationMessageModelListener(ValidationMessageModelListener validationMessageModelListener) {
        if (this._listenerManager != null) {
            this._listenerManager.removeListener((EventListener)validationMessageModelListener);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertySupport == null) {
            this._propertySupport = new PropertyChangeSupport(this);
        }
        this._propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertySupport != null) {
            this._propertySupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void paintValidationComponent() {
        this.getValidationPainter().paintComponent(this);
    }

    protected void fireValidationMessageEvent(int n, ValidationMessage validationMessage) {
        if (this._listenerManager != null) {
            Enumeration enumeration = this._listenerManager.getListeners();
            if (enumeration == null || !enumeration.hasMoreElements()) {
                return;
            }
            ValidationMessageModelEvent validationMessageModelEvent = new ValidationMessageModelEvent(this, n, validationMessage);
            switch (n) {
                case 2001: {
                    while (enumeration.hasMoreElements()) {
                        ((ValidationMessageModelListener)enumeration.nextElement()).messageAdded(validationMessageModelEvent);
                    }
                    break;
                }
                case 2002: {
                    while (enumeration.hasMoreElements()) {
                        ((ValidationMessageModelListener)enumeration.nextElement()).messageRemoved(validationMessageModelEvent);
                    }
                    break;
                }
            }
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._propertySupport != null) {
            this._propertySupport.firePropertyChange(string, object, object2);
        }
    }

    public abstract Object getData();

    private class Listener
    implements ValidationMessageModelListener {
        private Listener() {
        }

        public void messageAdded(ValidationMessageModelEvent validationMessageModelEvent) {
            AbstractValidationComponent.this.paintValidationComponent();
            AbstractValidationComponent.this.fireValidationMessageEvent(validationMessageModelEvent.getID(), validationMessageModelEvent.getMessage());
        }

        public void messageRemoved(ValidationMessageModelEvent validationMessageModelEvent) {
            AbstractValidationComponent.this.paintValidationComponent();
            AbstractValidationComponent.this.fireValidationMessageEvent(validationMessageModelEvent.getID(), validationMessageModelEvent.getMessage());
        }
    }
}

