/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.validate;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import oracle.bali.ewt.validate.ValidationMessage;
import oracle.bali.ewt.validate.ValidationMessageModel;
import oracle.bali.ewt.validate.ValidationMessageModelEvent;
import oracle.bali.ewt.validate.ValidationMessageModelListener;
import oracle.bali.share.event.ListenerManager;

public class DefaultValidationMessageModel
implements ValidationMessageModel {
    private ArrayList _messageList = new ArrayList();
    private int _errorCount = 0;
    private ListenerManager _listenerManager;

    public void addValidationMessage(ValidationMessage validationMessage) {
        if (validationMessage == null) {
            return;
        }
        if (validationMessage.getSeverity() == 1) {
            this._messageList.add(this._errorCount, validationMessage);
            ++this._errorCount;
        } else {
            this._messageList.add(validationMessage);
        }
        this.fireValidationMessageEvent(2001, validationMessage);
    }

    public void addValidationMessages(ValidationMessage[] validationMessageArray) {
        if (validationMessageArray == null) {
            return;
        }
        int n = 0;
        while (n < validationMessageArray.length) {
            this.addValidationMessage(validationMessageArray[n]);
            ++n;
        }
    }

    public void removeValidationMessage(ValidationMessage validationMessage) {
        if (validationMessage == null) {
            return;
        }
        if (((AbstractCollection)this._messageList).remove(validationMessage)) {
            if (validationMessage.getSeverity() == 1) {
                --this._errorCount;
            }
            this.fireValidationMessageEvent(2002, validationMessage);
        }
    }

    public void removeValidationMessages(ValidationMessage[] validationMessageArray) {
        if (validationMessageArray == null) {
            return;
        }
        int n = 0;
        while (n < validationMessageArray.length) {
            this.removeValidationMessage(validationMessageArray[n]);
            ++n;
        }
    }

    public void clear() {
        ValidationMessage[] validationMessageArray = this.getValidationMessages();
        this.removeValidationMessages(validationMessageArray);
    }

    public boolean isEmpty() {
        return this._messageList.isEmpty();
    }

    public int getMessageCount() {
        return this._messageList.size();
    }

    public int getMessageCount(int n) {
        if (n == 1) {
            return this._errorCount;
        }
        if (n == 2) {
            return this._messageList.size() - this._errorCount;
        }
        throw new IllegalArgumentException();
    }

    public ValidationMessage[] getValidationMessages() {
        return this._messageList.toArray(new ValidationMessage[0]);
    }

    public ValidationMessage[] getValidationMessages(int n) {
        if (n == 1) {
            List list = ((AbstractList)this._messageList).subList(0, this._errorCount);
            return list.toArray(new ValidationMessage[0]);
        }
        if (n == 2) {
            List list = ((AbstractList)this._messageList).subList(this._errorCount, this._messageList.size());
            return list.toArray(new ValidationMessage[0]);
        }
        throw new IllegalArgumentException();
    }

    public void addValidationMessageListener(ValidationMessageModelListener validationMessageModelListener) {
        if (this._listenerManager == null) {
            this._listenerManager = new ListenerManager();
        }
        this._listenerManager.addListener((EventListener)validationMessageModelListener);
    }

    public void removeValidationMessageListener(ValidationMessageModelListener validationMessageModelListener) {
        if (this._listenerManager != null) {
            this._listenerManager.removeListener((EventListener)validationMessageModelListener);
        }
    }

    protected void fireValidationMessageEvent(int n, ValidationMessage validationMessage) {
        if (this._listenerManager != null) {
            Enumeration enumeration = this._listenerManager.getListeners();
            if (enumeration == null || !enumeration.hasMoreElements()) {
                return;
            }
            ValidationMessageModelEvent validationMessageModelEvent = new ValidationMessageModelEvent(this, n, validationMessage);
            switch (n) {
                case 2001: {
                    while (enumeration.hasMoreElements()) {
                        ((ValidationMessageModelListener)enumeration.nextElement()).messageAdded(validationMessageModelEvent);
                    }
                    break;
                }
                case 2002: {
                    while (enumeration.hasMoreElements()) {
                        ((ValidationMessageModelListener)enumeration.nextElement()).messageRemoved(validationMessageModelEvent);
                    }
                    break;
                }
            }
        }
    }
}

