/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.validate;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessageModel;
import oracle.bali.ewt.validate.ValidationPainter;
import oracle.bali.share.collection.StringKey;

public class DefaultValidationPainter
implements ValidationPainter {
    private static final Object _VALIDATION_BORDER_KEY = new StringKey("_EWTValidationBorder");
    private static final Border _ERROR_BORDER = new ValidationBorder((Border)new LineBorder(new Color(153, 0, 0)), new LineBorder(new Color(255, 51, 51)));
    private static final Border _WARN_BORDER = new ValidationBorder((Border)new LineBorder(new Color(255, 141, 39)), new LineBorder(new Color(255, 204, 51)));
    private static ValidationPainter _sValidationPainter;

    protected DefaultValidationPainter() {
    }

    public static ValidationPainter getValidationPainter() {
        if (_sValidationPainter == null) {
            _sValidationPainter = new DefaultValidationPainter();
        }
        return _sValidationPainter;
    }

    public void paintComponent(ValidationComponent validationComponent) {
        if (validationComponent.isValid()) {
            this.paintValidState(validationComponent);
        } else {
            this.paintInValidState(validationComponent);
        }
    }

    public void paintInValidState(ValidationComponent validationComponent) {
        ValidationMessageModel validationMessageModel;
        Component component = validationComponent.getComponent();
        if (!(component instanceof JComponent)) {
            throw new IllegalArgumentException();
        }
        JComponent jComponent = (JComponent)component;
        Border border = jComponent.getBorder();
        if (!(border instanceof ValidationBorder)) {
            jComponent.putClientProperty(_VALIDATION_BORDER_KEY, border);
        }
        if ((validationMessageModel = validationComponent.getValidationMessageModel()).getMessageCount(1) > 0) {
            jComponent.setBorder(_ERROR_BORDER);
        } else if (validationMessageModel.getMessageCount(2) > 0) {
            jComponent.setBorder(_WARN_BORDER);
        }
    }

    public void paintValidState(ValidationComponent validationComponent) {
        Component component = validationComponent.getComponent();
        if (!(component instanceof JComponent)) {
            throw new IllegalArgumentException();
        }
        JComponent jComponent = (JComponent)component;
        if (jComponent.getBorder() instanceof ValidationBorder) {
            jComponent.setBorder((Border)jComponent.getClientProperty(_VALIDATION_BORDER_KEY));
        }
    }

    private static class ValidationBorder
    extends CompoundBorder {
        public ValidationBorder(Border border, LineBorder lineBorder) {
            super(border, lineBorder);
        }
    }
}

