/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.validate;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationManager;
import oracle.bali.share.collection.StringKey;

public class JTextValidationHandler {
    private static final JTextValidationHandler[] _HANDLER = new JTextValidationHandler[4];
    private static final Object _SOURCE_COMP_KEY = new StringKey("_EWTValidationTextComp");
    private Listener _listener = new Listener();
    private ArrayList _compList = new ArrayList();
    private ValidationManager _manager = new ValidationManager();
    private boolean _focusLostValidate;
    private boolean _textChangeValidate = true;

    public void registerComponent(ValidationComponent validationComponent) {
        if (validationComponent == null) {
            return;
        }
        Component component = validationComponent.getComponent();
        if (!(component instanceof JTextComponent)) {
            throw new IllegalArgumentException();
        }
        JTextComponent jTextComponent = (JTextComponent)component;
        this._compList.add(jTextComponent);
        this._putValidationComponent(jTextComponent, validationComponent);
        Document document = jTextComponent.getDocument();
        if (document != null) {
            document.putProperty(_SOURCE_COMP_KEY, jTextComponent);
        }
        jTextComponent.addPropertyChangeListener(this._listener);
        document.addDocumentListener(this._listener);
        jTextComponent.addFocusListener(this._listener);
    }

    public void unregisterComponent(ValidationComponent validationComponent) {
        if (validationComponent == null) {
            return;
        }
        Component component = validationComponent.getComponent();
        if (!(component instanceof JTextComponent)) {
            throw new IllegalArgumentException();
        }
        JTextComponent jTextComponent = (JTextComponent)component;
        if (((AbstractCollection)this._compList).remove(jTextComponent)) {
            this._putValidationComponent(jTextComponent, null);
            Document document = jTextComponent.getDocument();
            if (document != null) {
                document.putProperty(_SOURCE_COMP_KEY, null);
            }
            jTextComponent.removePropertyChangeListener(this._listener);
            document.removeDocumentListener(this._listener);
            jTextComponent.removeFocusListener(this._listener);
        }
    }

    private void _putValidationComponent(Component component, ValidationComponent validationComponent) {
        this._manager.putValidationComponent(component, validationComponent);
    }

    private ValidationComponent _getValidationComponent(Component component) {
        return this._manager.getValidationComponent(component);
    }

    private class Listener
    implements PropertyChangeListener,
    FocusListener,
    DocumentListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("document".equals(propertyChangeEvent.getPropertyName())) {
                Document document;
                Document document2 = (Document)propertyChangeEvent.getOldValue();
                JTextComponent jTextComponent = null;
                if (document2 != null) {
                    jTextComponent = (JTextComponent)document2.getProperty(_SOURCE_COMP_KEY);
                    document2.putProperty(_SOURCE_COMP_KEY, null);
                    document2.removeDocumentListener(this);
                }
                if ((document = (Document)propertyChangeEvent.getNewValue()) != null) {
                    document.putProperty(_SOURCE_COMP_KEY, jTextComponent);
                    document.addDocumentListener(this);
                }
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            ValidationComponent validationComponent = JTextValidationHandler.this._getValidationComponent(focusEvent.getComponent());
            if (validationComponent != null) {
                validationComponent.validateComponent(ValidationComponent.DEFAULT_VALIDATOR);
                validationComponent.validateComponent(ValidationComponent.FOCUS_CHANGE_VALIDATOR);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this._textChanged(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this._textChanged(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this._textChanged(documentEvent);
        }

        private void _textChanged(DocumentEvent documentEvent) {
            Component component = (Component)documentEvent.getDocument().getProperty(_SOURCE_COMP_KEY);
            ValidationComponent validationComponent = JTextValidationHandler.this._getValidationComponent(component);
            if (validationComponent != null) {
                validationComponent.validateComponent(ValidationComponent.DEFAULT_VALIDATOR);
                validationComponent.validateComponent(ValidationComponent.MODEL_CHANGE_VALIDATOR);
            }
        }
    }
}

