/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.validate;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.View;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationManager;
import oracle.bali.ewt.validate.ValidationMessage;
import oracle.bali.ewt.validate.ValidationMessageModel;
import oracle.bali.ewt.validate.ValidationMessageModelEvent;
import oracle.bali.ewt.validate.ValidationMessageModelListener;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;

public class ValidationMessagePane
extends LWComponent
implements Accessible {
    public static final String PANE_EMPTY = new String("paneEmpty");
    private static final String _LABELED_BY_PROPERTY = "labeledBy";
    private static final String _BUNDLE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _MESSAGE_KEY = "VALIDATION.MESSAGES";
    private static final Icon[] _ICONS = new Icon[2];
    private static final String[] _ICON_NAME = new String[]{"icons/error.png", "icons/warning.png"};
    private static final Border _MSG_TEXT_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Border _MSG_ICON_BORDER = new EmptyBorder(0, 3, 0, 0);
    private static final Color _ERROR_BG = new Color(255, 204, 204);
    private static final Color _WARN_BG = new Color(255, 255, 204);
    private static final String[] _VALIDATION_MESSAGE_ARR = new String[]{"VALIDATION_MESSAGE.ERROR_MNEMONIC", "VALIDATION_MESSAGE.WARNING_MNEMONIC", "VALIDATION_MESSAGE.ERROR", "VALIDATION_MESSAGE.WARNING"};
    private static final String _ACCESS_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private Listener _listener = new Listener();
    private JList _list;
    private DefaultListModel _model;
    private JLabel _messageLabel;
    private AccessibleJLabel _accessibleLabel;
    private ArrayList _comps;
    private HashMap _indexMap;
    private ValidationManager _manager;
    private Component _selectedComp;
    private Color _originalBg;
    private boolean _isEmpty;

    public ValidationMessagePane() {
        this._createUI();
        this._comps = new ArrayList();
        this._indexMap = new HashMap();
        this._manager = new ValidationManager();
        this._isEmpty = true;
    }

    public void addValidationComponent(ValidationComponent validationComponent) {
        if (!this._comps.contains(validationComponent)) {
            Component component = validationComponent.getComponent();
            this._comps.add(validationComponent);
            this._putValidationComponent(component, validationComponent);
            this._indexMap.put(validationComponent, IntegerUtils.getInteger((int)this._model.getSize()));
            this._addValidationMessageModel(validationComponent, validationComponent.getValidationMessageModel());
            validationComponent.addValidationMessageModelListener(this._listener);
            validationComponent.addPropertyChangeListener(this._listener);
            component.addFocusListener(this._listener);
        }
    }

    public void removeValidationComponent(ValidationComponent validationComponent) {
        if (((AbstractCollection)this._comps).remove(validationComponent)) {
            Component component = validationComponent.getComponent();
            this._putValidationComponent(component, null);
            ValidationMessageModel validationMessageModel = validationComponent.getValidationMessageModel();
            this._removeValidationMessageModel(validationComponent, validationComponent.getValidationMessageModel());
            this._updateIndex(validationComponent, -validationMessageModel.getMessageCount());
            this._indexMap.remove(validationComponent);
            validationComponent.removeValidationMessageModelListener(this._listener);
            validationComponent.removePropertyChangeListener(this._listener);
            component.removeFocusListener(this._listener);
        }
    }

    public void removeAllValidationComponents() {
        int n = this._comps.size();
        int n2 = 0;
        while (n2 < n) {
            ValidationComponent validationComponent = (ValidationComponent)this._comps.get(n2);
            validationComponent.removeValidationMessageModelListener(this._listener);
            validationComponent.removePropertyChangeListener(this._listener);
            validationComponent.getComponent().removeFocusListener(this._listener);
            ++n2;
        }
        this._model.removeAllElements();
        this._comps.clear();
        this._indexMap.clear();
    }

    public int getMessageCount() {
        return this._model.size();
    }

    public boolean isEmpty() {
        return this._isEmpty;
    }

    public void dispose() {
        this.removeAllValidationComponents();
        this._listener = null;
        this._comps = null;
        this._manager = null;
        this._indexMap = null;
        this._messageLabel = null;
        this._list.removeListSelectionListener(this._listener);
        this._list.removeFocusListener(this._listener);
        this._model.removeListDataListener(this._listener);
        this._model = null;
        this._list = null;
    }

    public void addNotify() {
        super.addNotify();
        this._updateMessageLabel();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this._updateMessageLabel();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJValidatePane();
            StatusBar statusBar = new StatusBar();
            this._accessibleLabel = new AccessibleJLabel();
            statusBar.add(this._accessibleLabel);
            statusBar.setPreferredSize(new Dimension(0, 0));
            this.add((Component)statusBar, "South");
        }
        return this.accessibleContext;
    }

    protected String getComponentName(ValidationComponent validationComponent) {
        JComponent jComponent;
        JLabel jLabel;
        Component component = validationComponent.getComponent();
        if (component instanceof JComponent && (jLabel = (JLabel)(jComponent = (JComponent)component).getClientProperty(_LABELED_BY_PROPERTY)) != null) {
            return jLabel.getText();
        }
        return component.getName();
    }

    private void _createUI() {
        this._model = new DefaultListModel();
        this._list = new JList(this._model){

            public boolean getScrollableTracksViewportWidth() {
                return true;
            }
        };
        this._list.setVisibleRowCount(3);
        this._list.setSelectionMode(1);
        this._list.setCellRenderer(new CellRenderer());
        this._list.addListSelectionListener(this._listener);
        this._list.addFocusListener(this._listener);
        this._model.addListDataListener(this._listener);
        this._messageLabel = new JLabel();
        this._messageLabel.setLabelFor(this._list);
        JScrollPane jScrollPane = new JScrollPane(this._list, 20, 31);
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this._messageLabel, "North");
        this.add(jScrollPane);
    }

    private void _updateMessageLabel() {
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_BUNDLE, locale);
        String string = resourceBundle.getString(_MESSAGE_KEY);
        this._messageLabel.setText(StringUtils.stripMnemonic((String)string));
        this._messageLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
    }

    private void _addValidationMessageModel(ValidationComponent validationComponent, ValidationMessageModel validationMessageModel) {
        if (!validationMessageModel.isEmpty()) {
            int n = (Integer)this._indexMap.get(validationComponent);
            ValidationMessage[] validationMessageArray = validationMessageModel.getValidationMessages();
            int n2 = 0;
            while (n2 < validationMessageArray.length) {
                this._model.add(n, new ListItem(validationComponent, validationMessageArray[n2]));
                ++n2;
            }
        }
    }

    private void _removeValidationMessageModel(ValidationComponent validationComponent, ValidationMessageModel validationMessageModel) {
        if (!validationMessageModel.isEmpty()) {
            int n = (Integer)this._indexMap.get(validationComponent);
            this._model.removeRange(n, n + validationMessageModel.getMessageCount() - 1);
        }
    }

    private void _updateIndex(ValidationComponent validationComponent, int n) {
        int n2 = this._comps.size();
        int n3 = this._comps.indexOf(validationComponent);
        if (n3 != -1) {
            int n4 = n3 + 1;
            while (n4 < n2) {
                ValidationComponent validationComponent2 = (ValidationComponent)this._comps.get(n4);
                int n5 = (Integer)this._indexMap.get(validationComponent2);
                this._indexMap.put(validationComponent2, IntegerUtils.getInteger((int)(n5 + n)));
                ++n4;
            }
        }
    }

    private void _checkPaneIsEmpty() {
        boolean bl;
        boolean bl2 = bl = this._model.getSize() == 0;
        if (bl != this._isEmpty) {
            this._isEmpty = bl;
            this.firePropertyChange(PANE_EMPTY, !this._isEmpty, this._isEmpty);
        }
    }

    private void _putValidationComponent(Component component, ValidationComponent validationComponent) {
        this._manager.putValidationComponent(component, validationComponent);
    }

    private ValidationComponent _getValidationComponent(Component component) {
        return this._manager.getValidationComponent(component);
    }

    private String _getAccessibleName(ListItem listItem) {
        Object[] objectArray;
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_ACCESS_BUNDLE, locale);
        ValidationComponent validationComponent = listItem.getValidationComponent();
        Component component = validationComponent.getComponent();
        JLabel jLabel = null;
        if (component instanceof JComponent) {
            jLabel = (JLabel)((JComponent)component).getClientProperty(_LABELED_BY_PROPERTY);
        }
        String string = this._getValidationMessageText(listItem);
        int n = jLabel == null ? 0 : jLabel.getDisplayedMnemonic();
        int n2 = 0;
        if (n != 0) {
            objectArray = new String[2];
            int n3 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4 ? 2 : 8;
            objectArray[0] = string;
            objectArray[1] = KeyEvent.getKeyModifiersText(n3) + KeyEvent.getKeyText(n);
            if (listItem.getMessage().getSeverity() == 2) {
                ++n2;
            }
        } else {
            objectArray = new String[]{string};
            n2 = 2;
            if (listItem.getMessage().getSeverity() == 2) {
                ++n2;
            }
        }
        return MessageFormat.format(resourceBundle.getString(_VALIDATION_MESSAGE_ARR[n2]), objectArray);
    }

    private String _getValidationMessageText(ListItem listItem) {
        String string = this.getComponentName(listItem.getValidationComponent());
        ValidationMessage validationMessage = listItem.getMessage();
        string = string != null && !"".equals(string) ? string + validationMessage.getMessage() : validationMessage.getMessage();
        return string;
    }

    private class AccessibleJLabel
    extends JLabel {
        private AccessibleJLabel() {
        }

        public void setText(String string) {
            super.setText(string);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleName", "", string);
            }
        }
    }

    private class AccessibleJValidatePane
    extends JComponent.AccessibleJComponent {
        private AccessibleJValidatePane() {
            super(ValidationMessagePane.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private class Listener
    implements FocusListener,
    ListDataListener,
    ListSelectionListener,
    PropertyChangeListener,
    ValidationMessageModelListener {
        private Listener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getComponent() == ValidationMessagePane.this._list) {
                ValidationMessagePane.this._list.setSelectionMode(1);
                if (ValidationMessagePane.this._selectedComp != null) {
                    this._restoreBackground(ValidationMessagePane.this._selectedComp);
                    ValidationMessagePane.this._selectedComp = null;
                }
            } else if (FocusUtils.getOppositeComponent(focusEvent) != ValidationMessagePane.this._list) {
                ValidationMessagePane.this._list.clearSelection();
                ValidationMessagePane.this._list.repaint();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (component == ValidationMessagePane.this._list) {
                ValidationMessagePane.this._list.setSelectionMode(0);
                ListItem listItem = (ListItem)ValidationMessagePane.this._list.getSelectedValue();
                if (listItem == null) {
                    if (ValidationMessagePane.this._list.getModel().getSize() > 0) {
                        ValidationMessagePane.this._list.setSelectedIndex(0);
                    }
                } else {
                    ValidationComponent validationComponent = listItem.getValidationComponent();
                    ValidationMessagePane.this._selectedComp = validationComponent.getComponent();
                    ValidationMessagePane.this._originalBg = ValidationMessagePane.this._selectedComp.getBackground();
                    if (validationComponent.getValidationMessageModel().getMessageCount(1) != 0) {
                        ValidationMessagePane.this._selectedComp.setBackground(_ERROR_BG);
                    } else {
                        ValidationMessagePane.this._selectedComp.setBackground(_WARN_BG);
                    }
                }
            } else {
                ValidationMessageModel validationMessageModel;
                int n;
                ValidationComponent validationComponent = ValidationMessagePane.this._getValidationComponent(component);
                if (validationComponent != null && (n = (validationMessageModel = validationComponent.getValidationMessageModel()).getMessageCount()) > 0) {
                    int n2 = (Integer)ValidationMessagePane.this._indexMap.get(validationComponent);
                    ValidationMessagePane.this._list.setSelectionInterval(n2, n2 + n - 1);
                    ValidationMessagePane.this._list.repaint();
                }
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ValidationMessagePane.this._list.hasFocus()) {
                ListItem listItem = (ListItem)ValidationMessagePane.this._list.getSelectedValue();
                if (listItem != null) {
                    ValidationComponent validationComponent = listItem.getValidationComponent();
                    Component component = validationComponent.getComponent();
                    if (component != ValidationMessagePane.this._selectedComp) {
                        if (ValidationMessagePane.this._selectedComp != null) {
                            this._restoreBackground(ValidationMessagePane.this._selectedComp);
                        }
                        ValidationMessagePane.this._selectedComp = component;
                        ValidationMessagePane.this._originalBg = ValidationMessagePane.this._selectedComp.getBackground();
                    }
                    if (validationComponent.getValidationMessageModel().getMessageCount(1) != 0) {
                        ValidationMessagePane.this._selectedComp.setBackground(_ERROR_BG);
                    } else {
                        ValidationMessagePane.this._selectedComp.setBackground(_WARN_BG);
                    }
                    if (ValidationMessagePane.this._list.getSelectedIndex() == 0) {
                        JViewport jViewport = (JViewport)ValidationMessagePane.this._list.getParent();
                        if (jViewport.getViewPosition().y != 0) {
                            jViewport.setViewPosition(new Point(0, 0));
                        }
                    }
                } else if (ValidationMessagePane.this._selectedComp != null) {
                    this._restoreBackground(ValidationMessagePane.this._selectedComp);
                    ValidationMessagePane.this._selectedComp = null;
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ValidationComponent validationComponent = (ValidationComponent)propertyChangeEvent.getSource();
            if ("validationModel".equals(propertyChangeEvent.getPropertyName())) {
                ValidationMessageModel validationMessageModel = (ValidationMessageModel)propertyChangeEvent.getOldValue();
                ValidationMessagePane.this._removeValidationMessageModel(validationComponent, validationMessageModel);
                ValidationMessageModel validationMessageModel2 = (ValidationMessageModel)propertyChangeEvent.getNewValue();
                ValidationMessagePane.this._addValidationMessageModel(validationComponent, validationMessageModel2);
                int n = validationMessageModel2.getMessageCount() - validationMessageModel.getMessageCount();
                ValidationMessagePane.this._updateIndex(validationComponent, n);
            }
        }

        public void messageAdded(ValidationMessageModelEvent validationMessageModelEvent) {
            ValidationComponent validationComponent = (ValidationComponent)validationMessageModelEvent.getSource();
            ValidationMessage validationMessage = validationMessageModelEvent.getMessage();
            ValidationMessageModel validationMessageModel = validationComponent.getValidationMessageModel();
            int n = (Integer)ValidationMessagePane.this._indexMap.get(validationComponent);
            ListItem listItem = new ListItem(validationComponent, validationMessage);
            if (validationMessage.getSeverity() == 1) {
                ValidationMessagePane.this._model.add(n + validationMessageModel.getMessageCount(1) - 1, listItem);
            } else {
                ValidationMessagePane.this._model.add(n + validationMessageModel.getMessageCount() - 1, listItem);
            }
            ValidationMessagePane.this._updateIndex(validationComponent, 1);
            if (ValidationMessagePane.this._accessibleLabel != null) {
                ValidationMessagePane.this._accessibleLabel.setText(ValidationMessagePane.this._getAccessibleName(listItem));
            }
        }

        public void messageRemoved(ValidationMessageModelEvent validationMessageModelEvent) {
            ValidationComponent validationComponent = (ValidationComponent)validationMessageModelEvent.getSource();
            ValidationMessageModel validationMessageModel = validationComponent.getValidationMessageModel();
            ValidationMessage validationMessage = validationMessageModelEvent.getMessage();
            ListItem listItem = new ListItem(validationComponent, validationMessage);
            if (validationMessage.getSeverity() == 1) {
                ValidationMessagePane.this._model.removeElement(listItem);
            } else {
                ValidationMessagePane.this._model.removeElement(listItem);
            }
            ValidationMessagePane.this._updateIndex(validationComponent, -1);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            ValidationMessagePane.this._checkPaneIsEmpty();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            ValidationMessagePane.this._checkPaneIsEmpty();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
        }

        private void _restoreBackground(Component component) {
            component.setBackground(ValidationMessagePane.this._originalBg);
        }
    }

    private class CellRenderer
    extends JPanel
    implements ListCellRenderer {
        private JLabel _iconLabel;
        private JTextArea _messageTextArea;
        private int _messageWidth;
        static /* synthetic */ Class class$oracle$bali$ewt$validate$ValidationMessagePane;

        public CellRenderer() {
            this.setOpaque(true);
            this._iconLabel = new JLabel();
            this._iconLabel.setOpaque(true);
            this._iconLabel.setBorder(_MSG_ICON_BORDER);
            this._messageTextArea = new JTextArea();
            this._messageTextArea.setLineWrap(true);
            this._messageTextArea.setWrapStyleWord(true);
            this._messageTextArea.setOpaque(true);
            this._messageTextArea.setBorder(_MSG_TEXT_BORDER);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            this.add((Component)this._iconLabel, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            this.add((Component)this._messageTextArea, gridBagConstraints);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            ListItem listItem = (ListItem)object;
            ValidationMessage validationMessage = listItem.getMessage();
            this._iconLabel.setIcon(this._getIcon(validationMessage.getSeverity()));
            String string = ValidationMessagePane.this._getValidationMessageText(listItem);
            this._messageTextArea.setText(string);
            Dimension dimension = this._messageTextArea.getSize();
            if (dimension.width == 0 && dimension.height == 0) {
                object2 = ValidationMessagePane.this.getInsets();
                this._messageWidth = ValidationMessagePane.this.getWidth() - (((Insets)object2).right + ((Insets)object2).left) - this._iconLabel.getPreferredSize().width;
            }
            object2 = this._messageTextArea.getUI().getRootView(this._messageTextArea);
            ((View)object2).setSize(this._messageWidth, Float.MAX_VALUE);
            int n2 = (int)((View)object2).getPreferredSpan(1);
            Insets insets = this._messageTextArea.getInsets();
            n2 = insets.top + insets.bottom + n2;
            this._messageTextArea.setPreferredSize(new Dimension(this._messageWidth, n2));
            boolean bl3 = jList.isEnabled();
            this._messageTextArea.setEnabled(bl3);
            this._iconLabel.setEnabled(bl3);
            this._messageTextArea.setFont(jList.getFont());
            Border border = null;
            if (bl2) {
                if (bl) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = _MSG_TEXT_BORDER;
            }
            this._messageTextArea.setBorder(border);
            if (bl) {
                this._messageTextArea.setBackground(jList.getSelectionBackground());
                this._messageTextArea.setForeground(jList.getSelectionForeground());
            } else {
                this._messageTextArea.setBackground(jList.getBackground());
                this._messageTextArea.setForeground(jList.getForeground());
            }
            Color color = jList.getBackground();
            this._iconLabel.setBackground(color);
            this.setBackground(color);
            return this;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new Access();
            }
            return this.accessibleContext;
        }

        private Icon _getIcon(int n) {
            int n2 = n == 1 ? 0 : 1;
            Icon icon = _ICONS[n2];
            if (_ICONS[n2] == null) {
                _ICONS[n2] = new ImageIcon(ImageUtils.getImageResource(class$oracle$bali$ewt$validate$ValidationMessagePane == null ? (class$oracle$bali$ewt$validate$ValidationMessagePane = CellRenderer.class$("oracle.bali.ewt.validate.ValidationMessagePane")) : class$oracle$bali$ewt$validate$ValidationMessagePane, _ICON_NAME[n2]));
            }
            return _ICONS[n2];
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private class Access
        extends JPanel.AccessibleJPanel {
            private Access() {
                super(CellRenderer.this);
            }

            public String getAccessibleName() {
                ListItem listItem = (ListItem)ValidationMessagePane.this._list.getSelectedValue();
                if (listItem != null) {
                    return ValidationMessagePane.this._getAccessibleName(listItem);
                }
                return null;
            }
        }
    }

    private class ListItem {
        private ValidationComponent _component;
        private ValidationMessage _message;

        public ListItem(ValidationComponent validationComponent, ValidationMessage validationMessage) {
            this._component = validationComponent;
            this._message = validationMessage;
        }

        public ValidationComponent getValidationComponent() {
            return this._component;
        }

        public ValidationMessage getMessage() {
            return this._message;
        }

        public boolean equals(Object object) {
            if (object instanceof ListItem) {
                ListItem listItem = (ListItem)object;
                return this.getValidationComponent().equals(listItem.getValidationComponent()) && this.getMessage().equals(listItem.getMessage());
            }
            return false;
        }

        public String toString() {
            return ValidationMessagePane.this._getValidationMessageText(this);
        }
    }
}

