/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.elaf.EWTWizardUI;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessagePane;
import oracle.bali.ewt.wizard.AccessibleLWComponent;
import oracle.bali.ewt.wizard.TitledWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardListener;
import oracle.bali.ewt.wizard.WizardListener2;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.WizardRoadMap;
import oracle.bali.ewt.wizard.WizardSize;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public abstract class BaseWizard
extends LWComponent
implements Accessible {
    public static final int MNEMONIC_APPLY = 0;
    public static final int MNEMONIC_CANCEL = 1;
    public static final int MNEMONIC_FINISH = 2;
    public static final int MNEMONIC_NEXT = 3;
    public static final int MNEMONIC_PREVIOUS = 4;
    public static final int MNEMONIC_HELP = 5;
    public static final int MNEMONIC_SAVE = 6;
    public static final int SMALL_SIZE = 0;
    public static final int LARGE_SIZE = 1;
    public static final int VALIDATION_MESSAGE = 0;
    public static final int BILLBOARD = 1;
    protected static final Object PAGE_CONTAINER = new String("PageContainer");
    private static final String _BUNDLE_NAME = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _FINISH_KEY = "WIZARD.FINISH";
    private static final String _APPLY_KEY = "WIZARD.APPLY";
    private static final String _CANCEL_KEY = "WIZARD.CANCEL";
    private static final String _PREVIOUS_KEY = "WIZARD.PREV";
    private static final String _NEXT_KEY = "WIZARD.NEXT";
    private static final String _HELP_KEY = "WIZARD.HELP";
    private static final String _SAVE_KEY = "WIZARD.SAVE";
    private static final String _CLOSE_KEY = "WIZARD.CLOSE";
    private static final Border _BUTTONBAR_BORDER = new EmptyBorder(3, 9, 4, 9);
    private static final Border _HEADER_BORDER = new EmptyBorder(0, 7, 0, 0);
    private static final String _FINISH_NAME = "Finish";
    private static final String _APPLY_NAME = "Apply";
    private static final String _CANCEL_NAME = "Cancel";
    private static final String _PREVIOUS_NAME = "Back";
    private static final String _NEXT_NAME = "Next";
    private static final String _HELP_NAME = "Help";
    private static final String _SAVE_NAME = "Save";
    private static final String _CLOSE_NAME = "Close";
    private static boolean _sImageWizardPageSupported = true;
    private static Border _sMessagePanelBorder;
    private boolean _sequential;
    private LWComponent _buttonRow;
    private JButton _apply;
    private JButton _cancel;
    private JButton _finish;
    private JButton _next;
    private JButton _previous;
    private JButton _help;
    private JButton _save;
    private int _customButtons;
    private boolean _finishDefaulted = true;
    private Action _listener;
    private ListenerManager _wizardListeners;
    private Vector _pages;
    private WizardPage _selectedPage;
    private JLabel _accessibleLabel;
    private JPanel _bottomPanel;
    private WizardRoadMap _roadMap;
    private BottomContent _bottomContent;
    private JPanel _mainPanel;
    private JPanel _topPanel;
    private HeaderLabel _headerLabel;
    private LogoCanvas _logoCanvas;
    private int _wizardSize = -1;
    private int _bottomContentMode = 0;
    private boolean _wizardFinished;
    private boolean _closed;
    private boolean _pageValidation;
    private WizardPage _progressPage;
    private WizardPage _endProcessPage;
    private Color[] _hColors;

    protected BaseWizard() {
        this(true);
    }

    BaseWizard(boolean bl) {
        this._sequential = bl;
        this._pages = new Vector();
        this._createUI();
        this._wizardSize = 0;
        this._pageValidation = true;
        this.updateUI();
    }

    public static final void setImageWizardPageSupported(boolean bl) {
        _sImageWizardPageSupported = bl;
    }

    public static final boolean isImageWizardPageSupported() {
        return _sImageWizardPageSupported;
    }

    public final WizardPage addPage(WizardPage wizardPage) {
        return this.addPage(wizardPage, null);
    }

    public synchronized WizardPage addPage(WizardPage wizardPage, WizardPage wizardPage2) {
        this.addPageImpl(wizardPage, wizardPage2);
        if (this.getSelectedPage() == null && this.isEnabled(wizardPage) && wizardPage.isVisible()) {
            this.selectPage(wizardPage, false);
        }
        return wizardPage;
    }

    public final void addPages(BaseWizard baseWizard, WizardPage wizardPage) {
        Object[] objectArray;
        if (baseWizard == this || baseWizard.getPageCount() == 0) {
            return;
        }
        BaseWizard baseWizard2 = baseWizard;
        synchronized (baseWizard2) {
            objectArray = new WizardPage[baseWizard.getPageCount()];
            baseWizard._pages.copyInto(objectArray);
            baseWizard.removeAllPages();
        }
        int n = 0;
        while (n < objectArray.length) {
            this.addPage((WizardPage)objectArray[n], wizardPage);
            ++n;
        }
    }

    public synchronized void removePage(WizardPage wizardPage) {
        if (this._selectedPage == wizardPage) {
            WizardPage wizardPage2 = this.getNextPage(wizardPage);
            if (wizardPage2 == null) {
                wizardPage2 = this.getPreviousPage(wizardPage);
            }
            this.selectPage(wizardPage2, false);
        } else {
            int n;
            int n2 = this.__getPageIndex(wizardPage);
            if (this._selectedPage != null && (n = this.__getPageIndex(this._selectedPage)) > n2 && n < this.__getActualPageCount() - 1) {
                this.selectPage(this.getPageAt(n + 1));
            }
        }
        wizardPage.removePropertyChangeListener(this._listener);
        wizardPage.__setParent(null);
        if (this._pages.removeElement(wizardPage)) {
            this.firePropertyChange("pageRemoved", null, wizardPage);
        }
        this.enableButtons();
    }

    public synchronized void removeAllPages() {
        int n = this._pages.size();
        while (--n >= 0) {
            WizardPage wizardPage = (WizardPage)this._pages.elementAt(n);
            wizardPage.removePropertyChangeListener(this._listener);
            wizardPage.__setParent(null);
            this.firePropertyChange("pageRemoved", null, wizardPage);
        }
        this._pages.removeAllElements();
        this.selectPage(null, false);
        this.enableButtons();
    }

    public int getPageCount() {
        return this._pages.size();
    }

    public WizardPage getPageAt(int n) {
        return (WizardPage)this._pages.elementAt(n);
    }

    public void selectPage(WizardPage wizardPage) {
        this.selectPage(wizardPage, true);
    }

    public WizardPage getSelectedPage() {
        return this._selectedPage;
    }

    public void setCurrentPageIndex(int n) {
        this.selectPage(this.getPageAt(n));
    }

    public int getCurrentPageIndex() {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage == null) {
            return -1;
        }
        return wizardPage.getIndex();
    }

    public void restart() {
        this.reset();
        if (this.getPageCount() == 0) {
            return;
        }
        WizardPage wizardPage = this.getPageAt(0);
        if (!this.isEnabled(wizardPage) || !wizardPage.isVisible()) {
            wizardPage = this.getNextPage(wizardPage);
        }
        if (wizardPage != null) {
            this.selectPage(wizardPage, false);
        }
    }

    public void reset() {
        this._setCancel();
        this._wizardFinished = false;
        int n = this._pages.size();
        int n2 = 0;
        while (n2 < n) {
            WizardPage wizardPage = (WizardPage)this._pages.get(n2);
            wizardPage.reset();
            ++n2;
        }
    }

    public WizardPage getNextPage(WizardPage wizardPage) {
        if (wizardPage == null) {
            return null;
        }
        int n = wizardPage.getIndex();
        int n2 = this.getPageCount();
        while (++n < n2) {
            WizardPage wizardPage2 = this.getPageAt(n);
            if (!wizardPage2.isVisible() || !this.isEnabled(wizardPage2)) continue;
            return wizardPage2;
        }
        return null;
    }

    public WizardPage getPreviousPage(WizardPage wizardPage) {
        if (wizardPage == null) {
            return null;
        }
        int n = wizardPage.getIndex();
        while (--n >= 0) {
            WizardPage wizardPage2 = this.getPageAt(n);
            if (!wizardPage2.isVisible() || !this.isEnabled(wizardPage2)) continue;
            return wizardPage2;
        }
        return null;
    }

    public void setHelpAvailable(boolean bl) {
        this._help.setVisible(bl);
    }

    public boolean isHelpAvailable() {
        return this._help.isVisible();
    }

    public void setCanApply(boolean bl) {
        this._apply.setVisible(bl);
        if (this._accessibleLabel != null && bl) {
            this.enableButtons();
        }
    }

    public boolean getCanApply() {
        return this._apply.isVisible();
    }

    public void setCanSave(boolean bl) {
        this._save.setVisible(bl);
    }

    public boolean getCanSave() {
        return this._save.isVisible();
    }

    public void setFinishText(String string) {
        if (string == null || "".equals(string)) {
            if (this._finishDefaulted) {
                return;
            }
            if (this.getPeer() == null) {
                this._finish.setText("");
            } else {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(_BUNDLE_NAME, LocaleUtils.getDefaultableLocale((Component)this));
                this._setButtonLabel(this._finish, resourceBundle.getString(_FINISH_KEY));
            }
            this._finishDefaulted = true;
        } else {
            if (this._finishDefaulted) {
                this._finish.setMnemonic(0);
            }
            this._finish.setText(string);
            this._finishDefaulted = false;
        }
    }

    public String getFinishText() {
        return this._finish.getText();
    }

    public void setFinishMnemonic(int n) {
        this._finish.setMnemonic(n);
    }

    public int getFinishMnemonic() {
        return this._finish.getMnemonic();
    }

    public int getButtonMnemonic(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = this._apply.getMnemonic();
                break;
            }
            case 1: {
                n2 = this._cancel.getMnemonic();
                break;
            }
            case 2: {
                n2 = this._finish.getMnemonic();
                break;
            }
            case 3: {
                n2 = this._next.getMnemonic();
                break;
            }
            case 4: {
                n2 = this._previous.getMnemonic();
                break;
            }
            case 5: {
                n2 = this._help.getMnemonic();
                break;
            }
            case 6: {
                n2 = this._save.getMnemonic();
            }
        }
        return n2;
    }

    public void addCustomButton(Component component) {
        if (component.getParent() != this._buttonRow) {
            this._buttonRow.add(component, 2 + this._customButtons);
            ++this._customButtons;
            this._buttonRow.revalidate();
        }
    }

    public void removeCustomButton(Component component) {
        if (component.getParent() == this._buttonRow) {
            --this._customButtons;
            this._buttonRow.remove(component);
            this._buttonRow.revalidate();
        }
    }

    public void setReservedButtonSpaces(int n) {
        this._buttonRow.putClientProperty("WizardReservedButtonSpaces", n == 0 ? null : new Integer(n));
    }

    public int getReservedButtonSpaces() {
        Object object = this._buttonRow.getClientProperty("WizardReservedButtonSpaces");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public void setLogoImage(Image image) {
        if (this._logoCanvas == null) {
            this._logoCanvas = new LogoCanvas();
            this._topPanel.add((Component)this._logoCanvas, "East");
        }
        this._logoCanvas.setImage(image);
    }

    public Image getLogoImage() {
        return this._logoCanvas == null ? null : this._logoCanvas.getImage();
    }

    public void setHeaderGradientBackground(Color[] colorArray) {
        this._hColors = colorArray;
        this._headerLabel.repaint();
    }

    public Color[] getHeaderGradientBackground() {
        return this._hColors;
    }

    public void setRoadmapVisible(boolean bl) {
        if (bl != this.isRoadmapVisible()) {
            if (this._roadMap == null) {
                this._roadMap = new WizardRoadMap(this);
                this.add((Component)this._roadMap, "West");
            }
            this._roadMap.setVisible(bl);
        }
    }

    public boolean isRoadmapVisible() {
        return this._roadMap != null && this._roadMap.isVisible();
    }

    public void setAllLinksEnabled(boolean bl) {
        if (this._roadMap != null) {
            this._roadMap.setAllLinksEnabled(bl);
        }
    }

    public boolean isAllLinksEnabled() {
        return this._roadMap != null && this._roadMap.isAllLinksEnabled();
    }

    public void setVisitedLinkEnabled(boolean bl) {
        if (this._roadMap != null) {
            this._roadMap.setVisitedLinkEnabled(bl);
        }
    }

    public boolean isVisitedLinkEnabled() {
        return this._roadMap != null && this._roadMap.isVisitedLinkEnabled();
    }

    public void setBillboard(Component component) {
        if (this.getBillboard() != component) {
            this._createBottomContent();
            this._bottomContent.setBillboard(component);
        }
    }

    public Component getBillboard() {
        return this._bottomContent == null ? null : this._bottomContent.getBillboard();
    }

    public void setValidationMessagePane(ValidationMessagePane validationMessagePane) {
        ValidationMessagePane validationMessagePane2 = this.getValidationMessagePane();
        if (validationMessagePane2 != validationMessagePane) {
            if (validationMessagePane2 != null) {
                validationMessagePane2.removePropertyChangeListener(this._listener);
            }
            this._createBottomContent();
            this._bottomContent.setValidationMessagePane(validationMessagePane);
        }
    }

    public ValidationMessagePane getValidationMessagePane() {
        return this._bottomContent == null ? null : this._bottomContent.getValidationMessagePane();
    }

    public void setBottomContentMode(int n) {
        if (n != this.getBottomContentMode()) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException();
            }
            this._bottomContentMode = n;
            if (this._bottomContent != null) {
                this._bottomContent.updateVisibility();
            }
        }
    }

    public int getBottomContentMode() {
        return this._bottomContentMode;
    }

    public void setDefaultWizardSize(int n) {
        if (this.isShowing()) {
            throw new IllegalArgumentException("WizardSize cannot be set when the component is visible");
        }
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException();
        }
        this._wizardSize = n;
    }

    public int getDefaultWizardSize() {
        return this._wizardSize;
    }

    public void setProgressWizardPage(WizardPage wizardPage) {
        this._progressPage = wizardPage;
        if (wizardPage != null) {
            this._progressPage.setCanGoBack(false);
            this._progressPage.setCanAdvance(false);
        }
    }

    public WizardPage getProgressWizardPage() {
        return this._progressPage;
    }

    public void setEndOfProcessWizardPage(WizardPage wizardPage) {
        this._endProcessPage = wizardPage;
        if (wizardPage != null) {
            this._endProcessPage.setCanGoBack(false);
        }
    }

    public WizardPage getEndOfProcessWizardPage() {
        return this._endProcessPage;
    }

    public synchronized void addWizardListener(WizardListener wizardListener) {
        if (this._wizardListeners == null) {
            this._wizardListeners = new ListenerManager();
        }
        this._wizardListeners.addListener((EventListener)wizardListener);
    }

    public synchronized void removeWizardListener(WizardListener wizardListener) {
        if (this._wizardListeners != null) {
            this._wizardListeners.removeListener((EventListener)wizardListener);
        }
    }

    public void dispose() {
        if (this._listener == null) {
            return;
        }
        this._unregisterKeyboardActions();
        if (this._roadMap != null) {
            this._roadMap.dispose();
            this._roadMap = null;
        }
        this.removeAllPages();
        this._pages = null;
        this._apply.removeActionListener(this._listener);
        this._apply.removeFocusListener(this._listener);
        this._apply = null;
        this._cancel.removeActionListener(this._listener);
        this._cancel.removeFocusListener(this._listener);
        this._cancel = null;
        this._finish.removeActionListener(this._listener);
        this._finish.removeFocusListener(this._listener);
        this._finish = null;
        this._next.removeActionListener(this._listener);
        this._next.removeFocusListener(this._listener);
        this._next = null;
        this._previous.removeActionListener(this._listener);
        this._previous.removeFocusListener(this._listener);
        this._previous = null;
        this._help.removeActionListener(this._listener);
        this._help.removeFocusListener(this._listener);
        this._help = null;
        this._save.removeActionListener(this._listener);
        this._save.removeFocusListener(this._listener);
        this._save = null;
        this._buttonRow.removeAll();
        this._buttonRow = null;
        this._wizardListeners = null;
        this._selectedPage = null;
        this._bottomPanel.removeAll();
        this._bottomPanel = null;
        this._topPanel.removeAll();
        this._topPanel = null;
        this._headerLabel = null;
        this._logoCanvas = null;
        if (this._bottomContent != null) {
            this._bottomContent.dispose();
            this._bottomContent = null;
        }
        this._mainPanel.removeAll();
        this._listener = null;
    }

    public void updateUI() {
        this.setUI((EWTWizardUI)UIManager.getUI(this));
        this.updateReadingDirection(this.getActualReadingDirection());
    }

    public String getUIClassID() {
        return "EWTWizardUI";
    }

    public void addNotify() {
        super.addNotify();
        Window window = WindowUtils.getWindow(this);
        window.addWindowListener(this._listener);
        this._loadButtonText(this.getLocale());
        this.enableButtons();
        this.resetFocus(this.getSelectedPage());
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._buttonRow != null) {
            this._loadButtonText(LocaleUtils.getDefaultableLocale((Component)this));
        }
    }

    public void enable() {
        super.enable();
        this.enableButtons();
        if (this._roadMap != null) {
            this._roadMap.setEnabled(true);
        }
    }

    public void disable() {
        super.disable();
        this.enableButtons();
        if (this._roadMap != null) {
            this._roadMap.setEnabled(false);
        }
    }

    public Dimension getPreferredSize() {
        return WizardSize.getWizardSize(this.getDefaultWizardSize());
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleWizard();
            if (this._bottomPanel != null) {
                this._accessibleLabel = new AccessibleLabel();
                StatusBar statusBar = new StatusBar();
                statusBar.setPreferredSize(new Dimension(0, 0));
                statusBar.add(this._accessibleLabel);
                this._bottomPanel.add("South", statusBar);
                this.validate();
                this._updateAccessibleTitle();
                this._updateAccessibleLabel();
            }
        }
        return this.accessibleContext;
    }

    protected final synchronized void addPageImpl(WizardPage wizardPage, WizardPage wizardPage2) {
        int n;
        if (wizardPage.getParent() != null) {
            wizardPage.getParent().removePage(wizardPage);
        }
        if (wizardPage2 == null) {
            this._pages.addElement(wizardPage);
        } else {
            this._pages.insertElementAt(wizardPage, this._pages.indexOf(wizardPage2));
        }
        wizardPage.__setParent(this);
        wizardPage.addPropertyChangeListener(this._listener);
        this.firePropertyChange("pageAdded", null, wizardPage);
        this.enableButtons();
        int n2 = this.__getPageIndex(wizardPage);
        if (this._selectedPage != null && (n = this.__getPageIndex(this._selectedPage)) >= n2) {
            this.selectPage(this.getPageAt(n - 1));
        }
    }

    protected void selectPage(WizardPage wizardPage, boolean bl) {
        if (wizardPage != this._selectedPage && this._validatePage(bl, true)) {
            Component component;
            this.setSelectedPage(wizardPage);
            this.processEvent(new WizardEvent(this, 2001, wizardPage));
            WizardPage wizardPage2 = this.getSelectedPage();
            if (wizardPage2 != null) {
                this._updateValidationMessagePane(wizardPage2, true);
            }
            this.enableButtons();
            this._updateAccessibleTitle();
            this._updateAccessibleLabel();
            this.resetFocus(wizardPage);
            if (wizardPage != null && (component = wizardPage.getContent()) != null && component instanceof JComponent) {
                HelpUtils.setHelpID(this._buttonRow, HelpUtils.getHelpID(component));
                HelpUtils.setHelpProvider(this._buttonRow, HelpUtils.getHelpProvider(component));
                HelpUtils.setHelpSet(this._buttonRow, HelpUtils.getHelpSet(component));
                return;
            }
            HelpUtils.setHelpID(this._buttonRow, null);
            HelpUtils.setHelpProvider(this._buttonRow, null);
            HelpUtils.setHelpSet(this._buttonRow, null);
        }
    }

    protected void setSelectedPage(WizardPage wizardPage) {
        WizardPage wizardPage2 = this._selectedPage;
        if (wizardPage2 != null) {
            wizardPage2.__setVisited(true);
        }
        this._selectedPage = wizardPage;
        this._updateHeaderText(wizardPage);
    }

    protected boolean getCanGoBack() {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage == null) {
            return false;
        }
        return wizardPage.getCanGoBack();
    }

    protected boolean getCanAdvance() {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage == null) {
            return false;
        }
        return wizardPage.getCanAdvance();
    }

    protected boolean getMustFinish() {
        return true;
    }

    protected void doHelp() {
        Component component = null;
        WizardPage wizardPage = this.getSelectedPage();
        Window window = WindowUtils.getWindow(this);
        if (window != null) {
            component = window.getFocusOwner();
        }
        if (component == null || component.getParent() == this._buttonRow || component.getParent() == this) {
            component = wizardPage != null ? wizardPage.getContent() : this;
        }
        try {
            HelpUtils.showHelp(component);
        }
        catch (HelpUnavailableException helpUnavailableException) {
            // empty catch block
        }
    }

    protected void doApply() {
        if (this._validatePage(true, false)) {
            this.processEvent(new WizardEvent(this, 2002, this.getSelectedPage()));
        }
    }

    protected void doSave() {
        this.processEvent(new WizardEvent(this, 2005, this.getSelectedPage()));
    }

    protected void doPrevious() {
        WizardPage wizardPage = this.getPreviousPage(this.getSelectedPage());
        if (wizardPage != null) {
            this.selectPage(wizardPage, false);
        }
    }

    protected void doNext() {
        WizardPage wizardPage;
        if (this._validatePage(true, false) && (wizardPage = this.getNextPage(this.getSelectedPage())) != null) {
            this.selectPage(wizardPage, false);
        }
    }

    protected void doFinish() {
        if (this._validatePage(true, true)) {
            this._wizardFinished = true;
            WizardPage wizardPage = this.getSelectedPage();
            this.processEvent(new WizardEvent(this, 2004, wizardPage));
            WizardPage wizardPage2 = this.getProgressWizardPage();
            if (wizardPage2 == null || wizardPage2.getParent() != this) {
                wizardPage2 = this.getEndOfProcessWizardPage();
            }
            if (wizardPage2 != null && wizardPage2.getParent() == this) {
                this.selectPage(wizardPage2, false);
            } else {
                this.reset();
            }
        }
    }

    protected void doCancel() {
        this.processEvent(new WizardEvent(this, 2003, this.getSelectedPage()));
    }

    protected void doClose() {
        this.processEvent(new WizardEvent(this, 2006, this.getSelectedPage()));
        this.reset();
    }

    protected void enableButtons() {
        this.freezeRepaints();
        try {
            boolean bl;
            WizardPage wizardPage = this._selectedPage;
            WizardPage wizardPage2 = this.getNextPage(wizardPage);
            boolean bl2 = this.getCanAdvance();
            boolean bl3 = this.getCanGoBack();
            boolean bl4 = this.getMustFinish();
            boolean bl5 = this.isEnabled();
            JRootPane jRootPane = this.getRootPane();
            if (jRootPane != null) {
                JButton jButton;
                JButton jButton2 = jRootPane.getDefaultButton();
                JButton jButton3 = jButton = !this._sequential || wizardPage2 == null ? this._finish : this._next;
                if (!(this._previous.hasFocus() || this._apply.hasFocus() || this._cancel.hasFocus() || this._help.hasFocus())) {
                    jButton.setDefaultCapable(true);
                    jRootPane.setDefaultButton(jButton);
                    if (jButton2 != jButton && jButton2 != null) {
                        jButton2.setDefaultCapable(false);
                    }
                }
            }
            boolean bl6 = this._isProgressPage(wizardPage) || this._isEndProcessPage(wizardPage);
            boolean bl7 = this._isProgressPage(wizardPage2) || this._isEndProcessPage(wizardPage2);
            boolean bl8 = bl = bl5 && bl2 && !bl6 && (wizardPage2 == null || !bl4 || bl7);
            if (bl && this._next.hasFocus()) {
                this._finish.requestFocus();
            }
            this._finish.setEnabled(bl);
            boolean bl9 = bl5 && bl2 && wizardPage2 != null && (bl6 || !bl7);
            this._next.setEnabled(bl9);
            this._previous.setEnabled(bl5 && bl3 && this.getPreviousPage(wizardPage) != null);
            if (this._accessibleLabel == null || this._apply.isVisible()) {
                this._apply.setEnabled(bl5 && bl2);
            }
            this._cancel.setEnabled(bl5);
            if (bl6 && (this._isProgressPage(wizardPage) && bl2 || wizardPage2 == null)) {
                this._setClose();
            } else {
                this._setCancel();
            }
            boolean bl10 = bl5 && !this._wizardFinished;
            this._save.setEnabled(bl10);
            Object var14_15 = null;
            this.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
    }

    boolean isEnabled(WizardPage wizardPage) {
        boolean bl = wizardPage.isEnabled();
        if (this._isProgressPage(wizardPage) || this._isEndProcessPage(wizardPage)) {
            if (!this._wizardFinished) {
                bl = false;
            }
        } else if (this._wizardFinished) {
            bl = false;
        }
        return bl;
    }

    protected boolean validateSelectedPage() {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage == null) {
            return true;
        }
        return wizardPage.validatePage();
    }

    protected void pagePropertyChange(WizardPage wizardPage, PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("accessibleDescription".equals(string)) {
            if (wizardPage == this.getSelectedPage()) {
                this._updateAccessibleLabel();
            }
        } else if ("visible".equals(string) || "enabled".equals(string)) {
            if (wizardPage == this.getSelectedPage() && Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
                WizardPage wizardPage2 = null;
                WizardPage wizardPage3 = this.getNextPage(wizardPage);
                if (wizardPage3 != null) {
                    wizardPage2 = wizardPage3;
                } else {
                    WizardPage wizardPage4 = this.getPreviousPage(wizardPage);
                    if (wizardPage4 != null) {
                        wizardPage2 = wizardPage4;
                    }
                }
                this.selectPage(wizardPage2, false);
            } else {
                this.enableButtons();
            }
            if ("visible".equals(string)) {
                this.firePropertyChange("pageVisible", null, wizardPage);
            }
        } else if ("canAdvance".equals(string) || "canGoBack".equals(string)) {
            this.enableButtons();
        } else if (("pageTitle".equals(string) || "label".equals(string)) && wizardPage == this.getSelectedPage()) {
            this._updateHeaderText(wizardPage);
        }
    }

    protected void resetFocus(final WizardPage wizardPage) {
        if (this._roadMap != null && this._roadMap.hasFocus()) {
            return;
        }
        if (wizardPage == null) {
            return;
        }
        Component component = wizardPage.getInitialFocus();
        if (component == null && !this._next.hasFocus() && !this._previous.hasFocus()) {
            component = !this._sequential || this._finish.isDefaultButton() ? this._finish : this._next;
        }
        if (component != null && component.isEnabled()) {
            final Component component2 = component;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (wizardPage.isSelected()) {
                        FocusUtils.requestFocus(component2);
                    }
                }
            });
        }
    }

    protected void processWizardEvent(WizardEvent wizardEvent) {
        Enumeration enumeration;
        int n = wizardEvent.getID();
        ListenerManager listenerManager = this._wizardListeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                WizardListener wizardListener = (WizardListener)enumeration.nextElement();
                switch (n) {
                    case 2001: {
                        wizardListener.wizardSelectionChanged(wizardEvent);
                        break;
                    }
                    case 2002: {
                        wizardListener.wizardApplyState(wizardEvent);
                        break;
                    }
                    case 2003: {
                        wizardListener.wizardCanceled(wizardEvent);
                        break;
                    }
                    case 2004: {
                        wizardListener.wizardFinished(wizardEvent);
                        break;
                    }
                    case 2005: {
                        if (!(wizardListener instanceof WizardListener2)) break;
                        ((WizardListener2)wizardListener).wizardSaveState(wizardEvent);
                        break;
                    }
                    case 2006: {
                        if (!(wizardListener instanceof WizardListener2)) break;
                        ((WizardListener2)wizardListener).wizardClosed(wizardEvent);
                        break;
                    }
                }
            }
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof WizardEvent) {
            this.processWizardEvent((WizardEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        if (PAGE_CONTAINER.equals(object) || "Center".equals(object) && component != this._mainPanel) {
            this._mainPanel.add(component, "Center", n);
        } else if (component != this._topPanel && component != this._roadMap && component != this._mainPanel && component != this._bottomPanel) {
            String string = object instanceof String ? (String)object : component.getName();
            this.addPage(new WizardPage(component, string));
        } else {
            super.addImpl(component, object, n);
        }
    }

    protected void updateReadingDirection(int n) {
    }

    protected String paramString() {
        String string = super.paramString();
        WizardPage wizardPage = this._selectedPage;
        if (wizardPage != null) {
            string = string + ",selected page=" + wizardPage;
        }
        return string;
    }

    int __getPageIndex(WizardPage wizardPage) {
        int n = this._pages.indexOf(wizardPage);
        return n;
    }

    void __doCancelClick() {
        if (this._cancel.isEnabled()) {
            this._cancel.doClick();
        }
    }

    WizardPage[] __getAllPages() {
        return this._pages.toArray(new WizardPage[0]);
    }

    boolean __isSequential() {
        return this._sequential;
    }

    int __getActualPageCount() {
        return this._pages.size();
    }

    WizardPage __getPageAt(int n) {
        return (WizardPage)this._pages.elementAt(n);
    }

    private void _createUI() {
        this.setLayout(new BorderLayout());
        this._listener = new Action();
        this._topPanel = new JPanel(new BorderLayout());
        this._headerLabel = new HeaderLabel();
        this._topPanel.add(this._headerLabel);
        this._mainPanel = new JPanel(new BorderLayout(0, 1));
        this._createButtonBar(this._listener);
        this._bottomPanel = new JPanel(new BorderLayout());
        this._bottomPanel.setBorder(_BUTTONBAR_BORDER);
        this._bottomPanel.add("North", this._buttonRow);
        this.add((Component)this._topPanel, "North");
        this.add((Component)this._mainPanel, "Center");
        this.add((Component)this._bottomPanel, "South");
        this._registerKeyboardActions();
    }

    private void _createButtonBar(Action action) {
        this._buttonRow = new DialogButtonBar();
        JButton jButton = this._createButton(action);
        this._buttonRow.add((Component)jButton, DialogButtonBar.CONSTRAINT_HELP);
        this._help = jButton;
        jButton = this._createButton(action);
        jButton.setVisible(false);
        this._buttonRow.add((Component)jButton, DialogButtonBar.CONSTRAINT_APPLY);
        this._apply = jButton;
        jButton = this._createButton(action);
        jButton.setVisible(false);
        this._buttonRow.add((Component)jButton, DialogButtonBar.CONSTRAINT_SAVE);
        this._save = jButton;
        jButton = this._createButton(action);
        jButton.setEnabled(false);
        this._buttonRow.add((Component)jButton, DialogButtonBar.CONSTRAINT_BACK);
        this._previous = jButton;
        this._previous.setHorizontalTextPosition(11);
        this._previous.setVerticalTextPosition(0);
        jButton = this._createButton(action);
        jButton.setEnabled(false);
        this._buttonRow.add((Component)jButton, DialogButtonBar.CONSTRAINT_NEXT);
        this._next = jButton;
        this._next.setHorizontalTextPosition(10);
        this._next.setVerticalTextPosition(0);
        jButton = this._createButton(action);
        jButton.setEnabled(false);
        this._buttonRow.add((Component)jButton, DialogButtonBar.CONSTRAINT_FINISH);
        this._finish = jButton;
        jButton = this._createButton(action);
        this._buttonRow.add((Component)jButton, DialogButtonBar.CONSTRAINT_CANCEL);
        this._cancel = jButton;
        this._cancel.setName(_CANCEL_NAME);
        this._help.setName(_HELP_NAME);
        this._apply.setName(_APPLY_NAME);
        this._previous.setName(_PREVIOUS_NAME);
        this._next.setName(_NEXT_NAME);
        this._finish.setName(_FINISH_NAME);
        this._save.setName(_SAVE_NAME);
    }

    private JButton _createButton(Action action) {
        JButton jButton = new JButton("");
        Insets insets = jButton.getMargin();
        if (insets != null) {
            insets.left = 2;
            insets.right = 1;
        } else {
            insets = new Insets(1, 2, 1, 1);
        }
        jButton.setMargin(insets);
        jButton.addActionListener(action);
        jButton.addFocusListener(action);
        jButton.setDefaultCapable(false);
        return jButton;
    }

    private void _loadButtonText(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_BUNDLE_NAME, locale);
        EWTWizardUI eWTWizardUI = (EWTWizardUI)this.ui;
        if (this._finishDefaulted) {
            this._setButtonLabel(this._finish, resourceBundle.getString(_FINISH_KEY));
        }
        this._setButtonLabel(this._help, resourceBundle.getString(_HELP_KEY));
        this._setButtonLabel(this._apply, resourceBundle.getString(_APPLY_KEY));
        this._setButtonLabel(this._save, resourceBundle.getString(_SAVE_KEY));
        this._setButtonLabel(this._previous, eWTWizardUI.getPreviousString(this, resourceBundle.getString(_PREVIOUS_KEY)));
        this._setButtonLabel(this._next, eWTWizardUI.getNextString(this, resourceBundle.getString(_NEXT_KEY)));
        this._setButtonLabel(this._cancel, resourceBundle.getString(this._closed ? _CLOSE_KEY : _CANCEL_KEY));
    }

    private void _setButtonLabel(JButton jButton, String string) {
        jButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jButton.setText(StringUtils.stripMnemonic((String)string));
    }

    private void _setClose() {
        if (!this._closed) {
            this._closed = true;
            Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(_BUNDLE_NAME, locale);
            this._setButtonLabel(this._cancel, resourceBundle.getString(_CLOSE_KEY));
            this._cancel.setName(_CLOSE_NAME);
        }
    }

    private void _setCancel() {
        if (this._closed) {
            this._closed = false;
            Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(_BUNDLE_NAME, locale);
            this._setButtonLabel(this._cancel, resourceBundle.getString(_CANCEL_KEY));
            this._cancel.setName(_CANCEL_NAME);
        }
    }

    private void _createBottomContent() {
        if (this._bottomContent == null) {
            this._bottomContent = new BottomContent();
            this._mainPanel.add((Component)this._bottomContent, "South");
        }
    }

    private void _updateHeaderText(WizardPage wizardPage) {
        String string = null;
        if (wizardPage != null && (string = wizardPage.getPageTitle()) == null && (string = wizardPage.getLabel()) == null && wizardPage instanceof TitledWizardPage) {
            string = ((TitledWizardPage)wizardPage).getTitle();
        }
        this._headerLabel.setText(string);
    }

    private boolean _validatePage(boolean bl, boolean bl2) {
        this._pageValidation = !bl || this.validateSelectedPage();
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage != null) {
            boolean bl3;
            boolean bl4 = bl3 = this._pageValidation && this._isValidationMessagePaneEmpty();
            if (bl2 && this._pageValidation) {
                this._updateValidationMessagePane(wizardPage, false);
            }
            wizardPage.setValid(bl3);
        }
        return this._pageValidation;
    }

    private boolean _isValidationMessagePaneEmpty() {
        ValidationMessagePane validationMessagePane = this.getValidationMessagePane();
        return validationMessagePane == null || validationMessagePane.isEmpty();
    }

    private void _updateValidationMessagePane(WizardPage wizardPage, boolean bl) {
        ValidationMessagePane validationMessagePane = this.getValidationMessagePane();
        if (validationMessagePane != null) {
            if (bl) {
                validationMessagePane.addPropertyChangeListener(this._listener);
                ValidationComponent[] validationComponentArray = wizardPage.getValidationComponents();
                if (validationComponentArray != null) {
                    int n = 0;
                    while (n < validationComponentArray.length) {
                        validationMessagePane.addValidationComponent(validationComponentArray[n]);
                        ++n;
                    }
                }
            } else {
                validationMessagePane.removePropertyChangeListener(this._listener);
                validationMessagePane.removeAllValidationComponents();
            }
        }
    }

    private boolean _isProgressPage(WizardPage wizardPage) {
        return wizardPage != null && wizardPage == this._progressPage && wizardPage.getParent() == this;
    }

    private boolean _isEndProcessPage(WizardPage wizardPage) {
        return wizardPage != null && wizardPage == this._endProcessPage && wizardPage.getParent() == this;
    }

    private void _registerKeyboardActions() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseWizard.this._cancel.doClick();
            }
        };
        this.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 1);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BaseWizard.this.isHelpAvailable()) {
                    BaseWizard.this.doHelp();
                }
            }
        };
        this.registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke(112, 0), 1);
        this.registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke(156, 0), 1);
    }

    private void _unregisterKeyboardActions() {
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(156, 0));
    }

    private void _updateAccessibleLabel() {
        if (this._accessibleLabel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WizardPage wizardPage = BaseWizard.this.getSelectedPage();
                    if (wizardPage != null) {
                        BaseWizard.this._accessibleLabel.setText(wizardPage.getAccessibleDescription());
                    }
                }
            });
        }
    }

    private void _updateAccessibleTitle() {
        if (this._accessibleLabel != null) {
            String string = null;
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window == null) {
                return;
            }
            if (window instanceof Frame) {
                string = ((Frame)window).getTitle();
            } else if (window instanceof Dialog) {
                string = ((Dialog)window).getTitle();
            }
            final String string2 = string;
            if (string2 != null && !"".equals(string2)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BaseWizard.this._accessibleLabel.setText(string2);
                    }
                });
            }
        }
    }

    private class AccessibleLabel
    extends JLabel {
        private AccessibleLabel() {
        }

        public void setText(String string) {
            String string2 = this.getText();
            super.setText(string);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleName", string2, string);
            }
        }
    }

    private class AccessibleWizard
    extends JComponent.AccessibleJComponent {
        private AccessibleWizard() {
            super(BaseWizard.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private class Action
    extends WindowAdapter
    implements ActionListener,
    PropertyChangeListener,
    FocusListener {
        private Action() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            BaseWizard.this.resetFocus(BaseWizard.this.getSelectedPage());
            BaseWizard.this._updateAccessibleTitle();
            BaseWizard.this._updateAccessibleLabel();
            windowEvent.getWindow().removeWindowListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == BaseWizard.this._apply) {
                BaseWizard.this.doApply();
            } else if (object == BaseWizard.this._cancel) {
                if (BaseWizard.this._closed) {
                    BaseWizard.this.doClose();
                } else {
                    BaseWizard.this.doCancel();
                }
            } else if (object == BaseWizard.this._finish) {
                BaseWizard.this.doFinish();
            } else if (object == BaseWizard.this._next) {
                BaseWizard.this.doNext();
            } else if (object == BaseWizard.this._previous) {
                BaseWizard.this.doPrevious();
            } else if (object == BaseWizard.this._help) {
                BaseWizard.this.doHelp();
            } else if (object == BaseWizard.this._save) {
                BaseWizard.this.doSave();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object == null) {
                return;
            }
            if (object == BaseWizard.this.getValidationMessagePane()) {
                WizardPage wizardPage;
                if (ValidationMessagePane.PANE_EMPTY.equals(propertyChangeEvent.getPropertyName()) && (wizardPage = BaseWizard.this.getSelectedPage()) != null) {
                    wizardPage.setValid(BaseWizard.this._pageValidation && Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                }
            } else if (object instanceof WizardPage) {
                BaseWizard.this.pagePropertyChange((WizardPage)object, propertyChangeEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            JButton jButton;
            JRootPane jRootPane = BaseWizard.this.getRootPane();
            JButton jButton2 = jRootPane == null ? null : jRootPane.getDefaultButton();
            if (jButton2 != (jButton = (JButton)focusEvent.getSource())) {
                if (jButton2 != null) {
                    jButton2.setDefaultCapable(false);
                }
                jButton.setDefaultCapable(true);
                if (jRootPane != null) {
                    jRootPane.setDefaultButton(jButton);
                }
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                WizardPage wizardPage = BaseWizard.this.getNextPage(BaseWizard.this.getSelectedPage());
                JButton jButton = !BaseWizard.this._sequential || wizardPage == null ? BaseWizard.this._finish : BaseWizard.this._next;
                JButton jButton2 = (JButton)focusEvent.getSource();
                if (jButton2 != jButton) {
                    JRootPane jRootPane = BaseWizard.this.getRootPane();
                    jButton2.setDefaultCapable(false);
                    if (jRootPane != null) {
                        jRootPane.setDefaultButton(jButton);
                    }
                    if (jButton != null) {
                        jButton.setDefaultCapable(true);
                    }
                }
            }
        }
    }

    private class BottomContent
    extends JPanel {
        private ValidationMessagePane _errorMsgPane;
        private Component _billboard;

        public BottomContent() {
            this.setLayout(new BorderLayout());
            if (_sMessagePanelBorder == null) {
                _sMessagePanelBorder = new EmptyBorder(0, 7, 7, 7);
            }
            this.setBorder(_sMessagePanelBorder);
        }

        public Dimension getPreferredSize() {
            return WizardSize.getMessagePanelSize(BaseWizard.this.getDefaultWizardSize());
        }

        public void dispose() {
            if (this._errorMsgPane != null) {
                this._errorMsgPane.dispose();
                this._errorMsgPane = null;
            }
            this._billboard = null;
            this.removeAll();
        }

        public void setValidationMessagePane(ValidationMessagePane validationMessagePane) {
            WizardPage wizardPage = BaseWizard.this.getSelectedPage();
            if (wizardPage != null && this.getValidationMessagePane() != null) {
                BaseWizard.this._updateValidationMessagePane(wizardPage, false);
            }
            this._errorMsgPane = validationMessagePane;
            if (wizardPage != null && this.getValidationMessagePane() != null) {
                BaseWizard.this._updateValidationMessagePane(wizardPage, true);
            }
            this.updateVisibility();
        }

        public ValidationMessagePane getValidationMessagePane() {
            return this._errorMsgPane;
        }

        public void setBillboard(Component component) {
            this._billboard = component;
            this.updateVisibility();
        }

        public Component getBillboard() {
            return this._billboard;
        }

        public void updateVisibility() {
            this.removeAll();
            boolean bl = true;
            if (this._errorMsgPane != null && this._billboard != null) {
                if (BaseWizard.this.getBottomContentMode() == 0) {
                    this.add(this._errorMsgPane);
                } else {
                    this.add(this._billboard);
                }
            } else if (this._errorMsgPane != null) {
                this.add(this._errorMsgPane);
            } else if (this._billboard != null) {
                this.add(this._billboard);
            } else {
                bl = false;
            }
            this.setVisible(bl);
            this.revalidate();
            this.repaint();
        }
    }

    private class LogoCanvas
    extends AccessibleLWComponent {
        private Image _image;

        private LogoCanvas() {
        }

        public void setImage(Image image) {
            this._image = image;
            ImageUtils.loadImage(image);
            this.revalidate();
            this.repaint();
        }

        public Image getImage() {
            return this._image;
        }

        protected void paintComponent(Graphics graphics) {
            if (this._image == null) {
                return;
            }
            int n = this._image.getWidth(this) - this.getWidth();
            int n2 = n > 0 ? -n : 0;
            graphics.drawImage(this._image, n2, 0, this);
        }

        public Dimension getPreferredSize() {
            return WizardSize.getHeaderSize(BaseWizard.this.getDefaultWizardSize());
        }
    }

    private class HeaderLabel
    extends JLabel {
        private boolean _doInit = true;

        public HeaderLabel() {
            this.setBorder(_HEADER_BORDER);
            this.setOpaque(false);
        }

        public Dimension getPreferredSize() {
            return WizardSize.getHeaderSize(BaseWizard.this.getDefaultWizardSize());
        }

        public void addNotify() {
            super.addNotify();
            if (this._doInit) {
                this._doInit = false;
                Font font = this.getFont();
                this.setFont(new Font(font.getName(), font.getStyle() | 1, (int)((double)font.getSize() * 1.3)));
            }
        }

        public void paintComponent(Graphics graphics) {
            Color color;
            int n = this.getWidth();
            Color color2 = BaseWizard.this._hColors != null && BaseWizard.this._hColors.length >= 1 ? BaseWizard.this._hColors[0] : null;
            Color color3 = color = BaseWizard.this._hColors != null && BaseWizard.this._hColors.length >= 2 ? BaseWizard.this._hColors[1] : null;
            if (color2 == null) {
                color2 = Color.white;
            }
            if (color == null) {
                color = UIManager.getColor("Panel.background");
            }
            if (graphics instanceof Graphics2D) {
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color2, n, 0.0f, color);
                ((Graphics2D)graphics).setPaint(gradientPaint);
            }
            graphics.fillRect(0, 0, n, this.getHeight());
            super.paintComponent(graphics);
        }
    }
}

