/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.TitledWizardPage;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class WelcomeWizardPage
extends TitledWizardPage {
    public static final String PROPERTY_SHOW_NEXT_TIME = "showNextTime";
    public static final String PROPERTY_SKIP_NEXT_TIME = "skipNextTime";
    private static final Border _BORDER = new EmptyBorder(23, 0, 0, 0);
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_CHECKBOX = "WIZARD.SKIP_NEXT_TIME_TEXT";
    private static final String _KEY_TITLE = "WIZARD.WELCOME";
    private MultiLineLabel _description;
    private JCheckBox _checkBox;
    private LabelUpdater _parentListener;
    private static final String _SKIP_NAME = "Skip_this_Page_Next_Time_CheckBox";

    public WelcomeWizardPage(Image image, String string, String string2) {
        this(image, null, string, string2);
    }

    public WelcomeWizardPage(String string, String string2) {
        this(null, string, string2, "");
    }

    private WelcomeWizardPage(Image image, String string, String string2, String string3) {
        super(new JPanel(), image, "", string2, string);
        this._description = new MultiLineLabel(WordWrapper.getTextWrapper(), string3);
        this._checkBox = new JCheckBox();
        this._checkBox.setName(_SKIP_NAME);
        this._checkBox.addActionListener(new HideListener());
        JPanel jPanel = (JPanel)this.getInteractiveArea();
        jPanel.setBorder(_BORDER);
        jPanel.setLayout(new BorderLayout(2, 2));
        jPanel.add("Center", this._description);
        Box box = new Box(0);
        box.add(this._checkBox);
        jPanel.add("South", box);
        this._parentListener = new LabelUpdater();
    }

    public boolean isShowNextTime() {
        return !this._checkBox.isSelected();
    }

    public void setShowNextTime(boolean bl) {
        this._checkBox.setSelected(!bl);
    }

    public boolean isSkipNextTime() {
        return this._checkBox.isSelected();
    }

    public void setSkipNextTime(boolean bl) {
        this._checkBox.setSelected(bl);
    }

    public String getDescription() {
        return this._description.getText();
    }

    public void setDescription(String string) {
        this._description.setText(string);
    }

    void __setParent(BaseWizard baseWizard) {
        BaseWizard baseWizard2 = this.getParent();
        super.__setParent(baseWizard);
        if (baseWizard2 != baseWizard) {
            if (baseWizard2 != null) {
                baseWizard2.removePropertyChangeListener(this._parentListener);
            }
            if (baseWizard != null) {
                baseWizard.addPropertyChangeListener(this._parentListener);
            }
        }
    }

    public String getAccessibleDescription() {
        if (this.__isAccessibleDescriptionSet()) {
            return super.getAccessibleDescription();
        }
        return this.getTitle() + " " + this.getDescription();
    }

    private void _updateLabels() {
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this.getContent());
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, locale);
        String string = resourceBundle.getString(_KEY_CHECKBOX);
        this._checkBox.setText(StringUtils.stripMnemonic((String)string));
        this._checkBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.setLabel(resourceBundle.getString(_KEY_TITLE));
    }

    private class LabelUpdater
    implements PropertyChangeListener {
        private LabelUpdater() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("ancestor".equals(propertyChangeEvent.getPropertyName())) {
                WelcomeWizardPage.this._updateLabels();
            }
        }
    }

    private class HideListener
    implements ActionListener {
        private HideListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WelcomeWizardPage.this.firePropertyChange(WelcomeWizardPage.PROPERTY_SHOW_NEXT_TIME, new Boolean(WelcomeWizardPage.this._checkBox.isSelected()), new Boolean(!WelcomeWizardPage.this._checkBox.isSelected()));
            WelcomeWizardPage.this.firePropertyChange(WelcomeWizardPage.PROPERTY_SKIP_NEXT_TIME, new Boolean(!WelcomeWizardPage.this._checkBox.isSelected()), new Boolean(WelcomeWizardPage.this._checkBox.isSelected()));
        }
    }
}

